/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Experiment;
import omero.model.IObject;
import omero.model.LightSettings;
import omero.model.MicrobeamManipulation;
import omero.model.MicrobeamManipulationType;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrobeamManipulationI
extends MicrobeamManipulation
implements ModelBased {
    public static final String TYPE = "ome.model.experiment.MicrobeamManipulation_type";
    public static final String LIGHTSOURCESETTINGS = "ome.model.experiment.MicrobeamManipulation_lightSourceSettings";
    public static final String EXPERIMENT = "ome.model.experiment.MicrobeamManipulation_experiment";
    public static final String DESCRIPTION = "ome.model.experiment.MicrobeamManipulation_description";
    public static final String DETAILS = "ome.model.experiment.MicrobeamManipulation_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.lightSourceSettingsSeq = new ArrayList();
            this.lightSourceSettingsLoaded = true;
        } else {
            this.lightSourceSettingsSeq = null;
            this.lightSourceSettingsLoaded = false;
        }
    }

    public MicrobeamManipulationI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public MicrobeamManipulationI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public MicrobeamManipulationI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadType();
        this.unloadLightSourceSettings();
        this.unloadExperiment();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        MicrobeamManipulationI copy = new MicrobeamManipulationI();
        copy.id = this.id;
        copy.version = this.version;
        MicrobeamManipulationType microbeamManipulationType = copy.type = this.type == null ? null : (MicrobeamManipulationType)this.type.proxy();
        if (!this.lightSourceSettingsLoaded) {
            copy.lightSourceSettingsLoaded = false;
            copy.lightSourceSettingsSeq = null;
        } else {
            copy.lightSourceSettingsLoaded = true;
            copy.lightSourceSettingsSeq = new ArrayList<LightSettings>();
            for (LightSettings item : this.lightSourceSettingsSeq) {
                copy.lightSourceSettingsSeq.add(item == null ? null : (LightSettings)item.proxy());
            }
        }
        copy.experiment = this.experiment == null ? null : (Experiment)this.experiment.proxy();
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new MicrobeamManipulationI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public MicrobeamManipulationType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(MicrobeamManipulationType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.experiment.MicrobeamManipulation source, IceMapper mapper) {
        this.type = (MicrobeamManipulationType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.experiment.MicrobeamManipulation target, IceMapper mapper) {
        target.putAt(TYPE, (Object)mapper.reverse((ModelBased)this.getType()));
    }

    @Override
    public void unloadLightSourceSettings(Current current) {
        this.lightSourceSettingsLoaded = false;
        this.lightSourceSettingsSeq = null;
    }

    protected List getLightSourceSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lightSourceSettingsSeq;
    }

    protected void setLightSourceSettings(List lightSourceSettings, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lightSourceSettingsSeq = lightSourceSettings == null ? new ArrayList() : new ArrayList(lightSourceSettings);
        this.lightSourceSettingsLoaded = lightSourceSettings != null;
    }

    private void copyLightSourceSettings(ome.model.experiment.MicrobeamManipulation source, IceMapper mapper) {
        this.setLightSourceSettings((List)mapper.findCollection((Collection)source.retrieve(LIGHTSOURCESETTINGS)), null);
    }

    private void fillLightSourceSettings(ome.model.experiment.MicrobeamManipulation target, IceMapper mapper) {
        if (this.lightSourceSettingsLoaded) {
            target.putAt(LIGHTSOURCESETTINGS, (Object)mapper.reverse(this.lightSourceSettingsSeq, Set.class));
        } else {
            target.putAt(LIGHTSOURCESETTINGS, null);
        }
    }

    public boolean isLightSourceSettingsLoaded() {
        return this.lightSourceSettingsLoaded;
    }

    @Override
    public int sizeOfLightSourceSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            return -1;
        }
        return this.lightSourceSettingsSeq.size();
    }

    public List copyLightSourceSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        ArrayList result = new ArrayList(this.lightSourceSettingsSeq);
        return result;
    }

    public Iterator iterateLightSourceSettings() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        return this.lightSourceSettingsSeq.iterator();
    }

    @Override
    public void addLightSettings(LightSettings target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        this.lightSourceSettingsSeq.add(target);
        target.setMicrobeamManipulation(this);
    }

    @Override
    public void addAllLightSettingsSet(List<LightSettings> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        this.lightSourceSettingsSeq.addAll(targets);
        for (LightSettings target : targets) {
            target.setMicrobeamManipulation(this);
        }
    }

    @Override
    public void removeLightSettings(LightSettings target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        this.lightSourceSettingsSeq.remove(target);
        target.setMicrobeamManipulation(null);
    }

    public void removeLightSettingsSet(Collection<LightSettings> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        for (LightSettings elt : targets) {
            elt.setMicrobeamManipulation(null);
            this.lightSourceSettingsSeq.remove(elt);
        }
    }

    @Override
    public void clearLightSourceSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.lightSourceSettingsLoaded) {
            this.throwNullCollectionException("lightSourceSettingsSeq");
        }
        for (LightSettings elt : this.lightSourceSettingsSeq) {
            elt.setMicrobeamManipulation(null);
        }
        this.lightSourceSettingsSeq.clear();
    }

    @Override
    public void reloadLightSourceSettings(MicrobeamManipulation toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.lightSourceSettingsLoaded) {
            throw new ClientError("Cannot reload active collection: lightSourceSettingsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<LightSettings> copy = toCopy.copyLightSourceSettings();
        for (LightSettings elt : copy) {
            elt.setMicrobeamManipulation(this);
        }
        this.lightSourceSettingsSeq = new ArrayList<LightSettings>(copy);
        toCopy.unloadLightSourceSettings();
        this.lightSourceSettingsLoaded = true;
    }

    public void unloadExperiment() {
        this.experiment = null;
    }

    @Override
    public Experiment getExperiment(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.experiment;
    }

    @Override
    public void setExperiment(Experiment experiment, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.experiment = experiment;
    }

    private void copyExperiment(ome.model.experiment.MicrobeamManipulation source, IceMapper mapper) {
        this.experiment = (Experiment)mapper.findTarget(source.getExperiment());
    }

    private void fillExperiment(ome.model.experiment.MicrobeamManipulation target, IceMapper mapper) {
        target.putAt(EXPERIMENT, (Object)mapper.reverse((ModelBased)this.getExperiment()));
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.experiment.MicrobeamManipulation source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.experiment.MicrobeamManipulation target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.experiment.MicrobeamManipulation) {
            ome.model.experiment.MicrobeamManipulation source = (ome.model.experiment.MicrobeamManipulation)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyType(source, mapper);
                this.copyLightSourceSettings(source, mapper);
                this.copyExperiment(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("MicrobeamManipulation cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.experiment.MicrobeamManipulation target = new ome.model.experiment.MicrobeamManipulation();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillType(target, mapper);
            this.fillLightSourceSettings(target, mapper);
            this.fillExperiment(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<MicrobeamManipulationI> cast(List list) {
        return list;
    }
}

