/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Event;
import omero.model.EventLog;
import omero.model.EventType;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.IObject;
import omero.model.Session;
import omero.rtypes;
import omero.util.IceMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventI
extends Event
implements ModelBased {
    public static final String STATUS = "ome.model.meta.Event_status";
    public static final String TIME = "ome.model.meta.Event_time";
    public static final String EXPERIMENTER = "ome.model.meta.Event_experimenter";
    public static final String EXPERIMENTERGROUP = "ome.model.meta.Event_experimenterGroup";
    public static final String TYPE = "ome.model.meta.Event_type";
    public static final String CONTAININGEVENT = "ome.model.meta.Event_containingEvent";
    public static final String LOGS = "ome.model.meta.Event_logs";
    public static final String SESSION = "ome.model.meta.Event_session";
    public static final String DETAILS = "ome.model.meta.Event_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"" + propertyName + "Loaded\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.logsSeq = new ArrayList();
            this.logsLoaded = true;
        } else {
            this.logsSeq = null;
            this.logsLoaded = false;
        }
    }

    public EventI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public EventI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public EventI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadStatus();
        this.unloadTime();
        this.unloadExperimenter();
        this.unloadExperimenterGroup();
        this.unloadType();
        this.unloadContainingEvent();
        this.unloadLogs();
        this.unloadSession();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return true;
    }

    @Override
    public boolean isMutable(Current current) {
        return false;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        EventI copy = new EventI();
        copy.id = this.id;
        copy.status = this.status;
        copy.time = this.time;
        copy.experimenter = this.experimenter == null ? null : (Experimenter)this.experimenter.proxy();
        copy.experimenterGroup = this.experimenterGroup == null ? null : (ExperimenterGroup)this.experimenterGroup.proxy();
        copy.type = this.type == null ? null : (EventType)this.type.proxy();
        Event event = copy.containingEvent = this.containingEvent == null ? null : (Event)this.containingEvent.proxy();
        if (!this.logsLoaded) {
            copy.logsLoaded = false;
            copy.logsSeq = null;
        } else {
            copy.logsLoaded = true;
            copy.logsSeq = new ArrayList<EventLog>();
            for (EventLog item : this.logsSeq) {
                copy.logsSeq.add(item == null ? null : (EventLog)item.proxy());
            }
        }
        copy.session = this.session == null ? null : (Session)this.session.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new EventI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    public void unloadStatus() {
        this.status = null;
    }

    @Override
    public RString getStatus(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.status;
    }

    @Override
    public void setStatus(RString status, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.status = status;
    }

    private void copyStatus(ome.model.meta.Event source, IceMapper mapper) {
        this.status = source.getStatus() == null ? null : rtypes.rstring(source.getStatus());
    }

    private void fillStatus(ome.model.meta.Event target, IceMapper mapper) {
        try {
            target.setStatus((String)mapper.fromRType(this.getStatus()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTime() {
        this.time = null;
    }

    @Override
    public RTime getTime(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.time;
    }

    @Override
    public void setTime(RTime time, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.time = time;
    }

    private void copyTime(ome.model.meta.Event source, IceMapper mapper) {
        this.time = source.getTime() == null ? null : rtypes.rtime(source.getTime().getTime());
    }

    private void fillTime(ome.model.meta.Event target, IceMapper mapper) {
        try {
            target.setTime((Timestamp)mapper.fromRType(this.getTime()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadExperimenter() {
        this.experimenter = null;
    }

    @Override
    public Experimenter getExperimenter(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.experimenter;
    }

    @Override
    public void setExperimenter(Experimenter experimenter, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.experimenter = experimenter;
    }

    private void copyExperimenter(ome.model.meta.Event source, IceMapper mapper) {
        this.experimenter = (Experimenter)mapper.findTarget(source.getExperimenter());
    }

    private void fillExperimenter(ome.model.meta.Event target, IceMapper mapper) {
        target.putAt(EXPERIMENTER, (Object)mapper.reverse((ModelBased)this.getExperimenter()));
    }

    public void unloadExperimenterGroup() {
        this.experimenterGroup = null;
    }

    @Override
    public ExperimenterGroup getExperimenterGroup(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.experimenterGroup;
    }

    @Override
    public void setExperimenterGroup(ExperimenterGroup experimenterGroup, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.experimenterGroup = experimenterGroup;
    }

    private void copyExperimenterGroup(ome.model.meta.Event source, IceMapper mapper) {
        this.experimenterGroup = (ExperimenterGroup)mapper.findTarget(source.getExperimenterGroup());
    }

    private void fillExperimenterGroup(ome.model.meta.Event target, IceMapper mapper) {
        target.putAt(EXPERIMENTERGROUP, (Object)mapper.reverse((ModelBased)this.getExperimenterGroup()));
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public EventType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(EventType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.meta.Event source, IceMapper mapper) {
        this.type = (EventType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.meta.Event target, IceMapper mapper) {
        target.putAt(TYPE, (Object)mapper.reverse((ModelBased)this.getType()));
    }

    public void unloadContainingEvent() {
        this.containingEvent = null;
    }

    @Override
    public Event getContainingEvent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.containingEvent;
    }

    @Override
    public void setContainingEvent(Event containingEvent, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.containingEvent = containingEvent;
    }

    private void copyContainingEvent(ome.model.meta.Event source, IceMapper mapper) {
        this.containingEvent = (Event)mapper.findTarget(source.getContainingEvent());
    }

    private void fillContainingEvent(ome.model.meta.Event target, IceMapper mapper) {
        target.putAt(CONTAININGEVENT, (Object)mapper.reverse((ModelBased)this.getContainingEvent()));
    }

    @Override
    public void unloadLogs(Current current) {
        this.logsLoaded = false;
        this.logsSeq = null;
    }

    protected List getLogs(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.logsSeq;
    }

    protected void setLogs(List logs, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.logsSeq = logs == null ? new ArrayList() : new ArrayList(logs);
        this.logsLoaded = logs != null;
    }

    private void copyLogs(ome.model.meta.Event source, IceMapper mapper) {
        this.setLogs((List)mapper.findCollection((Collection)source.retrieve(LOGS)), null);
    }

    private void fillLogs(ome.model.meta.Event target, IceMapper mapper) {
        if (this.logsLoaded) {
            target.putAt(LOGS, (Object)mapper.reverse(this.logsSeq, Set.class));
        } else {
            target.putAt(LOGS, null);
        }
    }

    public boolean isLogsLoaded() {
        return this.logsLoaded;
    }

    @Override
    public int sizeOfLogs(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            return -1;
        }
        return this.logsSeq.size();
    }

    public List copyLogs(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        ArrayList result = new ArrayList(this.logsSeq);
        return result;
    }

    public Iterator iterateLogs() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        return this.logsSeq.iterator();
    }

    @Override
    public void addEventLog(EventLog target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        this.logsSeq.add(target);
        target.setEvent(this);
    }

    @Override
    public void addAllEventLogSet(List<EventLog> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        this.logsSeq.addAll(targets);
        for (EventLog target : targets) {
            target.setEvent(this);
        }
    }

    @Override
    public void removeEventLog(EventLog target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        this.logsSeq.remove(target);
        target.setEvent(null);
    }

    public void removeEventLogSet(Collection<EventLog> targets) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        for (EventLog elt : targets) {
            elt.setEvent(null);
            this.logsSeq.remove(elt);
        }
    }

    @Override
    public void clearLogs(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.logsLoaded) {
            this.throwNullCollectionException("logsSeq");
        }
        for (EventLog elt : this.logsSeq) {
            elt.setEvent(null);
        }
        this.logsSeq.clear();
    }

    @Override
    public void reloadLogs(Event toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.logsLoaded) {
            throw new ClientError("Cannot reload active collection: logsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        List<EventLog> copy = toCopy.copyLogs();
        for (EventLog elt : copy) {
            elt.setEvent(this);
        }
        this.logsSeq = new ArrayList<EventLog>(copy);
        toCopy.unloadLogs();
        this.logsLoaded = true;
    }

    public void unloadSession() {
        this.session = null;
    }

    @Override
    public Session getSession(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.session;
    }

    @Override
    public void setSession(Session session, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.session = session;
    }

    private void copySession(ome.model.meta.Event source, IceMapper mapper) {
        this.session = (Session)mapper.findTarget(source.getSession());
    }

    private void fillSession(ome.model.meta.Event target, IceMapper mapper) {
        target.putAt(SESSION, (Object)mapper.reverse((ModelBased)this.getSession()));
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.meta.Event) {
            ome.model.meta.Event source = (ome.model.meta.Event)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.copyStatus(source, mapper);
                this.copyTime(source, mapper);
                this.copyExperimenter(source, mapper);
                this.copyExperimenterGroup(source, mapper);
                this.copyType(source, mapper);
                this.copyContainingEvent(source, mapper);
                this.copyLogs(source, mapper);
                this.copySession(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Event cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.meta.Event target = new ome.model.meta.Event();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            this.fillStatus(target, mapper);
            this.fillTime(target, mapper);
            this.fillExperimenter(target, mapper);
            this.fillExperimenterGroup(target, mapper);
            this.fillType(target, mapper);
            this.fillContainingEvent(target, mapper);
            this.fillLogs(target, mapper);
            this.fillSession(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<EventI> cast(List list) {
        return list;
    }
}

