/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import Ice.Current;
import java.lang.reflect.Method;
import omero.InternalException;
import omero.util.IceMapper;

public abstract class Task
implements Runnable {
    protected final Object cb;
    protected final boolean isVoid;
    protected final Current current;
    protected final Method response;
    protected final Method exception;

    public Task(Object callback, Current current, boolean isVoid) {
        this.current = current;
        this.isVoid = isVoid;
        this.cb = callback;
        if (callback != null) {
            this.response = this.getMethod(callback, "ice_response");
            this.exception = this.getMethod(callback, "ice_exception");
        } else {
            this.response = null;
            this.exception = null;
        }
    }

    public abstract void run();

    protected void response(Object rv) {
        try {
            if (this.isVoid) {
                this.response.invoke(this.cb, new Object[0]);
            } else {
                this.response.invoke(this.cb, rv);
            }
        }
        catch (Exception e) {
            try {
                InternalException ie = new InternalException();
                IceMapper.fillServerError(ie, e);
                ie.message = "Failed to invoke: " + this.toString();
                this.exception((Exception)((Object)ie));
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to invoke exception() after failed response()", e2);
            }
        }
    }

    protected void exception(Exception ex) {
        try {
            this.exception.invoke(this.cb, ex);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke exception()", e);
        }
    }

    Method getMethod(Object o, String methodName) {
        Class c = this.getPublicInterface(o.getClass());
        Method[] methods = c.getMethods();
        Method rv = null;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!methodName.equals(m.getName())) continue;
            if (rv != null) {
                throw new RuntimeException(methodName + " exists twice!");
            }
            rv = m;
        }
        return rv;
    }

    private Class getPublicInterface(Class c) {
        if (!c.getName().startsWith("AMD_")) {
            while (!c.equals(Object.class)) {
                Class<?>[] ifaces;
                for (Class<?> c2 : ifaces = c.getInterfaces()) {
                    if (!c2.getSimpleName().startsWith("AMD_")) continue;
                    return c2;
                }
                c = c.getSuperclass();
            }
            throw new RuntimeException("No public AMD_ interface found.");
        }
        return c;
    }
}

