/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.ConnectTimeoutException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.Current;
import Ice.Identity;
import Ice.NoEndpointException;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.TieBase;
import Ice.Util;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import ome.api.JobHandle;
import ome.conditions.SessionException;
import ome.logic.HardWiredInterceptor;
import ome.services.blitz.fire.AopContextInitializer;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.util.ServantHolder;
import ome.services.blitz.util.ServiceFactoryAware;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.Filterable;
import omero.ApiUsageException;
import omero.InternalException;
import omero.ServerError;
import omero.api.AMD_StatefulServiceInterface_close;
import omero.api.ClientCallbackPrx;
import omero.api.ClientCallbackPrxHelper;
import omero.api.GatewayPrx;
import omero.api.GatewayPrxHelper;
import omero.api.IAdminPrx;
import omero.api.IAdminPrxHelper;
import omero.api.IConfigPrx;
import omero.api.IConfigPrxHelper;
import omero.api.IContainerPrx;
import omero.api.IContainerPrxHelper;
import omero.api.IDeletePrx;
import omero.api.IDeletePrxHelper;
import omero.api.ILdapPrx;
import omero.api.ILdapPrxHelper;
import omero.api.IMetadataPrx;
import omero.api.IMetadataPrxHelper;
import omero.api.IPixelsPrx;
import omero.api.IPixelsPrxHelper;
import omero.api.IProjectionPrx;
import omero.api.IProjectionPrxHelper;
import omero.api.IQueryPrx;
import omero.api.IQueryPrxHelper;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRenderingSettingsPrxHelper;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRepositoryInfoPrxHelper;
import omero.api.IScriptPrx;
import omero.api.IScriptPrxHelper;
import omero.api.ISessionPrx;
import omero.api.ISessionPrxHelper;
import omero.api.ISharePrx;
import omero.api.ISharePrxHelper;
import omero.api.ITimelinePrx;
import omero.api.ITimelinePrxHelper;
import omero.api.ITypesPrx;
import omero.api.ITypesPrxHelper;
import omero.api.IUpdatePrx;
import omero.api.IUpdatePrxHelper;
import omero.api.JobHandlePrx;
import omero.api.JobHandlePrxHelper;
import omero.api.RawFileStorePrx;
import omero.api.RawFileStorePrxHelper;
import omero.api.RawPixelsStorePrx;
import omero.api.RawPixelsStorePrxHelper;
import omero.api.RenderingEnginePrx;
import omero.api.RenderingEnginePrxHelper;
import omero.api.SearchPrx;
import omero.api.SearchPrxHelper;
import omero.api.ServiceInterfacePrx;
import omero.api.ServiceInterfacePrxHelper;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.StatefulServiceInterfacePrxHelper;
import omero.api.ThumbnailStorePrx;
import omero.api.ThumbnailStorePrxHelper;
import omero.api._ServiceFactoryDisp;
import omero.api._ServiceInterfaceOperations;
import omero.api._StatefulServiceInterfaceOperations;
import omero.grid.InteractiveProcessorI;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.InteractiveProcessorPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.model.Job;
import omero.model.JobStatusI;
import omero.rtypes;
import omero.util.IceMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceFactoryI
extends _ServiceFactoryDisp {
    private static final Log log = LogFactory.getLog(ServiceFactoryI.class);
    boolean doClose = true;
    public final String clientId;
    private ClientCallbackPrx callback;
    final ObjectAdapter adapter;
    final SessionManager sessionManager;
    final TopicManager topicManager;
    final Executor executor;
    final ServantHolder holder;
    final Principal principal;
    final List<HardWiredInterceptor> cptors;
    final OmeroContext context;
    final AopContextInitializer initializer;

    public ServiceFactoryI(Current current, OmeroContext context, SessionManager manager, Executor executor, Principal p, List<HardWiredInterceptor> interceptors) throws ApiUsageException {
        ServantHolder local;
        this.adapter = current.adapter;
        this.clientId = ServiceFactoryI.clientId(current);
        this.context = context;
        this.sessionManager = manager;
        this.executor = executor;
        this.principal = p;
        this.cptors = interceptors;
        this.initializer = new AopContextInitializer(new ServiceFactory(this.context), this.principal);
        this.topicManager = null;
        Ehcache cache = manager.inMemoryCache(p.getName());
        String key = "servantHolder";
        if (!cache.isKeyInCache((java.lang.Object)key)) {
            local = new ServantHolder();
            cache.put(new Element((java.lang.Object)key, (java.lang.Object)local));
        } else {
            local = (ServantHolder)cache.get((Serializable)((java.lang.Object)key)).getObjectValue();
        }
        this.holder = local;
    }

    public ObjectAdapter getAdapter() {
        return this.adapter;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public IAdminPrx getAdminService(Current current) throws ServerError {
        return IAdminPrxHelper.uncheckedCast(this.getByName("omero.api.IAdmin", current));
    }

    @Override
    public IConfigPrx getConfigService(Current current) throws ServerError {
        return IConfigPrxHelper.uncheckedCast(this.getByName("omero.api.IConfig", current));
    }

    @Override
    public IDeletePrx getDeleteService(Current current) throws ServerError {
        return IDeletePrxHelper.uncheckedCast(this.getByName("omero.api.IDelete", current));
    }

    @Override
    public ILdapPrx getLdapService(Current current) throws ServerError {
        return ILdapPrxHelper.uncheckedCast(this.getByName("omero.api.ILdap", current));
    }

    @Override
    public IPixelsPrx getPixelsService(Current current) throws ServerError {
        return IPixelsPrxHelper.uncheckedCast(this.getByName("omero.api.IPixels", current));
    }

    @Override
    public IContainerPrx getContainerService(Current current) throws ServerError {
        return IContainerPrxHelper.uncheckedCast(this.getByName("omero.api.IContainer", current));
    }

    @Override
    public IProjectionPrx getProjectionService(Current current) throws ServerError {
        return IProjectionPrxHelper.uncheckedCast(this.getByName("omero.api.IProjection", current));
    }

    @Override
    public IQueryPrx getQueryService(Current current) throws ServerError {
        return IQueryPrxHelper.uncheckedCast(this.getByName("omero.api.IQuery", current));
    }

    @Override
    public IScriptPrx getScriptService(Current current) throws ServerError {
        ServiceInterfacePrx prx = this.getByName("omero.api.IScript", current);
        return IScriptPrxHelper.uncheckedCast(prx);
    }

    @Override
    public ISessionPrx getSessionService(Current current) throws ServerError {
        return ISessionPrxHelper.uncheckedCast(this.getByName("omero.api.ISession", current));
    }

    @Override
    public ISharePrx getShareService(Current current) throws ServerError {
        return ISharePrxHelper.uncheckedCast(this.getByName("omero.api.IShare", current));
    }

    @Override
    public ITimelinePrx getTimelineService(Current current) throws ServerError {
        return ITimelinePrxHelper.uncheckedCast(this.getByName("omero.api.ITimeline", current));
    }

    @Override
    public ITypesPrx getTypesService(Current current) throws ServerError {
        return ITypesPrxHelper.uncheckedCast(this.getByName("omero.api.ITypes", current));
    }

    @Override
    public IUpdatePrx getUpdateService(Current current) throws ServerError {
        return IUpdatePrxHelper.uncheckedCast(this.getByName("omero.api.IUpdate", current));
    }

    @Override
    public IRenderingSettingsPrx getRenderingSettingsService(Current current) throws ServerError {
        return IRenderingSettingsPrxHelper.uncheckedCast(this.getByName("omero.api.IRenderingSettings", current));
    }

    @Override
    public IRepositoryInfoPrx getRepositoryInfoService(Current current) throws ServerError {
        return IRepositoryInfoPrxHelper.uncheckedCast(this.getByName("omero.api.IRepositoryInfo", current));
    }

    @Override
    public IMetadataPrx getMetadataService(Current current) throws ServerError {
        return IMetadataPrxHelper.uncheckedCast(this.getByName("omero.api.IMetadata", current));
    }

    @Override
    public GatewayPrx createGateway(Current current) throws ServerError {
        return GatewayPrxHelper.uncheckedCast(this.createByName("omero.api.Gateway", current));
    }

    @Override
    public JobHandlePrx createJobHandle(Current current) throws ServerError {
        return JobHandlePrxHelper.uncheckedCast(this.createByName("omero.api.JobHandle", current));
    }

    @Override
    public RenderingEnginePrx createRenderingEngine(Current current) throws ServerError {
        return RenderingEnginePrxHelper.uncheckedCast(this.createByName("omero.api.RenderingEngine", current));
    }

    @Override
    public RawFileStorePrx createRawFileStore(Current current) throws ServerError {
        return RawFileStorePrxHelper.uncheckedCast(this.createByName("omero.api.RawFileStore", current));
    }

    @Override
    public RawPixelsStorePrx createRawPixelsStore(Current current) throws ServerError {
        return RawPixelsStorePrxHelper.uncheckedCast(this.createByName("omero.api.RawPixelsStore", current));
    }

    @Override
    public SearchPrx createSearchService(Current current) throws ServerError {
        return SearchPrxHelper.uncheckedCast(this.createByName("omero.api.Search", current));
    }

    @Override
    public ThumbnailStorePrx createThumbnailStore(Current current) throws ServerError {
        return ThumbnailStorePrxHelper.uncheckedCast(this.createByName("omero.api.ThumbnailStore", current));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInterfacePrx getByName(String name, Current current) throws ServerError {
        Identity id = this.getIdentity(name);
        this.holder.acquireLock(name);
        try {
            ObjectPrx prx;
            Object servant = this.holder.get(name);
            if (servant == null) {
                servant = this.createServantDelegate(name);
                prx = this.registerServant(current, id, servant);
            } else {
                prx = this.adapter.createDirectProxy(id);
            }
            ServiceInterfacePrx serviceInterfacePrx = ServiceInterfacePrxHelper.uncheckedCast(prx);
            return serviceInterfacePrx;
        }
        finally {
            this.holder.releaseLock(name);
        }
    }

    @Override
    public StatefulServiceInterfacePrx createByName(String name, Current current) throws ServerError {
        Identity id = this.getIdentity(Util.generateUUID() + name);
        if (null != this.adapter.find(id)) {
            InternalException ie = new InternalException();
            ie.message = name + " already registered for this adapter.";
        }
        Object servant = this.createServantDelegate(name);
        ObjectPrx prx = this.registerServant(current, id, servant);
        return StatefulServiceInterfacePrxHelper.uncheckedCast(prx);
    }

    @Override
    public void subscribe(String topicName, ObjectPrx prx, Current __current) throws ServerError {
        if (topicName == null || !topicName.startsWith("/public/")) {
            throw new ApiUsageException(null, null, "Currently only \"/public/\" topics allowed.");
        }
        this.topicManager.register(topicName, prx);
        log.info((java.lang.Object)("Registered " + prx + " for " + topicName));
    }

    @Override
    public InteractiveProcessorPrx acquireProcessor(final Job submittedJob, int seconds, Current current) throws ServerError {
        IceMapper mapper;
        ome.model.jobs.Job savedJob;
        if (seconds > 180) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = "Delay is too long. Maximum = 3 minutes.";
        }
        if ((savedJob = (ome.model.jobs.Job)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "submitJob", mapper = new IceMapper()){
            final /* synthetic */ IceMapper val$mapper;
            {
                this.val$mapper = iceMapper;
                super(x0, x1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public ome.model.jobs.Job doWork(Session session, ServiceFactory sf) {
                JobHandle handle = sf.createJobHandle();
                try {
                    JobStatusI status = new JobStatusI();
                    status.setValue(rtypes.rstring("Waiting"));
                    submittedJob.setStatus(status);
                    submittedJob.setMessage(rtypes.rstring("Interactive job. Waiting."));
                    handle.submit((ome.model.jobs.Job)this.val$mapper.reverse(submittedJob));
                    ome.model.jobs.Job job = handle.getJob();
                    return job;
                }
                catch (ApiUsageException e) {
                    ome.model.jobs.Job job = null;
                    return job;
                }
                finally {
                    if (handle != null) {
                        handle.close();
                    }
                }
            }
        })) == null) {
            throw new ApiUsageException(null, null, "Could not submit job. ");
        }
        Job unloadedJob = (Job)mapper.map((Filterable)savedJob);
        unloadedJob.unload();
        long start = System.currentTimeMillis();
        long stop = seconds < 0 ? start : start + (long)seconds * 1000L;
        do {
            ObjectPrx[] candidates;
            ObjectPrx objectPrx = this.adapter.getCommunicator().stringToProxy("IceGrid/Query");
            QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
            for (ObjectPrx op : candidates = query.findAllObjectsByType("::omero::grid::Processor")) {
                try {
                    ProcessorPrx p = ProcessorPrxHelper.checkedCast(op);
                    if (p == null) continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ObjectPrx prx = this.adapter.getCommunicator().stringToProxy("Processor");
            if (prx == null) continue;
            try {
                ProcessorPrx processor = ProcessorPrxHelper.checkedCast(prx);
                if (processor != null) {
                    long timeout = System.currentTimeMillis() + 3600000L;
                    InteractiveProcessorI ip = new InteractiveProcessorI(this.principal, this.sessionManager, this.executor, processor, unloadedJob, timeout);
                    Identity id = new Identity();
                    id.category = current.id.name;
                    id.name = Util.generateUUID();
                    ObjectPrx rv = this.registerServant(current, id, ip);
                    return InteractiveProcessorPrxHelper.uncheckedCast(rv);
                }
                try {
                    Thread.sleep((stop - start) / 10L);
                }
                catch (InterruptedException ie) {}
            }
            catch (NoEndpointException nee) {
                try {
                    Thread.sleep((stop - start) / 3L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        } while (stop < System.currentTimeMillis());
        return null;
    }

    @Override
    public void setCallback(ClientCallbackPrx callback, Current current) {
        this.callback = callback;
        log.info((java.lang.Object)(Util.identityToString((Identity)this.sessionId()) + " set callback to " + this.callback));
    }

    @Override
    public void detachOnDestroy(Current current) {
        this.doClose = false;
    }

    @Override
    @Deprecated
    public void close(Current current) {
        this.doClose = false;
    }

    @Override
    public void closeOnDestroy(Current current) {
        this.doClose = true;
    }

    public void destroy(Current current) {
        int ref;
        try {
            this.adapter.remove(this.sessionId());
        }
        catch (NotRegisteredException nre) {
            log.warn((java.lang.Object)("NotRegisteredException: " + Util.identityToString((Identity)this.sessionId())));
        }
        catch (ObjectAdapterDeactivatedException oade) {
            log.warn((java.lang.Object)("Adapter already deactivated. Cannot remove: " + this.sessionId()));
        }
        catch (Throwable t) {
            log.error((java.lang.Object)"Can't remove service factory", t);
        }
        try {
            ref = this.sessionManager.detach(this.principal.getName());
        }
        catch (SessionException rse) {
            log.info((java.lang.Object)"Session already removed. Cleaning up blitz state.");
            ref = 0;
            this.doClose = true;
        }
        if (this.doClose && ref < 1) {
            ClientCallbackPrx copy = this.callback;
            this.callback = null;
            if (copy != null) {
                try {
                    ObjectPrx prx = copy.ice_oneway();
                    ClientCallbackPrx oneway = ClientCallbackPrxHelper.uncheckedCast(prx);
                    oneway.sessionClosed();
                }
                catch (NotRegisteredException nre) {
                    log.warn((java.lang.Object)(this.clientId + "'s callback not registered -" + " perhaps wrong proxy?"));
                }
                catch (ConnectionRefusedException cre) {
                    log.warn((java.lang.Object)(this.clientId + "'s callback refused connection -" + " did the client die?"));
                }
                catch (ConnectionLostException cle) {
                    log.debug((java.lang.Object)(this.clientId + "'s connection lost as expected"));
                }
                catch (ConnectTimeoutException cte) {
                    log.warn((java.lang.Object)("ConnectTimeoutException on callback:" + this.clientId));
                }
                catch (Exception e) {
                    log.error((java.lang.Object)("Unknown error on oneway ClientCallback.sessionClosed to " + this.adapter.getCommunicator().identityToString(copy.ice_getIdentity())), (Throwable)e);
                }
            }
            this.doDestroy();
            try {
                ref = this.sessionManager.close(this.principal.getName());
            }
            catch (SessionException se) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDestroy() {
        if (log.isInfoEnabled()) {
            log.info((java.lang.Object)String.format("Closing %s session", this));
        }
        this.holder.acquireLock("*");
        try {
            List<String> servants = this.holder.getServantList();
            for (final String key : servants) {
                Object servantOrTie = this.holder.get(key);
                Identity id = this.getIdentity(key);
                if (servantOrTie == null) {
                    log.warn((java.lang.Object)("Servant already removed: " + key));
                    this.unregisterServant(id);
                    continue;
                }
                try {
                    java.lang.Object servant = servantOrTie instanceof TieBase ? ((TieBase)servantOrTie).ice_delegate() : servantOrTie;
                    if (servant instanceof _StatefulServiceInterfaceOperations) {
                        final _StatefulServiceInterfaceOperations stateful = (_StatefulServiceInterfaceOperations)servant;
                        Current __curr = new Current();
                        __curr.id = id;
                        __curr.adapter = this.adapter;
                        __curr.operation = "close";
                        __curr.ctx = new HashMap();
                        __curr.ctx.put("omero.client.uuid", this.clientId);
                        stateful.close_async(new AMD_StatefulServiceInterface_close(){

                            public void ice_exception(Exception ex) {
                                if (ex instanceof omero.SessionException) {
                                    log.warn((java.lang.Object)("Stateful session not properly closed: " + key));
                                } else {
                                    log.error((java.lang.Object)("Error on close callback: " + key + "=" + stateful), (Throwable)ex);
                                }
                            }

                            public void ice_response() {
                            }
                        }, __curr);
                        continue;
                    }
                    if (servant instanceof InteractiveProcessorI) {
                        InteractiveProcessorI ip = (InteractiveProcessorI)servant;
                        ip.stop();
                        continue;
                    }
                    if (servant instanceof _ServiceInterfaceOperations) continue;
                    throw new ome.conditions.InternalException("Unknown servant type: " + servant);
                }
                catch (Exception e) {
                    log.error((java.lang.Object)("Error destroying servant: " + key + "=" + servantOrTie), (Throwable)e);
                }
                finally {
                    this.unregisterServant(id);
                    log.info((java.lang.Object)("Removed servant from adapter: " + key));
                }
            }
        }
        finally {
            this.holder.releaseLock("*");
        }
    }

    @Override
    public List<String> activeServices(Current __current) {
        return this.holder.getServantList();
    }

    @Override
    public long keepAllAlive(ServiceInterfacePrx[] proxies, Current __current) {
        this.sessionManager.getEventContext(this.principal);
        if (log.isInfoEnabled()) {
            log.info((java.lang.Object)("Keep alive: " + __current.id.name));
        }
        if (proxies == null || proxies.length == 0) {
            return -1L;
        }
        long retVal = 0L;
        for (int i = 0; i < proxies.length; ++i) {
            ServiceInterfacePrx prx = proxies[i];
            Identity id = prx.ice_getIdentity();
            if (null != this.holder.get(id)) continue;
            retVal |= (long)(1 << i);
        }
        return retVal;
    }

    @Override
    public boolean keepAlive(ServiceInterfacePrx proxy, Current __current) {
        this.sessionManager.getEventContext(this.principal);
        if (log.isInfoEnabled()) {
            log.info((java.lang.Object)("Keep alive: " + __current.id.name));
        }
        if (proxy == null) {
            return false;
        }
        Identity id = proxy.ice_getIdentity();
        return null != this.holder.get(id);
    }

    protected Identity getIdentity(String key) {
        Identity id = new Identity();
        id.category = this.principal.getName();
        id.name = key;
        return id;
    }

    protected Object createServantDelegate(String name) throws ServerError {
        Object servant = null;
        try {
            servant = (Object)this.context.getBean(name);
            if (servant instanceof TieBase) {
                TieBase tie = (TieBase)servant;
                java.lang.Object obj = tie.ice_delegate();
                if (obj instanceof AbstractAmdServant) {
                    AbstractAmdServant amd = (AbstractAmdServant)obj;
                    amd.applyHardWiredInterceptors(this.cptors, this.initializer);
                }
                if (obj instanceof ServiceFactoryAware) {
                    ((ServiceFactoryAware)obj).setServiceFactory(this);
                }
            }
            return servant;
        }
        catch (ClassCastException cce) {
            throw new InternalException(null, null, "Could not cast to Ice.Object:[" + name + "]");
        }
        catch (NoSuchBeanDefinitionException nosuch) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = name + " is an unknown service. Please check Constants.ice or the documentation for valid strings.";
            throw aue;
        }
        catch (Exception e) {
            log.warn((java.lang.Object)"Uncaught exception in createServantDelegate. ", (Throwable)e);
            throw new InternalException(null, e.getClass().getName(), e.getMessage());
        }
    }

    protected ObjectPrx registerServant(Current current, Identity id, Object servant) throws ServerError {
        ObjectPrx prx;
        block5: {
            prx = null;
            try {
                Object already = this.adapter.find(id);
                if (null == already) {
                    this.adapter.add(servant, id);
                    prx = this.adapter.createDirectProxy(id);
                    if (log.isInfoEnabled()) {
                        log.info((java.lang.Object)("Added servant to adapter: " + this.servantString(id, servant)));
                    }
                    break block5;
                }
                throw new InternalException(null, null, "Servant already registered: " + this.servantString(id, servant));
            }
            catch (Exception e) {
                if (e instanceof InternalException) {
                    throw (InternalException)((java.lang.Object)e);
                }
                InternalException ie = new InternalException();
                IceMapper.fillServerError(ie, e);
                throw ie;
            }
        }
        this.holder.put(id.name, servant);
        return prx;
    }

    public void unregisterServant(Identity id) {
        if (null == this.adapter.find(id)) {
            return;
        }
        Object obj = this.adapter.remove(id);
        Object removed = this.holder.remove(id);
        if (removed == null) {
            log.error((java.lang.Object)"Adapter and active servants out of sync.");
        }
        if (log.isInfoEnabled()) {
            log.info((java.lang.Object)("Unregistered servant:" + this.servantString(id, obj)));
        }
    }

    private String servantString(Identity id, java.lang.Object obj) {
        StringBuilder sb = new StringBuilder(Util.identityToString((Identity)id));
        sb.append("(");
        sb.append(obj);
        sb.append(")");
        return sb.toString();
    }

    public static Identity sessionId(String clientId, String uuid) {
        Identity id = new Identity();
        id.category = "session-" + clientId;
        id.name = uuid;
        return id;
    }

    public Identity sessionId() {
        return ServiceFactoryI.sessionId(this.clientId, this.principal.getName());
    }

    public static String clientId(Current current) throws ApiUsageException {
        String clientId = null;
        if (current.ctx != null) {
            clientId = (String)current.ctx.get("omero.client.uuid");
        }
        if (clientId == null) {
            throw new ApiUsageException(null, null, "No omero.client.uuid key provided in context.");
        }
        return clientId;
    }
}

