/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.gateway.services.impl;

import java.util.List;
import java.util.Map;
import ome.services.blitz.gateway.services.GatewayFactory;
import ome.services.blitz.gateway.services.ImageService;
import ome.services.blitz.gateway.services.RawPixelsStoreService;
import ome.services.blitz.gateway.services.RenderingService;
import ome.services.blitz.gateway.services.ThumbnailService;
import omero.RInt;
import omero.ServerError;
import omero.api.IPixelsPrx;
import omero.api.IQueryPrx;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.rtypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageServiceImpl
implements ImageService {
    GatewayFactory gatewayFactory;

    public ImageServiceImpl(GatewayFactory gatewayFactory) {
        this.gatewayFactory = gatewayFactory;
    }

    @Override
    public Long createImage(int sizeX, int sizeY, int sizeZ, int sizeT, List<Integer> channelList, PixelsType pixelsType, String name, String description) throws ServerError {
        IPixelsPrx iPixels = this.gatewayFactory.getIPixels();
        return iPixels.createImage(sizeX, sizeY, sizeZ, sizeT, channelList, pixelsType, name, description).getValue();
    }

    @Override
    public Long copyPixels(long pixelsID, int x, int y, int t, int z, List<Integer> channelList, String methodology) throws ServerError {
        IPixelsPrx iPixels = this.gatewayFactory.getIPixels();
        Long newID = iPixels.copyAndResizePixels(pixelsID, rtypes.rint(x), rtypes.rint(y), rtypes.rint(t), rtypes.rint(z), channelList, methodology, true).getValue();
        return newID;
    }

    @Override
    public Long copyPixels(long pixelsID, List<Integer> channelList, String methodology) throws ServerError {
        IPixelsPrx iPixels = this.gatewayFactory.getIPixels();
        Pixels pixels = this.getPixels(pixelsID);
        Long newID = iPixels.copyAndResizePixels(pixelsID, pixels.getSizeX(), pixels.getSizeY(), pixels.getSizeT(), pixels.getSizeZ(), channelList, methodology, true).getValue();
        return newID;
    }

    @Override
    public Long copyImage(long imageId, int x, int y, int t, int z, List<Integer> channelList, String methodology) throws ServerError {
        IPixelsPrx iPixels = this.gatewayFactory.getIPixels();
        Long newID = iPixels.copyAndResizeImage(imageId, rtypes.rint(x), rtypes.rint(y), rtypes.rint(t), rtypes.rint(z), channelList, methodology, true).getValue();
        return newID;
    }

    @Override
    public Image getImage(long imageID) throws ServerError {
        String queryStr = new String("from Image as i left outer join fetch i.pixels as p where i.id= " + imageID);
        IQueryPrx query = this.gatewayFactory.getIQuery();
        return (Image)query.findByQuery(queryStr, null);
    }

    @Override
    public Pixels getPixels(long pixelsId) throws ServerError {
        RenderingService renderingService = this.gatewayFactory.getRenderingService();
        return renderingService.getPixels(pixelsId);
    }

    @Override
    public byte[] getRawPlane(long pixelsId, int z, int c, int t) throws ServerError {
        RawPixelsStoreService rawPixelsStoreService = this.gatewayFactory.getRawPixelsStoreService();
        return rawPixelsStoreService.getPlane(pixelsId, z, c, t);
    }

    @Override
    public int[] getRenderedImage(long pixelsId, int z, int t) throws ServerError {
        RenderingService renderingService = this.gatewayFactory.getRenderingService();
        return renderingService.getRenderedImage(pixelsId, z, t);
    }

    @Override
    public int[] renderAsPackedIntAsRGBA(long pixelsId, int z, int t) throws ServerError {
        RenderingService renderingService = this.gatewayFactory.getRenderingService();
        return renderingService.renderAsPackedIntAsRGBA(pixelsId, z, t);
    }

    @Override
    public int[][][] getRenderedImageMatrix(long pixelsId, int z, int t) throws ServerError {
        RenderingService renderingService = this.gatewayFactory.getRenderingService();
        return renderingService.getRenderedImageMatrix(pixelsId, z, t);
    }

    @Override
    public byte[] getThumbnail(long pixelsId, RInt sizeX, RInt sizeY) throws ServerError {
        ThumbnailService thumbnailService = this.gatewayFactory.getThumbnailStoreService();
        return thumbnailService.getThumbnail(pixelsId, sizeX, sizeY);
    }

    @Override
    public Map<Long, byte[]> getThumbnailSet(RInt sizeX, RInt sizeY, List<Long> pixelsIds) throws ServerError {
        ThumbnailService thumbnailService = this.gatewayFactory.getThumbnailStoreService();
        return thumbnailService.getThumbnailSet(sizeX, sizeY, pixelsIds);
    }

    @Override
    public void setActive(Long pixelsId, int w, boolean active) throws ServerError {
        RenderingService renderingService = this.gatewayFactory.getRenderingService();
        renderingService.setActive(pixelsId, w, active);
    }

    @Override
    public void uploadPlane(long pixelsId, int z, int c, int t, byte[] data) throws ServerError {
        RawPixelsStoreService rawPixelsStore = this.gatewayFactory.getRawPixelsStoreService();
        rawPixelsStore.setPlane(pixelsId, data, z, c, t);
    }
}

