/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionPrx;
import Glacier2.SessionPrxHelper;
import Glacier2._SessionManagerDisp;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.Util;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.logic.HardWiredInterceptor;
import ome.model.meta.Session;
import ome.security.SecuritySystem;
import ome.services.blitz.fire.Ring;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.ConvertToBlitzExceptionMessage;
import ome.services.blitz.util.UnregisterServantMessage;
import ome.services.messages.DestroySessionMessage;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.OmeroContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.util.messages.InternalMessage;
import omero.ConcurrencyException;
import omero.WrappedCreateSessionException;
import omero.api.ClientCallbackPrxHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public final class SessionManagerI
extends _SessionManagerDisp
implements ApplicationContextAware,
ApplicationListener {
    private static final List<HardWiredInterceptor> CPTORS = HardWiredInterceptor.parse((String[])new String[]{"ome.security.basic.BasicSecurityWiring"});
    private static final Log log = LogFactory.getLog(SessionManagerI.class);
    protected OmeroContext context;
    protected final ObjectAdapter adapter;
    protected final SecuritySystem securitySystem;
    protected final SessionManager sessionManager;
    protected final Executor executor;
    protected final Ring ring;
    protected final AtomicBoolean loaded = new AtomicBoolean(false);
    protected final Map<String, Set<String>> sessionToClientIds = new ConcurrentHashMap<String, Set<String>>();

    public SessionManagerI(Ring ring, ObjectAdapter adapter, SecuritySystem secSys, SessionManager sessionManager, Executor executor) {
        this.ring = ring;
        this.adapter = adapter;
        this.executor = executor;
        this.securitySystem = secSys;
        this.sessionManager = sessionManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (OmeroContext)applicationContext;
        HardWiredInterceptor.configure(CPTORS, (OmeroContext)this.context);
        this.loaded.set(true);
    }

    public SessionPrx create(String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        if (!this.loaded.get()) {
            WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
            wrapped.backOff = 1000L;
            wrapped.concurrency = true;
            wrapped.reason = "Server not fully initialized";
            wrapped.type = "ApiUsageException";
            throw wrapped;
        }
        try {
            String event;
            SessionPrx sf;
            boolean local = false;
            try {
                Session o = this.sessionManager.find(userId);
                local = o != null;
                log.info((Object)("Found session locally: " + userId));
            }
            catch (Exception e) {
                log.debug((Object)("Exception while waiting on SessionManager.find " + e));
            }
            if (!local && (sf = this.ring.getProxyOrNull(userId, control, current)) != null) {
                return sf;
            }
            Roles roles = this.securitySystem.getSecurityRoles();
            String group = this.getGroup(current);
            if (group == null) {
                group = roles.getUserGroupName();
            }
            if ((event = this.getEvent(current)) == null) {
                event = "User";
            }
            Principal p = new Principal(userId, group, event);
            Session s = this.sessionManager.create(p);
            Principal sp = new Principal(s.getUuid(), group, event);
            ServiceFactoryI session = new ServiceFactoryI(current, this.context, this.sessionManager, this.executor, sp, CPTORS);
            Identity id = session.sessionId();
            ObjectPrx _prx = current.adapter.add((Ice.Object)session, id);
            _prx = current.adapter.createDirectProxy(id);
            if (!this.sessionToClientIds.containsKey(s.getUuid())) {
                this.sessionToClientIds.put(s.getUuid(), new HashSet());
                log.info((Object)String.format("Created session %s for user %s", id.name, userId));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Rejoining session %s", id.name));
            }
            this.sessionToClientIds.get(s.getUuid()).add(session.clientId);
            return SessionPrxHelper.uncheckedCast((ObjectPrx)_prx);
        }
        catch (Exception t) {
            if (t instanceof CannotCreateSessionException) {
                throw (CannotCreateSessionException)t;
            }
            if (t instanceof ome.conditions.ConcurrencyException || t instanceof ConcurrencyException) {
                long backOff = t instanceof ConcurrencyException ? ((ConcurrencyException)((Object)t)).backOff : ((ome.conditions.ConcurrencyException)t).backOff;
                WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
                wrapped.backOff = backOff;
                wrapped.type = t.getClass().getName();
                wrapped.concurrency = true;
                wrapped.reason = "ConcurrencyException: " + t.getMessage() + "\nPlease retry in " + backOff + "ms. Cause: " + t.getMessage();
                throw wrapped;
            }
            ConvertToBlitzExceptionMessage convert = new ConvertToBlitzExceptionMessage((Object)this, t);
            try {
                this.context.publishMessage((InternalMessage)convert);
            }
            catch (Throwable t2) {
                log.error((Object)"Error while converting exception:", t2);
            }
            if (convert.to instanceof CannotCreateSessionException) {
                throw (CannotCreateSessionException)convert.to;
            }
            if (!(t instanceof omero.ApiUsageException || t instanceof ApiUsageException || t instanceof SecurityViolation)) {
                log.error((Object)"Error while creating ServiceFactoryI", (Throwable)t);
            }
            WrappedCreateSessionException wrapped = new WrappedCreateSessionException();
            wrapped.backOff = -1L;
            wrapped.concurrency = false;
            wrapped.reason = t.getMessage();
            wrapped.type = t.getClass().getName();
            wrapped.setStackTrace(t.getStackTrace());
            throw wrapped;
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof UnregisterServantMessage) {
            Identity id;
            UnregisterServantMessage msg = (UnregisterServantMessage)event;
            String key = msg.getServiceKey();
            Current curr = msg.getCurrent();
            try {
                String clientId = ServiceFactoryI.clientId(curr);
                id = ServiceFactoryI.sessionId(clientId, curr.id.category);
            }
            catch (omero.ApiUsageException e) {
                throw new RuntimeException("Could not unregister servant: could not create session id");
            }
            Ice.Object obj = curr.adapter.find(id);
            if (obj instanceof ServiceFactoryI) {
                ServiceFactoryI sf = (ServiceFactoryI)obj;
                sf.unregisterServant(Util.stringToIdentity((String)key));
            } else {
                log.warn((Object)("Not a ServiceFactory: " + obj));
            }
        } else if (event instanceof DestroySessionMessage) {
            DestroySessionMessage msg = (DestroySessionMessage)event;
            this.reapSession(msg.getSessionId());
        }
    }

    public void requestHeartBeats() {
        log.info((Object)"Performing requestHeartbeats");
        this.context.publishEvent((ApplicationEvent)new TopicManager.TopicMessage((Object)this, "/public/HeartBeat", new ClientCallbackPrxHelper(), "requestHeartbeat", new Object[0]));
    }

    public void reapSession(String sessionId) {
        Set<String> clientIds = this.sessionToClientIds.get(sessionId);
        if (clientIds != null) {
            for (String clientId : clientIds) {
                try {
                    Identity iid = ServiceFactoryI.sessionId(clientId, sessionId);
                    Ice.Object obj = this.adapter.find(iid);
                    if (obj == null) {
                        log.debug((Object)(Util.identityToString((Identity)iid) + " already removed."));
                        continue;
                    }
                    ServiceFactoryI sf = (ServiceFactoryI)obj;
                    sf.doDestroy();
                    this.adapter.remove(sf.sessionId());
                }
                catch (ObjectAdapterDeactivatedException oade) {
                    log.warn((Object)("Cannot reap session " + sessionId + " from client " + clientId + " since adapter is deactivated."));
                }
                catch (Exception e) {
                    log.error((Object)("Error reaping session " + sessionId + " from client " + clientId), (Throwable)e);
                }
            }
        }
        this.sessionToClientIds.remove(sessionId);
    }

    protected String getGroup(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return (String)current.ctx.get("omero.group");
    }

    protected String getEvent(Current current) {
        if (current.ctx == null) {
            return null;
        }
        return (String)current.ctx.get("omero.event");
    }
}

