/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.CannotCreateSessionException;
import Glacier2.SessionControlPrx;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Current;
import Ice.Identity;
import Ice.ObjectAdapter;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.model.IObject;
import ome.model.meta.Node;
import ome.services.blitz.fire.Registry;
import ome.services.blitz.redirect.NullRedirector;
import ome.services.blitz.redirect.Redirector;
import ome.services.sessions.state.SessionCache;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import omero.internal.ClusterNodePrx;
import omero.internal.ClusterNodePrxHelper;
import omero.internal._ClusterNodeDisp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ring
extends _ClusterNodeDisp
implements Redirector.Context {
    private static final Log log = LogFactory.getLog(Ring.class);
    public final String uuid;
    public final Principal principal;
    private final Executor executor;
    private final Redirector redirector;
    private final SessionCache cache;
    private Communicator communicator;
    private Registry registry;
    private ObjectAdapter adapter;
    private String directProxy;

    public Ring(String uuid, Executor executor, SessionCache cache) {
        this(uuid, executor, cache, new NullRedirector());
    }

    public Ring(String uuid, Executor executor, SessionCache cache, Redirector redirector) {
        this.uuid = uuid;
        this.executor = executor;
        this.cache = cache;
        this.redirector = redirector;
        this.principal = new Principal(uuid, "system", "Internal");
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public Principal principal() {
        return this.principal;
    }

    @Override
    public String getDirectProxy() {
        return this.directProxy;
    }

    @Override
    public Communicator getCommunicator() {
        return this.communicator;
    }

    public void init(ObjectAdapter adapter, String directProxy) {
        this.adapter = adapter;
        this.communicator = adapter.getCommunicator();
        this.directProxy = directProxy;
        Set<String> nodeUuids = this.checkClusterAndAddSelf();
        if (nodeUuids == null) {
            log.warn((Object)"No clusters found. Aborting ring initialization");
        } else {
            this.addManager(this.uuid, directProxy);
            nodeUuids.add(this.uuid);
            this.redirector.chooseNextRedirect(this, nodeUuids);
        }
    }

    protected Set<String> checkClusterAndAddSelf() {
        ClusterNodePrx[] nodes = this.registry.lookupClusterNodes();
        if (nodes == null) {
            log.error((Object)"Could not lookup nodes. Skipping initialization...");
            return null;
        }
        HashSet<String> nodeUuids = new HashSet<String>();
        for (int i = 0; i < nodes.length; ++i) {
            ClusterNodePrx prx = nodes[i];
            if (prx == null) {
                log.warn((Object)"Null proxy found");
                continue;
            }
            try {
                nodeUuids.add(nodes[i].getNodeUuid());
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Error getting uuid from node " + nodes[i] + " -- removing."));
                this.registry.removeObjectSafely(prx.ice_getIdentity());
            }
        }
        log.info((Object)("Got " + nodeUuids.size() + " cluster uuids : " + nodeUuids));
        this.assertNodes(nodeUuids);
        try {
            Identity clusterNode = this.communicator.stringToIdentity("ClusterNode/" + this.uuid);
            this.adapter.add((Ice.Object)this, clusterNode);
            this.registry.addObject(this.adapter.createDirectProxy(clusterNode));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register self as node: ", e);
        }
        return nodeUuids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        Identity id = this.communicator.stringToIdentity("ClusterNode/" + this.uuid);
        this.registry.removeObjectSafely(id);
        this.redirector.handleRingShutdown(this, this.uuid);
        int count = this.closeSessionsForManager(this.uuid);
        log.info((Object)("Removed " + count + " entries for " + this.uuid));
        log.info((Object)"Disconnected from OMERO.cluster");
        Object var4_4 = null;
        Object[] nodes = null;
        try {
            nodes = this.registry.lookupClusterNodes();
            if (nodes == null) return;
            for (Object clusterNodePrx : nodes) {
                try {
                    clusterNodePrx = ClusterNodePrxHelper.uncheckedCast(clusterNodePrx.ice_oneway());
                    clusterNodePrx.down(this.uuid);
                }
                catch (Exception e2) {
                    String msg = "Error signaling down to " + clusterNodePrx;
                    log.warn((Object)msg, (Throwable)e2);
                }
            }
        }
        catch (Exception e3) {
            log.error((Object)("Error signaling down to: " + Arrays.deepToString(nodes)), (Throwable)e3);
            return;
        }
        return;
        {
            catch (Exception e) {
                log.error((Object)("Error stopping ring " + this), (Throwable)e);
                Object var4_5 = null;
                nodes = null;
                try {
                    nodes = this.registry.lookupClusterNodes();
                    if (nodes == null) return;
                    for (Object clusterNodePrx : nodes) {
                        try {
                            clusterNodePrx = ClusterNodePrxHelper.uncheckedCast(clusterNodePrx.ice_oneway());
                            clusterNodePrx.down(this.uuid);
                        }
                        catch (Exception e2) {
                            String msg = "Error signaling down to " + clusterNodePrx;
                            log.warn((Object)msg, (Throwable)e2);
                        }
                    }
                    return;
                }
                catch (Exception e3) {
                    log.error((Object)("Error signaling down to: " + Arrays.deepToString(nodes)), (Throwable)e3);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            nodes = null;
            try {
                nodes = this.registry.lookupClusterNodes();
                if (nodes == null) throw throwable;
                for (Object clusterNodePrx : nodes) {
                    try {
                        clusterNodePrx = ClusterNodePrxHelper.uncheckedCast(clusterNodePrx.ice_oneway());
                        clusterNodePrx.down(this.uuid);
                    }
                    catch (Exception e2) {
                        String msg = "Error signaling down to " + clusterNodePrx;
                        log.warn((Object)msg, (Throwable)e2);
                    }
                }
                throw throwable;
            }
            catch (Exception e3) {
                log.error((Object)("Error signaling down to: " + Arrays.deepToString(nodes)), (Throwable)e3);
            }
            throw throwable;
        }
    }

    @Override
    public String getNodeUuid(Current __current) {
        return this.uuid;
    }

    @Override
    public void down(String downUuid, Current __current) {
        this.redirector.handleRingShutdown(this, downUuid);
    }

    public boolean checkPassword(final String userId) {
        return (Boolean)this.executor.executeStateless((Executor.StatelessWork)new Executor.SimpleStatelessWork(this, "checkPassword"){

            @Transactional(readOnly=true)
            public Object doWork(SimpleJdbcOperations jdbc) {
                int count = jdbc.queryForInt("select count(id) from session s where s.closed is null and s.uuid = ?", new Object[]{userId});
                return count > 0;
            }
        });
    }

    public SessionPrx getProxyOrNull(String userId, SessionControlPrx control, Current current) throws CannotCreateSessionException {
        return this.redirector.getProxyOrNull(this, userId, control, current);
    }

    public Set<String> knownManagers() {
        return this.getManagerList(true);
    }

    public void assertNodes(Set<String> nodeUuids) {
        Set<String> managers = this.knownManagers();
        for (String manager : managers) {
            if (nodeUuids.contains(manager) || this.uuid.equals(manager) || "000000000000000000000000000000000000".equals(manager)) continue;
            this.purgeNode(manager);
        }
    }

    protected void purgeNode(String manager) {
        log.info((Object)("Purging node: " + manager));
        try {
            Identity id = this.communicator.stringToIdentity("ClusterNode/" + manager);
            this.registry.removeObjectSafely(id);
            int count = this.closeSessionsForManager(manager);
            log.info((Object)("Removed " + count + " entries with value " + manager));
            this.setManagerDown(manager);
            log.info((Object)("Removed manager: " + manager));
        }
        catch (Exception e) {
            log.error((Object)("Failed to purge node " + manager), (Throwable)e);
        }
    }

    @Override
    public Set<String> getManagerList(final boolean onlyActive) {
        return (Set)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "getManagerList"){

            @Transactional(readOnly=true)
            public Object doWork(Session session, ServiceFactory sf) {
                List nodes = sf.getQueryService().findAll(Node.class, null);
                HashSet<String> nodeIds = new HashSet<String>();
                for (Node node : nodes) {
                    if (onlyActive && node.getDown() != null) continue;
                    nodeIds.add(node.getUuid());
                }
                return nodeIds;
            }
        });
    }

    private int closeSessionsForManager(final String managerUuid) {
        String sql = "update Session set closed = now() where closed is null and node in (select id from Node where uuid = :uuid)";
        return (Integer)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "executeUpdate - set closed = now()"){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                SQLQuery q = session.createSQLQuery("update Session set closed = now() where closed is null and node in (select id from Node where uuid = :uuid)");
                q.setParameter("uuid", (Object)managerUuid);
                return q.executeUpdate();
            }
        });
    }

    private void setManagerDown(final String managerUuid) {
        this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "setManagerDown"){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                SQLQuery q = session.createSQLQuery("update Node set down = now() where uuid = :uuid");
                q.setParameter("uuid", (Object)managerUuid);
                return q.executeUpdate();
            }
        });
    }

    private Node addManager(String managerUuid, String proxyString) {
        final Node node = new Node();
        node.setConn(proxyString);
        node.setUuid(managerUuid);
        node.setUp(new Timestamp(System.currentTimeMillis()));
        return (Node)this.executor.execute(this.principal, (Executor.Work)new Executor.SimpleWork(this, "addManager"){

            @Transactional(readOnly=false)
            public Object doWork(Session session, ServiceFactory sf) {
                return sf.getUpdateService().saveAndReturnObject((IObject)node);
            }
        });
    }
}

