/*
 * Decompiled with CFR 0.152.
 */
package omeroconnect;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.OMETiffWriter;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import omero.RType;
import omero.ServerError;
import omero.api.GatewayPrx;
import omero.api.IAdminPrx;
import omero.api.IMetadataPrx;
import omero.api.IQueryPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.SearchPrx;
import omero.api.ServiceFactoryPrx;
import omero.client;
import omero.model.Annotation;
import omero.model.AnnotationAnnotationLink;
import omero.model.ChannelI;
import omero.model.Dataset;
import omero.model.DatasetAnnotationLink;
import omero.model.DatasetAnnotationLinkI;
import omero.model.DatasetI;
import omero.model.DatasetImageLinkI;
import omero.model.DimensionOrder;
import omero.model.Experimenter;
import omero.model.FileAnnotation;
import omero.model.FileAnnotationI;
import omero.model.Format;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageAnnotationLink;
import omero.model.ImageAnnotationLinkI;
import omero.model.ImageI;
import omero.model.LogicalChannel;
import omero.model.LogicalChannelI;
import omero.model.LongAnnotation;
import omero.model.LongAnnotationI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Pixels;
import omero.model.PixelsI;
import omero.model.PixelsType;
import omero.model.PixelsTypeI;
import omero.model.Project;
import omero.model.ProjectAnnotationLink;
import omero.model.ProjectAnnotationLinkI;
import omero.model.ProjectDatasetLinkI;
import omero.model.ProjectI;
import omero.model.StatsInfo;
import omero.model.StatsInfoI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import omeroconnect.OPTDataEntry;
import omerojava.util.GatewayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private String loginName = null;
    private long loginId = 0L;
    private client omeroclient;
    private ServiceFactoryPrx sf;
    private GatewayPrx gw;
    private RawPixelsStorePrx rps;
    private SearchPrx srch;
    private IQueryPrx query;
    private IMetadataPrx meta;
    private RawFileStorePrx rfs;
    private IUpdatePrx up;

    public void Main() throws Exception {
    }

    public int initConnectionDetails(String servername, String username, String password) throws Exception {
        System.out.println("Connecting to: " + servername + "...");
        this.omeroclient = new client(servername, 4063);
        try {
            this.sf = this.omeroclient.createSession(username, password);
        }
        catch (CannotCreateSessionException cannotcreateexp) {
            System.out.println("CannotCreateSessionException");
            return -1;
        }
        catch (PermissionDeniedException permdeniedexp) {
            System.out.println("PermissionDeniedException");
            return -2;
        }
        catch (ServerError serverrexp) {
            System.out.println("ServerError");
            return -3;
        }
        this.sf.closeOnDestroy();
        this.getExperimenterData();
        this.gw = this.sf.createGateway();
        this.rps = this.sf.createRawPixelsStore();
        this.srch = this.sf.createSearchService();
        this.query = this.sf.getQueryService();
        this.meta = this.sf.getMetadataService();
        this.rfs = this.sf.createRawFileStore();
        this.up = this.sf.getUpdateService();
        return 1;
    }

    public void closeConnection() throws Exception {
        this.gw.close();
        this.rps.close();
        this.srch.close();
        this.rfs.close();
        this.omeroclient.closeSession();
    }

    public boolean isAlive() {
        boolean alive;
        try {
            this.sf.ice_ping();
            alive = true;
        }
        catch (Exception exc) {
            alive = false;
        }
        return alive;
    }

    public List getDatabase() throws Exception {
        List rv;
        List projects = null;
        ArrayList<ProjectObject> database = new ArrayList<ProjectObject>();
        System.out.println("--- Database data ---");
        projects = rv = this.query.findAllByQuery("select p from Project p left outer join fetch p.datasetLinks dl left outer join fetch dl.child d left outer join fetch d.imageLinks il left outer join fetch il.child i where p.details.owner.id = :loginId", (Parameters)new ParametersI().add("loginId", (RType)rtypes.rlong((long)this.loginId)));
        for (Project proj : projects) {
            List datasets = proj.linkedDatasetList();
            ArrayList<DatasetObject> dsobjlist = new ArrayList<DatasetObject>();
            for (Dataset ds : datasets) {
                List images = ds.linkedImageList();
                DatasetObject dsobj = new DatasetObject(ds, images);
                dsobjlist.add(dsobj);
            }
            ProjectObject pobj = new ProjectObject(proj, dsobjlist);
            database.add(pobj);
        }
        return database;
    }

    public List getAllProjectsList() throws Exception {
        String query_string = "select p from Project p where p.details.owner.id = :loginId";
        ParametersI p = new ParametersI().add("loginId", (RType)rtypes.rlong((long)this.loginId));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        return rv;
    }

    public List getAllDatasetsList() throws Exception {
        String query_string = "select d from Dataset d where d.details.owner.id = :loginId";
        ParametersI p = new ParametersI().add("loginId", (RType)rtypes.rlong((long)this.loginId));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        return rv;
    }

    public List getAllImagesList() throws Exception {
        String query_string = "select i from Image i left outer join where i.details.owner.id = :loginId";
        ParametersI p = new ParametersI().add("loginId", (RType)rtypes.rlong((long)this.loginId));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        return rv;
    }

    public Project getProject(long unique_id) throws Exception {
        String query_string = "select p from Project p left outer join fetch p.annotationLinks alinks where p.id = :uId";
        ParametersI p = new ParametersI().add("uId", (RType)rtypes.rlong((long)unique_id));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        List projs = rv;
        if (projs.size() == 0) {
            System.out.println("ERROR: Project with id:" + unique_id + " does not exist!!!");
            System.exit(1);
        }
        return (Project)projs.get(0);
    }

    public Dataset getDataset(long unique_id) throws Exception {
        String query_string = "select d from Dataset d left outer join fetch d.annotationLinks alinks where d.id = :uId";
        ParametersI p = new ParametersI().add("uId", (RType)rtypes.rlong((long)unique_id));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        List datasets = rv;
        if (datasets.size() == 0) {
            System.out.println("ERROR: Dataset with id:" + unique_id + " does not exist!!!");
            System.exit(1);
        }
        return (Dataset)datasets.get(0);
    }

    public Image getImage(long unique_id) throws Exception {
        String query_string = "select i from Image i left outer join fetch i.pixels pix left outer join fetch i.annotationLinks alinks left outer join fetch alinks.child as a left outer join fetch pix.dimensionOrder dimord left outer join fetch pix.pixelsType pixtype left outer join fetch pix.channels chan where i.id = :uId";
        ParametersI p = new ParametersI().add("uId", (RType)rtypes.rlong((long)unique_id));
        List rv = this.query.findAllByQuery(query_string, (Parameters)p);
        List images = rv;
        if (images.size() == 0) {
            System.out.println("ERROR: Image with id:" + unique_id + " does not exist!!!");
            System.exit(1);
        }
        return (Image)images.get(0);
    }

    public List<Image> getImagesFromProject(Project proj) throws Exception {
        ArrayList<Image> images = new ArrayList<Image>();
        List p = this.query.findAllByQuery("select p from Project p left outer join fetch p.datasetLinks dl left outer join fetch dl.child d left outer join fetch d.imageLinks il left outer join fetch il.child i where p.id = :projectId", (Parameters)new ParametersI().add("projectId", (RType)proj.getId()));
        proj = (Project)p.get(0);
        List datasets = proj.linkedDatasetList();
        ArrayList dsobjlist = new ArrayList();
        for (Dataset ds : datasets) {
            List ds_imgs = ds.linkedImageList();
            images.addAll(ds_imgs);
        }
        return images;
    }

    public List<Image> getImagesFromDataset(Dataset ds) throws Exception {
        ArrayList<Image> images = new ArrayList<Image>();
        List p = this.query.findAllByQuery("select d from Dataset d left outer join fetch d.imageLinks il left outer join fetch il.child i where d.id = :datasetId", (Parameters)new ParametersI().add("datasetId", (RType)ds.getId()));
        ds = (Dataset)p.get(0);
        images.addAll(ds.linkedImageList());
        return images;
    }

    public List<Dataset> getDatasetsFromProject(Project proj) throws Exception {
        ArrayList images = new ArrayList();
        List p = this.query.findAllByQuery("select p from Project p left outer join fetch p.datasetLinks dl left outer join fetch dl.child d where p.id = :projectId", (Parameters)new ParametersI().add("projectId", (RType)proj.getId()));
        proj = (Project)p.get(0);
        List datasets = proj.linkedDatasetList();
        return datasets;
    }

    public List<TagSets> getTagsetsAndTags() throws Exception {
        int i;
        int j;
        boolean found;
        ArrayList<TagSets> tagsets = new ArrayList<TagSets>();
        ArrayList<String> exclude = new ArrayList<String>();
        List tagsetslist = this.meta.loadTagSets(null);
        for (int i2 = 0; i2 < tagsetslist.size(); ++i2) {
            try {
                AnnotationAnnotationLink link = (AnnotationAnnotationLink)tagsetslist.get(i2);
                TagAnnotation parenttag = (TagAnnotation)link.getParent();
                TagAnnotation childtag = (TagAnnotation)link.getChild();
                found = false;
                for (j = 0; j < tagsets.size(); ++j) {
                    if (!((TagSets)tagsets.get((int)j)).tagset.equals(parenttag.getTextValue().getValue())) continue;
                    exclude.add(childtag.getTextValue().getValue());
                    ((TagSets)tagsets.get((int)j)).tags.add(childtag.getTextValue().getValue());
                    found = true;
                }
                if (found) continue;
                exclude.add(parenttag.getTextValue().getValue());
                exclude.add(childtag.getTextValue().getValue());
                TagSets tgs = new TagSets(parenttag.getTextValue().getValue(), childtag.getTextValue().getValue());
                tagsets.add(tgs);
                continue;
            }
            catch (Exception exp) {
                TagAnnotation tag = (TagAnnotation)tagsetslist.get(i2);
                exclude.add(tag.getTextValue().getValue());
                TagSets tgs = new TagSets(tag.getTextValue().getValue());
                tagsets.add(tgs);
            }
        }
        List tags = this.meta.loadSpecifiedAnnotations("TagAnnotation", null, null, null);
        TagSets tgset = new TagSets("Wild-n-Free");
        for (i = 0; i < tags.size(); ++i) {
            TagAnnotation tag = (TagAnnotation)tags.get(i);
            found = false;
            for (j = 0; j < exclude.size(); ++j) {
                if (!((String)exclude.get(j)).equals(tag.getTextValue().getValue())) continue;
                found = true;
            }
            if (found) continue;
            tgset.tags.add(tag.getTextValue().getValue());
        }
        tagsets.add(tgset);
        for (i = 0; i < tagsets.size(); ++i) {
            Collections.sort(((TagSets)tagsets.get((int)i)).tags, String.CASE_INSENSITIVE_ORDER);
        }
        Collections.sort(tagsets);
        return tagsets;
    }

    public List<String> getTagsFromTagset(String tagsetstr) throws Exception {
        List rv;
        ArrayList<String> tags = new ArrayList<String>();
        String query_string = "select link from AnnotationAnnotationLink as link left outer join fetch link.child aalc left outer join fetch link.parent aalp where link.parent.textValue = :namestring";
        ParametersI p = new ParametersI();
        p.add("namestring", (RType)rtypes.rstring((String)tagsetstr));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        for (int i = 0; i < links.size(); ++i) {
            AnnotationAnnotationLink link = (AnnotationAnnotationLink)links.get(i);
            TagAnnotation tag = (TagAnnotation)link.getChild();
            tags.add(tag.getTextValue().getValue());
        }
        return tags;
    }

    public void deleteTagSetAndTags(String tagsetstr) throws Exception {
        List<String> tags = this.getTagsFromTagset(tagsetstr);
        this.deleteTag(tagsetstr);
        for (int i = 0; i < tags.size(); ++i) {
            this.deleteTag(tags.get(i));
        }
    }

    public void deleteTag(String tagstr) throws Exception {
        List rv;
        String query_string = "select tag from TagAnnotation as tag where tag.textValue = :namestring";
        ParametersI p = new ParametersI();
        p.add("namestring", (RType)rtypes.rstring((String)tagstr));
        List tagannots = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        for (int i = 0; i < tagannots.size(); ++i) {
            TagAnnotation tag = (TagAnnotation)tagannots.get(i);
            String tagvalue = tag.getTextValue().getValue();
            List<IObject> imgs = this.getObjectsByTag("Image", tagvalue);
            for (int j = 0; j < imgs.size(); ++j) {
                Image img = (Image)imgs.get(j);
                img = this.getImage(img.getId().getValue());
                this.unlinkTag(img, tagvalue);
            }
            List<IObject> dsets = this.getObjectsByTag("Dataset", tag.getTextValue().getValue());
            for (int j = 0; j < dsets.size(); ++j) {
                Dataset ds = (Dataset)dsets.get(j);
                ds = this.getDataset(ds.getId().getValue());
                this.unlinkTag(ds, tagvalue);
            }
            List<IObject> projs = this.getObjectsByTag("Project", tag.getTextValue().getValue());
            for (int j = 0; j < projs.size(); ++j) {
                Project proj = (Project)projs.get(j);
                proj = this.getProject(proj.getId().getValue());
                this.unlinkTag(proj, tagvalue);
            }
            this.removeFromDatabase((IObject)tag);
        }
    }

    public void deleteTags(List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.deleteTag(tags.get(i));
        }
    }

    public void deleteTags(String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.deleteTag(tags[i]);
        }
    }

    public void addTags(Image img, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.addTag(img, tags.get(i));
        }
    }

    public void addTags(Dataset ds, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.addTag(ds, tags.get(i));
        }
    }

    public void addTags(Project proj, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.addTag(proj, tags.get(i));
        }
    }

    public void addTags(Image img, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.addTag(img, tags[i]);
        }
    }

    public void addTags(Dataset ds, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.addTag(ds, tags[i]);
        }
    }

    public void addTags(Project proj, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.addTag(proj, tags[i]);
        }
    }

    public void addTag(Image img, String tagstr) throws Exception {
        List rv;
        String query_string = "select link from ImageAnnotationLink as link left outer join fetch link.child ilc left outer join fetch link.parent ilp where link.child.textValue = :namestring";
        ParametersI p = new ParametersI();
        p.add("namestring", (RType)rtypes.rstring((String)tagstr));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        TagAnnotation tag = null;
        if (links.size() != 0) {
            tag = (TagAnnotation)((ImageAnnotationLink)links.get(0)).getChild();
            try {
                ImageAnnotationLink link = img.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                System.out.println("Warning: Object already contains this tag!");
            }
        } else {
            query_string = "select tag from TagAnnotation as tag where tag.textValue = :namestring";
            p = new ParametersI();
            p.add("namestring", (RType)rtypes.rstring((String)tagstr));
            List tags = rv = this.query.findAllByQuery(query_string, (Parameters)p);
            if (tags.size() != 0) {
                System.out.println("Tag Does Exists!");
                img.unloadCollections();
                ImageAnnotationLinkI link = new ImageAnnotationLinkI();
                link.setParent(img);
                link.setChild((Annotation)tags.get(0));
                this.setToDatabase((IObject)link);
            } else {
                System.out.println("Tag Does Not Exists!");
                tag = new TagAnnotationI();
                tag.setTextValue(rtypes.rstring((String)tagstr));
                img.unloadCollections();
                ImageAnnotationLinkI link = new ImageAnnotationLinkI();
                link.setParent(img);
                link.setChild((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
        }
    }

    public void addTag(Dataset ds, String tagstr) throws Exception {
        List rv;
        String query_string = "select link from DatasetAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.textValue = :namestring";
        ParametersI p = new ParametersI();
        p.add("namestring", (RType)rtypes.rstring((String)tagstr));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        TagAnnotation tag = null;
        if (links.size() != 0) {
            tag = (TagAnnotation)((DatasetAnnotationLink)links.get(0)).getChild();
            try {
                DatasetAnnotationLink link = ds.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                System.out.println("Warning: Object already contains this tag!");
            }
        } else {
            query_string = "select tag from TagAnnotation as tag where tag.textValue = :namestring";
            p = new ParametersI();
            p.add("namestring", (RType)rtypes.rstring((String)tagstr));
            List tags = rv = this.query.findAllByQuery(query_string, (Parameters)p);
            if (tags.size() != 0) {
                System.out.println("Tag Does Exists!");
                ds.unloadCollections();
                DatasetAnnotationLinkI link = new DatasetAnnotationLinkI();
                link.setParent(ds);
                link.setChild((Annotation)tags.get(0));
                this.setToDatabase((IObject)link);
            } else {
                System.out.println("Tag Does Not Exists!");
                tag = new TagAnnotationI();
                tag.setTextValue(rtypes.rstring((String)tagstr));
                ds.unloadCollections();
                DatasetAnnotationLinkI link = new DatasetAnnotationLinkI();
                link.setParent(ds);
                link.setChild((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
        }
    }

    public void addTag(Project proj, String tagstr) throws Exception {
        List rv;
        String query_string = "select link from ProjectAnnotationLink as link left outer join fetch link.child plc left outer join fetch link.parent plp where link.child.textValue = :namestring";
        ParametersI p = new ParametersI();
        p.add("namestring", (RType)rtypes.rstring((String)tagstr));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        TagAnnotation tag = null;
        if (links.size() != 0) {
            tag = (TagAnnotation)((ProjectAnnotationLink)links.get(0)).getChild();
            try {
                ProjectAnnotationLink link = proj.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                System.out.println("Warning: Object already contains this tag!");
            }
        } else {
            query_string = "select tag from TagAnnotation as tag where tag.textValue = :namestring";
            p = new ParametersI();
            p.add("namestring", (RType)rtypes.rstring((String)tagstr));
            List tags = rv = this.query.findAllByQuery(query_string, (Parameters)p);
            if (tags.size() != 0) {
                System.out.println("Tag Does Exists!");
                proj.unloadCollections();
                ProjectAnnotationLinkI link = new ProjectAnnotationLinkI();
                link.setParent(proj);
                link.setChild((Annotation)tags.get(0));
                this.setToDatabase((IObject)link);
            } else {
                System.out.println("Tag Does Not Exists!");
                tag = new TagAnnotationI();
                tag.setTextValue(rtypes.rstring((String)tagstr));
                proj.unloadCollections();
                ProjectAnnotationLinkI link = new ProjectAnnotationLinkI();
                link.setParent(proj);
                link.setChild((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
        }
    }

    public List<String> getTags(Image img) throws Exception {
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(img.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Image", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(img.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                tags.add(tag.getTextValue().getValue());
            }
        }
        return tags;
    }

    public List<String> getTags(Dataset ds) throws Exception {
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(ds.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Dataset", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(ds.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                tags.add(tag.getTextValue().getValue());
            }
        }
        return tags;
    }

    public List<String> getTags(Project proj) throws Exception {
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(proj.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Project", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(proj.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                tags.add(tag.getTextValue().getValue());
            }
        }
        return tags;
    }

    public void unlinkTag(Image img, String tagstr) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(img.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Image", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(img.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                List rv;
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                if (!tag.getTextValue().getValue().equals(tagstr)) continue;
                String query_string = "select link from ImageAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.id = :tagID and link.parent.id = :imageID";
                ParametersI p = new ParametersI();
                p.add("tagID", (RType)rtypes.rlong((long)tag.getId().getValue()));
                p.add("imageID", (RType)rtypes.rlong((long)img.getId().getValue()));
                List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
                for (int j = 0; j < links.size(); ++j) {
                    ImageAnnotationLink link = (ImageAnnotationLink)links.get(j);
                    img.removeImageAnnotationLink(link);
                    this.removeFromDatabase((IObject)link);
                }
            }
        }
    }

    public void unlinkTag(Dataset ds, String tagstr) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(ds.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Dataset", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(ds.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                List rv;
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                if (!tag.getTextValue().getValue().equals(tagstr)) continue;
                String query_string = "select link from DatasetAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.id = :tagID and link.parent.id = :dsID";
                ParametersI p = new ParametersI();
                p.add("tagID", (RType)rtypes.rlong((long)tag.getId().getValue()));
                p.add("dsID", (RType)rtypes.rlong((long)ds.getId().getValue()));
                List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
                for (int j = 0; j < links.size(); ++j) {
                    DatasetAnnotationLink link = (DatasetAnnotationLink)links.get(j);
                    ds.removeDatasetAnnotationLink(link);
                    this.removeFromDatabase((IObject)link);
                }
            }
        }
    }

    public void unlinkTag(Project proj, String tagstr) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(proj.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.TagAnnotation");
        Map annots = this.meta.loadAnnotations("Project", objectids, annotype, userids, null);
        if (!annots.isEmpty()) {
            List entries = (List)annots.get(proj.getId().getValue());
            for (int i = 0; i < entries.size(); ++i) {
                List rv;
                TagAnnotation tag = (TagAnnotation)entries.get(i);
                if (!tag.getTextValue().getValue().equals(tagstr)) continue;
                String query_string = "select link from ProjectAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.id = :tagID and link.parent.id = :imageID";
                ParametersI p = new ParametersI();
                p.add("tagID", (RType)rtypes.rlong((long)tag.getId().getValue()));
                p.add("imageID", (RType)rtypes.rlong((long)proj.getId().getValue()));
                List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
                for (int j = 0; j < links.size(); ++j) {
                    ProjectAnnotationLink link = (ProjectAnnotationLink)links.get(j);
                    proj.removeProjectAnnotationLink(link);
                    this.removeFromDatabase((IObject)link);
                }
            }
        }
    }

    public void unlinkTags(Image img, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.unlinkTag(img, tags.get(i));
        }
    }

    public void unlinkTags(Dataset ds, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.unlinkTag(ds, tags.get(i));
        }
    }

    public void unlinkTags(Project proj, List<String> tags) throws Exception {
        for (int i = 0; i < tags.size(); ++i) {
            this.unlinkTag(proj, tags.get(i));
        }
    }

    public void unlinkTags(Image img, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.unlinkTag(img, tags[i]);
        }
    }

    public void unlinkTags(Dataset ds, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.unlinkTag(ds, tags[i]);
        }
    }

    public void unlinkTags(Project proj, String[] tags) throws Exception {
        for (int i = 0; i < tags.length; ++i) {
            this.unlinkTag(proj, tags[i]);
        }
    }

    public long getRating(Image img) throws Exception {
        List rv;
        long ratingval = 0L;
        String query_string = "select link from ImageAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :imageID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("imageID", (RType)rtypes.rlong((long)img.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotation tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((ImageAnnotationLink)links.get(0)).getChild();
            ratingval = tag.getLongValue().getValue();
        } else {
            ratingval = -1L;
        }
        return ratingval;
    }

    public long getRating(Dataset ds) throws Exception {
        List rv;
        long ratingval = 0L;
        String query_string = "select link from DatasetAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :datasetID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("imageID", (RType)rtypes.rlong((long)ds.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotation tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((DatasetAnnotationLink)links.get(0)).getChild();
            ratingval = tag.getLongValue().getValue();
        } else {
            ratingval = -1L;
        }
        return ratingval;
    }

    public long getRating(Project proj) throws Exception {
        List rv;
        long ratingval = 0L;
        String query_string = "select link from ProjectAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :projectID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("projectID", (RType)rtypes.rlong((long)proj.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotation tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((ProjectAnnotationLink)links.get(0)).getChild();
            ratingval = tag.getLongValue().getValue();
        } else {
            ratingval = -1L;
        }
        return ratingval;
    }

    public void setRating(Image img, long rating) throws Exception {
        List rv;
        if (rating < 0L || rating > 5L) {
            return;
        }
        String query_string = "select link from ImageAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :imageID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("imageID", (RType)rtypes.rlong((long)img.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotationI tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((ImageAnnotationLink)links.get(0)).getChild();
            tag.setLongValue(rtypes.rlong((long)rating));
            try {
                ImageAnnotationLink link = img.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                tag.setLongValue(rtypes.rlong((long)rating));
                this.setToDatabase((IObject)tag);
            }
        } else {
            tag = new LongAnnotationI();
            tag.setLongValue(rtypes.rlong((long)rating));
            tag.setNs(rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
            ImageAnnotationLink link = img.linkAnnotation((Annotation)tag);
            this.setToDatabase((IObject)link);
        }
    }

    public void setRating(Dataset ds, long rating) throws Exception {
        List rv;
        if (rating < 0L || rating > 5L) {
            return;
        }
        String query_string = "select link from DatasetAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :datasetID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("datasetID", (RType)rtypes.rlong((long)ds.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotationI tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((DatasetAnnotationLink)links.get(0)).getChild();
            tag.setLongValue(rtypes.rlong((long)rating));
            try {
                DatasetAnnotationLink link = ds.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                tag.setLongValue(rtypes.rlong((long)rating));
                this.setToDatabase((IObject)tag);
            }
        } else {
            tag = new LongAnnotationI();
            tag.setLongValue(rtypes.rlong((long)rating));
            tag.setNs(rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
            DatasetAnnotationLink link = ds.linkAnnotation((Annotation)tag);
            this.setToDatabase((IObject)link);
        }
    }

    public void setRating(Project proj, long rating) throws Exception {
        List rv;
        if (rating < 0L || rating > 5L) {
            return;
        }
        String query_string = "select link from ProjectAnnotationLink as link left outer join fetch link.child dlc left outer join fetch link.parent dlp where link.child.ns = :namespacestring and link.parent.id = :projectID";
        ParametersI p = new ParametersI();
        p.add("namespacestring", (RType)rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
        p.add("projectID", (RType)rtypes.rlong((long)proj.getId().getValue()));
        List links = rv = this.query.findAllByQuery(query_string, (Parameters)p);
        LongAnnotationI tag = null;
        if (links.size() != 0) {
            tag = (LongAnnotation)((ProjectAnnotationLink)links.get(0)).getChild();
            tag.setLongValue(rtypes.rlong((long)rating));
            try {
                ProjectAnnotationLink link = proj.linkAnnotation((Annotation)tag);
                this.setToDatabase((IObject)link);
            }
            catch (Exception ex) {
                tag.setLongValue(rtypes.rlong((long)rating));
                this.setToDatabase((IObject)tag);
            }
        } else {
            tag = new LongAnnotationI();
            tag.setLongValue(rtypes.rlong((long)rating));
            tag.setNs(rtypes.rstring((String)"openmicroscopy.org/omero/insight/rating"));
            ProjectAnnotationLink link = proj.linkAnnotation((Annotation)tag);
            this.setToDatabase((IObject)link);
        }
    }

    public void addFile(Image img, String filestr) throws Exception {
        FileAnnotation fa = this.loadFile(filestr);
        if (fa == null) {
            return;
        }
        ImageAnnotationLink annotlink = img.linkAnnotation((Annotation)fa);
        this.setToDatabase((IObject)annotlink);
    }

    public void addFile(Dataset ds, String filestr) throws Exception {
        FileAnnotation fa = this.loadFile(filestr);
        if (fa == null) {
            return;
        }
        DatasetAnnotationLink annotlink = ds.linkAnnotation((Annotation)fa);
        this.setToDatabase((IObject)annotlink);
    }

    public void addFile(Project proj, String filestr) throws Exception {
        FileAnnotation fa = this.loadFile(filestr);
        if (fa == null) {
            return;
        }
        ProjectAnnotationLink annotlink = proj.linkAnnotation((Annotation)fa);
        this.setToDatabase((IObject)annotlink);
    }

    public void saveFiles(Image img, String path) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(img.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Image", objectids, annotype, userids, null);
        List entries = (List)annots.get(img.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            String filename = fileannot.getFile().getName().getValue();
            long filesize = fileannot.getFile().getSize().getValue();
            long fileid = fileannot.getFile().getId().getValue();
            this.rfs.setFileId(fileid);
            byte[] filedata = this.rfs.read(0L, (int)filesize);
            FileOutputStream fos = new FileOutputStream(path + "/" + filename);
            fos.write(filedata);
            fos.close();
        }
    }

    public void saveFiles(Dataset ds, String path) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(ds.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Dataset", objectids, annotype, userids, null);
        List entries = (List)annots.get(ds.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            String filename = fileannot.getFile().getName().getValue();
            long filesize = fileannot.getFile().getSize().getValue();
            long fileid = fileannot.getFile().getId().getValue();
            this.rfs.setFileId(fileid);
            byte[] filedata = this.rfs.read(0L, (int)filesize);
            FileOutputStream fos = new FileOutputStream(path + "/" + filename);
            fos.write(filedata);
            fos.close();
        }
    }

    public void saveFiles(Project proj, String path) throws Exception {
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(proj.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Project", objectids, annotype, userids, null);
        List entries = (List)annots.get(proj.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            String filename = fileannot.getFile().getName().getValue();
            long filesize = fileannot.getFile().getSize().getValue();
            long fileid = fileannot.getFile().getId().getValue();
            this.rfs.setFileId(fileid);
            byte[] filedata = this.rfs.read(0L, (int)filesize);
            FileOutputStream fos = new FileOutputStream(path + "/" + filename);
            fos.write(filedata);
            fos.close();
        }
    }

    public void copyAnnotations(Image img_src, Image img_dst) throws Exception {
        img_dst.unloadCollections();
        List<String> tags = this.getTags(img_src);
        for (int i = 0; i < tags.size(); ++i) {
            String curr_tag = tags.get(i);
            this.addTag(img_dst, curr_tag);
        }
        List<FileAnnotation> fileannots = this.getFiles(img_src);
        for (int i = 0; i < fileannots.size(); ++i) {
            FileAnnotation fileannot = fileannots.get(i);
            ImageAnnotationLinkI link = new ImageAnnotationLinkI();
            link.setParent(img_dst);
            link.setChild((Annotation)fileannot);
            this.setToDatabase((IObject)link);
        }
        long rating = this.getRating(img_src);
        this.setRating(img_dst, rating);
    }

    public void copyAnnotations(Dataset ds_src, Dataset ds_dst) throws Exception {
        ds_dst.unloadCollections();
        List<String> tags = this.getTags(ds_src);
        for (int i = 0; i < tags.size(); ++i) {
            String curr_tag = tags.get(i);
            this.addTag(ds_dst, curr_tag);
        }
        List<OriginalFile> files = this.getFiles(ds_src);
        for (int i = 0; i < files.size(); ++i) {
            OriginalFile oFile = files.get(i);
            FileAnnotationI fa = new FileAnnotationI();
            fa.setFile(oFile);
            DatasetAnnotationLinkI annotlink = new DatasetAnnotationLinkI();
            annotlink.setParent(ds_dst);
            annotlink.setChild((Annotation)fa);
            this.setToDatabase((IObject)annotlink);
        }
        long rating = this.getRating(ds_src);
        this.setRating(ds_dst, rating);
    }

    public void copyAnnotations(Project proj_src, Project proj_dst) throws Exception {
        proj_dst.unloadCollections();
        List<String> tags = this.getTags(proj_src);
        for (int i = 0; i < tags.size(); ++i) {
            String curr_tag = tags.get(i);
            this.addTag(proj_dst, curr_tag);
        }
        List<OriginalFile> files = this.getFiles(proj_src);
        for (int i = 0; i < files.size(); ++i) {
            OriginalFile oFile = files.get(i);
            FileAnnotationI fa = new FileAnnotationI();
            fa.setFile(oFile);
            ProjectAnnotationLinkI annotlink = new ProjectAnnotationLinkI();
            annotlink.setParent(proj_dst);
            annotlink.setChild((Annotation)fa);
            this.setToDatabase((IObject)annotlink);
        }
        long rating = this.getRating(proj_src);
        this.setRating(proj_dst, rating);
    }

    public void setToDatabase(IObject obj) throws Exception {
        this.up.saveObject(obj);
    }

    public IObject setToDatabaseAndReturnObject(IObject obj) throws Exception {
        return this.up.saveAndReturnObject(obj);
    }

    public void removeFromDatabase(IObject obj) throws Exception {
        this.up.deleteObject(obj);
    }

    public void printDatabase(List<ProjectObject> db) throws Exception {
        for (ProjectObject projobj : db) {
            System.out.println("-Project: " + projobj.project.getId().getValue() + " / " + projobj.project.getName().getValue());
            List dslist = projobj.datasets;
            for (DatasetObject dsobj : dslist) {
                System.out.println("\t-Dataset: " + dsobj.dataset.getId().getValue() + " / " + dsobj.dataset.getName().getValue());
                List imgslist = dsobj.images;
                for (Image img : imgslist) {
                    System.out.println("\t\t-Image: " + img.getId().getValue() + " / " + img.getName().getValue());
                }
            }
        }
    }

    public void saveImage(long unique_id, String dirname) throws Exception {
        Image img = this.getImage(unique_id);
        String imgname = img.getName().getValue();
        int startindex = imgname.lastIndexOf("/");
        imgname = imgname.substring(startindex + 1);
        imgname = imgname.replace('.', '_');
        String filename = dirname + imgname;
        Pixels pix = img.getPixels(0);
        this.rps.setPixelsId(pix.getId().getValue(), true);
        int xsize = pix.getSizeX().getValue();
        int ysize = pix.getSizeY().getValue();
        int zsize = pix.getSizeZ().getValue();
        int csize = pix.getSizeC().getValue();
        int tsize = pix.getSizeT().getValue();
        Double xreso = pix.getPhysicalSizeX().getValue();
        Double yreso = pix.getPhysicalSizeY().getValue();
        Double zreso = pix.getPhysicalSizeZ().getValue();
        int numbimgs = zsize * tsize * csize;
        System.out.println("=============================================");
        System.out.println("Image INFO:");
        System.out.println("(x,y,z) (c,t): (" + xsize + "," + ysize + "," + zsize + ") (" + csize + "," + tsize + ")");
        System.out.println("(x res, y res, z res):(" + xreso + "," + yreso + "," + zreso + ")");
        System.out.println("number of images: " + numbimgs);
        System.out.println("=============================================");
        System.out.println("Saving to OME-TIFF...");
        boolean eostack = false;
        boolean eoseries = false;
        boolean i = false;
        for (int t = 0; t < tsize; ++t) {
            int tdigits = Integer.toString(t).length();
            String tnumb = Integer.toString(t);
            if (tdigits == 1) {
                tnumb = "T00" + tnumb;
            } else if (tdigits == 2) {
                tnumb = "T0" + tnumb;
            }
            String current_file = filename + "_" + tnumb + ".tiff";
            IMetadata meta = MetadataTools.createOMEXMLMetadata();
            meta.createRoot();
            OMETiffWriter ometiffwriter = new OMETiffWriter();
            ometiffwriter.setMetadataRetrieve((MetadataRetrieve)meta);
            ometiffwriter.setId(current_file);
            System.out.println("Saving file: " + current_file);
            meta.setPixelsDimensionOrder("XYZCT", 0, 0);
            meta.setPixelsPixelType(pix.getPixelsType().getValue().getValue(), 0, 0);
            meta.setPixelsID("0", 0, 0);
            meta.setPixelsSizeX(Integer.valueOf(xsize), 0, 0);
            meta.setPixelsSizeY(Integer.valueOf(ysize), 0, 0);
            meta.setPixelsSizeZ(Integer.valueOf(zsize), 0, 0);
            meta.setPixelsSizeC(Integer.valueOf(csize), 0, 0);
            meta.setPixelsSizeT(Integer.valueOf(1), 0, 0);
            meta.setPixelsBigEndian(Boolean.valueOf(false), 0, 0);
            meta.setDimensionsPhysicalSizeX(Float.valueOf(xreso.floatValue()), 0, 0);
            meta.setDimensionsPhysicalSizeY(Float.valueOf(yreso.floatValue()), 0, 0);
            meta.setDimensionsPhysicalSizeZ(Float.valueOf(zreso.floatValue()), 0, 0);
            meta.setLogicalChannelSamplesPerPixel(Integer.valueOf(csize), 0, 0);
            for (int c = 0; c < csize; ++c) {
                int cdigits = Integer.toString(c).length();
                String cnumb = Integer.toString(c);
                if (cdigits == 1) {
                    cnumb = "C00" + cnumb;
                } else if (cdigits == 2) {
                    cnumb = "C0" + cnumb;
                }
                for (int z = 0; z < zsize; ++z) {
                    this.progress(c * (zsize - 1) + z, csize * zsize);
                    eostack = false;
                    if (c * (zsize - 1) + z == csize * (zsize - 1)) {
                        System.out.println("last in file");
                        eostack = true;
                    }
                    byte[] image_bytedata = this.rps.getPlane(z, c, t);
                    ometiffwriter.saveBytes(image_bytedata, eostack);
                }
            }
        }
    }

    public Image uploadImage(String localfilepath, String imgname, String imgdesc) throws Exception {
        OMEROMetadataStoreClient store = new OMEROMetadataStoreClient();
        store.initialize(this.sf);
        OMEROWrapper reader = new OMEROWrapper();
        ImportLibrary lib = new ImportLibrary(store, reader);
        File file = new File(localfilepath);
        List pixs = lib.importImage(file, 1, 1, 1, imgname, imgdesc, false, null);
        Image img = ((Pixels)pixs.get(0)).getImage();
        img = this.getImage(img.getId().getValue());
        img.setName(rtypes.rstring((String)imgname));
        img.setDescription(rtypes.rstring((String)imgdesc));
        img = (Image)this.setToDatabaseAndReturnObject((IObject)img);
        store.logout();
        reader.close();
        return img;
    }

    public Image uploadImage(File file, String imgname, String imgdesc) throws Exception {
        System.out.println("Intialising objects...");
        OMEROMetadataStoreClient store = new OMEROMetadataStoreClient();
        store.initialize(this.sf);
        OMEROWrapper reader = new OMEROWrapper();
        ImportLibrary lib = new ImportLibrary(store, reader);
        System.out.println("Importing Image...");
        List pixs = null;
        pixs = lib.importImage(file, 1, 1, 1, imgname, imgdesc, false, null);
        Image img = ((Pixels)pixs.get(0)).getImage();
        img = this.getImage(img.getId().getValue());
        System.out.println("Setting name and description...");
        img.setName(rtypes.rstring((String)imgname));
        img.setDescription(rtypes.rstring((String)imgdesc));
        System.out.println("Saving ojbect...");
        img = (Image)this.setToDatabaseAndReturnObject((IObject)img);
        System.out.println("De-Intialising objects...");
        store.logout();
        reader.close();
        return img;
    }

    public List<Image> uploadOPTDirectory(File file) throws Exception {
        OPTDataEntry optdir = new OPTDataEntry(file);
        ArrayList<Image> imgs = new ArrayList<Image>();
        for (int i = 0; i < optdir.metadata_allscans.size(); ++i) {
            OPTDataEntry.ImageCoreMetadata meta = optdir.metadata_allscans.get(i);
            Image img = this.createImage(meta.scan_name, "", meta.x, meta.y, meta.z, meta.c, meta.t, meta.pixelType);
            Pixels pix = img.getPrimaryPixels();
            pix.setPhysicalSizeX(rtypes.rdouble((double)meta.physicalX));
            pix.setPhysicalSizeY(rtypes.rdouble((double)meta.physicalY));
            pix.setPhysicalSizeZ(rtypes.rdouble((double)meta.physicalZ));
            img.setPrimaryPixels(pix);
            img = (Image)this.setToDatabaseAndReturnObject((IObject)img);
            for (int c = 0; c < meta.c; ++c) {
                File imgdir = null;
                if (i == 0) {
                    imgdir = new File(optdir.fileobj.getAbsolutePath() + "\\" + optdir.scanProjChannelDirNames.get(c).getName());
                } else if (i == 1) {
                    imgdir = new File(optdir.fileobj.getAbsolutePath() + "\\" + optdir.scanProjChannelDirNames.get(c).getName() + "\\" + optdir.scanReconChannelDirNames.get(c).getName());
                }
                File[] imgfiles = imgdir.listFiles();
                int z = 0;
                byte[] arrayBuf = null;
                arrayBuf = i == 0 ? new byte[524288] : new byte[262144];
                for (int k = 0; k < imgfiles.length; ++k) {
                    File imgfile = imgfiles[k];
                    if (!imgfile.getName().contains("bmp") && !imgfile.getName().contains("tif")) continue;
                    System.out.println(arrayBuf.length);
                    ++z;
                }
            }
            this.addFile(img, optdir.scanMetafile.getAbsolutePath());
            if (i == 0) {
                this.addFile(img, optdir.scanProjMetafile.getAbsolutePath());
            } else if (i == 1) {
                this.addFile(img, optdir.scanReconMetafile.getAbsolutePath());
            }
            imgs.add(img);
        }
        return imgs;
    }

    public Image createImage(String name, String desc, int xres, int yres, int zres, int cres, int tres, String pixelType) throws Exception {
        ArrayList<Integer> chans = new ArrayList<Integer>();
        for (int i = 0; i < cres; ++i) {
            chans.add(new Integer(i));
        }
        PixelsTypeI pixstype = new PixelsTypeI();
        if (pixelType.equals("uint8")) {
            pixstype.setValue(rtypes.rstring((String)"uint8"));
        } else if (pixelType.equals("uint16")) {
            pixstype.setValue(rtypes.rstring((String)"uint16"));
        } else if (pixelType.equals("uint32")) {
            pixstype.setValue(rtypes.rstring((String)"uint32"));
        } else if (pixelType.equals("int8")) {
            pixstype.setValue(rtypes.rstring((String)"int8"));
        } else if (pixelType.equals("int16")) {
            pixstype.setValue(rtypes.rstring((String)"int16"));
        } else if (pixelType.equals("int32")) {
            pixstype.setValue(rtypes.rstring((String)"int32"));
        } else if (pixelType.equals("double")) {
            pixstype.setValue(rtypes.rstring((String)"double"));
        } else if (pixelType.equals("float")) {
            pixstype.setValue(rtypes.rstring((String)"float"));
        }
        long image_id = this.gw.createImage(xres, yres, zres, tres, chans, (PixelsType)pixstype, name, desc);
        Image img = this.getImage(image_id);
        Pixels pix = img.getPrimaryPixels();
        ArrayList<ChannelI> chan_list = new ArrayList<ChannelI>();
        for (int i = 0; i < cres; ++i) {
            ChannelI src_chan = new ChannelI();
            LogicalChannelI dst_logchan = new LogicalChannelI();
            StatsInfoI dst_stats = new StatsInfoI();
            if (pixelType.equals("uint8") || pixelType.equals("int8")) {
                dst_stats.setGlobalMin(rtypes.rdouble((double)0.0));
                dst_stats.setGlobalMax(rtypes.rdouble((double)255.0));
            } else if (pixelType.equals("uint16") || pixelType.equals("int16")) {
                dst_stats.setGlobalMin(rtypes.rdouble((double)0.0));
                dst_stats.setGlobalMax(rtypes.rdouble((double)65535.0));
            } else if (pixelType.equals("uint32") || pixelType.equals("int32")) {
                dst_stats.setGlobalMin(rtypes.rdouble((double)0.0));
                dst_stats.setGlobalMax(rtypes.rdouble((double)4.294967295E9));
            }
            dst_logchan.setEmissionWave(rtypes.rint((int)i));
            dst_logchan.setExcitationWave(rtypes.rint((int)i));
            src_chan.setLogicalChannel((LogicalChannel)dst_logchan);
            src_chan.setStatsInfo((StatsInfo)dst_stats);
            chan_list.add(src_chan);
        }
        pix.addAllChannelSet(chan_list);
        img.setPrimaryPixels(pix);
        img = (Image)this.gw.saveAndReturnObject((IObject)img);
        img = this.getImage(img.getId().getValue());
        return img;
    }

    public Image copyImage(Image img) throws Exception {
        Pixels src_pix = img.getPrimaryPixels();
        int x = src_pix.getSizeX().getValue();
        int y = src_pix.getSizeY().getValue();
        int t = src_pix.getSizeT().getValue();
        int z = src_pix.getSizeZ().getValue();
        int c = src_pix.getSizeC().getValue();
        System.out.println("image dimensions:");
        System.out.println("x: " + x + " y: " + y + " z:" + z + " t:" + t + " c:" + c);
        src_pix = this.gw.getPixels(src_pix.getId().getValue());
        DimensionOrder dst_dimord = src_pix.getDimensionOrder();
        PixelsI dst_pix = new PixelsI();
        dst_pix.setDimensionOrder(dst_dimord);
        dst_pix.setSizeX(rtypes.rint((int)x));
        dst_pix.setSizeY(rtypes.rint((int)y));
        dst_pix.setSizeZ(rtypes.rint((int)z));
        dst_pix.setSizeC(rtypes.rint((int)c));
        dst_pix.setSizeT(rtypes.rint((int)t));
        dst_pix.setPhysicalSizeX(src_pix.getPhysicalSizeX());
        dst_pix.setPhysicalSizeY(src_pix.getPhysicalSizeY());
        dst_pix.setPhysicalSizeZ(src_pix.getPhysicalSizeZ());
        dst_pix.setSha1(src_pix.getSha1());
        PixelsTypeI pixtype = new PixelsTypeI();
        pixtype.setValue(src_pix.getPixelsType().getValue());
        dst_pix.setPixelsType((PixelsType)pixtype);
        Pixels pix = img.getPrimaryPixels();
        ArrayList<ChannelI> chan_list = new ArrayList<ChannelI>();
        for (int i = 0; i < c; ++i) {
            ChannelI chan = new ChannelI();
            LogicalChannelI logchan = new LogicalChannelI();
            StatsInfoI stats = new StatsInfoI();
            stats.setGlobalMin(rtypes.rdouble((double)0.0));
            stats.setGlobalMax(rtypes.rdouble((double)255.0));
            logchan.setEmissionWave(rtypes.rint((int)i));
            chan.setLogicalChannel((LogicalChannel)logchan);
            chan.setStatsInfo((StatsInfo)stats);
            chan_list.add(chan);
        }
        dst_pix.addAllChannelSet(chan_list);
        ImageI dst_img = new ImageI();
        dst_img.setName(rtypes.rstring((String)"NewImage"));
        dst_img.setAcquisitionDate(img.getAcquisitionDate());
        dst_img.addPixels((Pixels)dst_pix);
        dst_img.setPrimaryPixels((Pixels)dst_pix);
        dst_img = (Image)this.gw.saveAndReturnObject((IObject)dst_img);
        return dst_img;
    }

    public byte[] getPlane(Image img, int z, int c, int t) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        this.rps.setPixelsId(pix.getId().getValue(), true);
        byte[] plane_data = this.rps.getPlane(z, c, t);
        return plane_data;
    }

    public byte[] getPlane(long unique_id, int z, int c, int t) throws Exception {
        Image img = this.getImage(unique_id);
        Pixels pix = img.getPrimaryPixels();
        this.rps.setPixelsId(pix.getId().getValue(), true);
        byte[] plane_data = this.rps.getPlane(z, c, t);
        return plane_data;
    }

    public void setPlane(Image img, byte[] plane_data, int z, int c, int t) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        this.gw.uploadPlane(pix.getId().getValue(), z, c, t, plane_data);
    }

    public void setPlane(Image img, double[][] plane_data, int z, int c, int t) throws Exception {
        byte[] bytearray = this.convertClientToServer(img, plane_data);
        Pixels pix = img.getPrimaryPixels();
        this.gw.uploadPlane(pix.getId().getValue(), z, c, t, bytearray);
    }

    public String getPixelType(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        String pixtype = pix.getPixelsType().getValue().getValue();
        return pixtype;
    }

    public int getX(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        int x = pix.getSizeX().getValue();
        return x;
    }

    public int getY(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        int y = pix.getSizeY().getValue();
        return y;
    }

    public int getZ(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        int z = pix.getSizeZ().getValue();
        return z;
    }

    public int getC(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        int c = pix.getSizeC().getValue();
        return c;
    }

    public int getT(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        int t = pix.getSizeT().getValue();
        return t;
    }

    public double getPhysicalX(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        double x = pix.getPhysicalSizeX().getValue();
        return x;
    }

    public double getPhysicalY(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        double y = pix.getPhysicalSizeY().getValue();
        return y;
    }

    public double getPhysicalZ(Image img) throws Exception {
        Pixels pix = img.getPrimaryPixels();
        double z = pix.getPhysicalSizeZ().getValue();
        return z;
    }

    public void attachImageToDataset(Dataset ds, Image img) throws Exception {
        DatasetImageLinkI link = new DatasetImageLinkI();
        link.link(ds, img);
        this.setToDatabase((IObject)link);
    }

    public void attachImagesToDataset(Dataset ds, Image[] imgs) throws Exception {
        for (int i = 0; i < imgs.length; ++i) {
            DatasetImageLinkI link = new DatasetImageLinkI();
            link.link(ds, imgs[i]);
            this.setToDatabase((IObject)link);
        }
    }

    public void attachImagesToDataset(Dataset ds, List<Image> imgs) throws Exception {
        for (int i = 0; i < imgs.size(); ++i) {
            DatasetImageLinkI link = new DatasetImageLinkI();
            link.link(ds, imgs.get(i));
            this.setToDatabase((IObject)link);
        }
    }

    public void attachDatasetToProject(Project proj, Dataset ds) throws Exception {
        ProjectDatasetLinkI link = new ProjectDatasetLinkI();
        link.link(proj, ds);
        this.setToDatabase((IObject)link);
    }

    public void attachDatasetsToProject(Project proj, Dataset[] dsets) throws Exception {
        for (int i = 0; i < dsets.length; ++i) {
            ProjectDatasetLinkI link = new ProjectDatasetLinkI();
            link.link(proj, dsets[i]);
            this.setToDatabase((IObject)link);
        }
    }

    public void attachDatasetsToProject(Project proj, List<Dataset> dsets) throws Exception {
        for (int i = 0; i < dsets.size(); ++i) {
            ProjectDatasetLinkI link = new ProjectDatasetLinkI();
            link.link(proj, dsets.get(i));
            this.setToDatabase((IObject)link);
        }
    }

    public Project createProject(String name, String desc) throws Exception {
        ProjectI newproj = new ProjectI();
        newproj.setName(rtypes.rstring((String)name));
        newproj.setDescription(rtypes.rstring((String)desc));
        newproj = (Project)this.setToDatabaseAndReturnObject((IObject)newproj);
        return newproj;
    }

    public Dataset createDataset(String name, String desc) throws Exception {
        DatasetI ds = new DatasetI();
        ds.setName(rtypes.rstring((String)name));
        ds.setDescription(rtypes.rstring((String)desc));
        ds = (Dataset)this.setToDatabaseAndReturnObject((IObject)ds);
        return ds;
    }

    public List<IObject> getObjectsByTag(String objectType, String tag) throws Exception {
        ArrayList<IObject> objects = new ArrayList<IObject>();
        this.srch.onlyType(objectType);
        TagAnnotationI taganot = new TagAnnotationI();
        taganot.setTextValue(rtypes.rstring((String)tag));
        ArrayList<TagAnnotationI> annotlist = new ArrayList<TagAnnotationI>();
        annotlist.add(taganot);
        this.srch.byAnnotatedWith(annotlist);
        while (this.srch.hasNext()) {
            objects.addAll(this.srch.results());
        }
        return objects;
    }

    public List<IObject> getObjectsByTags(String objectType, String[] tags) throws Exception {
        ArrayList<IObject> objects = new ArrayList<IObject>();
        this.srch.onlyType(objectType);
        ArrayList<TagAnnotationI> annotlist = new ArrayList<TagAnnotationI>();
        for (int i = 0; i < tags.length; ++i) {
            TagAnnotationI tag = new TagAnnotationI();
            tag.setTextValue(rtypes.rstring((String)tags[i]));
            annotlist.add(tag);
        }
        this.srch.byAnnotatedWith(annotlist);
        while (this.srch.hasNext()) {
            objects.addAll(this.srch.results());
        }
        return objects;
    }

    public int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        return -1;
    }

    private List<FileAnnotation> getFiles(Image img) throws Exception {
        ArrayList<FileAnnotation> fileannots = new ArrayList<FileAnnotation>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(img.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Image", objectids, annotype, userids, null);
        List entries = (List)annots.get(img.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            fileannots.add(fileannot);
        }
        return fileannots;
    }

    private List<OriginalFile> getFiles(Dataset ds) throws Exception {
        ArrayList<OriginalFile> origfiles = new ArrayList<OriginalFile>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(ds.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Dataset", objectids, annotype, userids, null);
        List entries = (List)annots.get(ds.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            origfiles.add(fileannot.getFile());
        }
        return origfiles;
    }

    private List<OriginalFile> getFiles(Project proj) throws Exception {
        ArrayList<OriginalFile> origfiles = new ArrayList<OriginalFile>();
        ArrayList<Long> objectids = new ArrayList<Long>();
        objectids.add(proj.getId().getValue());
        ArrayList<Long> userids = new ArrayList<Long>();
        userids.add(this.loginId);
        ArrayList<String> annotype = new ArrayList<String>();
        annotype.add("ome.model.annotations.FileAnnotation");
        Map annots = this.meta.loadAnnotations("Project", objectids, annotype, userids, null);
        List entries = (List)annots.get(proj.getId().getValue());
        for (int i = 0; i < entries.size(); ++i) {
            FileAnnotation fileannot = (FileAnnotation)entries.get(i);
            origfiles.add(fileannot.getFile());
        }
        return origfiles;
    }

    private FileAnnotation loadFile(String filestr) throws Exception {
        File file = new File(filestr);
        Format f = (Format)this.query.findByString(Format.class.getName(), "value", "text/xml");
        OriginalFileI oFile = new OriginalFileI();
        oFile.setName(rtypes.rstring((String)file.getName()));
        oFile.setPath(rtypes.rstring((String)file.getAbsolutePath()));
        oFile.setSize(rtypes.rlong((long)file.length()));
        oFile.setSha1(rtypes.rstring((String)"pending"));
        oFile.setFormat(f);
        oFile = (OriginalFile)this.setToDatabaseAndReturnObject((IObject)oFile);
        this.rfs.setFileId(oFile.getId().getValue());
        byte[] buf = new byte[512];
        FileInputStream stream = null;
        try {
            int rlen;
            stream = new FileInputStream(file);
            long pos = 0L;
            while ((rlen = stream.read(buf)) > 0) {
                this.rfs.write(buf, pos, rlen);
                pos += (long)rlen;
                ByteBuffer bbuf = ByteBuffer.wrap(buf);
                bbuf.limit(rlen);
            }
            stream.close();
        }
        catch (Exception e) {
            System.out.println("ERROR: Could not read file: " + filestr);
            FileAnnotation fa = null;
            return fa;
        }
        FileAnnotationI fa = new FileAnnotationI();
        fa.setFile((OriginalFile)oFile);
        return fa;
    }

    private void getExperimenterData() throws Exception {
        IAdminPrx admin = this.sf.getAdminService();
        this.loginName = admin.getEventContext().userName;
        this.loginId = admin.getEventContext().userId;
        Experimenter e = admin.lookupExperimenter(this.loginName);
    }

    private List<Pixels> getPixels(Image img) {
        ArrayList<Pixels> pixlist = new ArrayList<Pixels>();
        for (int i = 0; i < img.sizeOfPixels(); ++i) {
            Pixels pix = img.getPixels(i);
            pixlist.add(pix);
        }
        return pixlist;
    }

    private byte[] convertClientToServer(Image img, double[][] data) {
        Pixels pix = img.getPrimaryPixels();
        byte[] bytearray = GatewayUtils.convertClientToServer((Pixels)pix, (double[][])data);
        return bytearray;
    }

    private void progress(int i, int size) {
        float prog = (float)(i + 1) / (float)size * 100.0f;
        prog = this.round(prog, 2);
        System.out.print("\r\r Progress = " + prog + " %");
    }

    private float round(float Rval, int Rpl) {
        float p = (float)Math.pow(10.0, Rpl);
        float tmp = Math.round(Rval *= p);
        return tmp / p;
    }

    private void saveTestImage() throws Exception {
        String id = "test.tiff";
        System.out.println("Creating random image...");
        int w = 512;
        int h = 512;
        int pixelType = 3;
        byte[] img = new byte[w * h * FormatTools.getBytesPerPixel((int)pixelType)];
        for (int i = 0; i < img.length; ++i) {
            img[i] = (byte)(256.0 * Math.random());
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        meta.createRoot();
        meta.setPixelsBigEndian(Boolean.TRUE, 0, 0);
        meta.setPixelsDimensionOrder("XYZCT", 0, 0);
        meta.setPixelsPixelType(FormatTools.getPixelTypeString((int)pixelType), 0, 0);
        meta.setPixelsSizeX(Integer.valueOf(w), 0, 0);
        meta.setPixelsSizeY(Integer.valueOf(h), 0, 0);
        meta.setPixelsSizeZ(Integer.valueOf(1), 0, 0);
        meta.setPixelsSizeC(Integer.valueOf(1), 0, 0);
        meta.setPixelsSizeT(Integer.valueOf(1), 0, 0);
        meta.setDimensionsPhysicalSizeX(Float.valueOf(0.254f), 0, 0);
        meta.setDimensionsPhysicalSizeY(Float.valueOf(0.254f), 0, 0);
        meta.setDimensionsPhysicalSizeZ(Float.valueOf(1.0f), 0, 0);
        meta.setLogicalChannelSamplesPerPixel(Integer.valueOf(1), 0, 0);
        System.out.println("Writing image to '" + id + "'...");
        OMETiffWriter writer = new OMETiffWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(id);
        writer.saveBytes(img, true);
        writer.close();
    }

    private void saveMultiDimensionalTestImage() throws Exception {
        String id = "test2.tiff";
        int index1d = 0;
        boolean eof = false;
        System.out.println("Creating random image...");
        int w = 512;
        int h = 512;
        int t = 4;
        int c = 2;
        int z = 32;
        int pixelType = 3;
        byte[] img = new byte[w * h * FormatTools.getBytesPerPixel((int)pixelType)];
        for (int i = 0; i < img.length; ++i) {
            img[i] = (byte)(256.0 * Math.random());
        }
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        meta.createRoot();
        meta.setPixelsBigEndian(Boolean.TRUE, 0, 0);
        meta.setPixelsDimensionOrder("XYZCT", 0, 0);
        meta.setPixelsPixelType(FormatTools.getPixelTypeString((int)pixelType), index1d, 0);
        meta.setPixelsSizeX(Integer.valueOf(w), 0, 0);
        meta.setPixelsSizeY(Integer.valueOf(h), 0, 0);
        meta.setPixelsSizeZ(Integer.valueOf(z), 0, 0);
        meta.setPixelsSizeC(Integer.valueOf(c), 0, 0);
        meta.setPixelsSizeT(Integer.valueOf(t), 0, 0);
        meta.setDimensionsPhysicalSizeX(Float.valueOf(0.254f), 0, 0);
        meta.setDimensionsPhysicalSizeY(Float.valueOf(0.254f), 0, 0);
        meta.setDimensionsPhysicalSizeZ(Float.valueOf(1.0f), 0, 0);
        meta.setLogicalChannelSamplesPerPixel(Integer.valueOf(1), 0, 0);
        OMETiffWriter writer = new OMETiffWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(id);
        for (int i = 0; i < t; ++i) {
            for (int j = 0; j < c; ++j) {
                for (int k = 0; k < z; ++k) {
                    index1d = (i * c + j) * z + k;
                    if (index1d == t * c * z - 1) {
                        System.out.println("eof");
                        eof = true;
                    }
                    writer.saveBytes(img, eof);
                }
            }
        }
        writer.close();
    }

    private BufferedImage toBufferedImage(int w, int h, byte[] data) {
        DataBufferByte buffer = new DataBufferByte(data, w * h);
        int pixelStride = 1;
        int scanlineStride = pixelStride * w;
        int[] bandOffsets = new int[]{0};
        WritableRaster raster = Raster.createInterleavedRaster(buffer, w, h, scanlineStride, pixelStride, bandOffsets, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        int transparency = 3;
        int transferType = 0;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, hasAlpha, isAlphaPremultiplied, transparency, transferType);
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    private void main(String[] args) throws Exception {
        this.initConnectionDetails("cmpdartsvr1.cmp.uea.ac.uk", "avondoj", "avondo");
        Image scr_img = this.getImage(48L);
        int x = this.getX(scr_img);
        int y = this.getY(scr_img);
        int z = this.getZ(scr_img);
        int c = this.getC(scr_img);
        int t = this.getT(scr_img);
        Image dst_img = this.createImage("new image", "", x, y, z, c, t, "UINT_8");
        System.out.println("imgID: " + dst_img.getId().getValue());
        for (int i = 0; i < z; ++i) {
            this.progress(i, z);
            for (int j = 0; j < c; ++j) {
                for (int k = 0; k < t; ++k) {
                    byte[] plane = this.getPlane(scr_img, i, j, k);
                    for (int ii = 0; ii < plane.length; ++ii) {
                        plane[ii] = (byte)(256.0 * Math.random());
                    }
                    this.setPlane(dst_img, plane, i, j, k);
                }
            }
        }
        this.closeConnection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TagSets
    implements Comparable<TagSets> {
        public String tagset;
        public List<String> tags;

        private TagSets(String tgsets, String tg) {
            this.tagset = tgsets;
            this.tags = new ArrayList<String>();
            this.tags.add(tg);
        }

        private TagSets(String tgsets) {
            this.tagset = tgsets;
            this.tags = new ArrayList<String>();
        }

        @Override
        public int compareTo(TagSets n) {
            int cmpval = this.tagset.toLowerCase().compareTo(n.tagset.toLowerCase());
            return cmpval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DatasetObject {
        private Dataset dataset;
        private List<Image> images;

        private DatasetObject(Dataset ds, List<Image> imgs) {
            this.dataset = ds;
            this.images = imgs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProjectObject {
        private Project project;
        private List<DatasetObject> datasets;

        private ProjectObject(Project p, List<DatasetObject> ds) {
            this.project = p;
            this.datasets = ds;
        }
    }
}

