/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.MetaLightSource;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.model.Filament;
import omero.model.LightSettings;
import omero.model.LightSource;
import omero.model.Pixels;

public class LightSourceSettingsFilamentTest
extends TestCase {
    private OMEROWrapper wrapper;
    private OMEROMetadataStoreClient store;
    private static final int LIGHTSOURCE_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;
    private static final int LOGICAL_CHANNEL_INDEX = 0;

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.wrapper = new OMEROWrapper();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.wrapper.setMetadataStore(this.store);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setLightSourceModel("Model", 0, 0);
        this.store.setLightSourceID("Filament:0", 0, 0);
        this.store.setFilamentType("Unknown", 0, 0);
        this.store.setLightSourceSettingsLightSource("Filament:0", 0, 0);
        this.store.setLightSourceSettingsAttenuation(Float.valueOf(1.0f), 0, 0);
        this.store.setLightSourceModel("Model", 0, 1);
        this.store.setLightSourceID("Filament:1", 0, 1);
        this.store.setFilamentType("Unknown", 0, 1);
        this.store.setLightSourceSettingsLightSource("Filament:1", 0, 1);
        this.store.setLightSourceSettingsAttenuation(Float.valueOf(1.0f), 0, 1);
    }

    public void testLightSourceSettingsLightSourceNotMLS() {
        int i = 0;
        while (i < 2) {
            LSID lsid = new LSID(LightSource.class, new int[]{0, i});
            LightSource ls = (LightSource)this.store.getSourceObject(lsid);
            if (ls instanceof MetaLightSource) {
                LightSourceSettingsFilamentTest.fail((String)("Light source " + ls + " is meta."));
            }
            ++i;
        }
    }

    public void testLightSourceCount() {
        LSID lsid = new LSID(Pixels.class, new int[]{0, 0});
        LightSourceSettingsFilamentTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        LightSourceSettingsFilamentTest.assertEquals((int)2, (int)this.store.countCachedContainers(Filament.class, new int[0]));
        LightSourceSettingsFilamentTest.assertEquals((int)5, (int)this.store.countCachedContainers(null, new int[0]));
    }

    public void testLightSourceSettingsCount() {
        LSID lsid = new LSID(Pixels.class, new int[]{0, 0});
        LightSourceSettingsFilamentTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        LightSourceSettingsFilamentTest.assertEquals((int)2, (int)this.store.countCachedContainers(Filament.class, new int[0]));
        LightSourceSettingsFilamentTest.assertEquals((int)5, (int)this.store.countCachedContainers(null, new int[0]));
    }

    public void testReferences() {
        int i = 0;
        while (i < 2) {
            LSID imageLsid = new LSID(LightSettings.class, new int[]{0, i});
            LightSourceSettingsFilamentTest.assertTrue((boolean)this.store.hasReference(imageLsid, new LSID("Filament:" + i)));
            ++i;
        }
        LightSourceSettingsFilamentTest.assertEquals((int)2, (int)this.store.countCachedReferences(null, null));
    }
}

