/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import java.util.LinkedHashMap;
import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import omero.metadatastore.IObjectContainer;
import omero.model.Laser;
import omero.model.LightSource;

public class LaserTest
extends TestCase {
    private OMEROMetadataStoreClient store;
    private static final int LIGHTSOURCE_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
    }

    public void testNewLaserAllAttributes() {
        int i = 10;
        this.store.setLightSourceID("Laser:100", 0, i);
        this.store.setLaserWavelength(100, 0, i);
        this.store.setLaserType("Foo", 0, i);
        this.store.setLaserLaserMedium("Bar", 0, i);
        this.store.setLaserPockelCell(true, 0, i);
        this.store.setLaserPulse("Pulse", 0, i);
        this.store.setLaserRepetitionRate(true, 0, i);
        this.store.setLaserTuneable(true, 0, i);
    }

    public void testNewLaserIdFirst() {
        int i = 10;
        this.store.setLightSourceID("LightSource:100", 0, i);
        this.store.setLaserType("Foo", 0, i);
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", 0);
        indexes.put("lightSourceIndex", i);
        IObjectContainer laserContainer = this.store.getIObjectContainer(Laser.class, indexes);
        IObjectContainer lightSourceContainer = this.store.getIObjectContainer(LightSource.class, indexes);
        LaserTest.assertEquals((String)"LightSource:100", (String)laserContainer.LSID);
        LaserTest.assertEquals((String)"LightSource:100", (String)lightSourceContainer.LSID);
        LaserTest.assertEquals((Object)laserContainer.sourceObject, (Object)laserContainer.sourceObject);
    }

    public void testNewLaserConcreteAttributeFirst() {
        int i = 10;
        this.store.setLaserType("Foo", 0, i);
        this.store.setLightSourceID("LightSource:100", 0, i);
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", 0);
        indexes.put("lightSourceIndex", i);
        IObjectContainer laserContainer = this.store.getIObjectContainer(Laser.class, indexes);
        IObjectContainer lightSourceContainer = this.store.getIObjectContainer(LightSource.class, indexes);
        LaserTest.assertEquals((String)"LightSource:100", (String)laserContainer.LSID);
        LaserTest.assertEquals((String)"LightSource:100", (String)lightSourceContainer.LSID);
        LaserTest.assertEquals((Object)laserContainer.sourceObject, (Object)laserContainer.sourceObject);
    }

    public void testNewLaserSuperclassAttributeLast() {
        int i = 10;
        this.store.setLightSourceID("LightSource:100", 0, i);
        this.store.setLaserType("Foo", 0, i);
        this.store.setLightSourceModel("Bar", 0, i);
        LinkedHashMap<String, Integer> indexes = new LinkedHashMap<String, Integer>();
        indexes.put("instrumentIndex", 0);
        indexes.put("lightSourceIndex", i);
        IObjectContainer laserContainer = this.store.getIObjectContainer(Laser.class, indexes);
        IObjectContainer lightSourceContainer = this.store.getIObjectContainer(LightSource.class, indexes);
        LaserTest.assertEquals((String)"LightSource:100", (String)laserContainer.LSID);
        LaserTest.assertEquals((String)"LightSource:100", (String)lightSourceContainer.LSID);
        LaserTest.assertEquals((Object)laserContainer.sourceObject, (Object)laserContainer.sourceObject);
    }
}

