/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.model.Image;
import omero.model.Instrument;
import omero.model.LightSource;
import omero.model.Pixels;

public class InstrumentTest
extends TestCase {
    private OMEROWrapper wrapper;
    private OMEROMetadataStoreClient store;
    private static final int LIGHTSOURCE_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;
    private static final String LIGHTSOURCE_MODEL = "Model";

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.wrapper = new OMEROWrapper();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.wrapper.setMetadataStore(this.store);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setPixelsSizeX(1, 1, 0);
        this.store.setPixelsSizeX(1, 2, 0);
        this.store.setLightSourceModel(LIGHTSOURCE_MODEL, 0, 0);
        this.store.setInstrumentID("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 1);
        this.store.setImageInstrumentRef("Instrument:0", 2);
    }

    public void testImageInstrumentExists() {
        int i = 0;
        while (i < 3) {
            LSID lsid = new LSID(Pixels.class, new int[]{i++, 0});
            InstrumentTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        }
        LSID lsid = new LSID(LightSource.class, new int[]{0, 0});
        InstrumentTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        InstrumentTest.assertNotNull((Object)this.store.getSourceObject(new LSID("Instrument:0")));
    }

    public void testImageInstrumentLightSourceModelPreserved() {
        LightSource ls = this.store.getLightSource(0, 0);
        InstrumentTest.assertEquals((String)LIGHTSOURCE_MODEL, (String)ls.getModel().getValue());
    }

    public void testContainerCount() {
        InstrumentTest.assertEquals((int)1, (int)this.store.countCachedContainers(LightSource.class, new int[0]));
        InstrumentTest.assertEquals((int)1, (int)this.store.countCachedContainers(Instrument.class, new int[0]));
        InstrumentTest.assertEquals((int)3, (int)this.store.countCachedContainers(Pixels.class, new int[0]));
        InstrumentTest.assertEquals((int)5, (int)this.store.countCachedContainers(null, new int[0]));
    }

    public void testReferences() {
        int i = 0;
        while (i < 3) {
            LSID imageLsid = new LSID(Image.class, new int[]{i++});
            InstrumentTest.assertTrue((boolean)this.store.hasReference(imageLsid, new LSID("Instrument:0")));
        }
        InstrumentTest.assertEquals((int)3, (int)this.store.countCachedReferences(null, null));
    }
}

