/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.model.Detector;
import omero.model.DetectorSettings;
import omero.model.Image;
import omero.model.Instrument;
import omero.model.Pixels;

public class DetectorSettingsTest
extends TestCase {
    private OMEROWrapper wrapper;
    private OMEROMetadataStoreClient store;
    private static final int DETECTOR_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;
    private static final int LOGICAL_CHANNEL_INDEX = 0;
    private static final String DETECTOR_MODEL = "Model";

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.wrapper = new OMEROWrapper();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.wrapper.setMetadataStore(this.store);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setPixelsSizeX(1, 1, 0);
        this.store.setPixelsSizeX(1, 2, 0);
        this.store.setDetectorModel(DETECTOR_MODEL, 0, 0);
        this.store.setDetectorID("Detector:0", 0, 0);
        this.store.setInstrumentID("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 0);
        this.store.setImageInstrumentRef("Instrument:0", 1);
        this.store.setImageInstrumentRef("Instrument:0", 2);
        this.store.setDetectorSettingsDetector("Detector:0", 0, 0);
        this.store.setDetectorSettingsDetector("Detector:0", 1, 0);
        this.store.setDetectorSettingsDetector("Detector:0", 2, 0);
    }

    public void testImageDetectorExists() {
        int i = 0;
        while (i < 3) {
            LSID lsid = new LSID(Pixels.class, new int[]{i++, 0});
            DetectorSettingsTest.assertNotNull((Object)this.store.getSourceObject(lsid));
        }
        DetectorSettingsTest.assertNotNull((Object)this.store.getSourceObject(new LSID("Instrument:0")));
        DetectorSettingsTest.assertNotNull((Object)this.store.getSourceObject(new LSID("Detector:0")));
    }

    public void testDetectorModelPreserved() {
        Detector detector = this.store.getDetector(0, 0);
        DetectorSettingsTest.assertEquals((String)DETECTOR_MODEL, (String)detector.getModel().getValue());
    }

    public void testContainerCount() {
        DetectorSettingsTest.assertEquals((int)1, (int)this.store.countCachedContainers(Detector.class, new int[0]));
        DetectorSettingsTest.assertEquals((int)1, (int)this.store.countCachedContainers(Instrument.class, new int[0]));
        DetectorSettingsTest.assertEquals((int)3, (int)this.store.countCachedContainers(Pixels.class, new int[0]));
        DetectorSettingsTest.assertEquals((int)5, (int)this.store.countCachedContainers(null, new int[0]));
    }

    public void testReferences() {
        int i = 0;
        while (i < 3) {
            LSID imageLsid = new LSID(Image.class, new int[]{i});
            LSID dsLsid = new LSID(DetectorSettings.class, new int[]{i++, 0});
            DetectorSettingsTest.assertTrue((boolean)this.store.hasReference(dsLsid, new LSID("Detector:0")));
            DetectorSettingsTest.assertTrue((boolean)this.store.hasReference(imageLsid, new LSID("Instrument:0")));
        }
        DetectorSettingsTest.assertEquals((int)6, (int)this.store.countCachedReferences(null, null));
    }
}

