/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.utests;

import java.util.Map;
import junit.framework.TestCase;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.BlitzInstanceProvider;
import ome.formats.utests.TestEnumerationProvider;
import ome.formats.utests.TestServiceFactory;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Plate;

public class ContainerCacheOrderTest
extends TestCase {
    private OMEROWrapper wrapper;
    private OMEROMetadataStoreClient store;
    private static final int LIGHTSOURCE_INDEX = 0;
    private static final int INSTRUMENT_INDEX = 0;
    private static final int IMAGE_INDEX = 0;
    private static final int PIXELS_INDEX = 0;
    private static final int LOGICAL_CHANNEL_INDEX = 0;
    private static final int OBJECTIVE_INDEX = 0;

    protected void setUp() throws Exception {
        TestServiceFactory sf = new TestServiceFactory();
        this.wrapper = new OMEROWrapper();
        this.store = new OMEROMetadataStoreClient();
        this.store.initialize(sf);
        this.store.setEnumerationProvider(new TestEnumerationProvider());
        this.store.setInstanceProvider(new BlitzInstanceProvider(this.store.getEnumerationProvider()));
        this.wrapper.setMetadataStore(this.store);
        this.store.setImageName("Foo", 0);
        this.store.setPixelsSizeX(1, 0, 0);
        this.store.setPixelsSizeX(1, 0, 1);
        this.store.setLogicalChannelEmWave(100, 0, 0);
        this.store.setInstrumentID("Instrument:0", 0);
        this.store.setLightSourceModel("Model", 0, 0);
        this.store.setLightSourceID("Laser:0", 0, 0);
        this.store.setLightSourcePower(Float.valueOf(1.0f), 0, 0);
        this.store.setLaserFrequencyMultiplication(1, 0, 0);
        this.store.setLightSourceSettingsLightSource("Laser:0", 0, 0);
        this.store.setLightSourceSettingsAttenuation(Float.valueOf(1.0f), 0, 0);
        this.store.setLightSourceModel("Model", 0, 1);
        this.store.setLightSourceID("Laser:1", 0, 1);
        this.store.setLightSourcePower(Float.valueOf(1.0f), 0, 1);
        this.store.setLaserFrequencyMultiplication(1, 0, 1);
        this.store.setLightSourceSettingsLightSource("Laser:1", 0, 1);
        this.store.setLightSourceSettingsAttenuation(Float.valueOf(1.0f), 0, 1);
        this.store.setLaserLaserMedium("Ar", 0, 2);
        this.store.setLaserType("Gas", 0, 2);
        this.store.setLightSourceID("Laser:2", 0, 2);
        this.store.setLightSourceSettingsLightSource("Laser:2", 0, 2);
        this.store.setLightSourceSettingsAttenuation(Float.valueOf(1.0f), 0, 2);
        this.store.setObjectiveLensNA(Float.valueOf(1.0f), 0, 0);
        this.store.setObjectiveID("Objective:0", 0, 0);
        this.store.setObjectiveSettingsObjective("Objective:0", 0);
        this.store.setObjectiveLensNA(Float.valueOf(1.0f), 0, 1);
        this.store.setObjectiveID("Objective:1", 0, 1);
        this.store.setObjectiveSettingsObjective("Objective:1", 1);
        this.store.setPlateName("Plate", 0);
    }

    public void testOrder() {
        Map<LSID, IObjectContainer> containerCache = this.store.getContainerCache();
        for (LSID key : containerCache.keySet()) {
            System.err.println(key + " == " + containerCache.get((Object)key).sourceObject);
        }
    }

    public void testPlateLSIDEquivilence() {
        LSID a = new LSID(Plate.class, new int[]{0});
        LSID b = new LSID("omero.model.Plate:0");
        ContainerCacheOrderTest.assertEquals((Object)a, (Object)b);
        ContainerCacheOrderTest.assertEquals((Object)b, (Object)a);
    }

    public void testGetPlateByString() {
        Map<LSID, IObjectContainer> containerCache = this.store.getContainerCache();
        ContainerCacheOrderTest.assertNotNull((Object)containerCache.get(new LSID("omero.model.Plate:0", true)));
    }

    public void testGetPlateByClassAndIndex() {
        Map<LSID, IObjectContainer> containerCache = this.store.getContainerCache();
        ContainerCacheOrderTest.assertNotNull((Object)containerCache.get(new LSID(Plate.class, new int[]{0})));
    }
}

