/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.test.util;

import java.io.File;
import java.util.prefs.BackingStoreException;
import org.ini4j.IniFile;

class TestEngineIniFile
extends IniFile {
    private boolean populate = true;

    public TestEngineIniFile(File file) throws BackingStoreException {
        super(file, IniFile.Mode.RW);
    }

    public String[] getFileList() {
        try {
            return this.childrenNames();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new RuntimeException("Unimplemented exception.");
        }
    }

    public void addFile(String fileName) {
        this.node(fileName);
    }

    public String getNote(String file) {
        return this.node(file).get("note", null);
    }

    public String[] getFileTypes() {
        String[] types = null;
        String fileTypes = this.node("populate_options").get("filetypes", null);
        if (fileTypes != null) {
            types = fileTypes.split(",");
            int i = 0;
            while (i < types.length) {
                types[i] = types[i].trim();
                ++i;
            }
        }
        return types;
    }

    public void testValue(String section, String key, Object value) {
        String storedValue;
        if (value != null && !(value instanceof String)) {
            value = value.toString();
        }
        if (value != null && value.toString().length() > 255) {
            value = String.valueOf(value.toString().substring(0, 252)) + "...";
        }
        if (((storedValue = this.node(section).get(key, null)) == null || this.populate) && value != null) {
            System.err.println("Storing value for " + section + ": key=" + key + ", value=: " + value);
            this.node(section).put(key, (String)value);
        } else if (value != null && !storedValue.equals(value) || value == null && storedValue != null) {
            System.err.println("Value mismatch in " + section + ": key=" + key + ", stored value=" + storedValue + " new value=" + value);
        } else if (value == null) {
            System.err.println("Skipping null value: " + section + ": key=" + key);
        }
    }
}

