/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.test.util;

import Glacier2.CannotCreateSessionException;
import Glacier2.PermissionDeniedException;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.test.util.IniWritingInterceptor;
import ome.formats.test.util.TestEngineConfig;
import ome.formats.test.util.TestEngineIniFile;
import omero.ServerError;
import omero.model.Dataset;
import omero.model.IObject;
import omero.model.Project;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;

public class TestEngine {
    private Log log = LogFactory.getLog(TestEngine.class);
    private TestEngineConfig config;
    private static final String APP_NAME = "import-tester";
    private OMEROMetadataStoreClient store;
    private ImportLibrary importLibrary;
    private OMEROWrapper wrapper;
    private IniWritingInterceptor interceptor = new IniWritingInterceptor();

    public TestEngine(TestEngineConfig config) throws CannotCreateSessionException, PermissionDeniedException, ServerError {
        this.config = config;
        this.store = new OMEROMetadataStoreClient();
        ProxyFactory pf = new ProxyFactory((Object)this.store);
        pf.addAdvice((Advice)this.interceptor);
        pf.setProxyTargetClass(true);
        this.store = (OMEROMetadataStoreClient)pf.getProxy();
        this.wrapper = new OMEROWrapper();
        if (config.getSessionKey() != null) {
            this.store.initialize(config.getHostname(), config.getPort(), config.getSessionKey());
        } else {
            this.store.initialize(config.getUsername(), config.getPassword(), config.getHostname(), config.getPort());
        }
        this.importLibrary = new ImportLibrary(this.store, this.wrapper);
    }

    public boolean run(String targetDirectory) throws Throwable {
        String projectName = new Date().toString();
        this.log.info((Object)("Storing project: " + projectName));
        Project project = this.store.addProject(projectName, "");
        File projectDirectory = new File(targetDirectory);
        boolean status = false;
        if (!this.config.getRecurse()) {
            String name = projectDirectory.getName();
            this.log.info((Object)("Storing dataset: " + name));
            Dataset dataset = this.store.addDataset(name, "", project);
            this.importLibrary.setTarget((IObject)dataset);
            status = this.processDirectory(this.config.getPopulate(), projectDirectory);
        } else {
            File[] fileArray = projectDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File datasetDirectory = fileArray[n2];
                if (datasetDirectory.exists() && datasetDirectory.isDirectory()) {
                    String name = datasetDirectory.getName();
                    this.log.info((Object)("Storing dataset: " + name));
                    Dataset dataset = this.store.addDataset(name, "", project);
                    this.importLibrary.setTarget((IObject)dataset);
                    status = this.processDirectory(this.config.getPopulate(), datasetDirectory);
                }
                ++n2;
            }
        }
        this.store.logout();
        return status;
    }

    private boolean processDirectory(boolean populate, File directory) throws Throwable {
        String iniFilePath = directory + File.separator + "test_setup.ini";
        this.log.info((Object)("INI file path: " + iniFilePath));
        TestEngineIniFile iniFile = new TestEngineIniFile(new File(iniFilePath));
        this.interceptor.setIniFile(iniFile);
        String[] fileTypes = iniFile.getFileTypes();
        populate = fileTypes != null;
        if (populate) {
            File[] datasetFiles;
            File[] fileArray = datasetFiles = directory.listFiles();
            int n = datasetFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File datasetFile = fileArray[n2];
                String[] stringArray = fileTypes;
                int n3 = fileTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileType = stringArray[n4];
                    if (datasetFile.isFile() && datasetFile.getName().endsWith("." + fileType)) {
                        iniFile.addFile(datasetFile.getName());
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            populate = fileTypes == null;
            if (populate) {
                this.log.error((Object)("No filetypes for " + iniFilePath));
            }
        }
        String[] fileList = iniFile.getFileList();
        if (fileList.length < 1) {
            this.log.error((Object)"No files available to import.");
        }
        int j = 0;
        while (j < fileList.length) {
            if (!fileList[j].equals("populate_options")) {
                File file = new File(directory + File.separator + fileList[j]);
                this.log.info((Object)("------Importing file: " + file + "------"));
                if (!file.exists()) {
                    this.log.warn((Object)("Image file " + file.getName() + " missing but referenced in test_setup.ini"));
                } else {
                    try {
                        this.interceptor.setSourceFile(file);
                        this.importLibrary.importImage(file, 0, 0, 1, fileList[j], null, false, null);
                        iniFile.flush();
                    }
                    catch (Throwable e) {
                        try {
                            iniFile.flush();
                        }
                        catch (Throwable e1) {
                            this.log.error((Object)("Failed on flushing ini file" + e1));
                        }
                        this.store.logout();
                        this.log.error((Object)("Failed on file:" + file.getName()));
                        throw e;
                    }
                }
            }
            ++j;
        }
        return true;
    }

    public static void usage() {
        System.err.println(String.format("Usage: %s [OPTION]... [TARGET DIRECTORY]\nImports one or more files into an OMERO instance and tests\nmetadata. More information about the test engine can be found at:\n\nhttp://trac.openmicroscopy.org.uk/wiki/ImporterTestEngine\n\nOptional arguments:\n  -s\tOMERO server hostname\n  -u\tOMERO experimenter name (username)\n  -w\tOMERO experimenter password\n  -k\tOMERO session key (can be used in place of -u and -w)\n  -p\tOMERO server port [defaults to 4063]\n  -c\tConfiguration file location (instead of any of the above arguments)\n  -x\tPopulate initiation files with metadata [defaults to False]\n  -h, --help\tDisplay this help and exit\n  --no-recurse\tSingle directory test run\n\nex. %s -s localhost -u bart -w simpson ShortRunImages\n\nReport bugs to <ome-users@openmicroscopy.org.uk>", APP_NAME, APP_NAME));
        System.exit(1);
    }

    public static void main(String[] args) throws Throwable {
        int a;
        LongOpt[] longOptions = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("no-recurse", 2, null, 114)};
        Getopt g = new Getopt(APP_NAME, args, "s:u:w:p:k:c:x", longOptions);
        InputStream configFile = new ByteArrayInputStream(new byte[0]);
        while ((a = g.getopt()) != -1) {
            switch (a) {
                case 99: {
                    configFile = new FileInputStream(g.getOptarg());
                }
            }
        }
        if (configFile instanceof ByteArrayInputStream) {
            InputStream fromClasspath = TestEngine.class.getClassLoader().getResourceAsStream("test_engine.ini");
            configFile = fromClasspath == null ? configFile : fromClasspath;
        }
        g = new Getopt(APP_NAME, args, "s:u:w:p:c:k:x", longOptions);
        TestEngineConfig config = new TestEngineConfig(configFile);
        while ((a = g.getopt()) != -1) {
            switch (a) {
                case 115: {
                    config.setHostname(g.getOptarg());
                    break;
                }
                case 117: {
                    config.setUsername(g.getOptarg());
                    break;
                }
                case 119: {
                    config.setPassword(g.getOptarg());
                    break;
                }
                case 107: {
                    config.setSessionKey(g.getOptarg());
                    break;
                }
                case 112: {
                    config.setPort(Integer.parseInt(g.getOptarg()));
                    break;
                }
                case 120: {
                    config.setPopulate(!config.getPopulate());
                    break;
                }
                case 114: {
                    config.setRecurse(!config.getRecurse());
                    break;
                }
                case 99: {
                    break;
                }
                default: {
                    TestEngine.usage();
                }
            }
        }
        if (!config.validateLogin()) {
            TestEngine.usage();
        }
        String path = config.getTarget();
        if (args.length - g.getOptind() == 1) {
            path = args[g.getOptind()];
        } else if (path == null) {
            TestEngine.usage();
        }
        TestEngine engine = new TestEngine(config);
        engine.run(path);
    }
}

