/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.LinkedHashMap;
import java.util.List;
import loci.formats.IFormatReader;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Channel;
import omero.model.IObject;
import omero.model.Image;
import omero.model.LogicalChannel;
import omero.model.Pixels;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelProcessor
implements ModelProcessor {
    private Log log = LogFactory.getLog(ChannelProcessor.class);
    private IObjectContainerStore store;

    public void process(IObjectContainerStore store) throws ModelException {
        this.store = store;
        List<Image> images = store.getSourceObjects(Image.class);
        int i = 0;
        while (i < images.size()) {
            Pixels pixels = (Pixels)store.getSourceObject(new LSID(Pixels.class, new int[]{i}));
            int sizeC = pixels.getSizeC().getValue();
            int c = 0;
            while (c < sizeC) {
                IObjectContainer container;
                LinkedHashMap<String, Integer> indexes;
                IObject sourceObject = store.getSourceObject(new LSID(Channel.class, new int[]{i, c}));
                if (sourceObject == null) {
                    indexes = new LinkedHashMap<String, Integer>();
                    indexes.put("imageIndex", i);
                    indexes.put("logicalChannelIndex", c);
                    container = store.getIObjectContainer(Channel.class, indexes);
                    sourceObject = container.sourceObject;
                }
                if (sizeC == 3 || sizeC == 4) {
                    this.populateColor((Channel)sourceObject, c);
                }
                if ((sourceObject = store.getSourceObject(new LSID(LogicalChannel.class, new int[]{i, c}))) == null) {
                    indexes = new LinkedHashMap();
                    indexes.put("imageIndex", i);
                    indexes.put("logicalChannelIndex", c);
                    container = store.getIObjectContainer(LogicalChannel.class, indexes);
                    sourceObject = container.sourceObject;
                }
                if (sizeC == 3 || sizeC == 4) {
                    this.populateName((LogicalChannel)sourceObject, c);
                }
                ++c;
            }
            ++i;
        }
    }

    private void populateColor(Channel channel, int channelIndex) {
        IFormatReader reader = this.store.getReader();
        if (reader.isRGB() || reader.isIndexed()) {
            this.log.debug((Object)"Setting color channel to RGB.");
            if (channelIndex == 0) {
                channel.setRed(rtypes.rint((int)255));
                channel.setGreen(rtypes.rint((int)0));
                channel.setBlue(rtypes.rint((int)0));
                channel.setAlpha(rtypes.rint((int)255));
            }
            if (channelIndex == 1) {
                channel.setRed(rtypes.rint((int)0));
                channel.setGreen(rtypes.rint((int)255));
                channel.setBlue(rtypes.rint((int)0));
                channel.setAlpha(rtypes.rint((int)255));
            }
            if (channelIndex == 2) {
                channel.setRed(rtypes.rint((int)0));
                channel.setGreen(rtypes.rint((int)0));
                channel.setBlue(rtypes.rint((int)255));
                channel.setAlpha(rtypes.rint((int)255));
            }
            if (channelIndex == 3) {
                channel.setRed(rtypes.rint((int)0));
                channel.setGreen(rtypes.rint((int)0));
                channel.setBlue(rtypes.rint((int)0));
                channel.setAlpha(rtypes.rint((int)0));
            }
        }
    }

    private void populateName(LogicalChannel lc, int logicalChannelIndex) {
        IFormatReader reader = this.store.getReader();
        if (reader.isRGB() || reader.isIndexed()) {
            this.log.debug((Object)"Setting channels name to Red, Green, Blue or Alpha.");
            if (lc.getName() == null && logicalChannelIndex == 0) {
                lc.setName(rtypes.rstring((String)"Red"));
            }
            if (lc.getName() == null && logicalChannelIndex == 1) {
                lc.setName(rtypes.rstring((String)"Green"));
            }
            if (lc.getName() == null && logicalChannelIndex == 2) {
                lc.setName(rtypes.rstring((String)"Blue"));
            }
            if (lc.getName() == null && logicalChannelIndex == 3) {
                lc.setName(rtypes.rstring((String)"Alpha"));
            }
        }
    }
}

