/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class UIUtilities {
    public static final String NANOMETER = " \u00b5m";
    public static final String DOTS = "...";
    public static final Color STEELBLUE = new Color(4620980);
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 500;
    public static final int SEPARATOR_WIDTH = 2;
    public static final int TABLE_WIDTH = 200;

    public static void centerOnScreen(Component window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle ed = window.getBounds();
        window.setLocation((screenSize.width - ed.width) / 2, (screenSize.height - ed.height) / 2);
    }

    public static void centerAndShow(Component window) {
        UIUtilities.centerOnScreen(window);
        window.setVisible(true);
    }

    public static void setLocationRelativeToAndShow(Component parent, Component child) {
        Dimension screenSize;
        int x = parent.getX() + parent.getWidth();
        int y = parent.getY();
        int childWidth = child.getWidth();
        if ((double)(x + childWidth) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            x = childWidth < parent.getX() ? parent.getX() - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        child.setVisible(true);
    }

    public static void incrementRelativeToAndShow(Rectangle bounds, Component child) {
        if (bounds == null) {
            UIUtilities.centerAndShow(child);
            return;
        }
        child.setLocation(bounds.x + 10, bounds.y + 10);
        child.setVisible(true);
    }

    public static void makeForDialog(Component parent, String title, JComponent c) {
        if (c == null) {
            return;
        }
        JDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new JDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            dialog = new JDialog((Dialog)parent);
        } else if (dialog == null || parent == null) {
            dialog = new JDialog();
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setSize(500, 500);
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)c, "Center");
        UIUtilities.centerAndShow(dialog);
    }

    public static void makeForDialog(Component parent, JComponent c) {
        UIUtilities.makeForDialog(parent, "", c);
    }

    public static String formatToolTipText(String toolTipText) {
        StringBuffer buf = new StringBuffer(90 + toolTipText.length());
        buf.append("<html><body bgcolor=#FFFCB7 text=#AD5B00>");
        buf.append("<font face=Arial size=2>");
        buf.append(toolTipText);
        buf.append("</font></body></html>");
        return toolTipText;
    }

    public static String makeParagraph(String title, String body, int maxWidth) {
        if (title != null && body == null) {
            return UIUtilities.formatToolTipText(title);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body bgcolor=#FFFCB7 text=#AD5B00>");
        if (title != null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td><b>");
            buf.append(title);
            buf.append("</b><hr size=1>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        } else if (title == null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    public static JSeparator toolBarSeparator(JButton button, Icon icon) {
        JSeparator separator = new JSeparator(1);
        Insets i = button.getInsets();
        int h = icon.getIconHeight();
        Dimension d = new Dimension(2, i.top + h + i.bottom);
        separator.setPreferredSize(d);
        separator.setSize(d);
        return separator;
    }

    public static JLabel setTextFont(String s) {
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        Font newFont = font.deriveFont(1);
        label.setFont(newFont);
        return label;
    }

    public static JPanel buildComponentPanel(JComponent component) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(component);
        return p;
    }

    public static JPanel buildComponentPanelRight(JComponent component) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        p.add(component);
        return p;
    }

    public static void unifiedButtonLookAndFeel(AbstractButton b) {
        b.setMargin(new Insets(0, 2, 0, 3));
        b.setBorderPainted(false);
        b.setFocusPainted(false);
    }

    public static void setTextAreaDefault(JTextComponent area) {
        area.setBorder(BorderFactory.createBevelBorder(1));
        area.setForeground(STEELBLUE);
        area.setBackground(Color.WHITE);
        area.setOpaque(true);
        area.setEditable(true);
    }

    public static String twoDecimalPlaces(double val) {
        double v;
        double c = v = val;
        if (v < 0.0) {
            return null;
        }
        String value = c - Math.floor(c) > 0.0 ? "" + (float)Math.round(c * 100.0) / 100.0f : "" + (int)c;
        if (value.equals("0")) {
            return null;
        }
        return value;
    }

    public static JTextPane buildTextPane(String text) {
        return UIUtilities.buildTextPane(text, null);
    }

    public static JTextPane buildTextPane(String text, Color foreground) {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        return textPane;
    }

    public static void enterPressesWhenFocused(JButton button) {
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }
}

