/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.Rectangle;
import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import ome.formats.importer.Main;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ini4j.IniFile;

public class IniFileLoader {
    Log log = LogFactory.getLog(IniFileLoader.class);
    private String userSettingsDirectory;
    private static String userSettingsFile;
    private Preferences userPrefs;
    private String staticConfigDirectory = String.valueOf(System.getProperty("user.dir")) + File.separator + "config";
    private static String staticConfigFile;
    private Preferences staticPrefs;
    private static IniFileLoader ini;

    private IniFileLoader(String userConfigFile) {
        staticConfigFile = String.valueOf(this.staticConfigDirectory) + File.separator + "importer.config";
        try {
            this.staticPrefs = new IniFile(new File(staticConfigFile), IniFile.Mode.RO);
        }
        catch (BackingStoreException e) {
            this.log.error((Object)e);
            JOptionPane.showMessageDialog(null, "We were not able to find the importer config file.\nMake sure you are running the importer from the\ndefault directory.\n\nYou will not be able to use the importer until this\nissue is resolved. Now exiting.", "Error", 0);
            System.exit(0);
        }
        this.userSettingsDirectory = String.valueOf(System.getProperty("user.home")) + File.separator + "omero";
        if (!new File(this.userSettingsDirectory).exists()) {
            new File(this.userSettingsDirectory).mkdir();
        }
        if (userConfigFile == null) {
            userConfigFile = String.valueOf(this.userSettingsDirectory) + File.separator + "importer.ini";
        }
        if (userSettingsFile == null) {
            userSettingsFile = userConfigFile;
        }
        try {
            this.userPrefs = new IniFile(new File(userConfigFile), IniFile.Mode.RW);
        }
        catch (BackingStoreException e) {
            this.log.error((Object)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                IniFileLoader.this.shutdown();
            }
        });
    }

    protected void shutdown() {
        this.flushPreferences();
    }

    public static IniFileLoader getIniFileLoader(String[] args) {
        String filename;
        String string = filename = args.length > 0 ? args[0] : userSettingsFile;
        if (ini == null) {
            ini = new IniFileLoader(filename);
        }
        return ini;
    }

    public static IniFileLoader getIniFileLoader() {
        if (ini == null) {
            ini = new IniFileLoader(null);
        }
        return ini;
    }

    public void flushPreferences() {
        try {
            this.userPrefs.flush();
        }
        catch (BackingStoreException e) {
            this.log.error((Object)e);
        }
    }

    public boolean getUseQuaqua() {
        return this.userPrefs.node("General").getBoolean("useQuaqua", true);
    }

    public String getAppTitle() {
        return this.staticPrefs.node("General").get("appTitle", "OMERO.importer");
    }

    public void setUseQuaqua(boolean b) {
        this.userPrefs.node("General").putBoolean("useQuaqua", b);
        this.flushPreferences();
    }

    public String getVersionNumber() {
        return this.staticPrefs.node("General").get("appVersion", Main.versionNumber);
    }

    public Boolean isDebugConsole() {
        return this.staticPrefs.node("General").getBoolean("displayDebugConsole", true);
    }

    public String getServerPort() {
        return this.staticPrefs.node("General").get("port", "4063");
    }

    public Boolean isDebugUI() {
        return this.staticPrefs.node("UI").getBoolean("displayRedBorders", false);
    }

    public Rectangle getUIBounds() {
        Rectangle rect = new Rectangle();
        rect.width = this.userPrefs.node("UI").getInt("width", 980);
        rect.height = this.userPrefs.node("UI").getInt("height", 580);
        rect.x = this.userPrefs.node("UI").getInt("xOffset", 10);
        rect.y = this.userPrefs.node("UI").getInt("yOffset", 10);
        return rect;
    }

    public void setUIBounds(Rectangle bounds) {
        if (bounds.x < 0) {
            bounds.x = 0;
        }
        if (bounds.y < 0) {
            bounds.y = 0;
        }
        if (bounds.width < 100) {
            bounds.width = 100;
        }
        if (bounds.height < 100) {
            bounds.height = 100;
        }
        this.userPrefs.node("UI").putInt("width", bounds.width);
        this.userPrefs.node("UI").putInt("height", bounds.height);
        this.userPrefs.node("UI").putInt("xOffset", bounds.x);
        this.userPrefs.node("UI").putInt("yOffset", bounds.y);
    }

    public static void main(String[] args) {
        IniFileLoader.getIniFileLoader(args);
    }

    public void displayDebugSettings() {
        System.out.println("version: " + this.getVersionNumber());
        System.out.println("debug: " + this.isDebugConsole());
    }
}

