/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.util.GuiCommonElements;
import ome.formats.importer.util.IniFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private GuiCommonElements gui;
    private Integer dialogHeight = 310;
    private Integer dialogWidth = 374;
    private JTabbedPane tabbedPane;
    private JPanel fileChooserPanel;
    private JPanel singlePanePanel;
    private JPanel triplePanePanel;
    private JRadioButton singlePaneBtn;
    private JRadioButton triplePaneBtn;
    public static final String SINGLE_PANE_IMAGE = "gfx/single_pane_fileChooser.png";
    public static final String TRIPLE_PANE_IMAGE = "gfx/triple_pane_fileChooser.png";
    public JCheckBox archiveImage;
    private JButton cancelBtn;
    private JButton okBtn;
    public boolean cancelled = true;
    private static Log log = LogFactory.getLog(OptionsDialog.class);
    public OMEROMetadataStoreClient store;
    private IniFileLoader ini;
    Component owner;

    OptionsDialog(JFrame owner, String title, boolean modal) {
        super(owner);
        this.owner = owner;
        this.ini = IniFileLoader.getIniFileLoader();
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.gui = new GuiCommonElements();
        double[][] mainTable = new double[][]{{-1.0, 120.0, 5.0, 120.0, -1.0}, {-2.0, 10.0, -1.0, 10.0, 30.0}};
        this.fileChooserPanel = this.gui.addMainPanel(this.tabbedPane, mainTable, 0, 10, 0, 10, this.debug);
        String message = "Switch between single pane view and triple pane view. You will need to reboot the importer before your changes will take effect.";
        this.gui.addTextPane(this.fileChooserPanel, message, "0, 0, 4, 0", this.debug);
        double[][] singlePaneTable = new double[][]{{24.0, 5.0, -1.0}, {-1.0}};
        this.singlePanePanel = this.gui.addMainPanel(this.fileChooserPanel, singlePaneTable, 0, 0, 0, 0, this.debug);
        this.singlePaneBtn = this.gui.addRadioButton(this.singlePanePanel, null, 117, null, "0,0", this.debug);
        this.gui.addImagePanel(this.singlePanePanel, SINGLE_PANE_IMAGE, "2,0", this.debug);
        this.fileChooserPanel.add((Component)this.singlePanePanel, "0, 2, 1, 2");
        double[][] triplePaneTable = new double[][]{{24.0, 5.0, -1.0}, {-1.0}};
        this.triplePanePanel = this.gui.addMainPanel(this.fileChooserPanel, triplePaneTable, 0, 0, 0, 0, this.debug);
        this.triplePaneBtn = this.gui.addRadioButton(this.triplePanePanel, null, 117, null, "0,0", this.debug);
        this.gui.addImagePanel(this.triplePanePanel, TRIPLE_PANE_IMAGE, "2,0", this.debug);
        this.fileChooserPanel.add((Component)this.triplePanePanel, "3, 2, 4, 2");
        ButtonGroup group = new ButtonGroup();
        group.add(this.singlePaneBtn);
        group.add(this.triplePaneBtn);
        log.debug((Object)("Using Quaqua?" + this.ini.getUseQuaqua()));
        if (this.ini.getUseQuaqua()) {
            this.triplePaneBtn.setSelected(true);
            this.singlePaneBtn.setSelected(false);
        } else {
            this.triplePaneBtn.setSelected(false);
            this.singlePaneBtn.setSelected(true);
        }
        this.cancelBtn = this.gui.addButton(this.fileChooserPanel, "Cancel", 76, "Cancel", "1, 4, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.okBtn = this.gui.addButton(this.fileChooserPanel, "OK", 81, "Import", "3, 4, f, c", this.debug);
        this.okBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okBtn);
        this.gui.enterPressesWhenFocused(this.okBtn);
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("FileChooser Settings", null, this.fileChooserPanel, "FileChooser Settings");
        this.getRootPane().setDefaultButton(this.okBtn);
        this.cancelBtn.addActionListener(this);
        this.okBtn.addActionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        }
        if (e.getSource() == this.okBtn && this.isDisplayable()) {
            if (this.singlePaneBtn.isSelected()) {
                this.ini.setUseQuaqua(false);
            } else {
                this.ini.setUseQuaqua(true);
            }
            this.dispose();
            this.gui.restartNotice(this.owner, null);
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        OptionsDialog dialog = new OptionsDialog(null, "Options Dialog", true);
        if (dialog != null) {
            System.exit(0);
        }
    }
}

