/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.in.InCellReader;
import loci.formats.in.LeicaReader;
import loci.formats.meta.MetadataStore;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.Plane2D;
import omero.model.Channel;
import omero.model.Pixels;

public class OMEROWrapper
extends MinMaxCalculator {
    private ChannelSeparator separator;
    private ChannelFiller filler;
    public Boolean minMaxSet = null;
    private ImageReader iReader;

    public OMEROWrapper() {
        try {
            this.iReader = new ImageReader(new ClassList("importer_readers.txt", IFormatReader.class, OMEROWrapper.class));
            this.filler = new ChannelFiller((IFormatReader)this.iReader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load readers.txt.");
        }
        this.separator = new ChannelSeparator((IFormatReader)this.filler);
        this.reader = this.separator;
        this.iReader.setMetadataFiltered(true);
        this.filler.setMetadataFiltered(true);
        this.separator.setMetadataFiltered(true);
    }

    public Plane2D openPlane2D(String id, int planeNumber, byte[] buf) throws FormatException, IOException {
        ByteBuffer plane;
        if (this.iReader.isRGB() || this.isLeicaReader()) {
            byte[] bytePlane = this.openBytes(planeNumber);
            plane = ByteBuffer.wrap(bytePlane);
        } else {
            plane = ByteBuffer.wrap(this.openBytes(planeNumber, buf));
        }
        return new Plane2D(plane, this.getPixelType(), this.isLittleEndian(), this.getSizeX(), this.getSizeY());
    }

    public boolean isLeicaReader() {
        return this.iReader.getReader() instanceof LeicaReader;
    }

    public boolean isSPWReader(String string) {
        try {
            return this.iReader.getReader(string) instanceof InCellReader;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isMinMaxSet() throws FormatException, IOException {
        if (this.minMaxSet == null) {
            MetadataStore store = this.reader.getMetadataStore();
            int series = this.reader.getSeries();
            List pixels = (List)store.getRoot();
            Pixels p = (Pixels)pixels.get(series);
            Channel c = p.getChannel(p.getSizeC().getValue() - 1);
            this.minMaxSet = c.getStatsInfo() == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.minMaxSet;
    }

    protected void updateMinMax(BufferedImage b, int ndx) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(b, ndx);
        }
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(b, ndx);
        }
    }

    public void close() throws IOException {
        this.minMaxSet = null;
        super.close();
    }

    public OMEROMetadataStoreClient getMetadataStore() {
        return (OMEROMetadataStoreClient)super.getMetadataStore();
    }

    public ImageReader getImageReader() {
        return this.iReader;
    }
}

