/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import ome.formats.importer.About;
import ome.formats.importer.CommentMessenger;
import ome.formats.importer.FileQueueHandler;
import ome.formats.importer.HistoryDB;
import ome.formats.importer.HistoryHandler;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.LogAppender;
import ome.formats.importer.LoginHandler;
import ome.formats.importer.OptionsDialog;
import ome.formats.importer.StatusBar;
import ome.formats.importer.util.BareBonesBrowserLaunch;
import ome.formats.importer.util.GuiCommonElements;
import ome.formats.importer.util.IniFileLoader;
import ome.system.UpgradeCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmicroscopy.shoola.util.ui.MacOSMenuHandler;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogin;
import org.openmicroscopy.shoola.util.ui.login.ScreenLogo;

public class Main
extends JFrame
implements ActionListener,
WindowListener,
IObserver,
PropertyChangeListener,
WindowStateListener,
WindowFocusListener {
    private static final long serialVersionUID = 1228000122345370913L;
    static IniFileLoader ini;
    public static String dbVersion;
    public static String versionNumber;
    public static String releaseDate;
    public static String revision;
    public static String revisionDate;
    private static Log log;
    private static final boolean useSplashScreenAbout = false;
    static boolean USE_QUAQUA;
    public static final String TITLE = "OMERO.importer";
    public static final String splash = "gfx/importer_splash.png";
    public static final String ICON = "gfx/icon.png";
    public static final String QUIT_ICON = "gfx/nuvola_exit16.png";
    public static final String LOGIN_ICON = "gfx/nuvola_login16.png";
    public static final String COMMENT_ICON = "gfx/nuvola_sendcomment16.png";
    public static final String HOME_ICON = "gfx/nuvola_home16.png";
    public static final String ABOUT_ICON = "gfx/nuvola_about16.png";
    public static final String HISTORY_ICON = "gfx/nuvola_history16.png";
    public static final String CHOOSER_ICON = "gfx/nuvola_chooser16.png";
    public static final String OUTPUT_ICON = "gfx/nuvola_output16.png";
    public static final String BUG_ICON = "gfx/nuvola_bug16.png";
    public static final String CONFIG_ICON = "gfx/nuvola_configure16.png";
    public LoginHandler loginHandler;
    public FileQueueHandler fileQueueHandler;
    public static HistoryDB db;
    public StatusBar statusBar;
    private GuiCommonElements gui;
    private static final String HOME_URL = "http://trac.openmicroscopy.org.uk/shoola/wiki/OmeroInsightGettingStarted";
    public ScreenLogin view;
    public ScreenLogo viewTop;
    private JMenuBar menubar;
    private JMenu fileMenu;
    private JMenuItem options;
    private JMenuItem fileQuit;
    private JMenuItem login;
    private JMenu helpMenu;
    private JMenuItem helpComment;
    private JMenuItem helpHome;
    private JMenuItem helpAbout;
    public Boolean loggedIn;
    private JTextPane outputTextPane;
    private JTextPane debugTextPane;
    private JPanel historyPanel;
    private JTabbedPane tPane;
    private String username;
    private String password;
    private String server;
    private String port;

    static {
        dbVersion = "300";
        versionNumber = "3.1";
        releaseDate = "2008-06-16 16:18:13 +0100 (Mon, 16 Jun 2008)";
        revision = "$LastChangedRevision: 2524 $";
        revisionDate = "$LastChangedDate: 2008-06-23 10:29:21 +0100 (Mon, 23 Jun 2008) $";
        log = LogFactory.getLog(Main.class);
        USE_QUAQUA = true;
    }

    public Main(String[] args) {
        this.isUpgradeRequired();
        this.gui = new GuiCommonElements();
        ini = IniFileLoader.getIniFileLoader(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Main.this.shutdown();
            }
        });
        this.setTitle(ini.getAppTitle());
        this.setIconImage(this.gui.getImageIcon(ICON).getImage());
        this.setPreferredSize(new Dimension(this.gui.bounds.width, this.gui.bounds.height));
        this.setSize(this.gui.bounds.width, this.gui.bounds.height);
        this.setLocation(this.gui.bounds.x, this.gui.bounds.y);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.pack();
        this.addWindowListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                ((Main)Main.this).gui.bounds = Main.this.getBounds();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                ((Main)Main.this).gui.bounds = Main.this.getBounds();
            }
        });
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.menubar.add(this.fileMenu);
        this.login = new JMenuItem("Login to the server...", this.gui.getImageIcon(LOGIN_ICON));
        this.login.setActionCommand("login");
        this.login.addActionListener(this);
        this.fileMenu.add(this.login);
        if (this.gui.getIsMac()) {
            this.options = new JMenuItem("Options...", this.gui.getImageIcon(CONFIG_ICON));
            this.options.setActionCommand("options");
            this.options.addActionListener(this);
            this.fileMenu.add(this.options);
        }
        this.fileQuit = new JMenuItem("Quit", this.gui.getImageIcon(QUIT_ICON));
        this.fileQuit.setActionCommand("quit");
        this.fileQuit.addActionListener(this);
        this.fileMenu.add(this.fileQuit);
        this.helpMenu = new JMenu("Help");
        this.menubar.add(this.helpMenu);
        this.helpComment = new JMenuItem("Send a Comment...", this.gui.getImageIcon(COMMENT_ICON));
        this.helpComment.setActionCommand("comment");
        this.helpComment.addActionListener(this);
        this.helpHome = new JMenuItem("Visit Importer Homepage...", this.gui.getImageIcon(HOME_ICON));
        this.helpHome.setActionCommand("home");
        this.helpHome.addActionListener(this);
        this.helpAbout = new JMenuItem("About the Importer...", this.gui.getImageIcon(ABOUT_ICON));
        this.helpAbout.setActionCommand("about");
        this.helpAbout.addActionListener(this);
        this.helpMenu.add(this.helpComment);
        this.helpMenu.add(this.helpHome);
        this.helpMenu.add(this.helpAbout);
        this.setJMenuBar(this.menubar);
        this.tPane = new JTabbedPane();
        this.tPane.setOpaque(false);
        JPanel filePanel = new JPanel(new BorderLayout());
        this.fileQueueHandler = new FileQueueHandler(this);
        filePanel.add((Component)this.fileQueueHandler, "Center");
        this.tPane.addTab("File Chooser", this.gui.getImageIcon(CHOOSER_ICON), filePanel, "Add and delete images here to the import queue.");
        this.tPane.setMnemonicAt(0, 49);
        this.historyPanel = new JPanel();
        this.historyPanel.setOpaque(false);
        this.historyPanel.setLayout(new BorderLayout());
        this.tPane.addTab("Import History", this.gui.getImageIcon(HISTORY_ICON), this.historyPanel, "Import history is displayed here.");
        this.tPane.setMnemonicAt(0, 52);
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new BorderLayout());
        this.outputTextPane = new JTextPane();
        this.outputTextPane.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane();
        outputScrollPane.getViewport().add(this.outputTextPane);
        outputScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Main.this.outputTextPane.setCaretPosition(Main.this.outputTextPane.getDocument().getLength());
            }
        });
        outputPanel.add((Component)outputScrollPane, "Center");
        this.tPane.addTab("Output Text", this.gui.getImageIcon(OUTPUT_ICON), outputPanel, "Standard output text goes here.");
        this.tPane.setMnemonicAt(0, 50);
        JPanel debugPanel = new JPanel();
        debugPanel.setLayout(new BorderLayout());
        this.debugTextPane = new JTextPane();
        this.debugTextPane.setEditable(false);
        JScrollPane debugScrollPane = new JScrollPane();
        debugScrollPane.getViewport().add(this.debugTextPane);
        debugScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Main.this.debugTextPane.setCaretPosition(Main.this.debugTextPane.getDocument().getLength());
            }
        });
        debugPanel.add((Component)debugScrollPane, "Center");
        this.tPane.addTab("Debug Text", this.gui.getImageIcon(BUG_ICON), debugPanel, "Debug messages are displayed here.");
        this.tPane.setMnemonicAt(0, 51);
        this.tPane.setSelectedIndex(0);
        this.add(this.tPane);
        this.statusBar = new StatusBar();
        this.statusBar.setStatusIcon("gfx/server_disconn16.png", "Server disconnected.");
        this.statusBar.setProgress(false, 0, "");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setVisible(false);
        this.loginHandler = LoginHandler.getLoginHandler(this, false, false);
        LogAppender.getInstance().setTextArea(this.debugTextPane);
        this.appendToOutputLn("> Starting the importer (revision " + Main.getPrintableKeyword(revision) + ").");
        this.appendToOutputLn("> Build date: " + Main.getPrintableKeyword(revisionDate));
        this.appendToOutputLn("> Release date: " + releaseDate);
        HistoryHandler historyHandler = HistoryHandler.getHistoryHandler();
        this.historyPanel.add((Component)historyHandler, "Center");
        this.macMenuFix();
    }

    boolean isUpgradeRequired() {
        ResourceBundle bundle = ResourceBundle.getBundle("omero");
        String version = bundle.getString("omero.version");
        String url = bundle.getString("omero.upgrades.url");
        UpgradeCheck check = new UpgradeCheck(url, version, "importer");
        check.run();
        return check.isUpgradeNeeded();
    }

    protected void shutdown() {
        ini.setUIBounds(this.gui.getUIBounds());
        ini.flushPreferences();
    }

    private void macMenuFix() {
        try {
            MacOSMenuHandler handler = new MacOSMenuHandler((JFrame)this);
            handler.initialize();
            this.addPropertyChangeListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean displayLoginDialog(Object viewer, boolean modal, boolean displayTop) {
        Image img = Toolkit.getDefaultToolkit().createImage(ICON);
        this.view = new ScreenLogin(ini.getAppTitle(), (Icon)this.gui.getImageIcon("gfx/login_background.png"), img, ini.getVersionNumber(), ini.getServerPort());
        this.view.showConnectionSpeed(false);
        this.viewTop = new ScreenLogo(ini.getAppTitle(), (Icon)this.gui.getImageIcon(splash), img);
        this.viewTop.setStatusVisible(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = this.viewTop.getExtendedSize();
        Dimension dlogin = this.view.getPreferredSize();
        if (displayTop) {
            int totalHeight = d.height + dlogin.height;
            this.viewTop.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, d.width, this.viewTop.getSize().height);
            Rectangle r = this.viewTop.getBounds();
            this.viewTop.addPropertyChangeListener((PropertyChangeListener)viewer);
            this.viewTop.addWindowStateListener((WindowStateListener)viewer);
            this.viewTop.addWindowFocusListener((WindowFocusListener)viewer);
            this.view.setBounds(r.x, r.y + d.height, dlogin.width, dlogin.height);
        } else {
            int totalHeight = dlogin.height;
            this.view.setBounds((screenSize.width - d.width) / 2, (screenSize.height - totalHeight) / 2, dlogin.width, dlogin.height);
            this.view.setQuitButtonText("Canel");
        }
        this.view.addPropertyChangeListener((PropertyChangeListener)viewer);
        this.view.addWindowStateListener((WindowStateListener)viewer);
        this.view.addWindowFocusListener((WindowFocusListener)viewer);
        this.view.setAlwaysOnTop(false);
        this.viewTop.setVisible(displayTop);
        this.view.setVisible(true);
        return true;
    }

    public void appendToOutput(String s) {
        try {
            StyledDocument doc = (StyledDocument)this.outputTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 200000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToOutputLn(String s) {
        this.appendToOutput(String.valueOf(s) + "\n");
    }

    public void appendToDebug(String s) {
        log.debug((Object)s);
        try {
            StyledDocument doc = (StyledDocument)this.debugTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 200000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToDebugLn(String s) {
        this.appendToDebug(String.valueOf(s) + "\n");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("login".equals(cmd)) {
            if (this.loggedIn.booleanValue()) {
                this.setImportEnabled(false);
                this.loggedIn = false;
                this.appendToOutputLn("> Logged out.");
                this.statusBar.setStatusIcon("gfx/server_disconn16.png", "Logged out.");
                this.loginHandler.logout();
                this.loginHandler = null;
            } else {
                this.loginHandler = LoginHandler.getLoginHandler(this, true, true);
                this.loginHandler.displayLogin(false);
                db = HistoryDB.getHistoryDB();
            }
        } else if ("quit".equals(cmd)) {
            if (this.gui.quitConfirmed(this, null)) {
                System.exit(0);
            }
        } else if ("options".equals(cmd)) {
            OptionsDialog dialog = new OptionsDialog(this, "Import", true);
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            About.show(this, false);
        } else if ("comment".equals(cmd)) {
            new CommentMessenger(this, "OMERO.importer Comment Dialog", (Boolean)true);
        } else if ("home".equals(cmd)) {
            BareBonesBrowserLaunch.openURL(HOME_URL);
        }
    }

    public static String getPrintableKeyword(String keyword) {
        int begin = keyword.indexOf(" ") + 1;
        int end = keyword.lastIndexOf(" ");
        return keyword.substring(begin, end);
    }

    public void waitCursor(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    public void setImportEnabled(boolean toggle) {
        if (toggle) {
            this.login.setText("Logout of the server...");
        } else {
            this.login.setText("Login to the server...");
        }
    }

    public void onlyAllowExit() {
        this.fileMenu.setEnabled(true);
        this.helpMenu.setEnabled(true);
    }

    public void enableMenus(boolean toggle) {
        this.fileMenu.setEnabled(toggle);
        this.helpMenu.setEnabled(toggle);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void windowClosing(WindowEvent e) {
        if (this.gui.quitConfirmed(this, null)) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        ini = IniFileLoader.getIniFileLoader(args);
        USE_QUAQUA = ini.getUseQuaqua();
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel") && USE_QUAQUA) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        new Main(args);
    }

    public static Point getSplashLocation() {
        return null;
    }

    public void update(IObservable importLibrary, Object message, Object[] args) {
        if (message == "loading_image") {
            this.statusBar.setProgress(true, -1, "Loading file " + args[2] + " of " + args[3]);
            this.appendToOutput("> [" + args[1] + "] Loading image \"" + args[0] + "\"...\n");
            this.statusBar.setStatusIcon("gfx/import_icon_16.png", "Prepping file \"" + args[0] + "\" (file " + args[2] + " of " + args[3] + " imports)");
        }
        if (message == "loaded_image") {
            this.statusBar.setProgress(true, -1, "Analyzing file " + args[2] + " of " + args[3]);
            this.appendToOutput(" Succesfully loaded.\n");
            this.appendToOutput("> [" + args[1] + "] Importing metadata for " + "image \"" + args[0] + "\"... ");
            this.statusBar.setStatusIcon("gfx/import_icon_16.png", "Analyzing the metadata for file \"" + args[0] + "\" (file " + args[2] + " of " + args[3] + " imports)");
        }
        if (message == "dataset_stored") {
            this.appendToOutputLn("Successfully stored to dataset \"" + args[4] + "\" with id \"" + args[5] + "\".");
            this.appendToOutputLn("> [" + args[1] + "] Importing pixel data for " + "image \"" + args[0] + "\"... ");
            this.statusBar.setProgress(true, 0, "Importing file " + args[2] + " of " + args[3]);
            this.statusBar.setProgressValue((Integer)args[2] - 1);
            this.statusBar.setStatusIcon("gfx/import_icon_16.png", "Importing the plane data for file \"" + args[0] + "\" (file " + args[2] + " of " + args[3] + " imports)");
            this.appendToOutput("> Importing plane: ");
        }
        if (message == "data_stored") {
            this.appendToOutputLn("> Successfully stored with pixels id \"" + args[5] + "\".");
            this.appendToOutputLn("> [" + args[1] + "] Image imported successfully!");
        }
        if (message == "java.io.IOException") {
            JOptionPane optionPane = new JOptionPane("The importer cannot retrieve one of your images in a timely manner.\nThe file in question is:\n'" + args[0] + "'\n\n" + "There are a number of reasons you may see this error:\n" + " - The file has been deleted.\n" + " - There was a networking error retrieving a remotely saved file.\n" + " - An archived file has not been fully retrieved from backup.\n\n" + "The importer will now try to continue with the remainer of your imports.\n", 0);
            JDialog dialog = new JDialog((Frame)this, "IO Error");
            dialog.setAlwaysOnTop(true);
            dialog.setContentPane(optionPane);
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("login".equals(name)) {
            LoginCredentials lc = (LoginCredentials)evt.getNewValue();
            if (lc != null) {
                this.login(lc);
            }
        } else if ("quit".equals(name) || name.equals("quitpplication")) {
            if (this.gui.quitConfirmed(this, null)) {
                System.exit(0);
            }
        } else if (!"toFront".equals(name) && !"moveFront".equals(name) && name.equals("aboutApplication")) {
            this.setDefaultCloseOperation(0);
            About.show(this, false);
        }
    }

    public void login(LoginCredentials lc) {
    }

    public void windowStateChanged(WindowEvent arg0) {
    }

    public void windowGainedFocus(WindowEvent arg0) {
    }

    public void windowLostFocus(WindowEvent arg0) {
    }
}

