/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.HistoryTable;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.LoginDialog;
import ome.formats.importer.LoginFrame;
import ome.formats.importer.Main;
import ome.formats.importer.util.GuiCommonElements;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmicroscopy.shoola.util.ui.login.LoginCredentials;

public class LoginHandler
implements IObservable,
ActionListener,
WindowListener,
PropertyChangeListener,
WindowStateListener,
WindowFocusListener {
    private static Log log = LogFactory.getLog(LoginHandler.class);
    private static boolean NEW_LOGIN = true;
    ArrayList<IObserver> observers = new ArrayList();
    public volatile JFrame f;
    private boolean center;
    private String username;
    private String password;
    private int port;
    private String server;
    private Main viewer;
    private Preferences userPrefs = Preferences.userNodeForPackage(LoginHandler.class);
    private OMEROMetadataStoreClient store;
    public LoginDialog dialog;
    public LoginFrame frame;
    private LoginCredentials lc;
    private boolean modal;
    private boolean displayTop;
    private HistoryTable historyTable = null;
    private GuiCommonElements gui;
    private static LoginHandler ref;

    LoginHandler(Main viewer, boolean modal, boolean center) {
        this.viewer = viewer;
        this.center = center;
        this.modal = modal;
        this.gui = new GuiCommonElements();
        this.historyTable = HistoryTable.getHistoryTable();
        if (this.historyTable != null) {
            this.addObserver(this.historyTable);
        }
        viewer.enableMenus(false);
        this.displayLogin(true);
    }

    public static synchronized LoginHandler getLoginHandler(Main viewer, boolean modal, boolean center) {
        if (ref == null) {
            try {
                ref = new LoginHandler(viewer, modal, center);
            }
            catch (Exception e) {
                log.error((Object)"Error constructing login handler.", (Throwable)e);
                JOptionPane.showMessageDialog(null, "Unknown exception.\n\nWe were not able to connect to the server.\nClick OK to exit.", "Warning", 0);
                System.exit(0);
            }
        }
        return ref;
    }

    public static synchronized LoginHandler getLoginHandler() {
        if (ref == null) {
            throw new RuntimeException("LoginHandler not created yet.");
        }
        return ref;
    }

    public void displayLogin(boolean displayTop) {
        this.displayTop = displayTop;
        boolean cancelled = NEW_LOGIN ? this.viewer.displayLoginDialog(this, this.modal, displayTop) : this.displayLoginDialog(this.viewer, this.modal);
        if (this.modal && cancelled) {
            this.loginCancelled();
        }
        if (this.modal && !cancelled) {
            this.tryLogin();
        }
    }

    public void tryLogin() {
        new Thread(){

            public void run() {
                if (!NEW_LOGIN) {
                    LoginHandler.this.viewer.setVisible(true);
                    if (!LoginHandler.this.modal) {
                        LoginHandler.this.username = LoginHandler.this.frame.username;
                        LoginHandler.this.password = LoginHandler.this.frame.password;
                        LoginHandler.this.server = LoginHandler.this.frame.currentServer;
                        LoginHandler.this.port = LoginHandler.this.frame.port;
                        LoginHandler.this.frame.updateServerList(LoginHandler.this.server);
                    } else {
                        LoginHandler.this.username = LoginHandler.this.dialog.username;
                        LoginHandler.this.password = LoginHandler.this.dialog.password;
                        LoginHandler.this.server = LoginHandler.this.dialog.currentServer;
                        LoginHandler.this.port = LoginHandler.this.dialog.port;
                        LoginHandler.this.dialog.updateServerList(LoginHandler.this.server);
                    }
                    LoginHandler.this.userPrefs.put("username", LoginHandler.this.username);
                    LoginHandler.this.userPrefs.put("server", LoginHandler.this.server);
                    LoginHandler.this.userPrefs.putInt("port", LoginHandler.this.port);
                } else {
                    LoginHandler.this.username = LoginHandler.this.lc.getUserName();
                    LoginHandler.this.password = LoginHandler.this.lc.getPassword();
                    LoginHandler.this.server = LoginHandler.this.lc.getHostName();
                    LoginHandler.this.port = LoginHandler.this.lc.getPort();
                }
                ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_trying16.png", "Trying to connect to " + LoginHandler.this.server);
                ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(true, -1, "connecting....");
                try {
                    if (LoginHandler.this.isValidLogin()) {
                        if (NEW_LOGIN) {
                            ((LoginHandler)LoginHandler.this).viewer.view.close();
                            ((LoginHandler)LoginHandler.this).viewer.viewTop.close();
                            LoginHandler.this.viewer.setVisible(true);
                        }
                        ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                        LoginHandler.this.viewer.appendToOutput("> Login Successful.\n");
                        log.info((Object)"Login successful!");
                        LoginHandler.this.viewer.enableMenus(true);
                        LoginHandler.this.viewer.setImportEnabled(true);
                        ((LoginHandler)LoginHandler.this).viewer.loggedIn = true;
                        LoginHandler.this.notifyObservers("LOGGED_IN", null);
                        try {
                            long freeSpace = LoginHandler.this.store.getRepositorySpace();
                            NumberFormat formatter = NumberFormat.getInstance(Locale.US);
                            String freeMB = formatter.format(freeSpace / 1000L);
                            ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_connect16.png", "Connected to " + LoginHandler.this.server + ". Free space: " + freeMB + " MB.");
                            return;
                        }
                        catch (Exception e) {
                            log.error((Object)"Exception retrieving repository free space.", (Throwable)e);
                            ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_connect16.png", "Connected to " + LoginHandler.this.server + ".");
                            return;
                        }
                    }
                    if (NEW_LOGIN) {
                        ((LoginHandler)LoginHandler.this).viewer.view.setAlwaysOnTop(false);
                    }
                    log.info((Object)"Login failed!");
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/error_msg16.png", "Incorrect username/password. Server login failed, please try to log in again.");
                    JOptionPane.showMessageDialog(LoginHandler.this.viewer, "Incorrect username/password. Server login \nfailed, please try to log in again.");
                    LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                    LoginHandler.this.viewer.enableMenus(true);
                    ((LoginHandler)LoginHandler.this).viewer.loggedIn = false;
                    if (NEW_LOGIN) {
                        LoginHandler.this.refreshNewLogin();
                    }
                    return;
                }
                catch (Exception e) {
                    log.error((Object)"Exception in LoginHandler.", (Throwable)e);
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/error_msg16.png", "Server connection to " + LoginHandler.this.server + " failed. " + "Please try again.");
                    if (NEW_LOGIN) {
                        ((LoginHandler)LoginHandler.this).viewer.view.setAlwaysOnTop(false);
                    }
                    JOptionPane.showMessageDialog(LoginHandler.this.viewer, "\nThe application failed to log in. The hostname may be wrong or \nthe server may be offline.\n\nPlease try again.");
                    LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                    LoginHandler.this.viewer.enableMenus(true);
                    ((LoginHandler)LoginHandler.this).viewer.loggedIn = false;
                    if (NEW_LOGIN) {
                        LoginHandler.this.refreshNewLogin();
                    }
                    return;
                }
            }
        }.start();
    }

    void refreshNewLogin() {
        this.viewer.view.setAlwaysOnTop(true);
        this.viewer.view.requestFocusOnField();
    }

    void loginCancelled() {
        this.viewer.loggedIn = false;
        this.viewer.enableMenus(true);
        this.viewer.setVisible(true);
    }

    private boolean displayLoginDialog(Main viewer, boolean modal) {
        if (modal) {
            this.dialog = new LoginDialog(viewer, viewer, "Login", modal, this.center);
            this.dialog.setAlwaysOnTop(true);
            if (this.dialog.cancelled) {
                return true;
            }
        } else {
            this.frame = new LoginFrame(viewer, viewer, "Login", modal, this.center);
            this.frame.addPropertyChangeListener(this);
        }
        return false;
    }

    private boolean isValidLogin() throws Exception {
        try {
            this.store = new OMEROMetadataStoreClient();
            this.store.initialize(this.username, this.password, this.server, this.port);
        }
        catch (Exception e) {
            log.error((Object)"Login failure.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void logout() {
        this.store.logout();
    }

    public OMEROMetadataStoreClient getMetadataStore() {
        return this.store;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (!NEW_LOGIN) {
            if (prop.equals("login")) {
                this.tryLogin();
            }
            if (prop.equals("login_cancelled")) {
                this.loginCancelled();
            }
        } else if (prop.equals("login")) {
            this.lc = (LoginCredentials)evt.getNewValue();
            if (this.lc != null) {
                this.tryLogin();
            }
        } else if ("quit".equals(prop)) {
            if (this.displayTop) {
                if (this.gui.quitConfirmed(this.viewer, "Do you really want to quit?")) {
                    System.exit(0);
                }
            } else {
                this.viewer.view.dispose();
            }
        } else if (!"toFront".equals(prop)) {
            "moveFront".equals(prop);
        }
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(Object message, Object[] args) {
        for (IObserver observer : this.observers) {
            observer.update(this, message, args);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }
}

