/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import ome.formats.importer.Main;
import ome.formats.importer.ServerDialog;
import ome.formats.importer.util.GuiCommonElements;
import ome.formats.importer.util.IniFileLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginFrame
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    IniFileLoader ini;
    boolean debug = false;
    JFrame main;
    GuiCommonElements gui;
    Integer loginHeight = 113;
    Integer loginWidth = 551;
    String DEFAULT_SERVER_TEXT = "Add a New Server ->";
    String SERVER_NAME_SEPARATOR = ",";
    List<String> serverList = new ArrayList<String>();
    JTextPane serverText;
    Color panelColor = Color.black;
    Color textColor = Color.white;
    String unameLabel = "<html><font color=white><b>Username: </b></font></html>";
    String pswdLabel = "<html><font color=white><b>Password: </b></font></html>";
    JPanel mainPanel;
    JPanel topPanel;
    JButton loginBtn;
    JButton quitBtn;
    JButton configBtn;
    JTextPane pleaseLogIn;
    JTextPane versionInfo;
    JTextField uname;
    JPasswordField pswd;
    JTextField srvr;
    JTextField prt;
    Frame f;
    public String username;
    public String password;
    public String currentServer;
    public int port = 4063;
    public boolean cancelled = true;
    private Preferences userPrefs = Preferences.userNodeForPackage(LoginFrame.class);

    LoginFrame(JFrame owner, JFrame main, String title, boolean modal, boolean center) {
        this.main = main;
        this.gui = new GuiCommonElements();
        this.setTitle("Login");
        this.setIconImage(this.gui.getImageIcon("gfx/icon.png").getImage());
        this.setLocation(200, 200);
        this.setResizable(false);
        this.toFront();
        this.setSize(new Dimension(this.loginWidth, this.loginHeight));
        this.setLocationRelativeTo(main);
        if (!center && Main.getSplashLocation() != null) {
            int offset = Main.getSplashLocation().y + this.gui.getImageIcon("gfx/importer_splash.png").getIconHeight() + 5;
            this.setLocation(this.getX(), offset);
        }
        this.setUndecorated(true);
        this.username = this.userPrefs.get("username", this.username);
        if (this.username != null) {
            this.username = this.username.trim();
        }
        this.currentServer = this.userPrefs.get("server", this.currentServer);
        if (this.currentServer != null) {
            this.currentServer = this.currentServer.trim();
        }
        this.serverList = this.getServerList();
        this.port = this.userPrefs.getInt("port", this.port);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0}, {-1.0, 30.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 20, 10, 20, this.debug);
        this.loginBtn = this.gui.addButton(this.mainPanel, "Login", 76, "Login", "1, 1, f, c", this.debug);
        this.loginBtn.addActionListener(this);
        this.quitBtn = this.gui.addButton(this.mainPanel, "Quit", 81, "Quit the Application", "3, 1, f, c", this.debug);
        this.quitBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.loginBtn);
        this.gui.enterPressesWhenFocused(this.loginBtn);
        double[][] topTable = new double[][]{{245.0, 18.0, 220.0, 28.0}, {32.0, -1.0}};
        this.topPanel = this.gui.addMainPanel(this, topTable, 0, 0, 0, 0, this.debug);
        String message = "Please Log In";
        StyleContext context = new StyleContext();
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        StyleConstants.setForeground(style, this.textColor);
        StyleConstants.setBold(style, true);
        StyleConstants.setFontSize(style, 18);
        this.pleaseLogIn = this.gui.addTextPane((Container)this.topPanel, message, "0, 0, l, c", context, style, this.debug);
        style = context.getStyle("default");
        StyleConstants.setAlignment(style, 2);
        StyleConstants.setForeground(style, this.textColor);
        this.serverList = this.getServerList();
        if (this.serverList == null || !this.serverList.contains(this.currentServer)) {
            this.currentServer = this.DEFAULT_SERVER_TEXT;
        }
        this.serverText = this.gui.addTextPane((Container)this.topPanel, this.currentServer, "2, 0, r, c", context, style, this.debug);
        this.configBtn = this.gui.addButton(this.topPanel, "", 88, "Config Server", "3, 0, c, c", this.debug);
        this.configBtn.setText(null);
        this.configBtn.setBorderPainted(false);
        this.configBtn.setMargin(new Insets(0, 0, 0, 0));
        this.configBtn.setBorder(BorderFactory.createEmptyBorder());
        this.configBtn.setFocusPainted(false);
        this.configBtn.setOpaque(false);
        this.configBtn.setContentAreaFilled(false);
        this.configBtn.setIcon(this.gui.getImageIcon("gfx/config.png"));
        this.configBtn.setPressedIcon(this.gui.getImageIcon("gfx/config_pressed.png"));
        this.uname = this.gui.addTextField(this.topPanel, this.unameLabel, this.username, 85, "Input your useername here.", "", -2.0, "0, 1, 0, 1", this.debug);
        this.pswd = this.gui.addPasswordField(this.topPanel, this.pswdLabel, this.password, 85, "Input your useername here.", "", -2.0, "2, 1, 3, 1", this.debug);
        style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        StyleConstants.setForeground(style, this.textColor);
        StyleConstants.setFontSize(style, 12);
        StyleConstants.setBold(style, true);
        this.versionInfo = this.gui.addTextPane((Container)this.mainPanel, this.ini.getVersionNumber(), "0, 1, l, b", context, style, this.debug);
        this.configBtn.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (LoginFrame.this.uname == null) {
                    LoginFrame.this.uname.requestFocus();
                } else {
                    LoginFrame.this.pswd.requestFocus();
                }
            }
        });
        this.mainPanel.add((Component)this.topPanel, "0, 0, 3, 0");
        JLabel background = new JLabel(this.gui.getImageIcon("gfx/login_background.png"));
        background.setBorder(BorderFactory.createEmptyBorder());
        this.getRootPane().setBorder(null);
        JLayeredPane layers = new JLayeredPane();
        layers.setBounds(0, 0, this.loginWidth, this.loginHeight);
        layers.setBackground(Color.black);
        background.setBounds(0, 0, this.loginWidth, this.loginHeight);
        this.mainPanel.setSize(this.loginWidth, this.loginHeight);
        layers.add((Component)background, new Integer(0));
        layers.add((Component)this.mainPanel, new Integer(1));
        this.getContentPane().add(layers);
        this.setVisible(true);
    }

    private List<String> getServerList() {
        String serverListString = null;
        if ((serverListString = this.userPrefs.get("servers", serverListString)) == null || serverListString.trim().length() == 0) {
            return null;
        }
        String[] l = serverListString.split(this.SERVER_NAME_SEPARATOR, 0);
        if (l == null || l.length == 0) {
            return null;
        }
        if (this.serverList != null) {
            this.serverList.clear();
        }
        int index = 0;
        while (index < l.length) {
            if (this.serverList != null) {
                this.serverList.add(l[index].trim());
            }
            ++index;
        }
        return this.serverList;
    }

    void updateServerList(String currentServer) {
        if (currentServer.trim().length() == 0 || currentServer.contains(this.DEFAULT_SERVER_TEXT)) {
            return;
        }
        List<String> l = this.getServerList();
        if (l != null && l.contains(currentServer)) {
            return;
        }
        String serverListString = null;
        if ((serverListString = this.userPrefs.get("servers", serverListString)) == null || serverListString.length() == 0) {
            this.userPrefs.put("servers", currentServer.trim());
        } else {
            this.userPrefs.put("servers", String.valueOf(serverListString) + this.SERVER_NAME_SEPARATOR + currentServer);
        }
    }

    private void removeServer(String server) {
        List<String> l = this.getServerList();
        if (l == null) {
            return;
        }
        l.remove(server);
        Iterator<String> i = l.iterator();
        String list = "";
        int n = l.size() - 1;
        int index = 0;
        while (i.hasNext()) {
            list = String.valueOf(list) + i.next();
            if (index != n) {
                list = String.valueOf(list) + this.SERVER_NAME_SEPARATOR;
            }
            ++index;
        }
        this.userPrefs.put("servers", list);
        this.serverList = this.getServerList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.loginBtn) {
            this.username = this.uname.getText();
            this.password = new String(this.pswd.getPassword());
            this.cancelled = false;
            this.firePropertyChange("login", false, true);
            this.dispose();
            if (this.f != null) {
                this.f.dispose();
            }
        }
        if (e.getSource() == this.quitBtn) {
            System.exit(0);
        }
        if (e.getSource() == this.configBtn) {
            this.serverList = this.getServerList();
            ServerDialog serverDialog = new ServerDialog(this.serverList);
            serverDialog.setLocationRelativeTo(this.main);
            serverDialog.addPropertyChangeListener(this);
            serverDialog.setVisible(true);
            this.currentServer = serverDialog.getCurrentServer();
            if (this.currentServer.trim().length() == 0) {
                this.currentServer = this.DEFAULT_SERVER_TEXT;
            }
            this.serverText.setText(this.currentServer);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String e = evt.getPropertyName();
        if ("remove".equals(e)) {
            String oldValue = (String)evt.getOldValue();
            this.removeServer(oldValue);
            if (this.currentServer.equals(oldValue)) {
                this.currentServer = this.DEFAULT_SERVER_TEXT;
            }
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        laf = "javax.swing.plaf.metal.MetalLookAndFeel";
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        JFrame f = new JFrame();
        new LoginFrame(f, f, "", false, true);
        f.setVisible(false);
        f.setDefaultCloseOperation(3);
        f.pack();
    }
}

