/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import ome.formats.importer.ImportCellRenderer;
import ome.formats.importer.ImportEntry;

public class JOutlookBar
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    DefaultListModel today = new DefaultListModel();
    DefaultListModel yesterday = new DefaultListModel();
    DefaultListModel thisWeek = new DefaultListModel();
    DefaultListModel lastWeek = new DefaultListModel();
    DefaultListModel thisMonth = new DefaultListModel();
    private JPanel topPanel = new JPanel(new GridLayout(1, 1));
    private JPanel bottomPanel = new JPanel(new GridLayout(1, 1));
    private Map bars = new LinkedHashMap();
    private int visibleBar = 0;
    private JComponent visibleComponent = null;

    public JOutlookBar() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
    }

    public void addBar(String name, JComponent component) {
        BarInfo barInfo = new BarInfo(name, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void addBar(String name, Icon icon, JComponent component) {
        BarInfo barInfo = new BarInfo(name, icon, component);
        barInfo.getButton().addActionListener(this);
        this.bars.put(name, barInfo);
        this.render();
    }

    public void removeBar(String name) {
        this.bars.remove(name);
        this.render();
    }

    public int getVisibleBar() {
        return this.visibleBar;
    }

    public void setVisibleBar(int visibleBar) {
        if (visibleBar >= 0 && visibleBar <= this.bars.size() - 1) {
            this.visibleBar = visibleBar;
            this.render();
        }
    }

    public void render() {
        int totalBars = this.bars.size();
        int topBars = this.visibleBar + 1;
        int bottomBars = totalBars - topBars;
        Iterator itr = this.bars.keySet().iterator();
        this.topPanel.removeAll();
        GridLayout topLayout = (GridLayout)this.topPanel.getLayout();
        topLayout.setRows(topBars);
        BarInfo barInfo = null;
        int i = 0;
        while (i < topBars) {
            String barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            this.topPanel.add(barInfo.getButton());
            ++i;
        }
        this.topPanel.validate();
        if (this.visibleComponent != null) {
            this.remove(this.visibleComponent);
        }
        this.visibleComponent = barInfo.getComponent();
        this.add((Component)this.visibleComponent, "Center");
        this.bottomPanel.removeAll();
        GridLayout bottomLayout = (GridLayout)this.bottomPanel.getLayout();
        bottomLayout.setRows(bottomBars);
        int i2 = 0;
        while (i2 < bottomBars) {
            String barName = (String)itr.next();
            barInfo = (BarInfo)this.bars.get(barName);
            this.bottomPanel.add(barInfo.getButton());
            ++i2;
        }
        this.bottomPanel.validate();
        this.validate();
    }

    public void actionPerformed(ActionEvent e) {
        int currentBar = 0;
        for (String barName : this.bars.keySet()) {
            BarInfo barInfo = (BarInfo)this.bars.get(barName);
            if (barInfo.getButton() == e.getSource()) {
                this.visibleBar = currentBar;
                this.render();
                return;
            }
            ++currentBar;
        }
    }

    public JPanel getListPanel(JList list) {
        list.setCellRenderer(new ImportCellRenderer());
        list.setSelectionMode(0);
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().add(list);
        panel.add(scrollPane);
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                int index;
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() > 0 && (index = list.locationToIndex(evt.getPoint())) >= 0) {
                    ImportEntry entry = (ImportEntry)list.getModel().getElementAt(index);
                    JOutlookBar.this.firePropertyChange("QUICK_HISTORY", -1, entry.importKey);
                }
            }
        });
        return panel;
    }

    public void updatePanelList(JList list, DefaultListModel mine, DefaultListModel theirs) {
        mine.clear();
        int i = 0;
        while (i < theirs.size()) {
            mine.addElement(theirs.get(i));
            ++i;
        }
        list.validate();
        this.visibleComponent.validate();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JOutlookBar Test");
        JOutlookBar outlookBar = new JOutlookBar();
        outlookBar.setVisibleBar(2);
        frame.getContentPane().add(outlookBar);
        frame.setSize(800, 600);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(d.width / 2 - 400, d.height / 2 - 300);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class BarInfo {
        private String name;
        private JButton button;
        private JComponent component;

        public BarInfo(String name, JComponent component) {
            this.name = name;
            this.component = component;
            this.button = new JButton(name);
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 0, 3, 0);
            Border etchedBorder = BorderFactory.createEtchedBorder(1);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(etchedBorder, emptyBorder);
            this.button.setBorder(compoundBorder);
        }

        public BarInfo(String name, Icon icon, JComponent component) {
            this.name = name;
            this.component = component;
            this.button = new JButton(name, icon);
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 0, 3, 0);
            Border etchedBorder = BorderFactory.createEtchedBorder(1);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(etchedBorder, emptyBorder);
            this.button.setBorder(compoundBorder);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JButton getButton() {
            return this.button;
        }

        public JComponent getComponent() {
            return this.component;
        }
    }
}

