/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import loci.formats.FormatException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.DebugMessenger;
import ome.formats.importer.FileQueueTable;
import ome.formats.importer.HistoryDB;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.Main;
import ome.formats.importer.OMEROWrapper;
import ome.formats.model.InstanceProvider;
import omero.ResourceError;
import omero.model.IObject;
import omero.rtypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportHandler {
    private ImportLibrary library;
    private Main viewer;
    private static boolean runState = false;
    private Thread runThread;
    HistoryDB db = null;
    ImportContainer[] importContainer = null;
    private FileQueueTable qTable;
    private static Log log = LogFactory.getLog(ImportHandler.class);
    private OMEROMetadataStoreClient store;
    private int numOfPendings = 0;
    private int numOfDone = 0;

    public ImportHandler(Main viewer, FileQueueTable qTable, OMEROMetadataStoreClient store, OMEROWrapper reader, ImportContainer[] importContainer) {
        this.importContainer = importContainer;
        this.db = HistoryDB.getHistoryDB();
        if (runState) {
            log.error((Object)"ImportHandler running twice");
            if (this.runThread != null) {
                log.error((Object)this.runThread);
            }
            throw new RuntimeException("ImportHandler running twice");
        }
        runState = true;
        try {
            this.viewer = viewer;
            this.store = store;
            this.qTable = qTable;
            this.library = new ImportLibrary(store, reader);
            this.library.addObserver(qTable);
            this.library.addObserver(viewer);
            this.runThread = new Thread(){

                public void run() {
                    try {
                        ImportHandler.this.importImages();
                    }
                    catch (Throwable e) {
                        new DebugMessenger(null, "OMERO.importer Error Dialog", (Boolean)true, e);
                    }
                }
            };
            this.runThread.start();
        }
        finally {
            runState = false;
        }
    }

    private void importImages() {
        Date date = null;
        long timestampIn = System.currentTimeMillis();
        date = new Date(timestampIn);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String myDate = formatter.format(date);
        this.viewer.appendToOutputLn("> Starting import at: " + myDate + "\n");
        this.viewer.statusBar.setStatusIcon("gfx/import_icon_16.png", "Now importing.");
        this.qTable.importBtn.setText("Cancel");
        this.qTable.importing = true;
        this.numOfPendings = 0;
        int importKey = 0;
        int importStatus = 0;
        try {
            if (this.db != null) {
                this.db.insertImportHistory(this.store.getExperimenterID(), "pending");
                importKey = this.db.getLastKey();
            }
        }
        catch (SQLException e) {
            log.error((Object)"SQL exception updating history DB.", (Throwable)e);
        }
        int i = 0;
        while (i < this.importContainer.length) {
            if (this.qTable.setProgressPending(i)) {
                ++this.numOfPendings;
                try {
                    if (this.db != null) {
                        this.db.insertFileHistory(importKey, this.store.getExperimenterID(), i, this.importContainer[i].imageName, this.importContainer[i].projectID, this.importContainer[i].getTarget().getId().getValue(), "pending", this.importContainer[i].file);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Generic error while updating progress.", (Throwable)e);
                }
            }
            ++i;
        }
        if (this.db != null) {
            this.db.notifyObservers("QUICKBAR_UPDATE", null);
        }
        this.viewer.statusBar.setProgressMaximum(this.numOfPendings);
        this.numOfDone = 0;
        int j = 0;
        while (j < this.importContainer.length) {
            ImportContainer container = this.importContainer[j];
            if (this.qTable.table.getValueAt(j, 2).equals("pending") && !this.qTable.cancel) {
                ++this.numOfDone;
                String filename = container.file.getAbsolutePath();
                this.viewer.appendToOutputLn("> [" + j + "] Importing \"" + filename + "\"");
                IObject target = container.getTarget();
                this.library.setTarget(target);
                try {
                    this.library.importImage(this.importContainer[j].file, j, this.numOfDone, this.numOfPendings, container.imageName, null, container.archive, container.userPixels);
                    this.store.createRoot();
                    try {
                        if (this.db != null) {
                            this.db.updateFileStatus(importKey, j, "done");
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)"SQL exception updating history DB.", (Throwable)e);
                    }
                }
                catch (FormatException fe) {
                    System.err.println(fe.getMessage());
                    log.error((Object)"Format exception while importing image.", (Throwable)fe);
                    this.qTable.setProgressUnknown(j);
                    this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                    importStatus = importStatus < 0 ? -3 : -1;
                    if (fe.getMessage() == "Cannot locate JPEG decoder") {
                        this.qTable.setProgressFailed(j);
                        this.viewer.appendToOutputLn("> [" + j + "] Lossless JPEG not supported.");
                        JOptionPane.showMessageDialog(this.viewer, "\nThe importer cannot import the lossless JPEG images used by the file\n" + this.importContainer[j].imageName);
                    }
                    try {
                        if (this.db != null) {
                            this.db.updateImportStatus(importKey, "incomplete");
                            this.db.updateFileStatus(importKey, j, "failed");
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)"SQL exception updating history DB.", (Throwable)e);
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)"I/O error while importing image.", (Throwable)ioe);
                    this.qTable.setProgressUnknown(j);
                    this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                    importStatus = importStatus < 0 ? -3 : -1;
                    JOptionPane.showMessageDialog(this.viewer, "\nThe importer has encountered an error while attempting\nto read data from the hard drive. This could indicate a\nproblem with a remote drive being inaccessable.\n\n The file in question is: \n" + this.importContainer[j].imageName);
                    try {
                        if (this.db != null) {
                            this.db.updateImportStatus(importKey, "incomplete");
                            this.db.updateFileStatus(importKey, j, "failed");
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)"SQL exception updating history DB.", (Throwable)e);
                    }
                }
                catch (ResourceError e) {
                    log.error((Object)"Resource error while importing image.", (Throwable)e);
                    JOptionPane.showMessageDialog(this.viewer, "The server is out of space and imports cannot continue.\n");
                    this.qTable.setProgressFailed(j);
                    importStatus = importStatus < 0 ? -3 : -2;
                    this.qTable.cancel = true;
                    this.qTable.abort = true;
                    this.qTable.importing = false;
                    try {
                        if (this.db != null) {
                            this.db.updateImportStatus(importKey, "incomplete");
                            this.db.updateFileStatus(importKey, j, "failed");
                        }
                    }
                    catch (SQLException sqle) {
                        log.error((Object)"SQL exception updating history DB.", (Throwable)sqle);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Generic error while importing image.", (Throwable)e);
                    this.qTable.setProgressFailed(j);
                    this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                    new DebugMessenger(null, "OMERO.importer Error Dialog", (Boolean)true, e);
                    importStatus = importStatus < 0 ? -3 : -2;
                    try {
                        if (this.db != null) {
                            this.db.updateImportStatus(importKey, "incomplete");
                            this.db.updateFileStatus(importKey, j, "failed");
                        }
                    }
                    catch (SQLException sqle) {
                        log.error((Object)"SQL exception updating history DB.", (Throwable)sqle);
                    }
                }
            }
            ++j;
        }
        this.qTable.importBtn.setText("Import");
        this.qTable.importBtn.setEnabled(true);
        this.qTable.queue.setRowSelectionAllowed(true);
        this.qTable.removeBtn.setEnabled(true);
        if (this.qTable.failedFiles) {
            this.qTable.clearFailedBtn.setEnabled(true);
        }
        if (this.qTable.doneFiles) {
            this.qTable.clearDoneBtn.setEnabled(true);
        }
        this.qTable.importing = false;
        this.qTable.cancel = false;
        this.qTable.abort = false;
        this.viewer.statusBar.setProgress(false, 0, "");
        this.viewer.statusBar.setStatusIcon("gfx/import_done_16.png", "Import complete.");
        if (importStatus >= 0) {
            try {
                if (this.db != null) {
                    this.db.updateImportStatus(importKey, "complete");
                }
            }
            catch (SQLException e) {
                log.error((Object)"SQL exception when updating import status.", (Throwable)e);
            }
        }
        long timestampOut = System.currentTimeMillis();
        long timestampDiff = timestampOut - timestampIn;
        long timeInSeconds = timestampDiff / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        this.viewer.appendToOutputLn("> Total import time: " + hours + " hour(s), " + minutes + " minute(s), " + seconds + " second(s).");
        this.viewer.appendToOutputLn("> Image import completed!");
    }

    private <T extends IObject> T instantiateTarget(Class<T> klass, long id) {
        InstanceProvider provider = this.store.getInstanceProvider();
        T o = provider.getInstance(klass);
        o.setId(rtypes.rlong((long)id));
        o.unload();
        return o;
    }
}

