/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.FileQueueChooser;
import ome.formats.importer.FileQueueTable;
import ome.formats.importer.HistoryTable;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportDialog;
import ome.formats.importer.ImportHandler;
import ome.formats.importer.Main;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.SPWDialog;
import omero.model.Dataset;
import omero.model.IObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileQueueHandler
extends JPanel
implements ActionListener,
PropertyChangeListener,
IObserver {
    private Log log = LogFactory.getLog(FileQueueHandler.class);
    private Preferences userPrefs = Preferences.userNodeForPackage(Main.class);
    private String savedDirectory = this.userPrefs.get("savedDirectory", "");
    public ImportHandler importHandler;
    private OMEROMetadataStoreClient store;
    private OMEROWrapper reader;
    private Main viewer;
    FileQueueChooser fileChooser = null;
    public FileQueueTable qTable = null;
    private HistoryTable historyTable = null;
    File[] files = null;
    File file = null;
    int[] rows = null;

    FileQueueHandler(Main viewer) {
        this.viewer = viewer;
        this.reader = new OMEROWrapper();
        this.setLayout(new BorderLayout());
        this.fileChooser = new FileQueueChooser(this.reader);
        this.fileChooser.addActionListener(this);
        this.fileChooser.addPropertyChangeListener(this);
        this.qTable = new FileQueueTable();
        this.qTable.addPropertyChangeListener(this);
        this.historyTable = HistoryTable.getHistoryTable();
        if (this.historyTable != null) {
            this.historyTable.addObserver(this);
            this.addPropertyChangeListener(this.historyTable);
        }
        JSplitPane splitPane = new JSplitPane(1, this.fileChooser, this.qTable);
        splitPane.setResizeWeight(0.1);
        this.add((Component)splitPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ApproveSelection")) {
            this.file = this.fileChooser.getSelectedFile();
            this.store = this.viewer.loginHandler.getMetadataStore();
            if (this.store != null && this.reader.isSPWReader(this.files[0].getAbsolutePath())) {
                SPWDialog dialog = new SPWDialog(this.viewer, "Screen Import", true, this.store);
                if (dialog.cancelled || dialog.screen == null) {
                    return;
                }
                File[] fileArray = this.files;
                int n = this.files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.addFileToQueue(f, (IObject)dialog.screen, null, dialog.screen.getName().getValue(), false, 0, dialog.archiveImage.isSelected(), null, null);
                    ++n2;
                }
                this.qTable.centerOnRow(this.qTable.queue.getRowCount() - 1);
            } else if (this.store != null) {
                ImportDialog dialog = new ImportDialog(this.viewer, "Import", true, this.store);
                if (dialog.cancelled || dialog.dataset == null) {
                    return;
                }
                Double[] pixelSizes = new Double[]{dialog.pixelSizeX, dialog.pixelSizeY, dialog.pixelSizeZ};
                this.addFileToQueue(this.file, (IObject)dialog.dataset, dialog.dataset.getName().getValue(), dialog.project.getName().getValue(), dialog.useFullPath, dialog.numOfDirectories, dialog.archiveImage.isSelected(), dialog.project.getId().getValue(), pixelSizes);
            } else {
                JOptionPane.showMessageDialog(this.viewer, "Due to an error the application is unable to \nretrieve an OMEROMetadataStore and cannot continue.The most likely cause for this error is that youare not logged in. Please try to login again.");
            }
        }
    }

    private void mustSelectFile() {
        JOptionPane.showMessageDialog(this.viewer, "You must select at least one importable file to\nadd to the import queue. Choose an image in the\nleft-hand panel first before continuing.");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void propertyChange(PropertyChangeEvent e) {
        block32: {
            prop = e.getPropertyName();
            if (prop.equals("add")) {
                if (this.fileChooser.getSelectedFile() == null) {
                    this.mustSelectFile();
                    return;
                }
                var6_3 = this.files = this.fileChooser.getSelectedFiles();
                var5_6 = this.files.length;
                var4_8 = 0;
                while (var4_8 < var5_6) {
                    f = var6_3[var4_8];
                    if (!f.isFile()) {
                        this.mustSelectFile();
                        return;
                    }
                    ++var4_8;
                }
                this.store = this.viewer.loginHandler.getMetadataStore();
                if (this.store != null && this.reader.isSPWReader(this.files[0].getAbsolutePath())) {
                    dialog /* !! */  = new SPWDialog(this.viewer, "Screen Import", true, this.store);
                    if (dialog /* !! */ .cancelled || dialog /* !! */ .screen == null) {
                        return;
                    }
                    var7_18 = this.files;
                    var6_4 = this.files.length;
                    var5_6 = 0;
                    while (var5_6 < var6_4) {
                        f = var7_18[var5_6];
                        this.addFileToQueue(f, (IObject)dialog /* !! */ .screen, null, dialog /* !! */ .screen.getName().getValue(), false, 0, dialog /* !! */ .archiveImage.isSelected(), null, null);
                        ++var5_6;
                    }
                    this.qTable.centerOnRow(this.qTable.queue.getRowCount() - 1);
                } else if (this.store != null) {
                    dialog /* !! */  = new ImportDialog(this.viewer, "Image Import", true, this.store);
                    if (dialog /* !! */ .cancelled || dialog /* !! */ .dataset == null) {
                        return;
                    }
                    pixelSizes = new Double[]{dialog /* !! */ .pixelSizeX, dialog /* !! */ .pixelSizeY, dialog /* !! */ .pixelSizeZ};
                    System.err.println(dialog /* !! */ .pixelSizeX);
                    var8_20 = this.files;
                    var7_19 = this.files.length;
                    var6_5 = 0;
                    while (var6_5 < var7_19) {
                        f = var8_20[var6_5];
                        if (f.isFile()) {
                            this.addFileToQueue(f, (IObject)dialog /* !! */ .dataset, dialog /* !! */ .dataset.getName().getValue(), dialog /* !! */ .project.getName().getValue(), dialog /* !! */ .useFullPath, dialog /* !! */ .numOfDirectories, dialog /* !! */ .archiveImage.isSelected(), dialog /* !! */ .project.getId().getValue(), pixelSizes);
                        }
                        ++var6_5;
                    }
                    this.qTable.centerOnRow(this.qTable.queue.getRowCount() - 1);
                } else {
                    JOptionPane.showMessageDialog(this.viewer, "Due to an error the application is unable to \nretrieve an OMEROMetadataStore and cannot continue.The most likely cause for this error is that youare not logged in. Please try to login again.");
                }
            }
            if (!prop.equals("remove")) break block32;
            this.rows = this.qTable.queue.getSelectedRows();
            if (this.rows.length != 0) ** GOTO lbl57
            JOptionPane.showMessageDialog(this.viewer, "You must select at least one file in the queue to\nremove. Choose an image in the right-hand panel \nfirst before removing.");
            return;
lbl-1000:
            // 1 sources

            {
                if (this.qTable.queue.getValueAt(this.rows[0], 2) != "added" && this.qTable.queue.getValueAt(this.rows[0], 2) != "pending") continue;
                this.removeFileFromQueue(this.rows[0]);
                this.rows = this.qTable.queue.getSelectedRows();
lbl57:
                // 3 sources

                ** while (this.rows.length > 0)
            }
        }
        if (prop.equals("clear_done")) {
            numRows = this.qTable.queue.getRowCount();
            i = numRows - 1;
            while (i >= 0) {
                if (this.qTable.queue.getValueAt(i, 2) == "done") {
                    this.removeFileFromQueue(i);
                }
                --i;
            }
            this.qTable.clearDoneBtn.setEnabled(false);
        }
        if (prop.equals("clear_failed")) {
            numRows = this.qTable.queue.getRowCount();
            i = numRows - 1;
            while (i >= 0) {
                if (this.qTable.queue.getValueAt(i, 2) == "failed") {
                    this.removeFileFromQueue(i);
                }
                --i;
            }
            this.qTable.clearFailedBtn.setEnabled(false);
        }
        if (prop.equals("import")) {
            if (!this.viewer.loggedIn.booleanValue()) {
                JOptionPane.showMessageDialog(this.viewer, "You must be logged in before you can import.");
                return;
            }
            this.qTable.clearDoneBtn.setEnabled(false);
            this.qTable.clearFailedBtn.setEnabled(false);
            try {
                if (!this.qTable.importing) {
                    fads = this.qTable.getFilesAndObjectTypes();
                    if (fads != null) {
                        this.store = this.viewer.loginHandler.getMetadataStore();
                        if (this.store != null) {
                            this.importHandler = new ImportHandler(this.viewer, this.qTable, this.store, this.reader, fads);
                        }
                    }
                    this.qTable.importing = true;
                    this.qTable.queue.setRowSelectionAllowed(false);
                    this.qTable.removeBtn.setEnabled(false);
                } else {
                    this.qTable.importBtn.setText("Wait...");
                    this.qTable.importBtn.setEnabled(false);
                    this.viewer.statusBar.setStatusIcon("gfx/import_cancelling_16.png", "Cancelling import... please wait.");
                    if (this.cancelImportDialog(this.viewer)) {
                        this.qTable.cancel = true;
                        this.qTable.abort = true;
                        this.qTable.importing = false;
                    } else {
                        this.qTable.cancel = true;
                        this.qTable.importing = false;
                    }
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Generic error while updating GUI for import.", (Throwable)ex);
                return;
            }
        }
        if (prop.equals("directoryChanged")) {
            this.savedDirectory = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            this.userPrefs.put("savedDirectory", this.savedDirectory);
        }
        if (prop.equals("refresh")) {
            this.fileChooser.setVisible(false);
            this.fileChooser.rescanCurrentDirectory();
            this.fileChooser.setVisible(true);
        }
    }

    private boolean cancelImportDialog(Component frame) {
        String s1 = "OK";
        String s2 = "Force Quit Now";
        Object[] options = new Object[]{s1, s2};
        int n = JOptionPane.showOptionDialog(frame, "Click 'OK' to cancel after the current file has\nfinished importing, or click 'Force Quit Now' to\nforce the importer to quit importing immediately.\n\nYou should only force quit the importer if there\nhas been an import problem, as this leaves partial\nfiles in your server dataset.\n\n", "Cancel Import", 0, 3, null, options, s1);
        return n == 1;
    }

    private void addFileToQueue(File file, IObject object, String dName, String project, Boolean useFullPath, int numOfDirectories, boolean archiveImage, Long projectID, Double[] pixelSizes) {
        Vector<Object> row = new Vector<Object>();
        String imageName = this.getImageName(file, useFullPath, numOfDirectories);
        String pdsString = null;
        pdsString = dName != null ? String.valueOf(project) + "/" + dName : project;
        row.add(imageName);
        row.add(pdsString);
        row.add("added");
        row.add(object);
        row.add(file);
        row.add(archiveImage);
        row.add(projectID);
        row.add(pixelSizes);
        this.qTable.table.addRow(row);
        if (this.qTable.table.getRowCount() == 1) {
            this.qTable.importBtn.setEnabled(true);
        }
    }

    private String getImageName(File file, Boolean useFullPath, int numOfDirectories) {
        String path = file.getAbsolutePath().replace('\\', '/');
        if (useFullPath.booleanValue()) {
            return path;
        }
        if (numOfDirectories == 0) {
            return file.getName();
        }
        String[] directories = this.splitDirectories(path);
        if (numOfDirectories > directories.length - 1) {
            numOfDirectories = directories.length - 1;
        }
        int start = directories.length - numOfDirectories - 1;
        String fileName = "";
        int i = start;
        while (i < directories.length - 1) {
            if (directories[i].length() != 0) {
                fileName = i == start ? directories[i] : String.valueOf(fileName) + "/" + directories[i];
            }
            ++i;
        }
        fileName = String.valueOf(fileName) + "/" + file.getName();
        return fileName;
    }

    private String[] splitDirectories(String path) {
        String[] fields = path.split("/");
        Integer length = fields.length;
        return fields;
    }

    private void removeFileFromQueue(int row) {
        this.qTable.table.removeRow(row);
        if (this.qTable.table.getRowCount() == 0) {
            this.qTable.importBtn.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        FileQueueHandler fqh = new FileQueueHandler(null);
        JFrame f = new JFrame();
        f.getContentPane().add(fqh);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }

    public void update(IObservable observable, Object message, Object[] args) {
        if (message == "REIMPORT") {
            this.store = this.viewer.loginHandler.getMetadataStore();
            String datasetName = "";
            String projectName = "";
            String fileName = "";
            Long datasetID = 0L;
            Long projectID = 0L;
            File file = null;
            Integer finalCount = 0;
            int count = 0;
            if (this.historyTable != null) {
                count = this.historyTable.table.getRowCount();
            }
            int r = 0;
            while (r < count) {
                block13: {
                    Vector<Object> row = new Vector<Object>();
                    datasetID = (Long)this.historyTable.table.getValueAt(r, 5);
                    projectID = (Long)this.historyTable.table.getValueAt(r, 6);
                    fileName = (String)this.historyTable.table.getValueAt(r, 0);
                    file = new File((String)this.historyTable.table.getValueAt(r, 4));
                    Dataset d = null;
                    try {
                        d = this.store.getTarget(Dataset.class, datasetID);
                        datasetName = d.getName().getValue();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to retrieve dataset: " + datasetID), (Throwable)e);
                        break block13;
                    }
                    try {
                        projectName = this.store.getProject(projectID).getName().getValue();
                    }
                    catch (Exception e) {
                        this.log.warn((Object)("Failed to retrieve project: " + projectID), (Throwable)e);
                        break block13;
                    }
                    finalCount = finalCount + 1;
                    row.add(fileName);
                    row.add(String.valueOf(projectName) + "/" + datasetName);
                    row.add("added");
                    row.add(d.getId().getValue());
                    row.add(file);
                    row.add(false);
                    row.add(projectID);
                    this.qTable.table.addRow(row);
                }
                ++r;
            }
            if (finalCount == 0) {
                JOptionPane.showMessageDialog(this.viewer, "None of the images in this history\nlist can be reimported.");
            } else if (finalCount == 1) {
                JOptionPane.showMessageDialog(this.viewer, "One of the images in this history list has been\nre-added to the import queue for reimport.");
            } else if (finalCount > 1) {
                JOptionPane.showMessageDialog(this.viewer, finalCount + " images in this history list have been re-added\n" + "to the import queue for reimport.");
            }
            if (this.qTable.table.getRowCount() > 0) {
                this.qTable.importBtn.setEnabled(true);
            }
        }
    }
}

