/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportDialog;
import ome.formats.importer.util.GuiCommonElements;
import omero.model.Screen;

public class AddScreenDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private Preferences userPrefs = Preferences.userNodeForPackage(ImportDialog.class);
    GuiCommonElements gui;
    Window owner;
    JPanel mainPanel;
    JPanel internalPanel;
    JButton OKBtn;
    JButton cancelBtn;
    JTextField nameField;
    JTextArea descriptionArea;
    String screenName;
    String screenDescription;
    Screen screen;
    OMEROMetadataStoreClient store;

    AddScreenDialog(Window owner, String title, Boolean modal, OMEROMetadataStoreClient store) {
        this.store = store;
        this.owner = owner;
        this.gui = new GuiCommonElements();
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(480, 300));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = this.gui.addButton(this.mainPanel, "Cancel", 67, "Cancel adding a screen", "1, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.OKBtn = this.gui.addButton(this.mainPanel, "OK", 79, "Accept your new screen", "3, 1, f, c", this.debug);
        this.OKBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.OKBtn);
        this.gui.enterPressesWhenFocused(this.OKBtn);
        double[][] internalTable = new double[][]{{160.0, -1.0}, {30.0, 30.0, -1.0}};
        this.internalPanel = this.gui.addMainPanel(this, internalTable, 10, 10, 10, 10, this.debug);
        String message = "Please enter your screen name and an optional description below.";
        JTextPane instructions = this.gui.addTextPane(this.internalPanel, message, "0,0,1,0", this.debug);
        this.nameField = this.gui.addTextField(this.internalPanel, "Screen Name: ", "", 69, "Input your screen name here.", "", -2.0, "0, 1, 1, 1", this.debug);
        this.descriptionArea = this.gui.addTextArea(this.internalPanel, "Description: (optional)", "", 87, "0, 2, 1, 2", this.debug);
        this.mainPanel.add((Component)this.internalPanel, "0, 0, 4, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.OKBtn) {
            this.screenName = this.nameField.getText();
            this.screenDescription = this.descriptionArea.getText();
            if (this.screenName.trim().length() > 0) {
                this.screen = this.store.addScreen(this.screenName, this.screenDescription);
                this.userPrefs.putLong("savedScreen", this.screen.getId().getValue());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.owner, "The screen's name can not be blank.");
            }
        }
        if (source == this.cancelBtn) {
            this.dispose();
        }
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        new AddScreenDialog(null, "Add a Screen", (Boolean)true, null);
    }
}

