/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.enums;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.formats.enums.EnumerationException;
import ome.formats.enums.EnumerationProvider;
import ome.formats.enums.handler.EnumHandlerFactory;
import ome.formats.enums.handler.EnumerationHandler;
import omero.RLong;
import omero.RString;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.model.IObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IQueryEnumProvider
implements EnumerationProvider {
    private static Log log = LogFactory.getLog(IQueryEnumProvider.class);
    private Map<Class<? extends IObject>, HashMap<String, IObject>> enumCache = new HashMap<Class<? extends IObject>, HashMap<String, IObject>>();
    private IQueryPrx iQuery;
    private EnumHandlerFactory enumHandlerFactory = new EnumHandlerFactory();

    public IQueryEnumProvider(IQueryPrx iQuery) {
        this.iQuery = iQuery;
    }

    private IObject copyEnumeration(IObject enumeration) {
        Class<?> klass = enumeration.getClass();
        try {
            Constructor<?> constructor = klass.getDeclaredConstructor(RLong.class, Boolean.TYPE);
            return (IObject)constructor.newInstance(enumeration.getId(), false);
        }
        catch (Exception e) {
            String m = "Unable to copy enumeration: " + enumeration;
            log.error((Object)m, (Throwable)e);
            throw new EnumerationException(m, klass, this.getValue(enumeration));
        }
    }

    private String getValue(IObject enumeration) {
        Class<?> klass = enumeration.getClass();
        try {
            Method method = klass.getMethod("getValue", new Class[0]);
            RString value = (RString)method.invoke((Object)enumeration, new Object[0]);
            return value.getValue();
        }
        catch (Exception e) {
            String m = "Unable to get value of enumeration: " + enumeration;
            log.error((Object)m, (Throwable)e);
            throw new EnumerationException(m, klass, "");
        }
    }

    @Override
    public <T extends IObject> T getEnumeration(Class<T> klass, String value, boolean loaded) {
        if (klass == null) {
            throw new NullPointerException("Expecting not-null klass.");
        }
        if (value == null) {
            log.warn((Object)("Enumeration " + klass + " with value of null."));
        } else if (value.length() == 0) {
            log.warn((Object)("Enumeration " + klass + " with value of zero length."));
        }
        HashMap<String, IObject> enumerations = this.getEnumerations(klass);
        EnumerationHandler handler = this.enumHandlerFactory.getHandler(klass);
        IObject otherEnumeration = (IObject)enumerations.get("Other");
        if (enumerations.containsKey(value)) {
            if (!loaded) {
                return (T)this.copyEnumeration(enumerations.get(value));
            }
            return (T)enumerations.get(value);
        }
        IObject enumeration = handler.findEnumeration(enumerations, value);
        if (enumeration != null) {
            if (!loaded) {
                return (T)this.copyEnumeration(enumeration);
            }
            return (T)enumeration;
        }
        if (otherEnumeration != null) {
            log.warn((Object)("Enumeration '" + value + "' does not exist in '" + klass + "' setting to 'Other'"));
            return (T)otherEnumeration;
        }
        log.warn((Object)("Enumeration '" + value + "' does not exist in '" + klass + "' returning 'null'"));
        return (T)enumeration;
    }

    @Override
    public <T extends IObject> HashMap<String, T> getEnumerations(Class<T> klass) {
        if (!this.enumCache.containsKey(klass)) {
            List enumerationList;
            try {
                enumerationList = this.iQuery.findAll(klass.getName(), null);
            }
            catch (ServerError e) {
                throw new RuntimeException(e);
            }
            if (enumerationList == null) {
                throw new EnumerationException("Problem finding enumeration: ", klass, null);
            }
            HashMap<String, IObject> enumerations = new HashMap<String, IObject>();
            for (IObject enumeration : enumerationList) {
                enumerations.put(this.getValue(enumeration), enumeration);
            }
            this.enumCache.put(klass, enumerations);
        }
        return this.enumCache.get(klass);
    }
}

