/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.panther;

import ch.randelshofer.quaqua.JBrowser;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.filechooser.AliasFileSystemTreeModel;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.FileRenderer;
import ch.randelshofer.quaqua.filechooser.FileTransferHandler;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.filechooser.SubtreeTreeModel;
import ch.randelshofer.quaqua.panther.filechooser.FilePreview;
import ch.randelshofer.quaqua.panther.filechooser.SidebarListModel;
import ch.randelshofer.quaqua.util.ResourceBundleUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuaquaPantherFileChooserUI
extends BasicFileChooserUI {
    private static Log log = LogFactory.getLog(QuaquaPantherFileChooserUI.class);
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FileView fileView;
    private FilterComboBoxModel filterComboBoxModel;
    private AliasFileSystemTreeModel model = null;
    private SubtreeTreeModel subtreeModel = null;
    private static int PREF_WIDTH = 518;
    private static int PREF_HEIGHT = 378;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 518;
    private static int MIN_HEIGHT = 378;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderText = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    protected String chooseButtonText = null;
    private String newFolderDialogPrompt;
    private String newFolderDefaultName;
    private String newFolderErrorText;
    private String newFolderExistsErrorText;
    private String newFolderTitleText;
    private static final File computer = AliasFileSystemTreeModel.COMPUTER;
    private SidebarListModel sidebarListModel;
    private AncestorListener ancestorListener;
    private FileTransferHandler fileTransferHandler;
    private Action newFolderAction = new NewFolderAction();
    private Action approveSelectionAction = new QuaquaApproveSelectionAction();
    private int isAdjusting = 0;
    private JPanel accessoryPanel;
    private JButton approveButton;
    private JBrowser browser;
    private JScrollPane browserScrollPane;
    private JToggleButton browserToggleButton;
    private JPanel cancelOpenPanel;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel controlsPanel;
    private JComboBox directoryComboBox;
    private JLabel fileNameLabel;
    private JPanel fileNamePanel;
    private JPanel fileNameSpringPanel;
    private JTextField fileNameTextField;
    private JLabel filesOfTypeLabel;
    private JComboBox filterComboBox;
    private JPanel formatPanel;
    private JPanel formatSpringPanel;
    private JPanel mainPanel;
    private JPanel navigationButtonsPanel;
    private JPanel navigationPanel;
    private JPanel navigationSpringPanel;
    private JButton newFolderButton;
    private JButton nextButton;
    private JButton previousButton;
    private JSeparator separator;
    private JSplitPane splitPane;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JToggleButton tableToggleButton;
    private ButtonGroup viewGroup;
    private JPanel viewsPanel;
    private JList sidebarList;
    private JScrollPane sidebarScrollPane;
    static final int space = 10;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaPantherFileChooserUI((JFileChooser)c);
    }

    public QuaquaPantherFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        this.sidebarList = new JList(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 10;
                return d;
            }
        };
        this.viewGroup = new ButtonGroup();
        this.fileNamePanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileNameSpringPanel = new JPanel();
        this.separator = new JSeparator();
        this.mainPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.navigationButtonsPanel = new JPanel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.tableToggleButton = new JToggleButton();
        this.browserToggleButton = new JToggleButton();
        this.directoryComboBox = new JComboBox();
        this.navigationSpringPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.sidebarScrollPane = new JScrollPane();
        this.viewsPanel = new JPanel();
        this.browserScrollPane = new JScrollPane();
        this.browser = new JBrowser();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.controlsPanel = new JPanel();
        this.accessoryPanel = new JPanel();
        this.formatPanel = new JPanel();
        this.filesOfTypeLabel = new JLabel();
        this.filterComboBox = new JComboBox();
        this.formatSpringPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.cancelOpenPanel = new JPanel();
        this.newFolderButton = new JButton();
        this.cancelButton = new JButton();
        this.approveButton = new JButton();
        fc.setLayout(new BorderLayout());
        fc.setBorder(new EmptyBorder(new Insets(6, 0, 10, 0)));
        this.fileNamePanel.setLayout(new GridBagLayout());
        this.fileNamePanel.setBorder(new EmptyBorder(new Insets(4, 0, 3, 0)));
        this.fileNameLabel.setHorizontalAlignment(4);
        this.fileNameLabel.setText("Save As:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        this.fileNamePanel.add((Component)this.fileNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileNameSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.fileNamePanel.add((Component)this.fileNameSpringPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.fileNamePanel.add((Component)this.separator, gridBagConstraints);
        fc.add((Component)this.fileNamePanel, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.navigationPanel.setLayout(new GridBagLayout());
        this.navigationPanel.setBorder(new EmptyBorder(new Insets(0, 8, 4, 8)));
        this.navigationButtonsPanel.setLayout(new GridBagLayout());
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/quaqua/panther/images/FileChooser.previousIcon.png")));
        this.navigationButtonsPanel.add((Component)this.previousButton, new GridBagConstraints());
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/quaqua/panther/images/FileChooser.nextIcon.png")));
        this.navigationButtonsPanel.add((Component)this.nextButton, new GridBagConstraints());
        this.tableToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/quaqua/panther/images/FileChooser.tableIcon.png")));
        this.viewGroup.add(this.tableToggleButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.navigationButtonsPanel.add((Component)this.tableToggleButton, gridBagConstraints);
        this.browserToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/quaqua/panther/images/FileChooser.browserIcon.png")));
        this.browserToggleButton.setSelected(true);
        this.viewGroup.add(this.browserToggleButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.navigationButtonsPanel.add((Component)this.browserToggleButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.navigationPanel.add((Component)this.navigationButtonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.navigationPanel.add((Component)this.directoryComboBox, gridBagConstraints);
        this.navigationSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.navigationPanel.add((Component)this.navigationSpringPanel, gridBagConstraints);
        this.mainPanel.add((Component)this.navigationPanel, "North");
        this.splitPane.setBorder(new EmptyBorder(new Insets(0, 8, 0, 8)));
        this.splitPane.setDividerLocation(130);
        this.sidebarScrollPane.setHorizontalScrollBarPolicy(31);
        this.sidebarList.setSelectionMode(0);
        this.sidebarScrollPane.setViewportView(this.sidebarList);
        this.splitPane.setLeftComponent(this.sidebarScrollPane);
        this.viewsPanel.setLayout(new CardLayout());
        this.browserScrollPane.setViewportView((Component)this.browser);
        this.viewsPanel.add((Component)this.browserScrollPane, "browser");
        this.tableScrollPane.setViewportView(this.table);
        this.viewsPanel.add((Component)this.tableScrollPane, "table");
        this.splitPane.setRightComponent(this.viewsPanel);
        this.mainPanel.add((Component)this.splitPane, "Center");
        fc.add((Component)this.mainPanel, "Center");
        this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 1));
        this.accessoryPanel.setLayout(new BorderLayout());
        this.accessoryPanel.setBorder(new EmptyBorder(new Insets(6, 8, 0, 8)));
        this.controlsPanel.add(this.accessoryPanel);
        this.formatPanel.setLayout(new GridBagLayout());
        this.formatPanel.setBorder(new EmptyBorder(new Insets(6, 0, 0, 0)));
        this.filesOfTypeLabel.setHorizontalAlignment(4);
        this.filesOfTypeLabel.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.formatPanel.add((Component)this.filesOfTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 250;
        this.formatPanel.add((Component)this.filterComboBox, gridBagConstraints);
        this.formatSpringPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.formatPanel.add((Component)this.formatSpringPanel, gridBagConstraints);
        this.controlsPanel.add(this.formatPanel);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(6, 20, 0, 20)));
        this.newFolderButton.setText("New Folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.cancelOpenPanel.setLayout(new GridLayout(1, 0, 8, 0));
        this.cancelButton.setText("Cancel");
        this.cancelOpenPanel.add(this.cancelButton);
        this.approveButton.setText("Open");
        this.cancelOpenPanel.add(this.approveButton);
        this.buttonsPanel.add((Component)this.cancelOpenPanel, new GridBagConstraints());
        fc.add((Component)this.controlsPanel, "South");
        int dividerSize = UIManager.getInt("FileChooser.splitPaneDividerSize");
        if (dividerSize != 0) {
            this.splitPane.setDividerSize(dividerSize);
        }
        int h = this.fileNameLabel.getPreferredSize().height;
        this.fileNameLabel.setMinimumSize(new Dimension(0, h));
        this.fileNameLabel.setPreferredSize(new Dimension(0, h));
        this.fileNameLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.fileNameTextField.getPreferredSize().height;
        this.fileNameTextField.setPreferredSize(new Dimension(0, h));
        this.fileNameTextField.setMinimumSize(new Dimension(0, h));
        this.fileNameTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.directoryComboBox.getPreferredSize().height;
        this.directoryComboBox.setPreferredSize(new Dimension(0, h));
        this.directoryComboBox.setMinimumSize(new Dimension(0, h));
        this.directoryComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        Dimension d = new Dimension(28, 25);
        Dimension d2 = new Dimension(29, 25);
        this.previousButton.setPreferredSize(d);
        this.nextButton.setPreferredSize(d2);
        this.tableToggleButton.setPreferredSize(d);
        this.browserToggleButton.setPreferredSize(d2);
        this.previousButton.setMinimumSize(d);
        this.nextButton.setMinimumSize(d2);
        this.tableToggleButton.setMinimumSize(d);
        this.browserToggleButton.setMinimumSize(d2);
        this.previousButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.tableToggleButton.setVisible(false);
        this.browserToggleButton.setVisible(false);
        h = this.navigationButtonsPanel.getPreferredSize().height;
        this.navigationButtonsPanel.setMinimumSize(new Dimension(0, h));
        this.navigationButtonsPanel.setPreferredSize(new Dimension(0, h));
        this.navigationButtonsPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filesOfTypeLabel.getPreferredSize().height;
        this.filesOfTypeLabel.setMinimumSize(new Dimension(0, h));
        this.filesOfTypeLabel.setPreferredSize(new Dimension(0, h));
        this.filesOfTypeLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        h = this.filterComboBox.getPreferredSize().height;
        this.filterComboBox.setPreferredSize(new Dimension(0, h));
        this.filterComboBox.setMinimumSize(new Dimension(0, h));
        this.filterComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, h));
        this.browser.setCellRenderer((ListCellRenderer)new FileRenderer(fc, UIManager.getIcon("Browser.expandingIcon"), UIManager.getIcon("Browser.expandedIcon"), UIManager.getIcon("Browser.selectedExpandingIcon"), UIManager.getIcon("Browser.selectedExpandedIcon")));
        if (fc.isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
        }
        this.browser.setModel((TreeModel)this.getTreeModel());
        this.browser.setPrototypeCellValue((Object)this.getFileSystemTreeModel().getPrototypeValue());
        this.browser.addTreeSelectionListener(this.createBrowserSelectionListener(fc));
        this.browser.addMouseListener(this.createDoubleClickListener(fc));
        this.browser.setFixedCellWidth(170);
        this.browserScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.browserScrollPane.setHorizontalScrollBarPolicy(32);
        this.browser.setShowCellTipOrigin((Point)UIManager.get("FileChooser.cellTipOrigin"));
        this.browser.setShowCellTips(true);
        this.sidebarScrollPane.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 2, 3, 2));
        this.formatPanel.setVisible(fc.getChoosableFileFilters().length > 1);
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        } else {
            this.accessoryPanel.setVisible(false);
        }
        this.separator.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, 0, 3, 0));
        this.newFolderButton.setText(this.newFolderText);
        this.newFolderButton.setToolTipText(this.newFolderToolTipText);
        this.fileNameLabel.setText(this.fileNameLabelText);
        this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        if (!fc.getControlButtonsAreShown()) {
            this.cancelButton.setVisible(false);
            this.approveButton.setVisible(false);
        }
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.sidebarListModel = new SidebarListModel(fc, new TreePath(this.getFileSystemTreeModel().getRoot()), (TreeModel)this.getFileSystemTreeModel());
        this.sidebarList.setModel(this.sidebarListModel);
        this.sidebarList.setCellRenderer(this.createVolumesRenderer(fc));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.fileNameTextField.addFocusListener(new SaveTextFocusListener());
        this.fileNameTextField.getDocument().addDocumentListener(new SaveTextDocumentListener());
        this.fileNameTextField.addActionListener(this.getApproveSelectionAction());
        this.sidebarList.addListSelectionListener(this.createVolumesSelectionListener(fc));
        this.fileTransferHandler = new FileTransferHandler(fc);
        Component[] dropComponents = new Component[]{fc, this.accessoryPanel, this.approveButton, this.browser, this.browserScrollPane, this.browserToggleButton, this.buttonsPanel, this.cancelButton, this.controlsPanel, this.directoryComboBox, this.fileNameLabel, this.fileNamePanel, this.fileNameSpringPanel, this.fileNameTextField, this.filesOfTypeLabel, this.filterComboBox, this.formatPanel, this.formatSpringPanel, this.mainPanel, this.navigationButtonsPanel, this.navigationPanel, this.navigationSpringPanel, this.newFolderButton, this.nextButton, this.previousButton, this.separator, this.splitPane, this.table, this.tableScrollPane, this.tableToggleButton, this.viewsPanel, this.sidebarList, this.sidebarScrollPane};
        int i = 0;
        while (i < dropComponents.length) {
            new DropTarget(dropComponents[i], 1, (DropTargetListener)this.fileTransferHandler);
            ++i;
        }
        boolean isSave = fc.getDialogType() == 1 || fc.getDialogType() == 2;
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        ResourceBundleUtil bundle = (ResourceBundleUtil)UIManager.get("Labels");
        boolean isLocalized = bundle.getLocale().getLanguage().equals(this.getLocale().getLanguage());
        this.browser.setPreviewRenderer(isSave || !isLocalized ? null : new FilePreview(fc));
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.ancestorListener = this.createAncestorListener(fc);
        if (this.ancestorListener != null) {
            fc.addAncestorListener(this.ancestorListener);
        }
        fc.addPropertyChangeListener(this.filterComboBoxModel);
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.ancestorListener != null) {
            fc.removeAncestorListener(this.ancestorListener);
        }
        fc.removePropertyChangeListener(this.filterComboBoxModel);
    }

    private Locale getLocale() {
        try {
            return this.getFileChooser().getLocale();
        }
        catch (IllegalComponentStateException e) {
            return Locale.getDefault();
        }
    }

    protected void installStrings(JFileChooser fc) {
        Locale l;
        super.installStrings(fc);
        try {
            l = this.getLocale();
        }
        catch (IllegalComponentStateException e) {
            l = Locale.getDefault();
        }
        this.chooseButtonText = UIManager.getString("FileChooser.chooseButtonText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = UIManager.getString("FileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = UIManager.getString("FileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.newFolderErrorText = this.getString("FileChooser.newFolderErrorText", l, "Error occured during folder creation");
        this.newFolderExistsErrorText = this.getString("FileChooser.newFolderExistsErrorText", l, "That name is already taken");
        this.newFolderText = this.getString("FileChooser.newFolderTitleText", l, "New Folder");
        this.newFolderTitleText = this.getString("FileChooser.newFolderTitleText", l, "New Folder");
        this.newFolderDialogPrompt = this.getString("FileChooser.newFolderPromptText", l, "Name of new folder:");
        this.newFolderDefaultName = this.getString("FileChooser.untitledFolderName", l, "untitled folder");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = this.getString("FileChooser.newFolderAccessibleName", l, this.newFolderTitleText);
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    private String getString(String string, Locale l, String defaultValue) {
        String value = UIManager.getString(string);
        return value == null ? defaultValue : value;
    }

    protected AncestorListener createAncestorListener(JFileChooser fc) {
        return new FileChooserAncestorListener();
    }

    public void createModel() {
        JFileChooser fc = this.getFileChooser();
        this.model = new AliasFileSystemTreeModel(fc);
        this.subtreeModel = new SubtreeTreeModel((TreeModel)this.model);
        this.fileView = QuaquaManager.getBoolean((String)"FileChooser.speed") ? new BasicFileChooserUI.BasicFileView(this) : QuaquaFileSystemView.getQuaquaFileSystemView().createFileView(fc);
        fc.setFileView(this.fileView);
        fc.setFileSystemView((FileSystemView)QuaquaFileSystemView.getQuaquaFileSystemView());
    }

    public SubtreeTreeModel getTreeModel() {
        return this.subtreeModel;
    }

    public AliasFileSystemTreeModel getFileSystemTreeModel() {
        return this.model;
    }

    private File[] getSelectedFiles() {
        JFileChooser fc = this.getFileChooser();
        if (fc.isMultiSelectionEnabled()) {
            File[] selectedFiles = fc.getSelectedFiles();
            ArrayList<File> list = new ArrayList<File>(selectedFiles.length);
            int i = 0;
            while (i < selectedFiles.length) {
                if (selectedFiles[i] != null) {
                    if (selectedFiles[i].isAbsolute()) {
                        list.add(selectedFiles[i]);
                    } else {
                        list.add(new File(QuaquaManager.getProperty((String)"user.home"), selectedFiles[i].getName()));
                    }
                }
                ++i;
            }
            return list.toArray(new File[list.size()]);
        }
        File f = fc.getSelectedFile();
        if (f == null) {
            return new File[0];
        }
        if (f.isAbsolute()) {
            return new File[]{f};
        }
        return new File[]{new File(QuaquaManager.getProperty((String)"user.home"), f.getName())};
    }

    private void updateSelection() {
        JFileChooser fc = this.getFileChooser();
        File[] files = this.getSelectedFiles();
        TreePath fullPath = null;
        boolean isAtLeastOneFileSelected = false;
        boolean isAtLeastOneDirSelected = false;
        if (files.length != 0) {
            AliasFileSystemTreeModel.Node node;
            TreePath[] paths = new TreePath[files.length];
            ArrayList<Serializable> list = new ArrayList<Serializable>(paths.length);
            TreePath commonParentPath = null;
            int i = 0;
            while (i < files.length) {
                boolean isDirectory;
                File file = files[i];
                fullPath = this.getFileSystemTreeModel().toPath(file, this.subtreeModel.toFullPath(this.browser.getSelectionPath()));
                AliasFileSystemTreeModel.Node node2 = (AliasFileSystemTreeModel.Node)fullPath.getLastPathComponent();
                boolean bl = isDirectory = !node2.isLeaf();
                if (isDirectory) {
                    isAtLeastOneDirSelected = true;
                } else {
                    isAtLeastOneFileSelected = true;
                }
                if (files.length == 1 || !isDirectory || fc.isDirectorySelectionEnabled()) {
                    TreePath parentPath;
                    TreePath subPath = this.getTreeModel().toSubPath(fullPath);
                    TreePath treePath = parentPath = subPath == null ? null : subPath.getParentPath();
                    if (list.size() == 0) {
                        commonParentPath = parentPath;
                    }
                    if (parentPath == null && commonParentPath == null || parentPath != null && commonParentPath != null && parentPath.equals(commonParentPath)) {
                        list.add(subPath);
                    }
                }
                ++i;
            }
            if (list.size() == 0 && files.length > 0) {
                list.add(fc.getFileSystemView().getParentDirectory(files[0]));
            }
            this.browser.setSelectionPaths(list.toArray(new TreePath[list.size()]));
            if (files.length == 1 && ((node = (AliasFileSystemTreeModel.Node)fullPath.getLastPathComponent()).isLeaf() || !files[0].exists())) {
                this.setFileName(files[0].getName());
            }
        }
        if (fullPath != null && fullPath.getPathCount() > 0) {
            AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)fullPath.getLastPathComponent();
            this.directoryComboBoxModel.setPath(node.isLeaf() ? fullPath.getParentPath() : fullPath);
        }
        boolean isEnabled = false;
        switch (fc.getFileSelectionMode()) {
            case 0: {
                isEnabled = isAtLeastOneFileSelected || this.isFileNameFieldVisible() && this.isFileNameFieldValid();
                break;
            }
            case 1: {
                isEnabled = !isAtLeastOneFileSelected;
                break;
            }
            case 2: {
                isEnabled = true;
            }
        }
        this.setApproveButtonEnabled(isEnabled);
    }

    private boolean isFileNameFieldValid() {
        String string = this.getFileName();
        return string != null && !string.equals("");
    }

    private boolean isFileNameFieldVisible() {
        JFileChooser fc = this.getFileChooser();
        return fc.getDialogType() == 1 || fc.getDialogType() == 2;
    }

    private void updateApproveButtonState() {
        JFileChooser fc = this.getFileChooser();
        if (fc.getControlButtonsAreShown()) {
            File[] files = this.getSelectedFiles();
            boolean isFileSelected = false;
            boolean isDirectorySelected = false;
            int i = 0;
            while (i < files.length) {
                if (files[i].exists()) {
                    if (files[i].isDirectory() && fc.isTraversable(files[i])) {
                        isDirectorySelected = true;
                    } else {
                        isFileSelected = true;
                    }
                }
                ++i;
            }
            boolean isEnabled = false;
            switch (fc.getFileSelectionMode()) {
                case 0: {
                    isEnabled = isFileSelected || this.isFileNameFieldVisible() && this.isFileNameFieldValid();
                    break;
                }
                case 1: {
                    isEnabled = !isFileSelected || files.length == 1 && !files[0].exists();
                    break;
                }
                case 2: {
                    isEnabled = true;
                }
            }
            this.setApproveButtonEnabled(isEnabled);
        }
    }

    private void setApproveButtonEnabled(boolean isEnabled) {
        JFileChooser fc = this.getFileChooser();
        if (fc.getControlButtonsAreShown()) {
            JRootPane rp;
            this.approveButton.setEnabled(isEnabled);
            if (isEnabled && (rp = this.approveButton.getRootPane()) != null) {
                rp.setDefaultButton(this.approveButton);
            }
        }
    }

    private void updateApproveButtonText() {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
    }

    protected TreeSelectionListener createBrowserSelectionListener(JFileChooser fc) {
        return new BrowserSelectionListener();
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(PREF_SIZE);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(MIN_SIZE);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.updateSelection();
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        File[] files = this.getSelectedFiles();
        if (files.length == 0) {
            File dir = (File)e.getNewValue();
            TreePath path = this.model.toPath(dir, this.browser.getSelectionPath());
            this.directoryComboBoxModel.setPath(path);
            this.browser.setSelectionPath(path);
            this.model.lazyInvalidatePath(this.browser.getSelectionPath());
            if (dir != null) {
                this.getNewFolderAction().setEnabled(dir.canWrite());
                this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(dir));
                if (fc.getDialogType() == 0) {
                    this.updateApproveButtonState();
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
        this.model.invalidatePath(this.browser.getSelectionPath());
        if (this.getFileChooser().isShowing()) {
            this.model.validatePath(this.browser.getSelectionPath());
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        this.updateApproveButtonText();
        this.updateApproveButtonState();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.browser.setSelectionMode(4);
        } else {
            this.browser.setSelectionMode(1);
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doChoosableFilterChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        boolean isChooserVisible = ((FileFilter[])e.getNewValue()).length > 1;
        this.formatPanel.setVisible(isChooserVisible);
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
            this.accessoryPanel.setVisible(accessory != null);
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        boolean isSave = this.isFileNameFieldVisible();
        this.fileNameTextField.setEnabled(isSave);
        this.fileNamePanel.setVisible(isSave);
        this.model.setResolveAliasesToFiles(!isSave);
        ResourceBundleUtil bundle = (ResourceBundleUtil)UIManager.get("Labels");
        boolean isLocalized = bundle.getLocale().getLanguage().equals(this.getLocale().getLanguage());
        this.browser.setPreviewRenderer(isSave || !isLocalized ? null : new FilePreview(fc));
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                QuaquaPantherFileChooserUI quaquaPantherFileChooserUI = QuaquaPantherFileChooserUI.this;
                quaquaPantherFileChooserUI.isAdjusting = quaquaPantherFileChooserUI.isAdjusting + 1;
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    QuaquaPantherFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    QuaquaPantherFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    QuaquaPantherFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doMultiSelectionChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ChoosableFileFilterChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doChoosableFilterChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    QuaquaPantherFileChooserUI.this.doControlButtonsChanged(e);
                } else if (!s.equals("componentOrientation") && s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    QuaquaPantherFileChooserUI.this.ensurePathIsVisible(QuaquaPantherFileChooserUI.this.subtreeModel.toFullPath(QuaquaPantherFileChooserUI.this.browser.getSelectionPath()));
                    QuaquaPantherFileChooserUI.this.fileNameTextField.selectAll();
                    QuaquaPantherFileChooserUI.this.fileNameTextField.requestFocus();
                }
                QuaquaPantherFileChooserUI quaquaPantherFileChooserUI2 = QuaquaPantherFileChooserUI.this;
                quaquaPantherFileChooserUI2.isAdjusting = quaquaPantherFileChooserUI2.isAdjusting - 1;
            }
        };
    }

    protected void removeControlButtons() {
        this.cancelButton.setVisible(false);
        this.approveButton.setVisible(false);
    }

    protected void addControlButtons() {
        this.cancelButton.setVisible(true);
        this.approveButton.setVisible(true);
    }

    private void ensurePathIsVisible(TreePath path) {
        if (!this.subtreeModel.isSubPath(path.getPath())) {
            ++this.isAdjusting;
            if (((AliasFileSystemTreeModel.Node)path.getLastPathComponent()).isLeaf()) {
                this.subtreeModel.setPathToRoot(path.getParentPath().getPath());
            } else {
                this.subtreeModel.setPathToRoot(path.getPath());
            }
            --this.isAdjusting;
        }
        this.browser.ensurePathIsVisible(path);
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (!(this.fileNameTextField == null || this.fileNameTextField.hasFocus() || filename != null && this.fileNameTextField.getText().equals(filename))) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected VolumesRenderer createVolumesRenderer(JFileChooser fc) {
        return new VolumesRenderer();
    }

    protected ListSelectionListener createVolumesSelectionListener(JFileChooser fc) {
        return new VolumesSelectionListener();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    private void maybeApproveSelection(boolean allowDirectories) {
        JFileChooser fc = this.getFileChooser();
        File selectedFile = null;
        File[] selectedFiles = null;
        String filename = null;
        if (this.isFileNameFieldVisible() && (filename = this.getFileName()).equals("")) {
            filename = null;
        }
        if (fc.isMultiSelectionEnabled()) {
            TreePath[] selectedPaths = this.browser.getSelectionPaths();
            if (filename != null) {
                selectedFiles = new File[]{new File(((AliasFileSystemTreeModel.Node)selectedPaths[0].getLastPathComponent()).getFile().getParent(), filename)};
            } else {
                selectedFiles = new File[selectedPaths.length];
                int i = 0;
                while (i < selectedPaths.length) {
                    selectedFiles[i] = ((AliasFileSystemTreeModel.Node)selectedPaths[i].getLastPathComponent()).getFile();
                    ++i;
                }
            }
            if (!allowDirectories && selectedFiles.length == 1 && selectedFiles[0].isDirectory()) {
                return;
            }
        } else {
            AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)this.browser.getSelectionPath().getLastPathComponent();
            selectedFile = node.getFile();
            if (filename != null) {
                selectedFile = new File(!node.isLeaf() ? selectedFile : selectedFile.getParentFile(), filename);
            } else if (fc.getFileSelectionMode() == 0 && !node.isLeaf()) {
                return;
            }
        }
        if (selectedFiles != null || selectedFile != null) {
            if (selectedFiles != null) {
                fc.setSelectedFiles(selectedFiles);
            } else if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(new File[]{selectedFile});
            } else {
                fc.setSelectedFile(selectedFile);
            }
            fc.approveSelection();
        } else {
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(null);
            } else {
                fc.setSelectedFile(null);
            }
            fc.cancelSelection();
        }
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        if (f != null) {
            TreePath fullPath = this.getFileSystemTreeModel().toPath(f, this.subtreeModel.toFullPath(this.browser.getSelectionPath()));
            TreePath subPath = this.getTreeModel().toSubPath(fullPath);
            if (subPath == null) {
                ++this.isAdjusting;
                this.getTreeModel().setPathToRoot(new Object[]{fullPath.getPathComponent(0)});
                --this.isAdjusting;
                subPath = fullPath;
            }
            this.ensurePathIsVisible(fullPath);
        }
    }

    public String getApproveButtonText(JFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.isDirectorySelectionEnabled() && this.chooseButtonText != null) {
            return this.chooseButtonText;
        }
        if (fc.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        if (fc.isShowing()) {
            this.model.lazyInvalidatePath(this.browser.getSelectionPath());
            this.model.validatePath(this.browser.getSelectionPath());
        }
    }

    public void clearIconCache() {
        try {
            this.fileView.getClass().getMethod("clearIconCache", new Class[0]).invoke((Object)this.fileView, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected MouseListener createDoubleClickListener(JFileChooser fc) {
        return new DoubleClickListener();
    }

    protected class BrowserSelectionListener
    implements TreeSelectionListener {
        protected BrowserSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (QuaquaPantherFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
            FileSystemView fsv = fc.getFileSystemView();
            TreePath path = QuaquaPantherFileChooserUI.this.browser.getSelectionPath();
            if (path != null) {
                QuaquaPantherFileChooserUI.this.model.lazyInvalidatePath(path);
                QuaquaPantherFileChooserUI.this.model.validatePath(path);
            }
            TreePath[] paths = QuaquaPantherFileChooserUI.this.browser.getSelectionPaths();
            boolean count = false;
            File[] files = new File[paths == null ? 0 : paths.length];
            ArrayList<File> list = new ArrayList<File>(files.length);
            int i = 0;
            while (i < files.length) {
                AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)paths[i].getLastPathComponent();
                File file = node.getFile();
                if (file != null) {
                    boolean isDirectory;
                    boolean bl = isDirectory = !node.isLeaf();
                    if (files.length == 1 || !isDirectory || fc.isDirectorySelectionEnabled()) {
                        list.add(file);
                    }
                }
                ++i;
            }
            if (fc.isMultiSelectionEnabled()) {
                fc.setSelectedFiles(list.toArray(new File[list.size()]));
            } else {
                fc.setSelectedFile(list.size() > 0 ? (File)list.get(0) : null);
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e) {
            if (QuaquaPantherFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
            AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)QuaquaPantherFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (node != null) {
                File file = node.getFile();
                if (fc.isMultiSelectionEnabled()) {
                    fc.setSelectedFiles(new File[]{file});
                } else {
                    fc.setSelectedFile(file);
                }
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        TreePath path;
        AliasFileSystemTreeModel.Node selectedDirectory = null;
        JFileChooser chooser;
        FileSystemView fsv;

        public DirectoryComboBoxModel() {
            this.chooser = QuaquaPantherFileChooserUI.this.getFileChooser();
            this.fsv = this.chooser.getFileSystemView();
        }

        private void setPath(TreePath path) {
            if (this.path != null && this.path.getPathCount() > 0) {
                this.fireIntervalRemoved(this, 0, this.path.getPathCount() - 1);
            }
            this.path = path;
            if (this.path.getPathCount() > 0) {
                this.fireIntervalAdded(this, 0, this.path.getPathCount() - 1);
            }
            this.setSelectedItem(this.path.getLastPathComponent());
        }

        public void setSelectedItem(Object selectedItem) {
            AliasFileSystemTreeModel.Node node;
            this.selectedDirectory = node = (AliasFileSystemTreeModel.Node)selectedItem;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.path == null ? 0 : this.path.getPathCount();
        }

        public Object getElementAt(int index) {
            return this.path.getPathComponent(this.path.getPathCount() - index - 1);
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;
        private Border border;
        private JSeparator separator;

        public DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
            this.border = new EmptyBorder(1, 0, 1, 0);
            this.separator = new JSeparator();
            this.separator.setPreferredSize(new Dimension(9, 9));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                super.getListCellRendererComponent((JList<?>)list, value, index, false, cellHasFocus);
                this.setText((String)value);
                this.setPreferredSize(new Dimension(10, 14));
                return this;
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setPreferredSize(null);
            if (value instanceof File) {
                this.setText(value + " " + index);
                return this;
            }
            AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)value;
            if (node == null) {
                return this.separator;
            }
            this.setText(node.getUserName());
            this.ii.icon = node.getIcon();
            this.ii.depth = 0;
            this.setIcon(this.ii);
            this.setBorder(this.border);
            return this;
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        protected DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && fc.getDialogType() != 1) {
                QuaquaPantherFileChooserUI.this.maybeApproveSelection(false);
            }
        }
    }

    private class FileChooserAncestorListener
    implements AncestorListener {
        private FileChooserAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
            if (QuaquaPantherFileChooserUI.this.model != null) {
                QuaquaPantherFileChooserUI.this.model.setAutoValidate(QuaquaManager.getBoolean((String)"FileChooser.autovalidate"));
                QuaquaPantherFileChooserUI.this.model.validatePath(QuaquaPantherFileChooserUI.this.browser.getSelectionPath());
                if (QuaquaPantherFileChooserUI.this.sidebarListModel != null) {
                    QuaquaPantherFileChooserUI.this.sidebarListModel.lazyValidate();
                }
            }
        }

        public void ancestorRemoved(AncestorEvent event) {
            if (QuaquaPantherFileChooserUI.this.model != null) {
                QuaquaPantherFileChooserUI.this.model.setAutoValidate(false);
                QuaquaPantherFileChooserUI.this.model.stopValidation();
                QuaquaPantherFileChooserUI.this.model.invalidatePath(QuaquaPantherFileChooserUI.this.browser.getSelectionPath());
                QuaquaPantherFileChooserUI.this.clearIconCache();
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = QuaquaPantherFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                QuaquaPantherFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                QuaquaPantherFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = QuaquaPantherFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                int i = 0;
                while (i < this.filters.length) {
                    if (this.filters[i] == currentFilter) {
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    QuaquaPantherFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return QuaquaPantherFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return QuaquaPantherFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                if (c.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(c, g, x + this.depth * 10, y);
                } else {
                    this.icon.paintIcon(c, g, x, y);
                }
            }
        }

        public int getIconWidth() {
            return this.icon == null ? this.depth * 10 : this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        private String showNewFolderDialog() {
            JOptionPane optionPane = new JOptionPane(QuaquaPantherFileChooserUI.this.newFolderDialogPrompt, -1, 2);
            optionPane.setWantsInput(true);
            optionPane.setInitialSelectionValue(QuaquaPantherFileChooserUI.this.newFolderDefaultName);
            JDialog dialog = optionPane.createDialog(QuaquaPantherFileChooserUI.this.getFileChooser(), QuaquaPantherFileChooserUI.this.newFolderTitleText);
            dialog.show();
            dialog.dispose();
            return optionPane.getInputValue() == JOptionPane.UNINITIALIZED_VALUE ? null : (String)optionPane.getInputValue();
        }

        public void actionPerformed(ActionEvent actionevent) {
            JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
            String newFolderName = this.showNewFolderDialog();
            if (newFolderName != null) {
                File newFolder;
                AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)QuaquaPantherFileChooserUI.this.browser.getSelectionPath().getLastPathComponent();
                File currentFile = node.getFile();
                if (node.isLeaf()) {
                    currentFile = currentFile.getParentFile();
                }
                if ((newFolder = new File(currentFile, newFolderName)).exists()) {
                    JOptionPane.showMessageDialog(fc, QuaquaPantherFileChooserUI.this.newFolderExistsErrorText, QuaquaPantherFileChooserUI.this.newFolderTitleText, 0);
                    return;
                }
                try {
                    newFolder.mkdir();
                    fc.rescanCurrentDirectory();
                    fc.setCurrentDirectory(newFolder);
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{newFolder});
                    } else {
                        fc.setSelectedFile(newFolder);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(fc, QuaquaPantherFileChooserUI.this.newFolderErrorText, QuaquaPantherFileChooserUI.this.newFolderTitleText, 0);
                }
            }
        }
    }

    protected class QuaquaApproveSelectionAction
    extends AbstractAction {
        protected QuaquaApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent e) {
            QuaquaPantherFileChooserUI.this.maybeApproveSelection(true);
        }
    }

    protected class SaveTextDocumentListener
    implements DocumentListener {
        protected SaveTextDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        public void removeUpdate(DocumentEvent documentevent) {
            this.textChanged();
        }

        public void changedUpdate(DocumentEvent documentevent) {
        }

        private void textChanged() {
            if (QuaquaPantherFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
                    AliasFileSystemTreeModel.Node node = (AliasFileSystemTreeModel.Node)QuaquaPantherFileChooserUI.this.browser.getSelectionPath().getLastPathComponent();
                    File file = node.getFile();
                    if (QuaquaPantherFileChooserUI.this.fileNameTextField.getText().length() != 0) {
                        if (!node.isLeaf()) {
                            QuaquaPantherFileChooserUI.this.updateApproveButtonState();
                            return;
                        }
                        file = new File(fc.getFileSystemView().getParentDirectory(file), QuaquaPantherFileChooserUI.this.fileNameTextField.getText());
                    }
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{file});
                    } else {
                        fc.setSelectedFile(file);
                    }
                    QuaquaPantherFileChooserUI.this.updateApproveButtonState();
                }
            });
        }
    }

    protected class SaveTextFocusListener
    implements FocusListener {
        protected SaveTextFocusListener() {
        }

        public void focusGained(FocusEvent focusevent) {
            QuaquaPantherFileChooserUI.this.updateApproveButtonState();
        }

        public void focusLost(FocusEvent focusevent) {
        }
    }

    class VolumesRenderer
    extends DefaultListCellRenderer {
        private Border border = new EmptyBorder(1, 3, 2, 0);
        private JComponent separator = new JComponent(){

            public void paintComponent(Graphics g) {
                Dimension s = this.getSize();
                g.setColor(new Color(179, 179, 179));
                g.fillRect(3, s.height / 2, s.width - 6, 2);
            }
        };
        private int backgroundIndex;

        public VolumesRenderer() {
            this.separator.setPreferredSize(new Dimension(9, 9));
        }

        protected void paintBorder(Graphics g) {
        }

        protected void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr;
            int width = this.getWidth();
            int height = this.getHeight();
            switch (this.backgroundIndex) {
                case 0: {
                    this.setOpaque(true);
                    break;
                }
                case 1: {
                    g.setColor(new Color(7, 131, 216));
                    g.fillRect(0, 0, width, 1);
                    g.setPaint(new GradientPaint(0.0f, 1.0f, new Color(62, 155, 228), 0.0f, height - 2, new Color(0, 96, 255)));
                    g.fillRect(0, 1, width, height - 1);
                    this.setOpaque(false);
                    break;
                }
                case 2: {
                    g.setColor(new Color(130, 129, 129));
                    g.fillRect(0, 0, width, 1);
                    g.setPaint(new GradientPaint(0.0f, 1.0f, new Color(151, 151, 151), 0.0f, height - 2, new Color(102, 102, 102)));
                    g.fillRect(0, 1, width, height - 1);
                    this.setOpaque(false);
                }
            }
            g.setColor(this.getForeground());
            super.paintComponent(g);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof File) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            FileInfo info = (FileInfo)value;
            if (info == null) {
                return this.separator;
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(info.getUserName());
            if (isSelected) {
                this.backgroundIndex = QuaquaUtilities.isFocused((Component)list) ? 1 : 2;
                this.setForeground(Color.white);
            } else {
                this.backgroundIndex = 3;
            }
            this.setIcon(info.getIcon());
            this.setBorder(this.border);
            return this;
        }
    }

    private class VolumesSelectionListener
    implements ListSelectionListener {
        private VolumesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (QuaquaPantherFileChooserUI.this.isAdjusting != 0) {
                return;
            }
            if (QuaquaPantherFileChooserUI.this.sidebarList != null) {
                FileInfo info = (FileInfo)QuaquaPantherFileChooserUI.this.sidebarList.getSelectedValue();
                if (info != null) {
                    JFileChooser fc = QuaquaPantherFileChooserUI.this.getFileChooser();
                    QuaquaPantherFileChooserUI quaquaPantherFileChooserUI = QuaquaPantherFileChooserUI.this;
                    quaquaPantherFileChooserUI.isAdjusting = quaquaPantherFileChooserUI.isAdjusting + 1;
                    QuaquaPantherFileChooserUI.this.subtreeModel.setPathToRoot(QuaquaPantherFileChooserUI.this.model.toPath(info.getFile(), new TreePath(QuaquaPantherFileChooserUI.this.subtreeModel.toFullPath(QuaquaPantherFileChooserUI.this.browser.getSelectionPath()).getPath())));
                    QuaquaPantherFileChooserUI quaquaPantherFileChooserUI2 = QuaquaPantherFileChooserUI.this;
                    quaquaPantherFileChooserUI2.isAdjusting = quaquaPantherFileChooserUI2.isAdjusting - 1;
                    if (fc.isMultiSelectionEnabled()) {
                        fc.setSelectedFiles(new File[]{info.getFile()});
                    } else {
                        fc.setSelectedFile(info.getFile());
                    }
                }
                TreePath path = QuaquaPantherFileChooserUI.this.subtreeModel.getPathToRoot();
                QuaquaPantherFileChooserUI.this.getFileSystemTreeModel().lazyInvalidatePath(path);
                QuaquaPantherFileChooserUI.this.getFileSystemTreeModel().validatePath(path);
            }
        }
    }
}

