/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.ExperimenterAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.model.meta.GroupExperimenterMap;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="experimenter", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_experimenter", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_experimenter"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Experimenter
implements Serializable,
IObject,
IGlobal,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.Experimenter_id";
    protected Long id;
    public static final String VERSION = "ome.model.meta.Experimenter_version";
    protected Integer version = 0;
    protected List<GroupExperimenterMap> groupExperimenterMap = new ArrayList<GroupExperimenterMap>();
    private Map<Long, Long> groupExperimenterMapCountPerOwner = null;
    protected String omeName = null;
    protected String firstName = null;
    protected String middleName = null;
    protected String lastName = null;
    protected String institution = null;
    protected String email = null;
    protected Set<ExperimenterAnnotationLink> annotationLinks = new HashSet<ExperimenterAnnotationLink>();
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String GROUPEXPERIMENTERMAPCOUNTPEROWNER = "ome.model.meta.Experimenter_groupExperimenterMapCountPerOwner";
    public static final String GROUPEXPERIMENTERMAP = "ome.model.meta.Experimenter_groupExperimenterMap";
    public static final String OMENAME = "ome.model.meta.Experimenter_omeName";
    public static final String FIRSTNAME = "ome.model.meta.Experimenter_firstName";
    public static final String MIDDLENAME = "ome.model.meta.Experimenter_middleName";
    public static final String LASTNAME = "ome.model.meta.Experimenter_lastName";
    public static final String INSTITUTION = "ome.model.meta.Experimenter_institution";
    public static final String EMAIL = "ome.model.meta.Experimenter_email";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.meta.Experimenter_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.meta.Experimenter_annotationLinks";
    public static final String DETAILS = "ome.model.meta.Experimenter_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Experimenter() {
        this(null, true);
    }

    protected Experimenter(Long id) {
        this(id, true);
    }

    public Experimenter(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Experimenter(String _omeName, String _firstName, String _lastName) {
        this(null, true);
        this.setOmeName(_omeName);
        this.setFirstName(_firstName);
        this.setLastName(_lastName);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_experimenter")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @JoinColumn(name="child", nullable=false)
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @IndexColumn(name="child_index", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected List<GroupExperimenterMap> getGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.groupExperimenterMap;
    }

    protected void setGroupExperimenterMap(List<GroupExperimenterMap> groupExperimenterMap) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.groupExperimenterMap = groupExperimenterMap;
    }

    public int sizeOfGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.groupExperimenterMap == null ? -1 : this.groupExperimenterMap.size();
    }

    public Iterator<GroupExperimenterMap> iterateGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return new EmptyIterator<GroupExperimenterMap>();
        }
        return this.getGroupExperimenterMap().iterator();
    }

    public Collection<GroupExperimenterMap> unmodifiableGroupExperimenterMap() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getGroupExperimenterMap());
    }

    public <E> List<E> collectGroupExperimenterMap(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<GroupExperimenterMap> it = this.iterateGroupExperimenterMap();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addGroupExperimenterMap(GroupExperimenterMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().add(target);
        if (target.isLoaded()) {
            target.setChild(this);
        }
    }

    public void addGroupExperimenterMapSet(Collection<GroupExperimenterMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().addAll(targets);
        for (GroupExperimenterMap target : targets) {
            if (!target.isLoaded()) continue;
            target.setChild(this);
        }
    }

    public void removeGroupExperimenterMap(GroupExperimenterMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().remove(target);
        if (target.isLoaded()) {
            target.setChild(null);
        }
    }

    public void removeGroupExperimenterMapSet(Collection<GroupExperimenterMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().removeAll(targets);
        for (GroupExperimenterMap target : targets) {
            if (!target.isLoaded()) continue;
            target.setChild(null);
        }
    }

    public GroupExperimenterMap getGroupExperimenterMap(int index) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        return this.getGroupExperimenterMap().get(index);
    }

    public void setGroupExperimenterMap(int index, GroupExperimenterMap element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().set(index, element);
    }

    @Transient
    public GroupExperimenterMap getPrimaryGroupExperimenterMap() throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        return this.getGroupExperimenterMap().get(0);
    }

    public GroupExperimenterMap setPrimaryGroupExperimenterMap(GroupExperimenterMap element) throws IndexOutOfBoundsException {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        List<GroupExperimenterMap> list = this.getGroupExperimenterMap();
        int index = list.indexOf(element);
        GroupExperimenterMap old = list.get(0);
        list.set(index, old);
        list.set(0, element);
        return old;
    }

    public GroupExperimenterMap linkExperimenterGroup(ExperimenterGroup addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        GroupExperimenterMap link = new GroupExperimenterMap();
        link.link(addition, this);
        this.addGroupExperimenterMap(link, true);
        return link;
    }

    public void addGroupExperimenterMap(GroupExperimenterMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().add(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().addGroupExperimenterMap(link, false);
        }
    }

    public Iterator<ExperimenterGroup> linkedExperimenterGroupIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            return new EmptyIterator<ExperimenterGroup>();
        }
        final Iterator<GroupExperimenterMap> it = this.getGroupExperimenterMap().iterator();
        return new Iterator<ExperimenterGroup>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public ExperimenterGroup next() {
                if (it == null) {
                    throw new NoSuchElementException("groupExperimenterMap is null; no elements.");
                }
                GroupExperimenterMap link = (GroupExperimenterMap)it.next();
                return link.parent();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<GroupExperimenterMap> findGroupExperimenterMap(ExperimenterGroup target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<GroupExperimenterMap> it = this.iterateGroupExperimenterMap();
        HashSet<GroupExperimenterMap> result = new HashSet<GroupExperimenterMap>();
        while (it.hasNext()) {
            GroupExperimenterMap link = it.next();
            if (link.parent() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<ExperimenterGroup> linkedExperimenterGroupList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ExperimenterGroup> it = this.linkedExperimenterGroupIterator();
        ArrayList<ExperimenterGroup> list = new ArrayList<ExperimenterGroup>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedExperimenterGroup(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ExperimenterGroup> it = this.linkedExperimenterGroupIterator();
        while (it.hasNext()) {
            ExperimenterGroup obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkExperimenterGroup(ExperimenterGroup removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<GroupExperimenterMap> toRemove = this.findGroupExperimenterMap(removal);
        Iterator<GroupExperimenterMap> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeGroupExperimenterMap(it.next(), true);
        }
    }

    public void removeGroupExperimenterMap(GroupExperimenterMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getGroupExperimenterMap() == null) {
            this.throwNullCollectionException("GroupExperimenterMap");
        }
        this.getGroupExperimenterMap().remove(link);
        if (bothSides && link.parent().isLoaded()) {
            link.parent().removeGroupExperimenterMap(link, false);
        }
    }

    public void clearExperimenterGroupLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<GroupExperimenterMap> list = new ArrayList<GroupExperimenterMap>(this.getGroupExperimenterMap());
        for (GroupExperimenterMap link : list) {
            this.removeGroupExperimenterMap(link, true);
        }
    }

    protected void setGroupExperimenterMapCountPerOwner(Map<Long, Long> map) {
        this.groupExperimenterMapCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Experimenter_groupExperimenterMap_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Experimenter_groupExperimenterMap")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getGroupExperimenterMapCountPerOwner() {
        return this.groupExperimenterMapCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=true, name="omeName", updatable=true)
    public String getOmeName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.omeName;
    }

    public void setOmeName(String omeName) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.omeName = omeName;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="firstName", updatable=true)
    public String getFirstName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.firstName = firstName;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="middleName", updatable=true)
    public String getMiddleName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.middleName = middleName;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="lastName", updatable=true)
    public String getLastName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lastName;
    }

    public void setLastName(String lastName) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lastName = lastName;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="institution", updatable=true)
    public String getInstitution() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.institution;
    }

    public void setInstitution(String institution) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.institution = institution;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="email", updatable=true)
    public String getEmail() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.email;
    }

    public void setEmail(String email) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.email = email;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected Set<ExperimenterAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<ExperimenterAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<ExperimenterAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<ExperimenterAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<ExperimenterAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<ExperimenterAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addExperimenterAnnotationLink(ExperimenterAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        target.setParent(this);
    }

    public void addExperimenterAnnotationLinkSet(Collection<ExperimenterAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (ExperimenterAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    public void removeExperimenterAnnotationLink(ExperimenterAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeExperimenterAnnotationLinkSet(Collection<ExperimenterAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (ExperimenterAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public ExperimenterAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ExperimenterAnnotationLink link = new ExperimenterAnnotationLink();
        link.link(this, addition);
        this.addExperimenterAnnotationLink(link, true);
        return link;
    }

    public void addExperimenterAnnotationLink(ExperimenterAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<ExperimenterAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                ExperimenterAnnotationLink link = (ExperimenterAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<ExperimenterAnnotationLink> findExperimenterAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<ExperimenterAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<ExperimenterAnnotationLink> result = new HashSet<ExperimenterAnnotationLink>();
        while (it.hasNext()) {
            ExperimenterAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<ExperimenterAnnotationLink> toRemove = this.findExperimenterAnnotationLink(removal);
        Iterator<ExperimenterAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeExperimenterAnnotationLink(it.next(), true);
        }
    }

    public void removeExperimenterAnnotationLink(ExperimenterAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<ExperimenterAnnotationLink> list = new ArrayList<ExperimenterAnnotationLink>(this.getAnnotationLinks());
        for (ExperimenterAnnotationLink link : list) {
            this.removeExperimenterAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @JoinTable(name="count_Experimenter_annotationLinks_by_owner")
    @Column(name="count", nullable=false)
    @ForeignKey(name="FK_count_to_Experimenter_annotationLinks")
    @CollectionOfElements
    @MapKey(columns={@Column(name="owner_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Experimenter newInstance() {
        return new Experimenter();
    }

    public Experimenter proxy() {
        return new Experimenter(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.groupExperimenterMapCountPerOwner = __filter.filter(GROUPEXPERIMENTERMAPCOUNTPEROWNER, this.groupExperimenterMapCountPerOwner);
            this.groupExperimenterMap = (List)__filter.filter(GROUPEXPERIMENTERMAP, this.groupExperimenterMap);
            this.omeName = (String)__filter.filter(OMENAME, this.omeName);
            this.firstName = (String)__filter.filter(FIRSTNAME, this.firstName);
            this.middleName = (String)__filter.filter(MIDDLENAME, this.middleName);
            this.lastName = (String)__filter.filter(LASTNAME, this.lastName);
            this.institution = (String)__filter.filter(INSTITUTION, this.institution);
            this.email = (String)__filter.filter(EMAIL, this.email);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(GROUPEXPERIMENTERMAPCOUNTPEROWNER)) {
            return this.getGroupExperimenterMapCountPerOwner();
        }
        if (field.equals(GROUPEXPERIMENTERMAP)) {
            return this.getGroupExperimenterMap();
        }
        if (field.equals(OMENAME)) {
            return this.getOmeName();
        }
        if (field.equals(FIRSTNAME)) {
            return this.getFirstName();
        }
        if (field.equals(MIDDLENAME)) {
            return this.getMiddleName();
        }
        if (field.equals(LASTNAME)) {
            return this.getLastName();
        }
        if (field.equals(INSTITUTION)) {
            return this.getInstitution();
        }
        if (field.equals(EMAIL)) {
            return this.getEmail();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(GROUPEXPERIMENTERMAPCOUNTPEROWNER)) {
            this.setGroupExperimenterMapCountPerOwner((Map)value);
        } else if (field.equals(GROUPEXPERIMENTERMAP)) {
            this.setGroupExperimenterMap((List)value);
        } else if (field.equals(OMENAME)) {
            this.setOmeName((String)value);
        } else if (field.equals(FIRSTNAME)) {
            this.setFirstName((String)value);
        } else if (field.equals(MIDDLENAME)) {
            this.setMiddleName((String)value);
        } else if (field.equals(LASTNAME)) {
            this.setLastName((String)value);
        } else if (field.equals(INSTITUTION)) {
            this.setInstitution((String)value);
        } else if (field.equals(EMAIL)) {
            this.setEmail((String)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.groupExperimenterMapCountPerOwner = null;
        this.groupExperimenterMap = null;
        this.omeName = null;
        this.firstName = null;
        this.middleName = null;
        this.lastName = null;
        this.institution = null;
        this.email = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(GROUPEXPERIMENTERMAPCOUNTPEROWNER);
        raw.add(GROUPEXPERIMENTERMAP);
        raw.add(OMENAME);
        raw.add(FIRSTNAME);
        raw.add(MIDDLENAME);
        raw.add(LASTNAME);
        raw.add(INSTITUTION);
        raw.add(EMAIL);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKexperimenter_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

