/*
 * Decompiled with CFR 0.152.
 */
package ome.model.display;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.display.RenderingDef;
import ome.model.enums.Family;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="channelbinding_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="channelbinding_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="channelbinding_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="channelbinding_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="channelbinding_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="channelbinding_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="channelbinding_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="channelbinding_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="channelbinding", uniqueConstraints={@UniqueConstraint(columnNames={"renderingDef", "renderingDef_index"})})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_channelbinding", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_channelbinding"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class ChannelBinding
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "channelbinding_owner_filter";
    public static final String GROUP_FILTER = "channelbinding_group_filter";
    public static final String EVENT_FILTER = "channelbinding_event_filter";
    public static final String PERMS_FILTER = "channelbinding_perms_filter";
    public static final String ID = "ome.model.display.ChannelBinding_id";
    protected Long id;
    public static final String VERSION = "ome.model.display.ChannelBinding_version";
    protected Integer version = 0;
    protected RenderingDef renderingDef = null;
    protected Family family = null;
    protected Double coefficient = null;
    protected Double inputStart = null;
    protected Double inputEnd = null;
    protected Boolean active = null;
    protected Boolean noiseReduction = null;
    protected Integer red = null;
    protected Integer green = null;
    protected Integer blue = null;
    protected Integer alpha = null;
    protected ome.model.internal.Details details = new Details();
    public static final String RENDERINGDEF = "ome.model.display.ChannelBinding_renderingDef";
    public static final String FAMILY = "ome.model.display.ChannelBinding_family";
    public static final String COEFFICIENT = "ome.model.display.ChannelBinding_coefficient";
    public static final String INPUTSTART = "ome.model.display.ChannelBinding_inputStart";
    public static final String INPUTEND = "ome.model.display.ChannelBinding_inputEnd";
    public static final String ACTIVE = "ome.model.display.ChannelBinding_active";
    public static final String NOISEREDUCTION = "ome.model.display.ChannelBinding_noiseReduction";
    public static final String RED = "ome.model.display.ChannelBinding_red";
    public static final String GREEN = "ome.model.display.ChannelBinding_green";
    public static final String BLUE = "ome.model.display.ChannelBinding_blue";
    public static final String ALPHA = "ome.model.display.ChannelBinding_alpha";
    public static final String DETAILS = "ome.model.display.ChannelBinding_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public ChannelBinding() {
        this(null, true);
    }

    protected ChannelBinding(Long id) {
        this(id, true);
    }

    public ChannelBinding(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public ChannelBinding(RenderingDef _renderingDef, Family _family, Double _coefficient, Double _inputStart, Double _inputEnd, Boolean _active, Boolean _noiseReduction, Integer _red, Integer _green, Integer _blue, Integer _alpha) {
        this(null, true);
        this.setRenderingDef(_renderingDef);
        this.setFamily(_family);
        this.setCoefficient(_coefficient);
        this.setInputStart(_inputStart);
        this.setInputEnd(_inputEnd);
        this.setActive(_active);
        this.setNoiseReduction(_noiseReduction);
        this.setRed(_red);
        this.setGreen(_green);
        this.setBlue(_blue);
        this.setAlpha(_alpha);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_channelbinding")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=RenderingDef.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="renderingDef", nullable=false, unique=false, insertable=false, updatable=false)
    @ForeignKey(name="FKchannelbinding_renderingDef_renderingdef")
    public RenderingDef getRenderingDef() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.renderingDef;
    }

    public void setRenderingDef(RenderingDef renderingDef) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.renderingDef = renderingDef;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Family.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="family", nullable=false, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKchannelbinding_family_family")
    public Family getFamily() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.family;
    }

    public void setFamily(Family family) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.family = family;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="coefficient", updatable=true)
    public Double getCoefficient() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.coefficient;
    }

    public void setCoefficient(Double coefficient) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.coefficient = coefficient;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="inputStart", updatable=true)
    public Double getInputStart() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.inputStart;
    }

    public void setInputStart(Double inputStart) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.inputStart = inputStart;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="inputEnd", updatable=true)
    public Double getInputEnd() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.inputEnd;
    }

    public void setInputEnd(Double inputEnd) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.inputEnd = inputEnd;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="active", updatable=true)
    public Boolean getActive() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.active;
    }

    public void setActive(Boolean active) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.active = active;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="noiseReduction", updatable=true)
    public Boolean getNoiseReduction() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.noiseReduction;
    }

    public void setNoiseReduction(Boolean noiseReduction) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.noiseReduction = noiseReduction;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="red", updatable=true)
    public Integer getRed() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.red;
    }

    public void setRed(Integer red) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.red = red;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="green", updatable=true)
    public Integer getGreen() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.green;
    }

    public void setGreen(Integer green) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.green = green;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="blue", updatable=true)
    public Integer getBlue() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.blue;
    }

    public void setBlue(Integer blue) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.blue = blue;
    }

    @Column(columnDefinition="", nullable=false, unique=false, name="alpha", updatable=true)
    public Integer getAlpha() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.alpha;
    }

    public void setAlpha(Integer alpha) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.alpha = alpha;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public ChannelBinding newInstance() {
        return new ChannelBinding();
    }

    public ChannelBinding proxy() {
        return new ChannelBinding(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.renderingDef = (RenderingDef)__filter.filter(RENDERINGDEF, this.renderingDef);
            this.family = (Family)__filter.filter(FAMILY, this.family);
            this.coefficient = (Double)__filter.filter(COEFFICIENT, this.coefficient);
            this.inputStart = (Double)__filter.filter(INPUTSTART, this.inputStart);
            this.inputEnd = (Double)__filter.filter(INPUTEND, this.inputEnd);
            this.active = (Boolean)__filter.filter(ACTIVE, this.active);
            this.noiseReduction = (Boolean)__filter.filter(NOISEREDUCTION, this.noiseReduction);
            this.red = (Integer)__filter.filter(RED, this.red);
            this.green = (Integer)__filter.filter(GREEN, this.green);
            this.blue = (Integer)__filter.filter(BLUE, this.blue);
            this.alpha = (Integer)__filter.filter(ALPHA, this.alpha);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(RENDERINGDEF)) {
            return this.getRenderingDef();
        }
        if (field.equals(FAMILY)) {
            return this.getFamily();
        }
        if (field.equals(COEFFICIENT)) {
            return this.getCoefficient();
        }
        if (field.equals(INPUTSTART)) {
            return this.getInputStart();
        }
        if (field.equals(INPUTEND)) {
            return this.getInputEnd();
        }
        if (field.equals(ACTIVE)) {
            return this.getActive();
        }
        if (field.equals(NOISEREDUCTION)) {
            return this.getNoiseReduction();
        }
        if (field.equals(RED)) {
            return this.getRed();
        }
        if (field.equals(GREEN)) {
            return this.getGreen();
        }
        if (field.equals(BLUE)) {
            return this.getBlue();
        }
        if (field.equals(ALPHA)) {
            return this.getAlpha();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(RENDERINGDEF)) {
            this.setRenderingDef((RenderingDef)value);
        } else if (field.equals(FAMILY)) {
            this.setFamily((Family)value);
        } else if (field.equals(COEFFICIENT)) {
            this.setCoefficient((Double)value);
        } else if (field.equals(INPUTSTART)) {
            this.setInputStart((Double)value);
        } else if (field.equals(INPUTEND)) {
            this.setInputEnd((Double)value);
        } else if (field.equals(ACTIVE)) {
            this.setActive((Boolean)value);
        } else if (field.equals(NOISEREDUCTION)) {
            this.setNoiseReduction((Boolean)value);
        } else if (field.equals(RED)) {
            this.setRed((Integer)value);
        } else if (field.equals(GREEN)) {
            this.setGreen((Integer)value);
        } else if (field.equals(BLUE)) {
            this.setBlue((Integer)value);
        } else if (field.equals(ALPHA)) {
            this.setAlpha((Integer)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.renderingDef = null;
        this.family = null;
        this.coefficient = null;
        this.inputStart = null;
        this.inputEnd = null;
        this.active = null;
        this.noiseReduction = null;
        this.red = null;
        this.green = null;
        this.blue = null;
        this.alpha = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(RENDERINGDEF);
        raw.add(FAMILY);
        raw.add(COEFFICIENT);
        raw.add(INPUTSTART);
        raw.add(INPUTEND);
        raw.add(ACTIVE);
        raw.add(NOISEREDUCTION);
        raw.add(RED);
        raw.add(GREEN);
        raw.add(BLUE);
        raw.add(ALPHA);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKchannelbinding_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKchannelbinding_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKchannelbinding_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKchannelbinding_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKchannelbinding_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

