/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.DetectorSettings;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.LightSettings;
import ome.model.acquisition.OTF;
import ome.model.core.Channel;
import ome.model.enums.AcquisitionMode;
import ome.model.enums.ContrastMethod;
import ome.model.enums.Illumination;
import ome.model.enums.PhotometricInterpretation;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="logicalchannel_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="logicalchannel_owner_filter_CHANNELS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_group_filter_CHANNELS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_event_filter_CHANNELS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="logicalchannel_perms_filter_CHANNELS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="logicalchannel_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="logicalchannel_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="logicalchannel_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="logicalchannel_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="logicalchannel", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_logicalchannel", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_logicalchannel"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class LogicalChannel
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "logicalchannel_owner_filter";
    public static final String GROUP_FILTER = "logicalchannel_group_filter";
    public static final String EVENT_FILTER = "logicalchannel_event_filter";
    public static final String PERMS_FILTER = "logicalchannel_perms_filter";
    public static final String ID = "ome.model.core.LogicalChannel_id";
    protected Long id;
    public static final String VERSION = "ome.model.core.LogicalChannel_version";
    protected Integer version = 0;
    protected String name = null;
    protected Double pinHoleSize = null;
    protected Illumination illumination = null;
    protected ContrastMethod contrastMethod = null;
    protected Integer excitationWave = null;
    protected Integer emissionWave = null;
    protected String fluor = null;
    protected Double ndFilter = null;
    protected OTF otf = null;
    protected DetectorSettings detectorSettings = null;
    protected LightSettings lightSourceSettings = null;
    protected FilterSet filterSet = null;
    protected ome.model.acquisition.Filter secondaryEmissionFilter = null;
    protected ome.model.acquisition.Filter secondaryExcitationFilter = null;
    protected Integer samplesPerPixel = null;
    protected PhotometricInterpretation photometricInterpretation = null;
    protected AcquisitionMode mode = null;
    protected Integer pockelCellSetting = null;
    protected Set<Channel> channels = new HashSet<Channel>();
    public static final String OWNER_FILTER_CHANNELS = "logicalchannel_owner_filter_CHANNELS";
    public static final String GROUP_FILTER_CHANNELS = "logicalchannel_group_filter_CHANNELS";
    public static final String EVENT_FILTER_CHANNELS = "logicalchannel_event_filter_CHANNELS";
    public static final String PERMS_FILTER_CHANNELS = "logicalchannel_perms_filter_CHANNELS";
    protected ome.model.internal.Details details = new Details();
    public static final String NAME = "ome.model.core.LogicalChannel_name";
    public static final String PINHOLESIZE = "ome.model.core.LogicalChannel_pinHoleSize";
    public static final String ILLUMINATION = "ome.model.core.LogicalChannel_illumination";
    public static final String CONTRASTMETHOD = "ome.model.core.LogicalChannel_contrastMethod";
    public static final String EXCITATIONWAVE = "ome.model.core.LogicalChannel_excitationWave";
    public static final String EMISSIONWAVE = "ome.model.core.LogicalChannel_emissionWave";
    public static final String FLUOR = "ome.model.core.LogicalChannel_fluor";
    public static final String NDFILTER = "ome.model.core.LogicalChannel_ndFilter";
    public static final String OTF = "ome.model.core.LogicalChannel_otf";
    public static final String DETECTORSETTINGS = "ome.model.core.LogicalChannel_detectorSettings";
    public static final String LIGHTSOURCESETTINGS = "ome.model.core.LogicalChannel_lightSourceSettings";
    public static final String FILTERSET = "ome.model.core.LogicalChannel_filterSet";
    public static final String SECONDARYEMISSIONFILTER = "ome.model.core.LogicalChannel_secondaryEmissionFilter";
    public static final String SECONDARYEXCITATIONFILTER = "ome.model.core.LogicalChannel_secondaryExcitationFilter";
    public static final String SAMPLESPERPIXEL = "ome.model.core.LogicalChannel_samplesPerPixel";
    public static final String PHOTOMETRICINTERPRETATION = "ome.model.core.LogicalChannel_photometricInterpretation";
    public static final String MODE = "ome.model.core.LogicalChannel_mode";
    public static final String POCKELCELLSETTING = "ome.model.core.LogicalChannel_pockelCellSetting";
    public static final String CHANNELS = "ome.model.core.LogicalChannel_channels";
    public static final String DETAILS = "ome.model.core.LogicalChannel_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public LogicalChannel() {
        this(null, true);
    }

    protected LogicalChannel(Long id) {
        this(id, true);
    }

    public LogicalChannel(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_logicalchannel")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="pinHoleSize", updatable=true)
    public Double getPinHoleSize() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pinHoleSize;
    }

    public void setPinHoleSize(Double pinHoleSize) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pinHoleSize = pinHoleSize;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Illumination.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="illumination", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_illumination_illumination")
    public Illumination getIllumination() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.illumination;
    }

    public void setIllumination(Illumination illumination) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.illumination = illumination;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ContrastMethod.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="contrastMethod", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_contrastMethod_contrastmethod")
    public ContrastMethod getContrastMethod() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.contrastMethod;
    }

    public void setContrastMethod(ContrastMethod contrastMethod) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.contrastMethod = contrastMethod;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="excitationWave", updatable=true)
    public Integer getExcitationWave() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.excitationWave;
    }

    public void setExcitationWave(Integer excitationWave) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.excitationWave = excitationWave;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="emissionWave", updatable=true)
    public Integer getEmissionWave() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.emissionWave;
    }

    public void setEmissionWave(Integer emissionWave) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.emissionWave = emissionWave;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="fluor", updatable=true)
    public String getFluor() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.fluor;
    }

    public void setFluor(String fluor) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.fluor = fluor;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="ndFilter", updatable=true)
    public Double getNdFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.ndFilter;
    }

    public void setNdFilter(Double ndFilter) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.ndFilter = ndFilter;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=OTF.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="otf", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_otf_otf")
    public OTF getOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.otf;
    }

    public void setOtf(OTF otf) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.otf = otf;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=DetectorSettings.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="detectorSettings", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_detectorSettings_detectorsettings")
    public DetectorSettings getDetectorSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.detectorSettings;
    }

    public void setDetectorSettings(DetectorSettings detectorSettings) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.detectorSettings = detectorSettings;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=LightSettings.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="lightSourceSettings", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_lightSourceSettings_lightsettings")
    public LightSettings getLightSourceSettings() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lightSourceSettings;
    }

    public void setLightSourceSettings(LightSettings lightSourceSettings) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lightSourceSettings = lightSourceSettings;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=FilterSet.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="filterSet", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_filterSet_filterset")
    public FilterSet getFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filterSet;
    }

    public void setFilterSet(FilterSet filterSet) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.filterSet = filterSet;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ome.model.acquisition.Filter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="secondaryEmissionFilter", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_secondaryEmissionFilter_filter")
    public ome.model.acquisition.Filter getSecondaryEmissionFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.secondaryEmissionFilter;
    }

    public void setSecondaryEmissionFilter(ome.model.acquisition.Filter secondaryEmissionFilter) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.secondaryEmissionFilter = secondaryEmissionFilter;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=ome.model.acquisition.Filter.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="secondaryExcitationFilter", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_secondaryExcitationFilter_filter")
    public ome.model.acquisition.Filter getSecondaryExcitationFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.secondaryExcitationFilter;
    }

    public void setSecondaryExcitationFilter(ome.model.acquisition.Filter secondaryExcitationFilter) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.secondaryExcitationFilter = secondaryExcitationFilter;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="samplesPerPixel", updatable=true)
    public Integer getSamplesPerPixel() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.samplesPerPixel;
    }

    public void setSamplesPerPixel(Integer samplesPerPixel) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.samplesPerPixel = samplesPerPixel;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=PhotometricInterpretation.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="photometricInterpretation", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_photometricInterpretation_photometricinterpretation")
    public PhotometricInterpretation getPhotometricInterpretation() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.photometricInterpretation;
    }

    public void setPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.photometricInterpretation = photometricInterpretation;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=AcquisitionMode.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @JoinColumn(name="mode", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKlogicalchannel_mode_acquisitionmode")
    public AcquisitionMode getMode() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.mode;
    }

    public void setMode(AcquisitionMode mode) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.mode = mode;
    }

    @Column(columnDefinition="", nullable=true, unique=false, name="pockelCellSetting", updatable=true)
    public Integer getPockelCellSetting() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pockelCellSetting;
    }

    public void setPockelCellSetting(Integer pockelCellSetting) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pockelCellSetting = pockelCellSetting;
    }

    @OneToMany(mappedBy="logicalChannel", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="logicalchannel_owner_filter_CHANNELS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="logicalchannel_group_filter_CHANNELS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="logicalchannel_event_filter_CHANNELS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="logicalchannel_perms_filter_CHANNELS", condition=":permsStr = permissions")})
    protected Set<Channel> getChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels;
    }

    protected void setChannels(Set<Channel> channels) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.channels = channels;
    }

    public int sizeOfChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.channels == null ? -1 : this.channels.size();
    }

    public Iterator<Channel> iterateChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return new EmptyIterator<Channel>();
        }
        return this.getChannels().iterator();
    }

    public Collection<Channel> unmodifiableChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getChannels());
    }

    public <E> List<E> collectChannels(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Channel> it = this.iterateChannels();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addChannel(Channel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().add(target);
        target.setLogicalChannel(this);
    }

    public void addChannelSet(Collection<Channel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().addAll(targets);
        for (Channel target : targets) {
            target.setLogicalChannel(this);
        }
    }

    public void removeChannel(Channel target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().remove(target);
        target.setLogicalChannel(null);
    }

    public void removeChannelSet(Collection<Channel> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().removeAll(targets);
        for (Channel target : targets) {
            target.setLogicalChannel(null);
        }
    }

    public void clearChannels() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getChannels() == null) {
            this.throwNullCollectionException("Channels");
        }
        this.getChannels().clear();
        Iterator<Channel> it = this.iterateChannels();
        while (it.hasNext()) {
            Channel target = it.next();
            target.setLogicalChannel(null);
        }
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public LogicalChannel newInstance() {
        return new LogicalChannel();
    }

    public LogicalChannel proxy() {
        return new LogicalChannel(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.name = (String)__filter.filter(NAME, this.name);
            this.pinHoleSize = (Double)__filter.filter(PINHOLESIZE, this.pinHoleSize);
            this.illumination = (Illumination)__filter.filter(ILLUMINATION, this.illumination);
            this.contrastMethod = (ContrastMethod)__filter.filter(CONTRASTMETHOD, this.contrastMethod);
            this.excitationWave = (Integer)__filter.filter(EXCITATIONWAVE, this.excitationWave);
            this.emissionWave = (Integer)__filter.filter(EMISSIONWAVE, this.emissionWave);
            this.fluor = (String)__filter.filter(FLUOR, this.fluor);
            this.ndFilter = (Double)__filter.filter(NDFILTER, this.ndFilter);
            this.otf = (OTF)__filter.filter(OTF, this.otf);
            this.detectorSettings = (DetectorSettings)__filter.filter(DETECTORSETTINGS, this.detectorSettings);
            this.lightSourceSettings = (LightSettings)__filter.filter(LIGHTSOURCESETTINGS, this.lightSourceSettings);
            this.filterSet = (FilterSet)__filter.filter(FILTERSET, this.filterSet);
            this.secondaryEmissionFilter = (ome.model.acquisition.Filter)__filter.filter(SECONDARYEMISSIONFILTER, this.secondaryEmissionFilter);
            this.secondaryExcitationFilter = (ome.model.acquisition.Filter)__filter.filter(SECONDARYEXCITATIONFILTER, this.secondaryExcitationFilter);
            this.samplesPerPixel = (Integer)__filter.filter(SAMPLESPERPIXEL, this.samplesPerPixel);
            this.photometricInterpretation = (PhotometricInterpretation)__filter.filter(PHOTOMETRICINTERPRETATION, this.photometricInterpretation);
            this.mode = (AcquisitionMode)__filter.filter(MODE, this.mode);
            this.pockelCellSetting = (Integer)__filter.filter(POCKELCELLSETTING, this.pockelCellSetting);
            this.channels = (Set)__filter.filter(CHANNELS, this.channels);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(PINHOLESIZE)) {
            return this.getPinHoleSize();
        }
        if (field.equals(ILLUMINATION)) {
            return this.getIllumination();
        }
        if (field.equals(CONTRASTMETHOD)) {
            return this.getContrastMethod();
        }
        if (field.equals(EXCITATIONWAVE)) {
            return this.getExcitationWave();
        }
        if (field.equals(EMISSIONWAVE)) {
            return this.getEmissionWave();
        }
        if (field.equals(FLUOR)) {
            return this.getFluor();
        }
        if (field.equals(NDFILTER)) {
            return this.getNdFilter();
        }
        if (field.equals(OTF)) {
            return this.getOtf();
        }
        if (field.equals(DETECTORSETTINGS)) {
            return this.getDetectorSettings();
        }
        if (field.equals(LIGHTSOURCESETTINGS)) {
            return this.getLightSourceSettings();
        }
        if (field.equals(FILTERSET)) {
            return this.getFilterSet();
        }
        if (field.equals(SECONDARYEMISSIONFILTER)) {
            return this.getSecondaryEmissionFilter();
        }
        if (field.equals(SECONDARYEXCITATIONFILTER)) {
            return this.getSecondaryExcitationFilter();
        }
        if (field.equals(SAMPLESPERPIXEL)) {
            return this.getSamplesPerPixel();
        }
        if (field.equals(PHOTOMETRICINTERPRETATION)) {
            return this.getPhotometricInterpretation();
        }
        if (field.equals(MODE)) {
            return this.getMode();
        }
        if (field.equals(POCKELCELLSETTING)) {
            return this.getPockelCellSetting();
        }
        if (field.equals(CHANNELS)) {
            return this.getChannels();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(PINHOLESIZE)) {
            this.setPinHoleSize((Double)value);
        } else if (field.equals(ILLUMINATION)) {
            this.setIllumination((Illumination)value);
        } else if (field.equals(CONTRASTMETHOD)) {
            this.setContrastMethod((ContrastMethod)value);
        } else if (field.equals(EXCITATIONWAVE)) {
            this.setExcitationWave((Integer)value);
        } else if (field.equals(EMISSIONWAVE)) {
            this.setEmissionWave((Integer)value);
        } else if (field.equals(FLUOR)) {
            this.setFluor((String)value);
        } else if (field.equals(NDFILTER)) {
            this.setNdFilter((Double)value);
        } else if (field.equals(OTF)) {
            this.setOtf((OTF)value);
        } else if (field.equals(DETECTORSETTINGS)) {
            this.setDetectorSettings((DetectorSettings)value);
        } else if (field.equals(LIGHTSOURCESETTINGS)) {
            this.setLightSourceSettings((LightSettings)value);
        } else if (field.equals(FILTERSET)) {
            this.setFilterSet((FilterSet)value);
        } else if (field.equals(SECONDARYEMISSIONFILTER)) {
            this.setSecondaryEmissionFilter((ome.model.acquisition.Filter)value);
        } else if (field.equals(SECONDARYEXCITATIONFILTER)) {
            this.setSecondaryExcitationFilter((ome.model.acquisition.Filter)value);
        } else if (field.equals(SAMPLESPERPIXEL)) {
            this.setSamplesPerPixel((Integer)value);
        } else if (field.equals(PHOTOMETRICINTERPRETATION)) {
            this.setPhotometricInterpretation((PhotometricInterpretation)value);
        } else if (field.equals(MODE)) {
            this.setMode((AcquisitionMode)value);
        } else if (field.equals(POCKELCELLSETTING)) {
            this.setPockelCellSetting((Integer)value);
        } else if (field.equals(CHANNELS)) {
            this.setChannels((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.name = null;
        this.pinHoleSize = null;
        this.illumination = null;
        this.contrastMethod = null;
        this.excitationWave = null;
        this.emissionWave = null;
        this.fluor = null;
        this.ndFilter = null;
        this.otf = null;
        this.detectorSettings = null;
        this.lightSourceSettings = null;
        this.filterSet = null;
        this.secondaryEmissionFilter = null;
        this.secondaryExcitationFilter = null;
        this.samplesPerPixel = null;
        this.photometricInterpretation = null;
        this.mode = null;
        this.pockelCellSetting = null;
        this.channels = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(NAME);
        raw.add(PINHOLESIZE);
        raw.add(ILLUMINATION);
        raw.add(CONTRASTMETHOD);
        raw.add(EXCITATIONWAVE);
        raw.add(EMISSIONWAVE);
        raw.add(FLUOR);
        raw.add(NDFILTER);
        raw.add(OTF);
        raw.add(DETECTORSETTINGS);
        raw.add(LIGHTSOURCESETTINGS);
        raw.add(FILTERSET);
        raw.add(SECONDARYEMISSIONFILTER);
        raw.add(SECONDARYEXCITATIONFILTER);
        raw.add(SAMPLESPERPIXEL);
        raw.add(PHOTOMETRICINTERPRETATION);
        raw.add(MODE);
        raw.add(POCKELCELLSETTING);
        raw.add(CHANNELS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKlogicalchannel_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlogicalchannel_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKlogicalchannel_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlogicalchannel_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKlogicalchannel_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

