/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.meta;

import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

public final class MetadataConverter {
    private MetadataConverter() {
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        int datasetCount = src.getDatasetCount();
        for (int datasetIndex = 0; datasetIndex < datasetCount; ++datasetIndex) {
            String datasetNameValue;
            Boolean datasetLockedValue;
            String datasetIDValue;
            String datasetGroupRefValue;
            String datasetExperimenterRefValue;
            String datasetDescriptionValue = src.getDatasetDescription(datasetIndex);
            if (datasetDescriptionValue != null) {
                dest.setDatasetDescription(datasetDescriptionValue, datasetIndex);
            }
            if ((datasetExperimenterRefValue = src.getDatasetExperimenterRef(datasetIndex)) != null) {
                dest.setDatasetExperimenterRef(datasetExperimenterRefValue, datasetIndex);
            }
            if ((datasetGroupRefValue = src.getDatasetGroupRef(datasetIndex)) != null) {
                dest.setDatasetGroupRef(datasetGroupRefValue, datasetIndex);
            }
            if ((datasetIDValue = src.getDatasetID(datasetIndex)) != null) {
                dest.setDatasetID(datasetIDValue, datasetIndex);
            }
            if ((datasetLockedValue = src.getDatasetLocked(datasetIndex)) != null) {
                dest.setDatasetLocked(datasetLockedValue, datasetIndex);
            }
            if ((datasetNameValue = src.getDatasetName(datasetIndex)) != null) {
                dest.setDatasetName(datasetNameValue, datasetIndex);
            }
            int projectRefCount = src.getProjectRefCount(datasetIndex);
            for (int projectRefIndex = 0; projectRefIndex < projectRefCount; ++projectRefIndex) {
                String projectRefIDValue = src.getProjectRefID(datasetIndex, projectRefIndex);
                if (projectRefIDValue == null) continue;
                dest.setProjectRefID(projectRefIDValue, datasetIndex, projectRefIndex);
            }
        }
        int experimentCount = src.getExperimentCount();
        for (int experimentIndex = 0; experimentIndex < experimentCount; ++experimentIndex) {
            String experimentTypeValue;
            String experimentIDValue;
            String experimentExperimenterRefValue;
            String experimentDescriptionValue = src.getExperimentDescription(experimentIndex);
            if (experimentDescriptionValue != null) {
                dest.setExperimentDescription(experimentDescriptionValue, experimentIndex);
            }
            if ((experimentExperimenterRefValue = src.getExperimentExperimenterRef(experimentIndex)) != null) {
                dest.setExperimentExperimenterRef(experimentExperimenterRefValue, experimentIndex);
            }
            if ((experimentIDValue = src.getExperimentID(experimentIndex)) != null) {
                dest.setExperimentID(experimentIDValue, experimentIndex);
            }
            if ((experimentTypeValue = src.getExperimentType(experimentIndex)) != null) {
                dest.setExperimentType(experimentTypeValue, experimentIndex);
            }
            int microbeamManipulationRefCount = src.getMicrobeamManipulationRefCount(experimentIndex);
            for (int microbeamManipulationRefIndex = 0; microbeamManipulationRefIndex < microbeamManipulationRefCount; ++microbeamManipulationRefIndex) {
                String microbeamManipulationRefIDValue = src.getMicrobeamManipulationRefID(experimentIndex, microbeamManipulationRefIndex);
                if (microbeamManipulationRefIDValue == null) continue;
                dest.setMicrobeamManipulationRefID(microbeamManipulationRefIDValue, experimentIndex, microbeamManipulationRefIndex);
            }
        }
        int experimenterCount = src.getExperimenterCount();
        for (int experimenterIndex = 0; experimenterIndex < experimenterCount; ++experimenterIndex) {
            String experimenterOMENameValue;
            String experimenterLastNameValue;
            String experimenterInstitutionValue;
            String experimenterIDValue;
            String experimenterFirstNameValue;
            String experimenterEmailValue = src.getExperimenterEmail(experimenterIndex);
            if (experimenterEmailValue != null) {
                dest.setExperimenterEmail(experimenterEmailValue, experimenterIndex);
            }
            if ((experimenterFirstNameValue = src.getExperimenterFirstName(experimenterIndex)) != null) {
                dest.setExperimenterFirstName(experimenterFirstNameValue, experimenterIndex);
            }
            if ((experimenterIDValue = src.getExperimenterID(experimenterIndex)) != null) {
                dest.setExperimenterID(experimenterIDValue, experimenterIndex);
            }
            if ((experimenterInstitutionValue = src.getExperimenterInstitution(experimenterIndex)) != null) {
                dest.setExperimenterInstitution(experimenterInstitutionValue, experimenterIndex);
            }
            if ((experimenterLastNameValue = src.getExperimenterLastName(experimenterIndex)) != null) {
                dest.setExperimenterLastName(experimenterLastNameValue, experimenterIndex);
            }
            if ((experimenterOMENameValue = src.getExperimenterOMEName(experimenterIndex)) != null) {
                dest.setExperimenterOMEName(experimenterOMENameValue, experimenterIndex);
            }
            int groupRefCount = src.getGroupRefCount(experimenterIndex);
            for (int groupRefIndex = 0; groupRefIndex < groupRefCount; ++groupRefIndex) {
                String experimenterMembershipGroupValue = src.getExperimenterMembershipGroup(experimenterIndex, groupRefIndex);
                if (experimenterMembershipGroupValue == null) continue;
                dest.setExperimenterMembershipGroup(experimenterMembershipGroupValue, experimenterIndex, groupRefIndex);
            }
        }
        int groupCount = src.getGroupCount();
        for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            String contactExperimenterValue;
            String groupNameValue;
            String groupIDValue = src.getGroupID(groupIndex);
            if (groupIDValue != null) {
                dest.setGroupID(groupIDValue, groupIndex);
            }
            if ((groupNameValue = src.getGroupName(groupIndex)) != null) {
                dest.setGroupName(groupNameValue, groupIndex);
            }
            if ((contactExperimenterValue = src.getContactExperimenter(groupIndex)) == null) continue;
            dest.setContactExperimenter(contactExperimenterValue, groupIndex);
        }
        int imageCount = src.getImageCount();
        for (int imageIndex = 0; imageIndex < imageCount; ++imageIndex) {
            String thumbnailMIMEtypeValue;
            String thumbnailIDValue;
            String thumbnailHrefValue;
            Float stageLabelZValue;
            Float stageLabelYValue;
            Float stageLabelXValue;
            Float objectiveSettingsRefractiveIndexValue;
            String objectiveSettingsObjectiveValue;
            String objectiveSettingsMediumValue;
            Float imagingEnvironmentTemperatureValue;
            Float imagingEnvironmentHumidityValue;
            Float imagingEnvironmentCO2PercentValue;
            Float imagingEnvironmentAirPressureValue;
            Float displayOptionsZoomValue;
            String displayOptionsIDValue;
            String imageNameValue;
            String imageInstrumentRefValue;
            String imageIDValue;
            String imageGroupRefValue;
            String imageExperimenterRefValue;
            String imageExperimentRefValue;
            String imageDescriptionValue;
            String imageDefaultPixelsValue;
            String imageCreationDateValue;
            String imageAcquiredPixelsValue = src.getImageAcquiredPixels(imageIndex);
            if (imageAcquiredPixelsValue != null) {
                dest.setImageAcquiredPixels(imageAcquiredPixelsValue, imageIndex);
            }
            if ((imageCreationDateValue = src.getImageCreationDate(imageIndex)) != null) {
                dest.setImageCreationDate(imageCreationDateValue, imageIndex);
            }
            if ((imageDefaultPixelsValue = src.getImageDefaultPixels(imageIndex)) != null) {
                dest.setImageDefaultPixels(imageDefaultPixelsValue, imageIndex);
            }
            if ((imageDescriptionValue = src.getImageDescription(imageIndex)) != null) {
                dest.setImageDescription(imageDescriptionValue, imageIndex);
            }
            if ((imageExperimentRefValue = src.getImageExperimentRef(imageIndex)) != null) {
                dest.setImageExperimentRef(imageExperimentRefValue, imageIndex);
            }
            if ((imageExperimenterRefValue = src.getImageExperimenterRef(imageIndex)) != null) {
                dest.setImageExperimenterRef(imageExperimenterRefValue, imageIndex);
            }
            if ((imageGroupRefValue = src.getImageGroupRef(imageIndex)) != null) {
                dest.setImageGroupRef(imageGroupRefValue, imageIndex);
            }
            if ((imageIDValue = src.getImageID(imageIndex)) != null) {
                dest.setImageID(imageIDValue, imageIndex);
            }
            if ((imageInstrumentRefValue = src.getImageInstrumentRef(imageIndex)) != null) {
                dest.setImageInstrumentRef(imageInstrumentRefValue, imageIndex);
            }
            if ((imageNameValue = src.getImageName(imageIndex)) != null) {
                dest.setImageName(imageNameValue, imageIndex);
            }
            int datasetRefCount = src.getDatasetRefCount(imageIndex);
            for (int datasetRefIndex = 0; datasetRefIndex < datasetRefCount; ++datasetRefIndex) {
                String datasetRefIDValue = src.getDatasetRefID(imageIndex, datasetRefIndex);
                if (datasetRefIDValue == null) continue;
                dest.setDatasetRefID(datasetRefIDValue, imageIndex, datasetRefIndex);
            }
            String displayOptionsDisplayValue = src.getDisplayOptionsDisplay(imageIndex);
            if (displayOptionsDisplayValue != null) {
                dest.setDisplayOptionsDisplay(displayOptionsDisplayValue, imageIndex);
            }
            if ((displayOptionsIDValue = src.getDisplayOptionsID(imageIndex)) != null) {
                dest.setDisplayOptionsID(displayOptionsIDValue, imageIndex);
            }
            if ((displayOptionsZoomValue = src.getDisplayOptionsZoom(imageIndex)) != null) {
                dest.setDisplayOptionsZoom(displayOptionsZoomValue, imageIndex);
            }
            if ((imagingEnvironmentAirPressureValue = src.getImagingEnvironmentAirPressure(imageIndex)) != null) {
                dest.setImagingEnvironmentAirPressure(imagingEnvironmentAirPressureValue, imageIndex);
            }
            if ((imagingEnvironmentCO2PercentValue = src.getImagingEnvironmentCO2Percent(imageIndex)) != null) {
                dest.setImagingEnvironmentCO2Percent(imagingEnvironmentCO2PercentValue, imageIndex);
            }
            if ((imagingEnvironmentHumidityValue = src.getImagingEnvironmentHumidity(imageIndex)) != null) {
                dest.setImagingEnvironmentHumidity(imagingEnvironmentHumidityValue, imageIndex);
            }
            if ((imagingEnvironmentTemperatureValue = src.getImagingEnvironmentTemperature(imageIndex)) != null) {
                dest.setImagingEnvironmentTemperature(imagingEnvironmentTemperatureValue, imageIndex);
            }
            int logicalChannelCount = src.getLogicalChannelCount(imageIndex);
            for (int logicalChannelIndex = 0; logicalChannelIndex < logicalChannelCount; ++logicalChannelIndex) {
                Integer lightSourceSettingsWavelengthValue;
                String lightSourceSettingsLightSourceValue;
                Float lightSourceSettingsAttenuationValue;
                Float detectorSettingsVoltageValue;
                Float detectorSettingsReadOutRateValue;
                Float detectorSettingsOffsetValue;
                Float detectorSettingsGainValue;
                String detectorSettingsDetectorValue;
                String logicalChannelSecondaryExcitationFilterValue;
                String logicalChannelSecondaryEmissionFilterValue;
                Integer logicalChannelSamplesPerPixelValue;
                Integer logicalChannelPockelCellSettingValue;
                Float logicalChannelPinholeSizeValue;
                String logicalChannelPhotometricInterpretationValue;
                String logicalChannelOTFValue;
                Float logicalChannelNdFilterValue;
                String logicalChannelNameValue;
                String logicalChannelModeValue;
                String logicalChannelLightSourceValue;
                String logicalChannelIlluminationTypeValue;
                String logicalChannelIDValue;
                String logicalChannelFluorValue;
                String logicalChannelFilterSetValue;
                Integer logicalChannelExWaveValue;
                Integer logicalChannelEmWaveValue;
                String logicalChannelDetectorValue;
                String logicalChannelContrastMethodValue = src.getLogicalChannelContrastMethod(imageIndex, logicalChannelIndex);
                if (logicalChannelContrastMethodValue != null) {
                    dest.setLogicalChannelContrastMethod(logicalChannelContrastMethodValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelDetectorValue = src.getLogicalChannelDetector(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelDetector(logicalChannelDetectorValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelEmWaveValue = src.getLogicalChannelEmWave(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelEmWave(logicalChannelEmWaveValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelExWaveValue = src.getLogicalChannelExWave(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelExWave(logicalChannelExWaveValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelFilterSetValue = src.getLogicalChannelFilterSet(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelFilterSet(logicalChannelFilterSetValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelFluorValue = src.getLogicalChannelFluor(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelFluor(logicalChannelFluorValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelIDValue = src.getLogicalChannelID(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelID(logicalChannelIDValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelIlluminationTypeValue = src.getLogicalChannelIlluminationType(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelIlluminationType(logicalChannelIlluminationTypeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelLightSourceValue = src.getLogicalChannelLightSource(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelLightSource(logicalChannelLightSourceValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelModeValue = src.getLogicalChannelMode(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelMode(logicalChannelModeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelNameValue = src.getLogicalChannelName(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelName(logicalChannelNameValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelNdFilterValue = src.getLogicalChannelNdFilter(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelNdFilter(logicalChannelNdFilterValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelOTFValue = src.getLogicalChannelOTF(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelOTF(logicalChannelOTFValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPhotometricInterpretationValue = src.getLogicalChannelPhotometricInterpretation(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPhotometricInterpretation(logicalChannelPhotometricInterpretationValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPinholeSizeValue = src.getLogicalChannelPinholeSize(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPinholeSize(logicalChannelPinholeSizeValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelPockelCellSettingValue = src.getLogicalChannelPockelCellSetting(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelPockelCellSetting(logicalChannelPockelCellSettingValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelSamplesPerPixelValue = src.getLogicalChannelSamplesPerPixel(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelSamplesPerPixel(logicalChannelSamplesPerPixelValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelSecondaryEmissionFilterValue = src.getLogicalChannelSecondaryEmissionFilter(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelSecondaryEmissionFilter(logicalChannelSecondaryEmissionFilterValue, imageIndex, logicalChannelIndex);
                }
                if ((logicalChannelSecondaryExcitationFilterValue = src.getLogicalChannelSecondaryExcitationFilter(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLogicalChannelSecondaryExcitationFilter(logicalChannelSecondaryExcitationFilterValue, imageIndex, logicalChannelIndex);
                }
                int channelComponentCount = src.getChannelComponentCount(imageIndex, logicalChannelIndex);
                for (int channelComponentIndex = 0; channelComponentIndex < channelComponentCount; ++channelComponentIndex) {
                    String channelComponentPixelsValue;
                    Integer channelComponentIndexValue;
                    String channelComponentColorDomainValue = src.getChannelComponentColorDomain(imageIndex, logicalChannelIndex, channelComponentIndex);
                    if (channelComponentColorDomainValue != null) {
                        dest.setChannelComponentColorDomain(channelComponentColorDomainValue, imageIndex, logicalChannelIndex, channelComponentIndex);
                    }
                    if ((channelComponentIndexValue = src.getChannelComponentIndex(imageIndex, logicalChannelIndex, channelComponentIndex)) != null) {
                        dest.setChannelComponentIndex(channelComponentIndexValue, imageIndex, logicalChannelIndex, channelComponentIndex);
                    }
                    if ((channelComponentPixelsValue = src.getChannelComponentPixels(imageIndex, logicalChannelIndex, channelComponentIndex)) == null) continue;
                    dest.setChannelComponentPixels(channelComponentPixelsValue, imageIndex, logicalChannelIndex, channelComponentIndex);
                }
                String detectorSettingsBinningValue = src.getDetectorSettingsBinning(imageIndex, logicalChannelIndex);
                if (detectorSettingsBinningValue != null) {
                    dest.setDetectorSettingsBinning(detectorSettingsBinningValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsDetectorValue = src.getDetectorSettingsDetector(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsDetector(detectorSettingsDetectorValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsGainValue = src.getDetectorSettingsGain(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsGain(detectorSettingsGainValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsOffsetValue = src.getDetectorSettingsOffset(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsOffset(detectorSettingsOffsetValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsReadOutRateValue = src.getDetectorSettingsReadOutRate(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsReadOutRate(detectorSettingsReadOutRateValue, imageIndex, logicalChannelIndex);
                }
                if ((detectorSettingsVoltageValue = src.getDetectorSettingsVoltage(imageIndex, logicalChannelIndex)) != null) {
                    dest.setDetectorSettingsVoltage(detectorSettingsVoltageValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsAttenuationValue = src.getLightSourceSettingsAttenuation(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLightSourceSettingsAttenuation(lightSourceSettingsAttenuationValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsLightSourceValue = src.getLightSourceSettingsLightSource(imageIndex, logicalChannelIndex)) != null) {
                    dest.setLightSourceSettingsLightSource(lightSourceSettingsLightSourceValue, imageIndex, logicalChannelIndex);
                }
                if ((lightSourceSettingsWavelengthValue = src.getLightSourceSettingsWavelength(imageIndex, logicalChannelIndex)) == null) continue;
                dest.setLightSourceSettingsWavelength(lightSourceSettingsWavelengthValue, imageIndex, logicalChannelIndex);
            }
            int microbeamManipulationCount = src.getMicrobeamManipulationCount(imageIndex);
            for (int microbeamManipulationIndex = 0; microbeamManipulationIndex < microbeamManipulationCount; ++microbeamManipulationIndex) {
                String microbeamManipulationTypeValue;
                String microbeamManipulationIDValue;
                String microbeamManipulationExperimenterRefValue = src.getMicrobeamManipulationExperimenterRef(imageIndex, microbeamManipulationIndex);
                if (microbeamManipulationExperimenterRefValue != null) {
                    dest.setMicrobeamManipulationExperimenterRef(microbeamManipulationExperimenterRefValue, imageIndex, microbeamManipulationIndex);
                }
                if ((microbeamManipulationIDValue = src.getMicrobeamManipulationID(imageIndex, microbeamManipulationIndex)) != null) {
                    dest.setMicrobeamManipulationID(microbeamManipulationIDValue, imageIndex, microbeamManipulationIndex);
                }
                if ((microbeamManipulationTypeValue = src.getMicrobeamManipulationType(imageIndex, microbeamManipulationIndex)) != null) {
                    dest.setMicrobeamManipulationType(microbeamManipulationTypeValue, imageIndex, microbeamManipulationIndex);
                }
                int lightSourceRefCount = src.getLightSourceRefCount(imageIndex, microbeamManipulationIndex);
                for (int lightSourceRefIndex = 0; lightSourceRefIndex < lightSourceRefCount; ++lightSourceRefIndex) {
                    Integer lightSourceRefWavelengthValue;
                    String lightSourceRefLightSourceValue;
                    Float lightSourceRefAttenuationValue = src.getLightSourceRefAttenuation(imageIndex, microbeamManipulationIndex, lightSourceRefIndex);
                    if (lightSourceRefAttenuationValue != null) {
                        dest.setLightSourceRefAttenuation(lightSourceRefAttenuationValue, imageIndex, microbeamManipulationIndex, lightSourceRefIndex);
                    }
                    if ((lightSourceRefLightSourceValue = src.getLightSourceRefLightSource(imageIndex, microbeamManipulationIndex, lightSourceRefIndex)) != null) {
                        dest.setLightSourceRefLightSource(lightSourceRefLightSourceValue, imageIndex, microbeamManipulationIndex, lightSourceRefIndex);
                    }
                    if ((lightSourceRefWavelengthValue = src.getLightSourceRefWavelength(imageIndex, microbeamManipulationIndex, lightSourceRefIndex)) == null) continue;
                    dest.setLightSourceRefWavelength(lightSourceRefWavelengthValue, imageIndex, microbeamManipulationIndex, lightSourceRefIndex);
                }
                int roiRefCount = src.getROIRefCount(imageIndex, microbeamManipulationIndex);
                for (int roiRefIndex = 0; roiRefIndex < roiRefCount; ++roiRefIndex) {
                    String roiRefIDValue = src.getROIRefID(imageIndex, microbeamManipulationIndex, roiRefIndex);
                    if (roiRefIDValue == null) continue;
                    dest.setROIRefID(roiRefIDValue, imageIndex, microbeamManipulationIndex, roiRefIndex);
                }
            }
            Float objectiveSettingsCorrectionCollarValue = src.getObjectiveSettingsCorrectionCollar(imageIndex);
            if (objectiveSettingsCorrectionCollarValue != null) {
                dest.setObjectiveSettingsCorrectionCollar(objectiveSettingsCorrectionCollarValue, imageIndex);
            }
            if ((objectiveSettingsMediumValue = src.getObjectiveSettingsMedium(imageIndex)) != null) {
                dest.setObjectiveSettingsMedium(objectiveSettingsMediumValue, imageIndex);
            }
            if ((objectiveSettingsObjectiveValue = src.getObjectiveSettingsObjective(imageIndex)) != null) {
                dest.setObjectiveSettingsObjective(objectiveSettingsObjectiveValue, imageIndex);
            }
            if ((objectiveSettingsRefractiveIndexValue = src.getObjectiveSettingsRefractiveIndex(imageIndex)) != null) {
                dest.setObjectiveSettingsRefractiveIndex(objectiveSettingsRefractiveIndexValue, imageIndex);
            }
            int pixelsCount = src.getPixelsCount(imageIndex);
            for (int pixelsIndex = 0; pixelsIndex < pixelsCount; ++pixelsIndex) {
                Integer pixelsSizeZValue;
                Integer pixelsSizeYValue;
                Integer pixelsSizeXValue;
                Integer pixelsSizeTValue;
                Integer pixelsSizeCValue;
                String pixelsPixelTypeValue;
                String pixelsIDValue;
                String pixelsDimensionOrderValue;
                Boolean pixelsBigEndianValue;
                Integer dimensionsWaveStartValue;
                Integer dimensionsWaveIncrementValue;
                Float dimensionsTimeIncrementValue;
                Float dimensionsPhysicalSizeZValue;
                Float dimensionsPhysicalSizeYValue;
                Float dimensionsPhysicalSizeXValue = src.getDimensionsPhysicalSizeX(imageIndex, pixelsIndex);
                if (dimensionsPhysicalSizeXValue != null) {
                    dest.setDimensionsPhysicalSizeX(dimensionsPhysicalSizeXValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsPhysicalSizeYValue = src.getDimensionsPhysicalSizeY(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsPhysicalSizeY(dimensionsPhysicalSizeYValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsPhysicalSizeZValue = src.getDimensionsPhysicalSizeZ(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsPhysicalSizeZ(dimensionsPhysicalSizeZValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsTimeIncrementValue = src.getDimensionsTimeIncrement(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsTimeIncrement(dimensionsTimeIncrementValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsWaveIncrementValue = src.getDimensionsWaveIncrement(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsWaveIncrement(dimensionsWaveIncrementValue, imageIndex, pixelsIndex);
                }
                if ((dimensionsWaveStartValue = src.getDimensionsWaveStart(imageIndex, pixelsIndex)) != null) {
                    dest.setDimensionsWaveStart(dimensionsWaveStartValue, imageIndex, pixelsIndex);
                }
                if ((pixelsBigEndianValue = src.getPixelsBigEndian(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsBigEndian(pixelsBigEndianValue, imageIndex, pixelsIndex);
                }
                if ((pixelsDimensionOrderValue = src.getPixelsDimensionOrder(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsDimensionOrder(pixelsDimensionOrderValue, imageIndex, pixelsIndex);
                }
                if ((pixelsIDValue = src.getPixelsID(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsID(pixelsIDValue, imageIndex, pixelsIndex);
                }
                if ((pixelsPixelTypeValue = src.getPixelsPixelType(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsPixelType(pixelsPixelTypeValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeCValue = src.getPixelsSizeC(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeC(pixelsSizeCValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeTValue = src.getPixelsSizeT(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeT(pixelsSizeTValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeXValue = src.getPixelsSizeX(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeX(pixelsSizeXValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeYValue = src.getPixelsSizeY(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeY(pixelsSizeYValue, imageIndex, pixelsIndex);
                }
                if ((pixelsSizeZValue = src.getPixelsSizeZ(imageIndex, pixelsIndex)) != null) {
                    dest.setPixelsSizeZ(pixelsSizeZValue, imageIndex, pixelsIndex);
                }
                int planeCount = src.getPlaneCount(imageIndex, pixelsIndex);
                for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                    Float stagePositionPositionZValue;
                    Float stagePositionPositionYValue;
                    Float stagePositionPositionXValue;
                    Float planeTimingExposureTimeValue;
                    Float planeTimingDeltaTValue;
                    Integer planeTheZValue;
                    Integer planeTheTValue;
                    Integer planeTheCValue;
                    String planeIDValue;
                    String planeHashSHA1Value = src.getPlaneHashSHA1(imageIndex, pixelsIndex, planeIndex);
                    if (planeHashSHA1Value != null) {
                        dest.setPlaneHashSHA1(planeHashSHA1Value, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeIDValue = src.getPlaneID(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneID(planeIDValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTheCValue = src.getPlaneTheC(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTheC(planeTheCValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTheTValue = src.getPlaneTheT(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTheT(planeTheTValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTheZValue = src.getPlaneTheZ(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTheZ(planeTheZValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTimingDeltaTValue = src.getPlaneTimingDeltaT(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTimingDeltaT(planeTimingDeltaTValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((planeTimingExposureTimeValue = src.getPlaneTimingExposureTime(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setPlaneTimingExposureTime(planeTimingExposureTimeValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionXValue = src.getStagePositionPositionX(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setStagePositionPositionX(stagePositionPositionXValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionYValue = src.getStagePositionPositionY(imageIndex, pixelsIndex, planeIndex)) != null) {
                        dest.setStagePositionPositionY(stagePositionPositionYValue, imageIndex, pixelsIndex, planeIndex);
                    }
                    if ((stagePositionPositionZValue = src.getStagePositionPositionZ(imageIndex, pixelsIndex, planeIndex)) == null) continue;
                    dest.setStagePositionPositionZ(stagePositionPositionZValue, imageIndex, pixelsIndex, planeIndex);
                }
                int tiffDataCount = src.getTiffDataCount(imageIndex, pixelsIndex);
                for (int tiffDataIndex = 0; tiffDataIndex < tiffDataCount; ++tiffDataIndex) {
                    String tiffDataUUIDValue;
                    Integer tiffDataNumPlanesValue;
                    Integer tiffDataIFDValue;
                    Integer tiffDataFirstZValue;
                    Integer tiffDataFirstTValue;
                    Integer tiffDataFirstCValue;
                    String tiffDataFileNameValue = src.getTiffDataFileName(imageIndex, pixelsIndex, tiffDataIndex);
                    if (tiffDataFileNameValue != null) {
                        dest.setTiffDataFileName(tiffDataFileNameValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstCValue = src.getTiffDataFirstC(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstC(tiffDataFirstCValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstTValue = src.getTiffDataFirstT(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstT(tiffDataFirstTValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataFirstZValue = src.getTiffDataFirstZ(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataFirstZ(tiffDataFirstZValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataIFDValue = src.getTiffDataIFD(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataIFD(tiffDataIFDValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataNumPlanesValue = src.getTiffDataNumPlanes(imageIndex, pixelsIndex, tiffDataIndex)) != null) {
                        dest.setTiffDataNumPlanes(tiffDataNumPlanesValue, imageIndex, pixelsIndex, tiffDataIndex);
                    }
                    if ((tiffDataUUIDValue = src.getTiffDataUUID(imageIndex, pixelsIndex, tiffDataIndex)) == null) continue;
                    dest.setTiffDataUUID(tiffDataUUIDValue, imageIndex, pixelsIndex, tiffDataIndex);
                }
            }
            int roiCount = src.getROICount(imageIndex);
            for (int roiIndex = 0; roiIndex < roiCount; ++roiIndex) {
                Integer roiZ1Value;
                Integer roiZ0Value;
                Integer roiY1Value;
                Integer roiY0Value;
                Integer roiX1Value;
                Integer roiX0Value;
                Integer roiT1Value;
                Integer roiT0Value;
                String roiidValue = src.getROIID(imageIndex, roiIndex);
                if (roiidValue != null) {
                    dest.setROIID(roiidValue, imageIndex, roiIndex);
                }
                if ((roiT0Value = src.getROIT0(imageIndex, roiIndex)) != null) {
                    dest.setROIT0(roiT0Value, imageIndex, roiIndex);
                }
                if ((roiT1Value = src.getROIT1(imageIndex, roiIndex)) != null) {
                    dest.setROIT1(roiT1Value, imageIndex, roiIndex);
                }
                if ((roiX0Value = src.getROIX0(imageIndex, roiIndex)) != null) {
                    dest.setROIX0(roiX0Value, imageIndex, roiIndex);
                }
                if ((roiX1Value = src.getROIX1(imageIndex, roiIndex)) != null) {
                    dest.setROIX1(roiX1Value, imageIndex, roiIndex);
                }
                if ((roiY0Value = src.getROIY0(imageIndex, roiIndex)) != null) {
                    dest.setROIY0(roiY0Value, imageIndex, roiIndex);
                }
                if ((roiY1Value = src.getROIY1(imageIndex, roiIndex)) != null) {
                    dest.setROIY1(roiY1Value, imageIndex, roiIndex);
                }
                if ((roiZ0Value = src.getROIZ0(imageIndex, roiIndex)) != null) {
                    dest.setROIZ0(roiZ0Value, imageIndex, roiIndex);
                }
                if ((roiZ1Value = src.getROIZ1(imageIndex, roiIndex)) != null) {
                    dest.setROIZ1(roiZ1Value, imageIndex, roiIndex);
                }
                int roiLinkCount = src.getRoiLinkCount(imageIndex, roiIndex);
                for (int roiLinkIndex = 0; roiLinkIndex < roiLinkCount; ++roiLinkIndex) {
                    String roiLinkRefValue;
                    String roiLinkNameValue;
                    String roiLinkDirectionValue = src.getRoiLinkDirection(imageIndex, roiIndex, roiLinkIndex);
                    if (roiLinkDirectionValue != null) {
                        dest.setRoiLinkDirection(roiLinkDirectionValue, imageIndex, roiIndex, roiLinkIndex);
                    }
                    if ((roiLinkNameValue = src.getRoiLinkName(imageIndex, roiIndex, roiLinkIndex)) != null) {
                        dest.setRoiLinkName(roiLinkNameValue, imageIndex, roiIndex, roiLinkIndex);
                    }
                    if ((roiLinkRefValue = src.getRoiLinkRef(imageIndex, roiIndex, roiLinkIndex)) == null) continue;
                    dest.setRoiLinkRef(roiLinkRefValue, imageIndex, roiIndex, roiLinkIndex);
                }
                int shapeCount = src.getShapeCount(imageIndex, roiIndex);
                for (int shapeIndex = 0; shapeIndex < shapeCount; ++shapeIndex) {
                    String rectYValue;
                    String rectXValue;
                    String rectWidthValue;
                    String rectTransformValue;
                    String rectIDValue;
                    String rectHeightValue;
                    String polylineTransformValue;
                    String polylinePointsValue;
                    String polylineIDValue;
                    String polygonTransformValue;
                    String polygonPointsValue;
                    String polygonIDValue;
                    String pointTransformValue;
                    String pointRValue;
                    String pointIDValue;
                    String pointCyValue;
                    String pointCxValue;
                    String pathIDValue;
                    String pathDValue;
                    Integer maskPixelsSizeYValue;
                    Integer maskPixelsSizeXValue;
                    String maskPixelsIDValue;
                    String maskPixelsExtendedPixelTypeValue;
                    String maskPixelsBinDataValue;
                    Boolean maskPixelsBigEndianValue;
                    String maskYValue;
                    String maskXValue;
                    String maskWidthValue;
                    String maskTransformValue;
                    String maskIDValue;
                    String maskHeightValue;
                    String lineY2Value;
                    String lineY1Value;
                    String lineX2Value;
                    String lineX1Value;
                    String lineTransformValue;
                    String lineIDValue;
                    String ellipseTransformValue;
                    String ellipseRyValue;
                    String ellipseRxValue;
                    String ellipseIDValue;
                    String ellipseCyValue;
                    String ellipseCxValue;
                    String circleTransformValue;
                    String circleRValue;
                    String circleIDValue;
                    String circleCyValue;
                    String circleCxValue;
                    String shapeWritingModeValue;
                    Boolean shapeVisibilityValue;
                    String shapeVectorEffectValue;
                    Integer shapeTheZValue;
                    Integer shapeTheTValue;
                    String shapeTextStrokeValue;
                    String shapeTextFillValue;
                    String shapeTextDecorationValue;
                    String shapeTextAnchorValue;
                    String shapeTextValue;
                    Integer shapeStrokeWidthValue;
                    Float shapeStrokeOpacityValue;
                    Integer shapeStrokeMiterLimitValue;
                    String shapeStrokeLineJoinValue;
                    String shapeStrokeLineCapValue;
                    String shapeStrokeDashArrayValue;
                    String shapeStrokeColorValue;
                    String shapeStrokeAttributeValue;
                    Boolean shapeLockedValue;
                    String shapeIDValue;
                    Integer shapeGlyphOrientationVerticalValue;
                    String shapeGValue;
                    String shapeFontWeightValue;
                    String shapeFontVariantValue;
                    String shapeFontStyleValue;
                    String shapeFontStretchValue;
                    Integer shapeFontSizeValue;
                    String shapeFontFamilyValue;
                    String shapeFillRuleValue;
                    String shapeFillOpacityValue;
                    String shapeFillColorValue;
                    String shapeDirectionValue;
                    String shapeBaselineShiftValue = src.getShapeBaselineShift(imageIndex, roiIndex, shapeIndex);
                    if (shapeBaselineShiftValue != null) {
                        dest.setShapeBaselineShift(shapeBaselineShiftValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeDirectionValue = src.getShapeDirection(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeDirection(shapeDirectionValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFillColorValue = src.getShapeFillColor(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFillColor(shapeFillColorValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFillOpacityValue = src.getShapeFillOpacity(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFillOpacity(shapeFillOpacityValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFillRuleValue = src.getShapeFillRule(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFillRule(shapeFillRuleValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontFamilyValue = src.getShapeFontFamily(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontFamily(shapeFontFamilyValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontSizeValue = src.getShapeFontSize(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontSize(shapeFontSizeValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontStretchValue = src.getShapeFontStretch(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontStretch(shapeFontStretchValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontStyleValue = src.getShapeFontStyle(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontStyle(shapeFontStyleValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontVariantValue = src.getShapeFontVariant(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontVariant(shapeFontVariantValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeFontWeightValue = src.getShapeFontWeight(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeFontWeight(shapeFontWeightValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeGValue = src.getShapeG(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeG(shapeGValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeGlyphOrientationVerticalValue = src.getShapeGlyphOrientationVertical(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeGlyphOrientationVertical(shapeGlyphOrientationVerticalValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeIDValue = src.getShapeID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeID(shapeIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeLockedValue = src.getShapeLocked(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeLocked(shapeLockedValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeAttributeValue = src.getShapeStrokeAttribute(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeAttribute(shapeStrokeAttributeValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeColorValue = src.getShapeStrokeColor(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeColor(shapeStrokeColorValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeDashArrayValue = src.getShapeStrokeDashArray(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeDashArray(shapeStrokeDashArrayValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeLineCapValue = src.getShapeStrokeLineCap(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeLineCap(shapeStrokeLineCapValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeLineJoinValue = src.getShapeStrokeLineJoin(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeLineJoin(shapeStrokeLineJoinValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeMiterLimitValue = src.getShapeStrokeMiterLimit(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeMiterLimit(shapeStrokeMiterLimitValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeOpacityValue = src.getShapeStrokeOpacity(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeOpacity(shapeStrokeOpacityValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeStrokeWidthValue = src.getShapeStrokeWidth(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeStrokeWidth(shapeStrokeWidthValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTextValue = src.getShapeText(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeText(shapeTextValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTextAnchorValue = src.getShapeTextAnchor(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTextAnchor(shapeTextAnchorValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTextDecorationValue = src.getShapeTextDecoration(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTextDecoration(shapeTextDecorationValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTextFillValue = src.getShapeTextFill(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTextFill(shapeTextFillValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTextStrokeValue = src.getShapeTextStroke(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTextStroke(shapeTextStrokeValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTheTValue = src.getShapeTheT(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTheT(shapeTheTValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeTheZValue = src.getShapeTheZ(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeTheZ(shapeTheZValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeVectorEffectValue = src.getShapeVectorEffect(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeVectorEffect(shapeVectorEffectValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeVisibilityValue = src.getShapeVisibility(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeVisibility(shapeVisibilityValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((shapeWritingModeValue = src.getShapeWritingMode(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setShapeWritingMode(shapeWritingModeValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((circleCxValue = src.getCircleCx(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setCircleCx(circleCxValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((circleCyValue = src.getCircleCy(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setCircleCy(circleCyValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((circleIDValue = src.getCircleID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setCircleID(circleIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((circleRValue = src.getCircleR(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setCircleR(circleRValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((circleTransformValue = src.getCircleTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setCircleTransform(circleTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseCxValue = src.getEllipseCx(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseCx(ellipseCxValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseCyValue = src.getEllipseCy(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseCy(ellipseCyValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseIDValue = src.getEllipseID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseID(ellipseIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseRxValue = src.getEllipseRx(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseRx(ellipseRxValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseRyValue = src.getEllipseRy(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseRy(ellipseRyValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((ellipseTransformValue = src.getEllipseTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setEllipseTransform(ellipseTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineIDValue = src.getLineID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineID(lineIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineTransformValue = src.getLineTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineTransform(lineTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineX1Value = src.getLineX1(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineX1(lineX1Value, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineX2Value = src.getLineX2(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineX2(lineX2Value, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineY1Value = src.getLineY1(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineY1(lineY1Value, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((lineY2Value = src.getLineY2(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setLineY2(lineY2Value, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskHeightValue = src.getMaskHeight(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskHeight(maskHeightValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskIDValue = src.getMaskID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskID(maskIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskTransformValue = src.getMaskTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskTransform(maskTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskWidthValue = src.getMaskWidth(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskWidth(maskWidthValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskXValue = src.getMaskX(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskX(maskXValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskYValue = src.getMaskY(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskY(maskYValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsBigEndianValue = src.getMaskPixelsBigEndian(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsBigEndian(maskPixelsBigEndianValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsBinDataValue = src.getMaskPixelsBinData(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsBinData(maskPixelsBinDataValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsExtendedPixelTypeValue = src.getMaskPixelsExtendedPixelType(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsExtendedPixelType(maskPixelsExtendedPixelTypeValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsIDValue = src.getMaskPixelsID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsID(maskPixelsIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsSizeXValue = src.getMaskPixelsSizeX(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsSizeX(maskPixelsSizeXValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((maskPixelsSizeYValue = src.getMaskPixelsSizeY(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setMaskPixelsSizeY(maskPixelsSizeYValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pathDValue = src.getPathD(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPathD(pathDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pathIDValue = src.getPathID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPathID(pathIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pointCxValue = src.getPointCx(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPointCx(pointCxValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pointCyValue = src.getPointCy(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPointCy(pointCyValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pointIDValue = src.getPointID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPointID(pointIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pointRValue = src.getPointR(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPointR(pointRValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((pointTransformValue = src.getPointTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPointTransform(pointTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polygonIDValue = src.getPolygonID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolygonID(polygonIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polygonPointsValue = src.getPolygonPoints(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolygonPoints(polygonPointsValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polygonTransformValue = src.getPolygonTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolygonTransform(polygonTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polylineIDValue = src.getPolylineID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolylineID(polylineIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polylinePointsValue = src.getPolylinePoints(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolylinePoints(polylinePointsValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((polylineTransformValue = src.getPolylineTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setPolylineTransform(polylineTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectHeightValue = src.getRectHeight(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setRectHeight(rectHeightValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectIDValue = src.getRectID(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setRectID(rectIDValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectTransformValue = src.getRectTransform(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setRectTransform(rectTransformValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectWidthValue = src.getRectWidth(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setRectWidth(rectWidthValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectXValue = src.getRectX(imageIndex, roiIndex, shapeIndex)) != null) {
                        dest.setRectX(rectXValue, imageIndex, roiIndex, shapeIndex);
                    }
                    if ((rectYValue = src.getRectY(imageIndex, roiIndex, shapeIndex)) == null) continue;
                    dest.setRectY(rectYValue, imageIndex, roiIndex, shapeIndex);
                }
            }
            int regionCount = src.getRegionCount(imageIndex);
            for (int regionIndex = 0; regionIndex < regionCount; ++regionIndex) {
                String regionTagValue;
                String regionNameValue;
                String regionIDValue = src.getRegionID(imageIndex, regionIndex);
                if (regionIDValue != null) {
                    dest.setRegionID(regionIDValue, imageIndex, regionIndex);
                }
                if ((regionNameValue = src.getRegionName(imageIndex, regionIndex)) != null) {
                    dest.setRegionName(regionNameValue, imageIndex, regionIndex);
                }
                if ((regionTagValue = src.getRegionTag(imageIndex, regionIndex)) == null) continue;
                dest.setRegionTag(regionTagValue, imageIndex, regionIndex);
            }
            String stageLabelNameValue = src.getStageLabelName(imageIndex);
            if (stageLabelNameValue != null) {
                dest.setStageLabelName(stageLabelNameValue, imageIndex);
            }
            if ((stageLabelXValue = src.getStageLabelX(imageIndex)) != null) {
                dest.setStageLabelX(stageLabelXValue, imageIndex);
            }
            if ((stageLabelYValue = src.getStageLabelY(imageIndex)) != null) {
                dest.setStageLabelY(stageLabelYValue, imageIndex);
            }
            if ((stageLabelZValue = src.getStageLabelZ(imageIndex)) != null) {
                dest.setStageLabelZ(stageLabelZValue, imageIndex);
            }
            if ((thumbnailHrefValue = src.getThumbnailHref(imageIndex)) != null) {
                dest.setThumbnailHref(thumbnailHrefValue, imageIndex);
            }
            if ((thumbnailIDValue = src.getThumbnailID(imageIndex)) != null) {
                dest.setThumbnailID(thumbnailIDValue, imageIndex);
            }
            if ((thumbnailMIMEtypeValue = src.getThumbnailMIMEtype(imageIndex)) == null) continue;
            dest.setThumbnailMIMEtype(thumbnailMIMEtypeValue, imageIndex);
        }
        int instrumentCount = src.getInstrumentCount();
        for (int instrumentIndex = 0; instrumentIndex < instrumentCount; ++instrumentIndex) {
            String microscopeTypeValue;
            String microscopeSerialNumberValue;
            String microscopeModelValue;
            String microscopeManufacturerValue;
            String instrumentIDValue = src.getInstrumentID(instrumentIndex);
            if (instrumentIDValue != null) {
                dest.setInstrumentID(instrumentIDValue, instrumentIndex);
            }
            int detectorCount = src.getDetectorCount(instrumentIndex);
            for (int detectorIndex = 0; detectorIndex < detectorCount; ++detectorIndex) {
                Float detectorZoomValue;
                Float detectorVoltageValue;
                String detectorTypeValue;
                String detectorSerialNumberValue;
                Float detectorOffsetValue;
                String detectorModelValue;
                String detectorManufacturerValue;
                String detectorIDValue;
                Float detectorGainValue;
                Float detectorAmplificationGainValue = src.getDetectorAmplificationGain(instrumentIndex, detectorIndex);
                if (detectorAmplificationGainValue != null) {
                    dest.setDetectorAmplificationGain(detectorAmplificationGainValue, instrumentIndex, detectorIndex);
                }
                if ((detectorGainValue = src.getDetectorGain(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorGain(detectorGainValue, instrumentIndex, detectorIndex);
                }
                if ((detectorIDValue = src.getDetectorID(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorID(detectorIDValue, instrumentIndex, detectorIndex);
                }
                if ((detectorManufacturerValue = src.getDetectorManufacturer(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorManufacturer(detectorManufacturerValue, instrumentIndex, detectorIndex);
                }
                if ((detectorModelValue = src.getDetectorModel(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorModel(detectorModelValue, instrumentIndex, detectorIndex);
                }
                if ((detectorOffsetValue = src.getDetectorOffset(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorOffset(detectorOffsetValue, instrumentIndex, detectorIndex);
                }
                if ((detectorSerialNumberValue = src.getDetectorSerialNumber(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorSerialNumber(detectorSerialNumberValue, instrumentIndex, detectorIndex);
                }
                if ((detectorTypeValue = src.getDetectorType(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorType(detectorTypeValue, instrumentIndex, detectorIndex);
                }
                if ((detectorVoltageValue = src.getDetectorVoltage(instrumentIndex, detectorIndex)) != null) {
                    dest.setDetectorVoltage(detectorVoltageValue, instrumentIndex, detectorIndex);
                }
                if ((detectorZoomValue = src.getDetectorZoom(instrumentIndex, detectorIndex)) == null) continue;
                dest.setDetectorZoom(detectorZoomValue, instrumentIndex, detectorIndex);
            }
            int dichroicCount = src.getDichroicCount(instrumentIndex);
            for (int dichroicIndex = 0; dichroicIndex < dichroicCount; ++dichroicIndex) {
                String dichroicModelValue;
                String dichroicManufacturerValue;
                String dichroicLotNumberValue;
                String dichroicIDValue = src.getDichroicID(instrumentIndex, dichroicIndex);
                if (dichroicIDValue != null) {
                    dest.setDichroicID(dichroicIDValue, instrumentIndex, dichroicIndex);
                }
                if ((dichroicLotNumberValue = src.getDichroicLotNumber(instrumentIndex, dichroicIndex)) != null) {
                    dest.setDichroicLotNumber(dichroicLotNumberValue, instrumentIndex, dichroicIndex);
                }
                if ((dichroicManufacturerValue = src.getDichroicManufacturer(instrumentIndex, dichroicIndex)) != null) {
                    dest.setDichroicManufacturer(dichroicManufacturerValue, instrumentIndex, dichroicIndex);
                }
                if ((dichroicModelValue = src.getDichroicModel(instrumentIndex, dichroicIndex)) == null) continue;
                dest.setDichroicModel(dichroicModelValue, instrumentIndex, dichroicIndex);
            }
            int filterCount = src.getFilterCount(instrumentIndex);
            for (int filterIndex = 0; filterIndex < filterCount; ++filterIndex) {
                Integer transmittanceRangeTransmittanceValue;
                Integer transmittanceRangeCutOutToleranceValue;
                Integer transmittanceRangeCutOutValue;
                Integer transmittanceRangeCutInToleranceValue;
                Integer transmittanceRangeCutInValue;
                String exFilterTypeValue;
                String exFilterModelValue;
                String exFilterManufacturerValue;
                String exFilterLotNumberValue;
                String emFilterTypeValue;
                String emFilterModelValue;
                String emFilterManufacturerValue;
                String emFilterLotNumberValue;
                String filterTypeValue;
                String filterModelValue;
                String filterManufacturerValue;
                String filterLotNumberValue;
                String filterIDValue;
                String filterFilterWheelValue = src.getFilterFilterWheel(instrumentIndex, filterIndex);
                if (filterFilterWheelValue != null) {
                    dest.setFilterFilterWheel(filterFilterWheelValue, instrumentIndex, filterIndex);
                }
                if ((filterIDValue = src.getFilterID(instrumentIndex, filterIndex)) != null) {
                    dest.setFilterID(filterIDValue, instrumentIndex, filterIndex);
                }
                if ((filterLotNumberValue = src.getFilterLotNumber(instrumentIndex, filterIndex)) != null) {
                    dest.setFilterLotNumber(filterLotNumberValue, instrumentIndex, filterIndex);
                }
                if ((filterManufacturerValue = src.getFilterManufacturer(instrumentIndex, filterIndex)) != null) {
                    dest.setFilterManufacturer(filterManufacturerValue, instrumentIndex, filterIndex);
                }
                if ((filterModelValue = src.getFilterModel(instrumentIndex, filterIndex)) != null) {
                    dest.setFilterModel(filterModelValue, instrumentIndex, filterIndex);
                }
                if ((filterTypeValue = src.getFilterType(instrumentIndex, filterIndex)) != null) {
                    dest.setFilterType(filterTypeValue, instrumentIndex, filterIndex);
                }
                if ((emFilterLotNumberValue = src.getEmFilterLotNumber(instrumentIndex, filterIndex)) != null) {
                    dest.setEmFilterLotNumber(emFilterLotNumberValue, instrumentIndex, filterIndex);
                }
                if ((emFilterManufacturerValue = src.getEmFilterManufacturer(instrumentIndex, filterIndex)) != null) {
                    dest.setEmFilterManufacturer(emFilterManufacturerValue, instrumentIndex, filterIndex);
                }
                if ((emFilterModelValue = src.getEmFilterModel(instrumentIndex, filterIndex)) != null) {
                    dest.setEmFilterModel(emFilterModelValue, instrumentIndex, filterIndex);
                }
                if ((emFilterTypeValue = src.getEmFilterType(instrumentIndex, filterIndex)) != null) {
                    dest.setEmFilterType(emFilterTypeValue, instrumentIndex, filterIndex);
                }
                if ((exFilterLotNumberValue = src.getExFilterLotNumber(instrumentIndex, filterIndex)) != null) {
                    dest.setExFilterLotNumber(exFilterLotNumberValue, instrumentIndex, filterIndex);
                }
                if ((exFilterManufacturerValue = src.getExFilterManufacturer(instrumentIndex, filterIndex)) != null) {
                    dest.setExFilterManufacturer(exFilterManufacturerValue, instrumentIndex, filterIndex);
                }
                if ((exFilterModelValue = src.getExFilterModel(instrumentIndex, filterIndex)) != null) {
                    dest.setExFilterModel(exFilterModelValue, instrumentIndex, filterIndex);
                }
                if ((exFilterTypeValue = src.getExFilterType(instrumentIndex, filterIndex)) != null) {
                    dest.setExFilterType(exFilterTypeValue, instrumentIndex, filterIndex);
                }
                if ((transmittanceRangeCutInValue = src.getTransmittanceRangeCutIn(instrumentIndex, filterIndex)) != null) {
                    dest.setTransmittanceRangeCutIn(transmittanceRangeCutInValue, instrumentIndex, filterIndex);
                }
                if ((transmittanceRangeCutInToleranceValue = src.getTransmittanceRangeCutInTolerance(instrumentIndex, filterIndex)) != null) {
                    dest.setTransmittanceRangeCutInTolerance(transmittanceRangeCutInToleranceValue, instrumentIndex, filterIndex);
                }
                if ((transmittanceRangeCutOutValue = src.getTransmittanceRangeCutOut(instrumentIndex, filterIndex)) != null) {
                    dest.setTransmittanceRangeCutOut(transmittanceRangeCutOutValue, instrumentIndex, filterIndex);
                }
                if ((transmittanceRangeCutOutToleranceValue = src.getTransmittanceRangeCutOutTolerance(instrumentIndex, filterIndex)) != null) {
                    dest.setTransmittanceRangeCutOutTolerance(transmittanceRangeCutOutToleranceValue, instrumentIndex, filterIndex);
                }
                if ((transmittanceRangeTransmittanceValue = src.getTransmittanceRangeTransmittance(instrumentIndex, filterIndex)) == null) continue;
                dest.setTransmittanceRangeTransmittance(transmittanceRangeTransmittanceValue, instrumentIndex, filterIndex);
            }
            int filterSetCount = src.getFilterSetCount(instrumentIndex);
            for (int filterSetIndex = 0; filterSetIndex < filterSetCount; ++filterSetIndex) {
                String filterSetModelValue;
                String filterSetManufacturerValue;
                String filterSetLotNumberValue;
                String filterSetIDValue;
                String filterSetExFilterValue;
                String filterSetEmFilterValue;
                String filterSetDichroicValue = src.getFilterSetDichroic(instrumentIndex, filterSetIndex);
                if (filterSetDichroicValue != null) {
                    dest.setFilterSetDichroic(filterSetDichroicValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetEmFilterValue = src.getFilterSetEmFilter(instrumentIndex, filterSetIndex)) != null) {
                    dest.setFilterSetEmFilter(filterSetEmFilterValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetExFilterValue = src.getFilterSetExFilter(instrumentIndex, filterSetIndex)) != null) {
                    dest.setFilterSetExFilter(filterSetExFilterValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetIDValue = src.getFilterSetID(instrumentIndex, filterSetIndex)) != null) {
                    dest.setFilterSetID(filterSetIDValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetLotNumberValue = src.getFilterSetLotNumber(instrumentIndex, filterSetIndex)) != null) {
                    dest.setFilterSetLotNumber(filterSetLotNumberValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetManufacturerValue = src.getFilterSetManufacturer(instrumentIndex, filterSetIndex)) != null) {
                    dest.setFilterSetManufacturer(filterSetManufacturerValue, instrumentIndex, filterSetIndex);
                }
                if ((filterSetModelValue = src.getFilterSetModel(instrumentIndex, filterSetIndex)) == null) continue;
                dest.setFilterSetModel(filterSetModelValue, instrumentIndex, filterSetIndex);
            }
            int lightSourceCount = src.getLightSourceCount(instrumentIndex);
            for (int lightSourceIndex = 0; lightSourceIndex < lightSourceCount; ++lightSourceIndex) {
                String pumpLightSourceValue;
                Integer laserWavelengthValue;
                String laserTypeValue;
                Boolean laserTuneableValue;
                Boolean laserRepetitionRateValue;
                String laserPulseValue;
                Boolean laserPockelCellValue;
                String laserLaserMediumValue;
                Integer laserFrequencyMultiplicationValue;
                String filamentTypeValue;
                String arcTypeValue;
                String lightSourceSerialNumberValue;
                Float lightSourcePowerValue;
                String lightSourceModelValue;
                String lightSourceManufacturerValue;
                String lightSourceIDValue = src.getLightSourceID(instrumentIndex, lightSourceIndex);
                if (lightSourceIDValue != null) {
                    dest.setLightSourceID(lightSourceIDValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceManufacturerValue = src.getLightSourceManufacturer(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceManufacturer(lightSourceManufacturerValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceModelValue = src.getLightSourceModel(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceModel(lightSourceModelValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourcePowerValue = src.getLightSourcePower(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourcePower(lightSourcePowerValue, instrumentIndex, lightSourceIndex);
                }
                if ((lightSourceSerialNumberValue = src.getLightSourceSerialNumber(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLightSourceSerialNumber(lightSourceSerialNumberValue, instrumentIndex, lightSourceIndex);
                }
                if ((arcTypeValue = src.getArcType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setArcType(arcTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((filamentTypeValue = src.getFilamentType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setFilamentType(filamentTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserFrequencyMultiplicationValue = src.getLaserFrequencyMultiplication(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserFrequencyMultiplication(laserFrequencyMultiplicationValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserLaserMediumValue = src.getLaserLaserMedium(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserLaserMedium(laserLaserMediumValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserPockelCellValue = src.getLaserPockelCell(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserPockelCell(laserPockelCellValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserPulseValue = src.getLaserPulse(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserPulse(laserPulseValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserRepetitionRateValue = src.getLaserRepetitionRate(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserRepetitionRate(laserRepetitionRateValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserTuneableValue = src.getLaserTuneable(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserTuneable(laserTuneableValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserTypeValue = src.getLaserType(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserType(laserTypeValue, instrumentIndex, lightSourceIndex);
                }
                if ((laserWavelengthValue = src.getLaserWavelength(instrumentIndex, lightSourceIndex)) != null) {
                    dest.setLaserWavelength(laserWavelengthValue, instrumentIndex, lightSourceIndex);
                }
                if ((pumpLightSourceValue = src.getPumpLightSource(instrumentIndex, lightSourceIndex)) == null) continue;
                dest.setPumpLightSource(pumpLightSourceValue, instrumentIndex, lightSourceIndex);
            }
            String microscopeIDValue = src.getMicroscopeID(instrumentIndex);
            if (microscopeIDValue != null) {
                dest.setMicroscopeID(microscopeIDValue, instrumentIndex);
            }
            if ((microscopeManufacturerValue = src.getMicroscopeManufacturer(instrumentIndex)) != null) {
                dest.setMicroscopeManufacturer(microscopeManufacturerValue, instrumentIndex);
            }
            if ((microscopeModelValue = src.getMicroscopeModel(instrumentIndex)) != null) {
                dest.setMicroscopeModel(microscopeModelValue, instrumentIndex);
            }
            if ((microscopeSerialNumberValue = src.getMicroscopeSerialNumber(instrumentIndex)) != null) {
                dest.setMicroscopeSerialNumber(microscopeSerialNumberValue, instrumentIndex);
            }
            if ((microscopeTypeValue = src.getMicroscopeType(instrumentIndex)) != null) {
                dest.setMicroscopeType(microscopeTypeValue, instrumentIndex);
            }
            int otfCount = src.getOTFCount(instrumentIndex);
            for (int otfIndex = 0; otfIndex < otfCount; ++otfIndex) {
                Integer otfSizeYValue;
                Integer otfSizeXValue;
                String otfPixelTypeValue;
                Boolean otfOpticalAxisAveragedValue;
                String otfObjectiveValue;
                String otfidValue;
                String otfBinaryFileValue = src.getOTFBinaryFile(instrumentIndex, otfIndex);
                if (otfBinaryFileValue != null) {
                    dest.setOTFBinaryFile(otfBinaryFileValue, instrumentIndex, otfIndex);
                }
                if ((otfidValue = src.getOTFID(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFID(otfidValue, instrumentIndex, otfIndex);
                }
                if ((otfObjectiveValue = src.getOTFObjective(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFObjective(otfObjectiveValue, instrumentIndex, otfIndex);
                }
                if ((otfOpticalAxisAveragedValue = src.getOTFOpticalAxisAveraged(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFOpticalAxisAveraged(otfOpticalAxisAveragedValue, instrumentIndex, otfIndex);
                }
                if ((otfPixelTypeValue = src.getOTFPixelType(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFPixelType(otfPixelTypeValue, instrumentIndex, otfIndex);
                }
                if ((otfSizeXValue = src.getOTFSizeX(instrumentIndex, otfIndex)) != null) {
                    dest.setOTFSizeX(otfSizeXValue, instrumentIndex, otfIndex);
                }
                if ((otfSizeYValue = src.getOTFSizeY(instrumentIndex, otfIndex)) == null) continue;
                dest.setOTFSizeY(otfSizeYValue, instrumentIndex, otfIndex);
            }
            int objectiveCount = src.getObjectiveCount(instrumentIndex);
            for (int objectiveIndex = 0; objectiveIndex < objectiveCount; ++objectiveIndex) {
                Float objectiveWorkingDistanceValue;
                String objectiveSerialNumberValue;
                Integer objectiveNominalMagnificationValue;
                String objectiveModelValue;
                String objectiveManufacturerValue;
                Float objectiveLensNAValue;
                Boolean objectiveIrisValue;
                String objectiveImmersionValue;
                String objectiveIDValue;
                String objectiveCorrectionValue;
                Float objectiveCalibratedMagnificationValue = src.getObjectiveCalibratedMagnification(instrumentIndex, objectiveIndex);
                if (objectiveCalibratedMagnificationValue != null) {
                    dest.setObjectiveCalibratedMagnification(objectiveCalibratedMagnificationValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveCorrectionValue = src.getObjectiveCorrection(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveCorrection(objectiveCorrectionValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveIDValue = src.getObjectiveID(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveID(objectiveIDValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveImmersionValue = src.getObjectiveImmersion(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveImmersion(objectiveImmersionValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveIrisValue = src.getObjectiveIris(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveIris(objectiveIrisValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveLensNAValue = src.getObjectiveLensNA(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveLensNA(objectiveLensNAValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveManufacturerValue = src.getObjectiveManufacturer(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveManufacturer(objectiveManufacturerValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveModelValue = src.getObjectiveModel(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveModel(objectiveModelValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveNominalMagnificationValue = src.getObjectiveNominalMagnification(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveNominalMagnification(objectiveNominalMagnificationValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveSerialNumberValue = src.getObjectiveSerialNumber(instrumentIndex, objectiveIndex)) != null) {
                    dest.setObjectiveSerialNumber(objectiveSerialNumberValue, instrumentIndex, objectiveIndex);
                }
                if ((objectiveWorkingDistanceValue = src.getObjectiveWorkingDistance(instrumentIndex, objectiveIndex)) == null) continue;
                dest.setObjectiveWorkingDistance(objectiveWorkingDistanceValue, instrumentIndex, objectiveIndex);
            }
        }
        int plateCount = src.getPlateCount();
        for (int plateIndex = 0; plateIndex < plateCount; ++plateIndex) {
            Double plateWellOriginYValue;
            Double plateWellOriginXValue;
            String plateStatusValue;
            String plateRowNamingConventionValue;
            String plateNameValue;
            String plateIDValue;
            String plateExternalIdentifierValue;
            String plateDescriptionValue;
            String plateColumnNamingConventionValue = src.getPlateColumnNamingConvention(plateIndex);
            if (plateColumnNamingConventionValue != null) {
                dest.setPlateColumnNamingConvention(plateColumnNamingConventionValue, plateIndex);
            }
            if ((plateDescriptionValue = src.getPlateDescription(plateIndex)) != null) {
                dest.setPlateDescription(plateDescriptionValue, plateIndex);
            }
            if ((plateExternalIdentifierValue = src.getPlateExternalIdentifier(plateIndex)) != null) {
                dest.setPlateExternalIdentifier(plateExternalIdentifierValue, plateIndex);
            }
            if ((plateIDValue = src.getPlateID(plateIndex)) != null) {
                dest.setPlateID(plateIDValue, plateIndex);
            }
            if ((plateNameValue = src.getPlateName(plateIndex)) != null) {
                dest.setPlateName(plateNameValue, plateIndex);
            }
            if ((plateRowNamingConventionValue = src.getPlateRowNamingConvention(plateIndex)) != null) {
                dest.setPlateRowNamingConvention(plateRowNamingConventionValue, plateIndex);
            }
            if ((plateStatusValue = src.getPlateStatus(plateIndex)) != null) {
                dest.setPlateStatus(plateStatusValue, plateIndex);
            }
            if ((plateWellOriginXValue = src.getPlateWellOriginX(plateIndex)) != null) {
                dest.setPlateWellOriginX(plateWellOriginXValue, plateIndex);
            }
            if ((plateWellOriginYValue = src.getPlateWellOriginY(plateIndex)) != null) {
                dest.setPlateWellOriginY(plateWellOriginYValue, plateIndex);
            }
            int screenRefCount = src.getScreenRefCount(plateIndex);
            for (int screenRefIndex = 0; screenRefIndex < screenRefCount; ++screenRefIndex) {
                String screenRefIDValue = src.getScreenRefID(plateIndex, screenRefIndex);
                if (screenRefIDValue == null) continue;
                dest.setScreenRefID(screenRefIDValue, plateIndex, screenRefIndex);
            }
            int wellCount = src.getWellCount(plateIndex);
            for (int wellIndex = 0; wellIndex < wellCount; ++wellIndex) {
                String wellTypeValue;
                Integer wellRowValue;
                String wellReagentValue;
                String wellIDValue;
                String wellExternalIdentifierValue;
                String wellExternalDescriptionValue;
                Integer wellColumnValue = src.getWellColumn(plateIndex, wellIndex);
                if (wellColumnValue != null) {
                    dest.setWellColumn(wellColumnValue, plateIndex, wellIndex);
                }
                if ((wellExternalDescriptionValue = src.getWellExternalDescription(plateIndex, wellIndex)) != null) {
                    dest.setWellExternalDescription(wellExternalDescriptionValue, plateIndex, wellIndex);
                }
                if ((wellExternalIdentifierValue = src.getWellExternalIdentifier(plateIndex, wellIndex)) != null) {
                    dest.setWellExternalIdentifier(wellExternalIdentifierValue, plateIndex, wellIndex);
                }
                if ((wellIDValue = src.getWellID(plateIndex, wellIndex)) != null) {
                    dest.setWellID(wellIDValue, plateIndex, wellIndex);
                }
                if ((wellReagentValue = src.getWellReagent(plateIndex, wellIndex)) != null) {
                    dest.setWellReagent(wellReagentValue, plateIndex, wellIndex);
                }
                if ((wellRowValue = src.getWellRow(plateIndex, wellIndex)) != null) {
                    dest.setWellRow(wellRowValue, plateIndex, wellIndex);
                }
                if ((wellTypeValue = src.getWellType(plateIndex, wellIndex)) != null) {
                    dest.setWellType(wellTypeValue, plateIndex, wellIndex);
                }
                int wellSampleCount = src.getWellSampleCount(plateIndex, wellIndex);
                for (int wellSampleIndex = 0; wellSampleIndex < wellSampleCount; ++wellSampleIndex) {
                    Integer wellSampleTimepointValue;
                    Float wellSamplePosYValue;
                    Float wellSamplePosXValue;
                    Integer wellSampleIndexValue;
                    String wellSampleImageRefValue;
                    String wellSampleIDValue = src.getWellSampleID(plateIndex, wellIndex, wellSampleIndex);
                    if (wellSampleIDValue != null) {
                        dest.setWellSampleID(wellSampleIDValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSampleImageRefValue = src.getWellSampleImageRef(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSampleImageRef(wellSampleImageRefValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSampleIndexValue = src.getWellSampleIndex(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSampleIndex(wellSampleIndexValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSamplePosXValue = src.getWellSamplePosX(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSamplePosX(wellSamplePosXValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSamplePosYValue = src.getWellSamplePosY(plateIndex, wellIndex, wellSampleIndex)) != null) {
                        dest.setWellSamplePosY(wellSamplePosYValue, plateIndex, wellIndex, wellSampleIndex);
                    }
                    if ((wellSampleTimepointValue = src.getWellSampleTimepoint(plateIndex, wellIndex, wellSampleIndex)) == null) continue;
                    dest.setWellSampleTimepoint(wellSampleTimepointValue, plateIndex, wellIndex, wellSampleIndex);
                }
            }
        }
        int projectCount = src.getProjectCount();
        for (int projectIndex = 0; projectIndex < projectCount; ++projectIndex) {
            String projectNameValue;
            String projectIDValue;
            String projectGroupRefValue;
            String projectExperimenterRefValue;
            String projectDescriptionValue = src.getProjectDescription(projectIndex);
            if (projectDescriptionValue != null) {
                dest.setProjectDescription(projectDescriptionValue, projectIndex);
            }
            if ((projectExperimenterRefValue = src.getProjectExperimenterRef(projectIndex)) != null) {
                dest.setProjectExperimenterRef(projectExperimenterRefValue, projectIndex);
            }
            if ((projectGroupRefValue = src.getProjectGroupRef(projectIndex)) != null) {
                dest.setProjectGroupRef(projectGroupRefValue, projectIndex);
            }
            if ((projectIDValue = src.getProjectID(projectIndex)) != null) {
                dest.setProjectID(projectIDValue, projectIndex);
            }
            if ((projectNameValue = src.getProjectName(projectIndex)) == null) continue;
            dest.setProjectName(projectNameValue, projectIndex);
        }
        int screenCount = src.getScreenCount();
        for (int screenIndex = 0; screenIndex < screenCount; ++screenIndex) {
            String screenTypeValue;
            String screenReagentSetIdentifierValue;
            String screenReagentSetDescriptionValue;
            String screenProtocolIdentifierValue;
            String screenProtocolDescriptionValue;
            String screenNameValue;
            String screenIDValue;
            String screenExternValue;
            String screenDescriptionValue = src.getScreenDescription(screenIndex);
            if (screenDescriptionValue != null) {
                dest.setScreenDescription(screenDescriptionValue, screenIndex);
            }
            if ((screenExternValue = src.getScreenExtern(screenIndex)) != null) {
                dest.setScreenExtern(screenExternValue, screenIndex);
            }
            if ((screenIDValue = src.getScreenID(screenIndex)) != null) {
                dest.setScreenID(screenIDValue, screenIndex);
            }
            if ((screenNameValue = src.getScreenName(screenIndex)) != null) {
                dest.setScreenName(screenNameValue, screenIndex);
            }
            if ((screenProtocolDescriptionValue = src.getScreenProtocolDescription(screenIndex)) != null) {
                dest.setScreenProtocolDescription(screenProtocolDescriptionValue, screenIndex);
            }
            if ((screenProtocolIdentifierValue = src.getScreenProtocolIdentifier(screenIndex)) != null) {
                dest.setScreenProtocolIdentifier(screenProtocolIdentifierValue, screenIndex);
            }
            if ((screenReagentSetDescriptionValue = src.getScreenReagentSetDescription(screenIndex)) != null) {
                dest.setScreenReagentSetDescription(screenReagentSetDescriptionValue, screenIndex);
            }
            if ((screenReagentSetIdentifierValue = src.getScreenReagentSetIdentifier(screenIndex)) != null) {
                dest.setScreenReagentSetIdentifier(screenReagentSetIdentifierValue, screenIndex);
            }
            if ((screenTypeValue = src.getScreenType(screenIndex)) != null) {
                dest.setScreenType(screenTypeValue, screenIndex);
            }
            int plateRefCount = src.getPlateRefCount(screenIndex);
            for (int plateRefIndex = 0; plateRefIndex < plateRefCount; ++plateRefIndex) {
                String plateRefWellValue;
                Integer plateRefSampleValue;
                String plateRefIDValue = src.getPlateRefID(screenIndex, plateRefIndex);
                if (plateRefIDValue != null) {
                    dest.setPlateRefID(plateRefIDValue, screenIndex, plateRefIndex);
                }
                if ((plateRefSampleValue = src.getPlateRefSample(screenIndex, plateRefIndex)) != null) {
                    dest.setPlateRefSample(plateRefSampleValue, screenIndex, plateRefIndex);
                }
                if ((plateRefWellValue = src.getPlateRefWell(screenIndex, plateRefIndex)) == null) continue;
                dest.setPlateRefWell(plateRefWellValue, screenIndex, plateRefIndex);
            }
            int reagentCount = src.getReagentCount(screenIndex);
            for (int reagentIndex = 0; reagentIndex < reagentCount; ++reagentIndex) {
                String reagentReagentIdentifierValue;
                String reagentNameValue;
                String reagentIDValue;
                String reagentDescriptionValue = src.getReagentDescription(screenIndex, reagentIndex);
                if (reagentDescriptionValue != null) {
                    dest.setReagentDescription(reagentDescriptionValue, screenIndex, reagentIndex);
                }
                if ((reagentIDValue = src.getReagentID(screenIndex, reagentIndex)) != null) {
                    dest.setReagentID(reagentIDValue, screenIndex, reagentIndex);
                }
                if ((reagentNameValue = src.getReagentName(screenIndex, reagentIndex)) != null) {
                    dest.setReagentName(reagentNameValue, screenIndex, reagentIndex);
                }
                if ((reagentReagentIdentifierValue = src.getReagentReagentIdentifier(screenIndex, reagentIndex)) == null) continue;
                dest.setReagentReagentIdentifier(reagentReagentIdentifierValue, screenIndex, reagentIndex);
            }
            int screenAcquisitionCount = src.getScreenAcquisitionCount(screenIndex);
            for (int screenAcquisitionIndex = 0; screenAcquisitionIndex < screenAcquisitionCount; ++screenAcquisitionIndex) {
                String screenAcquisitionStartTimeValue;
                String screenAcquisitionIDValue;
                String screenAcquisitionEndTimeValue = src.getScreenAcquisitionEndTime(screenIndex, screenAcquisitionIndex);
                if (screenAcquisitionEndTimeValue != null) {
                    dest.setScreenAcquisitionEndTime(screenAcquisitionEndTimeValue, screenIndex, screenAcquisitionIndex);
                }
                if ((screenAcquisitionIDValue = src.getScreenAcquisitionID(screenIndex, screenAcquisitionIndex)) != null) {
                    dest.setScreenAcquisitionID(screenAcquisitionIDValue, screenIndex, screenAcquisitionIndex);
                }
                if ((screenAcquisitionStartTimeValue = src.getScreenAcquisitionStartTime(screenIndex, screenAcquisitionIndex)) != null) {
                    dest.setScreenAcquisitionStartTime(screenAcquisitionStartTimeValue, screenIndex, screenAcquisitionIndex);
                }
                int wellSampleRefCount = src.getWellSampleRefCount(screenIndex, screenAcquisitionIndex);
                for (int wellSampleRefIndex = 0; wellSampleRefIndex < wellSampleRefCount; ++wellSampleRefIndex) {
                    String wellSampleRefIDValue = src.getWellSampleRefID(screenIndex, screenAcquisitionIndex, wellSampleRefIndex);
                    if (wellSampleRefIDValue == null) continue;
                    dest.setWellSampleRefID(wellSampleRefIDValue, screenIndex, screenAcquisitionIndex, wellSampleRefIndex);
                }
            }
        }
    }
}

