/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.XMLTools;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphTiffReader
extends BaseTiffReader {
    public MetamorphTiffReader() {
        super("Metamorph TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return comment.trim().startsWith("<MetaData>");
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        this.debug("MetamorphTiffReader.initFile(" + id + ")");
        super.initFile(id);
        String[] comments = new String[this.ifds.size()];
        MetamorphHandler handler = new MetamorphHandler(this.getGlobalMetadata());
        for (int i2 = 0; i2 < comments.length; ++i2) {
            comments[i2] = ((IFD)this.ifds.get(i2)).getComment();
            XMLTools.parseXML(comments[i2], (DefaultHandler)handler);
        }
        this.core[0].sizeC = 0;
        Vector<String> timestamps = handler.getTimestamps();
        Vector<Integer> wavelengths = handler.getWavelengths();
        Vector<Float> zPositions = handler.getZPositions();
        Vector<Float> exposures = handler.getExposures();
        Vector<Integer> uniqueC = new Vector<Integer>();
        for (int i3 = 0; i3 < wavelengths.size(); ++i3) {
            Integer c = wavelengths.get(i3);
            if (uniqueC.contains(c)) continue;
            uniqueC.add(c);
        }
        this.core[0].sizeC = uniqueC.size();
        Vector<Float> uniqueZ = new Vector<Float>();
        for (int i4 = 0; i4 < zPositions.size(); ++i4) {
            Float z = zPositions.get(i4);
            if (uniqueZ.contains(z)) continue;
            uniqueZ.add(z);
        }
        this.core[0].sizeZ = uniqueZ.size();
        this.core[0].sizeT = this.ifds.size() / (this.getSizeZ() * this.getSizeC());
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setImageName(handler.getImageName(), 0);
        store.setImageDescription("", 0);
        String parse = "yyyyMMdd HH:mm:ss.SSS";
        for (i = 0; i < timestamps.size(); ++i) {
            long timestamp = DateTools.getTime(timestamps.get(i), parse);
            this.addGlobalMeta("timestamp " + i, timestamp);
        }
        for (i = 0; i < exposures.size(); ++i) {
            this.addGlobalMeta("exposure time " + i + " (ms)", exposures.get(i).floatValue() * 1000.0f);
        }
        long startDate = 0L;
        if (timestamps.size() > 0) {
            startDate = DateTools.getTime(timestamps.get(0), parse);
        }
        for (int i5 = 0; i5 < this.getImageCount(); ++i5) {
            int[] coords = this.getZCTCoords(i5);
            if (coords[2] < timestamps.size()) {
                String stamp = timestamps.get(coords[2]);
                long ms = DateTools.getTime(stamp, parse);
                store.setPlaneTimingDeltaT(new Float((float)(ms - startDate) / 1000.0f), 0, 0, i5);
            }
            if (i5 >= exposures.size()) continue;
            store.setPlaneTimingExposureTime(exposures.get(i5), 0, 0, i5);
        }
        String date = DateTools.formatDate(handler.getDate(), "yyyy-MM-dd'T'HH:mm:ss");
        store.setImageCreationDate(date, 0);
        store.setImagingEnvironmentTemperature(new Float(handler.getTemperature()), 0);
        store.setDimensionsPhysicalSizeX(new Float(handler.getPixelSizeX()), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(handler.getPixelSizeY()), 0, 0);
    }
}

