/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeicaHandler
extends DefaultHandler {
    private String elementName;
    private String collection;
    private int count = 0;
    private int numChannels;
    private int extras;
    private Vector<String> lutNames;
    private Vector<Float> xPos;
    private Vector<Float> yPos;
    private Vector<Float> zPos;
    private int numDatasets = -1;
    private Hashtable globalMetadata = new Hashtable();
    private MetadataStore store;
    private int nextLaser;
    private int channel;
    private int nextDetector = -1;
    private Float zoom;
    private Float pinhole;
    private Float readOutRate;
    private Vector<Integer> detectorIndices;
    private String filterWheelName;
    private int nextFilter = 0;
    private int filterIndex;
    private Vector<CoreMetadata> core;
    private boolean canParse = true;
    private long firstStamp = 0L;
    private Hashtable<Integer, String> bytesPerAxis;

    public LeicaHandler(MetadataStore store) {
        this.lutNames = new Vector();
        this.store = store;
        this.core = new Vector();
        this.detectorIndices = new Vector();
        this.xPos = new Vector();
        this.yPos = new Vector();
        this.zPos = new Vector();
        this.bytesPerAxis = new Hashtable();
    }

    public Vector<CoreMetadata> getCoreMetadata() {
        return this.core;
    }

    public Hashtable getGlobalMetadata() {
        return this.globalMetadata;
    }

    public Vector<String> getLutNames() {
        return this.lutNames;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("ImageDescription")) {
            int c;
            int nChannels;
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            if (this.numChannels == 0) {
                this.numChannels = 1;
            }
            coreMeta.sizeC = this.numChannels;
            if (this.extras > 1) {
                if (coreMeta.sizeZ == 1) {
                    coreMeta.sizeZ = this.extras;
                } else {
                    coreMeta.sizeT *= this.extras;
                }
            }
            if (coreMeta.sizeX == 0 && coreMeta.sizeY == 0) {
                --this.numDatasets;
            } else {
                String[] axes;
                if (coreMeta.sizeX == 0) {
                    coreMeta.sizeX = 1;
                }
                if (coreMeta.sizeZ == 0) {
                    coreMeta.sizeZ = 1;
                }
                if (coreMeta.sizeT == 0) {
                    coreMeta.sizeT = 1;
                }
                coreMeta.orderCertain = true;
                coreMeta.metadataComplete = true;
                coreMeta.littleEndian = true;
                coreMeta.interleaved = coreMeta.rgb;
                coreMeta.imageCount = coreMeta.sizeZ * coreMeta.sizeT;
                if (!coreMeta.rgb) {
                    coreMeta.imageCount *= coreMeta.sizeC;
                }
                coreMeta.indexed = !coreMeta.rgb;
                coreMeta.falseColor = true;
                Object[] bytes = this.bytesPerAxis.keySet().toArray(new Integer[0]);
                Arrays.sort(bytes);
                coreMeta.dimensionOrder = "XY";
                for (Object nBytes : bytes) {
                    String axis = this.bytesPerAxis.get(nBytes);
                    if (coreMeta.dimensionOrder.indexOf(axis) != -1) continue;
                    coreMeta.dimensionOrder = coreMeta.dimensionOrder + axis;
                }
                for (String axis : axes = new String[]{"Z", "C", "T"}) {
                    if (coreMeta.dimensionOrder.indexOf(axis) != -1) continue;
                    coreMeta.dimensionOrder = coreMeta.dimensionOrder + axis;
                }
                this.core.setElementAt(coreMeta, this.numDatasets);
            }
            int n = nChannels = coreMeta.rgb ? 0 : this.numChannels;
            if (this.readOutRate != null) {
                for (int c2 = 0; c2 < nChannels; ++c2) {
                    int index;
                    if (c2 >= this.detectorIndices.size() || (index = this.detectorIndices.get(c2).intValue()) >= nChannels || index > this.nextDetector) continue;
                    this.store.setDetectorSettingsReadOutRate(this.readOutRate, this.numDatasets, c2);
                    String id = MetadataTools.createLSID("Detector", this.numDatasets, index);
                    this.store.setDetectorSettingsDetector(id, this.numDatasets, c2);
                }
            }
            for (c = 0; c < nChannels; ++c) {
                this.store.setLogicalChannelPinholeSize(this.pinhole, this.numDatasets, c);
            }
            for (int i = 0; i < this.xPos.size(); ++i) {
                int nPlanes = coreMeta.imageCount / (coreMeta.rgb ? 1 : coreMeta.sizeC);
                for (int image = 0; image < nPlanes; ++image) {
                    int offset = image * nChannels + i;
                    this.store.setStagePositionPositionX(this.xPos.get(i), this.numDatasets, 0, offset);
                    this.store.setStagePositionPositionY(this.yPos.get(i), this.numDatasets, 0, offset);
                    this.store.setStagePositionPositionZ(this.zPos.get(i), this.numDatasets, 0, offset);
                }
            }
            for (c = 0; c < nChannels; ++c) {
                int index;
                int n2 = index = c < this.detectorIndices.size() ? this.detectorIndices.get(c) : this.detectorIndices.size() - 1;
                if (index < 0 || index >= nChannels || index > this.nextDetector) break;
                String id = MetadataTools.createLSID("Detector", this.numDatasets, index);
                this.store.setDetectorSettingsDetector(id, this.numDatasets, c);
            }
            this.xPos.clear();
            this.yPos.clear();
            this.zPos.clear();
            this.detectorIndices.clear();
        } else if (qName.equals("Element")) {
            int c;
            this.nextLaser = 0;
            this.nextFilter = 0;
            this.nextDetector = -1;
            int nChannels = this.core.get((int)this.numDatasets).rgb ? 1 : this.numChannels;
            for (c = 0; c < this.detectorIndices.size(); ++c) {
                int index = this.detectorIndices.get(c);
                if (c >= nChannels || index >= nChannels || index > this.nextDetector) break;
                String id = MetadataTools.createLSID("Detector", this.numDatasets, index);
                this.store.setDetectorSettingsDetector(id, this.numDatasets, index);
            }
            for (c = 0; c < nChannels; ++c) {
                this.store.setLogicalChannelPinholeSize(this.pinhole, this.numDatasets, c);
            }
        } else if (qName.equals("LDM_Block_Sequential_Master")) {
            this.canParse = true;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Hashtable h = this.getSeriesHashtable(this.numDatasets);
        if (qName.equals("LDM_Block_Sequential_Master")) {
            this.canParse = false;
        }
        if (!this.canParse) {
            return;
        }
        if (qName.equals("Element")) {
            this.elementName = attributes.getValue("Name");
        } else if (qName.equals("Collection")) {
            this.collection = this.elementName;
        } else if (qName.equals("Image")) {
            this.core.add(new CoreMetadata());
            ++this.numDatasets;
            String name = this.elementName;
            if (this.collection != null) {
                name = this.collection + "/" + name;
            }
            this.store.setImageName(name, this.numDatasets);
            String instrumentID = MetadataTools.createLSID("Instrument", this.numDatasets);
            this.store.setInstrumentID(instrumentID, this.numDatasets);
            this.store.setImageInstrumentRef(instrumentID, this.numDatasets);
            this.channel = 0;
            this.numChannels = 0;
            this.extras = 1;
        } else if (qName.equals("Attachment")) {
            if (attributes.getValue("Name").equals("ContextDescription")) {
                this.store.setImageDescription(attributes.getValue("Content"), this.numDatasets);
            }
        } else if (qName.equals("ChannelDescription")) {
            ++this.count;
            ++this.numChannels;
            this.lutNames.add(attributes.getValue("LUTName"));
            int bytes = Integer.parseInt(attributes.getValue("BytesInc"));
            if (bytes > 0) {
                this.bytesPerAxis.put(new Integer(bytes), "C");
            }
        } else if (qName.equals("DimensionDescription")) {
            int len = Integer.parseInt(attributes.getValue("NumberOfElements"));
            int id = Integer.parseInt(attributes.getValue("DimID"));
            float physicalLen = Float.parseFloat(attributes.getValue("Length"));
            String unit = attributes.getValue("Unit");
            int nBytes = Integer.parseInt(attributes.getValue("BytesInc"));
            physicalLen /= (float)len;
            if (unit.equals("Ks")) {
                physicalLen /= 1000.0f;
            } else if (unit.equals("m")) {
                physicalLen *= 1000000.0f;
            }
            Float physicalSize = new Float(physicalLen);
            CoreMetadata coreMeta = this.core.get(this.core.size() - 1);
            switch (id) {
                case 1: {
                    coreMeta.sizeX = len;
                    boolean bl = coreMeta.rgb = nBytes % 3 == 0;
                    if (coreMeta.rgb) {
                        nBytes /= 3;
                    }
                    switch (nBytes) {
                        case 1: {
                            coreMeta.pixelType = 1;
                            break;
                        }
                        case 2: {
                            coreMeta.pixelType = 3;
                            break;
                        }
                        case 4: {
                            coreMeta.pixelType = 6;
                        }
                    }
                    this.store.setDimensionsPhysicalSizeX(physicalSize, this.numDatasets, 0);
                    break;
                }
                case 2: {
                    if (coreMeta.sizeY != 0) {
                        if (coreMeta.sizeZ == 1) {
                            coreMeta.sizeZ = len;
                            break;
                        }
                        if (coreMeta.sizeT != 1) break;
                        coreMeta.sizeT = len;
                        break;
                    }
                    coreMeta.sizeY = len;
                    this.store.setDimensionsPhysicalSizeY(physicalSize, this.numDatasets, 0);
                    break;
                }
                case 3: {
                    if (coreMeta.sizeY == 0) {
                        coreMeta.sizeY = len;
                        coreMeta.sizeZ = 1;
                        this.store.setDimensionsPhysicalSizeY(physicalSize, this.numDatasets, 0);
                    } else {
                        coreMeta.sizeZ = len;
                    }
                    this.bytesPerAxis.put(new Integer(nBytes), "Z");
                    break;
                }
                case 4: {
                    if (coreMeta.sizeY == 0) {
                        coreMeta.sizeY = len;
                        coreMeta.sizeT = 1;
                        this.store.setDimensionsPhysicalSizeY(physicalSize, this.numDatasets, 0);
                    } else {
                        coreMeta.sizeT = len;
                    }
                    this.bytesPerAxis.put(new Integer(nBytes), "T");
                    break;
                }
                default: {
                    this.extras *= len;
                }
            }
            ++this.count;
        } else if (qName.equals("ScannerSettingRecord")) {
            String id = attributes.getValue("Identifier");
            String value = attributes.getValue("Variant");
            if (id.equals("SystemType")) {
                this.store.setMicroscopeModel(value, this.numDatasets);
                this.store.setMicroscopeType("Unknown", this.numDatasets);
            } else if (id.equals("dblPinhole")) {
                this.pinhole = new Float(Float.parseFloat(value) * 1000000.0f);
            } else if (id.equals("dblZoom")) {
                this.zoom = new Float(value);
            } else if (id.equals("dblStepSize")) {
                float zStep = (float)(Double.parseDouble(value) * 1000000.0);
                this.store.setDimensionsPhysicalSizeZ(new Float(zStep), this.numDatasets, 0);
            } else if (id.equals("nDelayTime_s")) {
                this.store.setDimensionsTimeIncrement(new Float(value), this.numDatasets, 0);
            } else if (id.equals("CameraName")) {
                this.store.setDetectorModel(value, this.numDatasets, 0);
            } else if (id.indexOf("WFC") == 1) {
                int c = 0;
                try {
                    c = Integer.parseInt(id.replaceAll("\\D", ""));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (id.endsWith("ExposureTime")) {
                    this.store.setPlaneTimingExposureTime(new Float(value), this.numDatasets, 0, c);
                } else if (id.endsWith("Gain")) {
                    this.store.setDetectorSettingsGain(new Float(value), this.numDatasets, c);
                    String detectorID = MetadataTools.createLSID("Detector", this.numDatasets, 0);
                    this.store.setDetectorSettingsDetector(detectorID, this.numDatasets, c);
                    this.store.setDetectorID(detectorID, this.numDatasets, 0);
                } else if (id.endsWith("WaveLength")) {
                    this.store.setLogicalChannelExWave(new Integer(value), this.numDatasets, c);
                } else if (id.endsWith("UesrDefName")) {
                    this.store.setLogicalChannelName(value, this.numDatasets, c);
                }
            }
        } else if (qName.equals("FilterSettingRecord")) {
            String object = attributes.getValue("ObjectName");
            String attribute = attributes.getValue("Attribute");
            String objectClass = attributes.getValue("ClassName");
            String variant = attributes.getValue("Variant");
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            if (attribute.equals("NumericalAperture")) {
                this.store.setObjectiveLensNA(new Float(variant), this.numDatasets, 0);
            } else if (attribute.equals("OrderNumber")) {
                this.store.setObjectiveSerialNumber(variant, this.numDatasets, 0);
            } else if (objectClass.equals("CLaser")) {
                if (attribute.equals("Wavelength")) {
                    String id = MetadataTools.createLSID("LightSource", this.numDatasets, this.nextLaser);
                    this.store.setLightSourceID(id, this.numDatasets, this.nextLaser);
                    this.store.setLaserWavelength(new Integer(variant), this.numDatasets, this.nextLaser);
                    String model = object.substring(object.indexOf("(") + 1, object.indexOf(")"));
                    this.store.setLightSourceModel(model, this.numDatasets, this.nextLaser);
                    ++this.nextLaser;
                } else if (attribute.equals("Output Power")) {
                    this.store.setLightSourcePower(new Float(variant), this.numDatasets, this.nextLaser - 1);
                }
            } else if (objectClass.equals("CDetectionUnit")) {
                if (attribute.equals("State")) {
                    String id = MetadataTools.createLSID("Detector", this.numDatasets, ++this.nextDetector);
                    this.store.setDetectorID(id, this.numDatasets, this.nextDetector);
                    this.store.setDetectorModel(object, this.numDatasets, this.nextDetector);
                    this.store.setDetectorType("Unknown", this.numDatasets, this.nextDetector);
                    this.store.setDetectorZoom(this.zoom, this.numDatasets, this.nextDetector);
                } else if (attribute.equals("HighVoltage")) {
                    this.store.setDetectorVoltage(new Float(variant), this.numDatasets, this.nextDetector);
                } else if (attribute.equals("VideoOffset")) {
                    this.store.setDetectorOffset(new Float(variant), this.numDatasets, this.nextDetector);
                }
            } else if (attribute.equals("Objective")) {
                StringTokenizer tokens = new StringTokenizer(variant, " ");
                boolean foundMag = false;
                StringBuffer model = new StringBuffer();
                while (!foundMag) {
                    String token = tokens.nextToken();
                    int x = token.indexOf("x");
                    if (x != -1) {
                        foundMag = true;
                        int mag = (int)Float.parseFloat(token.substring(0, x));
                        String na = token.substring(x + 1);
                        this.store.setObjectiveNominalMagnification(new Integer(mag), this.numDatasets, 0);
                        this.store.setObjectiveLensNA(new Float(na), this.numDatasets, 0);
                        continue;
                    }
                    model.append(token);
                    model.append(" ");
                }
                if (tokens.hasMoreTokens()) {
                    String immersion = tokens.nextToken();
                    if (immersion == null || immersion.trim().equals("")) {
                        immersion = "Unknown";
                    }
                    this.store.setObjectiveImmersion(immersion, this.numDatasets, 0);
                }
                if (tokens.hasMoreTokens()) {
                    String correction = tokens.nextToken();
                    if (correction == null || correction.trim().equals("")) {
                        correction = "Unknown";
                    }
                    this.store.setObjectiveCorrection(correction, this.numDatasets, 0);
                }
                this.store.setObjectiveModel(model.toString().trim(), this.numDatasets, 0);
            } else if (attribute.equals("RefractionIndex")) {
                String id = MetadataTools.createLSID("Objective", this.numDatasets, 0);
                this.store.setObjectiveID(id, this.numDatasets, 0);
                this.store.setObjectiveSettingsObjective(id, this.numDatasets);
                this.store.setObjectiveSettingsRefractiveIndex(new Float(variant), this.numDatasets);
            } else if (attribute.equals("XPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount / c;
                Float posX = new Float(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    int index = image * (coreMeta.rgb ? 1 : coreMeta.sizeC) + this.channel;
                    if (index >= nPlanes) continue;
                    this.store.setStagePositionPositionX(posX, this.numDatasets, 0, index);
                }
                if (this.numChannels == 0) {
                    this.xPos.add(posX);
                }
            } else if (attribute.equals("YPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount / c;
                Float posY = new Float(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    int index = image * (coreMeta.rgb ? 1 : coreMeta.sizeC) + this.channel;
                    if (index >= nPlanes) continue;
                    this.store.setStagePositionPositionY(posY, this.numDatasets, 0, index);
                }
                if (this.numChannels == 0) {
                    this.yPos.add(posY);
                }
            } else if (attribute.equals("ZPos")) {
                int c = coreMeta.rgb || coreMeta.sizeC == 0 ? 1 : coreMeta.sizeC;
                int nPlanes = coreMeta.imageCount / c;
                Float posZ = new Float(variant);
                for (int image = 0; image < nPlanes; ++image) {
                    int index = image * (coreMeta.rgb ? 1 : coreMeta.sizeC) + this.channel;
                    if (index >= nPlanes) continue;
                    this.store.setStagePositionPositionZ(posZ, this.numDatasets, 0, index);
                }
                if (this.numChannels == 0) {
                    this.zPos.add(posZ);
                }
            } else if (attribute.equals("Speed")) {
                this.readOutRate = new Float(Float.parseFloat(variant) / 1000000.0f);
            }
        } else if (qName.equals("MultiBand")) {
            if (this.channel >= this.core.get((int)this.numDatasets).sizeC) {
                return;
            }
            String em = attributes.getValue("LeftWorld");
            String ex = attributes.getValue("RightWorld");
            Integer emWave = new Integer((int)Float.parseFloat(em));
            Integer exWave = new Integer((int)Float.parseFloat(ex));
            String name = attributes.getValue("DyeName");
            this.store.setLogicalChannelEmWave(emWave, this.numDatasets, this.channel);
            this.store.setLogicalChannelExWave(exWave, this.numDatasets, this.channel);
            this.store.setLogicalChannelName(name, this.numDatasets, this.channel);
            ++this.channel;
        } else if (qName.equals("Detector")) {
            Float gain = new Float(attributes.getValue("Gain"));
            Float offset = new Float(attributes.getValue("Offset"));
            int index = Integer.parseInt(attributes.getValue("Channel")) - 1;
            int c = this.channel - 1;
            if (c >= 0) {
                this.store.setDetectorSettingsGain(gain, this.numDatasets, c);
                this.store.setDetectorSettingsOffset(offset, this.numDatasets, c);
                this.store.setDetectorSettingsReadOutRate(this.readOutRate, this.numDatasets, c);
                int detectorIndex = this.nextDetector < 0 ? 0 : this.nextDetector;
                String detectorID = MetadataTools.createLSID("Detector", this.numDatasets, detectorIndex);
                this.store.setDetectorSettingsDetector(detectorID, this.numDatasets, c);
                this.detectorIndices.add(new Integer(index));
            }
        } else if (qName.equals("LaserLineSetting")) {
            String wavelength = attributes.getValue("LaserLine");
            int index = Integer.parseInt(attributes.getValue("LineIndex"));
            String id = MetadataTools.createLSID("LightSource", this.numDatasets, index);
            this.store.setLightSourceID(id, this.numDatasets, index);
            this.store.setLaserWavelength(new Integer(wavelength), this.numDatasets, index);
            this.store.setLaserType("Unknown", this.numDatasets, index);
            this.store.setLaserLaserMedium("Unknown", this.numDatasets, index);
            float intensity = Float.parseFloat(attributes.getValue("IntensityDev"));
            if (intensity > 0.0f && this.channel > 0) {
                this.store.setLightSourceSettingsLightSource(id, this.numDatasets, this.channel - 1);
                this.store.setLightSourceSettingsAttenuation(new Float(intensity / 100.0f), this.numDatasets, this.channel - 1);
            }
        } else if (qName.equals("TimeStamp")) {
            long high = Long.parseLong(attributes.getValue("HighInteger"));
            long low = Long.parseLong(attributes.getValue("LowInteger"));
            long ms = DateTools.getMillisFromTicks(high, low);
            if (this.count == 0) {
                String date = DateTools.convertDate(ms, 1);
                if (DateTools.getTime(date, "yyyy-MM-dd'T'HH:mm:ss") < System.currentTimeMillis()) {
                    this.store.setImageCreationDate(date, this.numDatasets);
                }
                this.firstStamp = ms;
                this.store.setPlaneTimingDeltaT(new Float(0.0f), this.numDatasets, 0, this.count);
            } else {
                CoreMetadata coreMeta = this.core.get(this.numDatasets);
                int nImages = coreMeta.sizeZ * coreMeta.sizeT * coreMeta.sizeC;
                if (this.count < nImages) {
                    this.store.setPlaneTimingDeltaT(new Float((float)(ms -= this.firstStamp) / 1000.0f), this.numDatasets, 0, this.count);
                }
            }
            ++this.count;
        } else if (qName.equals("RelTimeStamp")) {
            CoreMetadata coreMeta = this.core.get(this.numDatasets);
            int nImages = coreMeta.sizeZ * coreMeta.sizeT * coreMeta.sizeC;
            if (this.count < nImages) {
                Float time = new Float(attributes.getValue("Time"));
                this.store.setPlaneTimingDeltaT(time, this.numDatasets, 0, this.count++);
            }
        } else if (qName.equals("Wheel")) {
            this.filterIndex = Integer.parseInt(attributes.getValue("FilterIndex"));
        } else if (qName.equals("WheelName")) {
            String id = MetadataTools.createLSID("Dichroic", this.numDatasets, this.nextFilter);
            this.store.setDichroicID(id, this.numDatasets, this.nextFilter);
            this.store.setDichroicModel(attributes.getValue("FilterName").trim(), this.numDatasets, this.nextFilter);
            if (this.nextFilter == this.filterIndex) {
                String filterSet = MetadataTools.createLSID("FilterSet", this.numDatasets, this.channel);
                this.store.setFilterSetID(filterSet, this.numDatasets, this.channel);
                this.store.setFilterSetDichroic(id, this.numDatasets, this.channel);
                if (this.channel < this.core.get((int)this.numDatasets).sizeC) {
                    this.store.setLogicalChannelFilterSet(filterSet, this.numDatasets, this.channel);
                }
            }
            ++this.nextFilter;
        } else {
            this.count = 0;
        }
        this.storeSeriesHashtable(this.numDatasets, h);
    }

    private Hashtable getSeriesHashtable(int series) {
        if (series < 0 || series >= this.core.size()) {
            return new Hashtable();
        }
        return this.core.get((int)series).seriesMetadata;
    }

    private void storeSeriesHashtable(int series, Hashtable h) {
        if (series < 0) {
            return;
        }
        CoreMetadata coreMeta = this.core.get(series);
        coreMeta.seriesMetadata = h;
        this.core.setElementAt(coreMeta, series);
    }
}

