/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.MSRLECodec;
import loci.formats.codec.MSVideoCodec;
import loci.formats.meta.FilterMetadata;

public class AVIReader
extends FormatReader {
    public static final String AVI_MAGIC_STRING = "RIFF";
    private static final int MSRLE = 1;
    private static final int MS_VIDEO = 1296126531;
    private Vector<Long> offsets;
    private Vector<Long> lengths;
    private String type = "error";
    private String fcc = "error";
    private int size = -1;
    private long pos;
    private int bytesPerPlane;
    private int bmpColorsUsed;
    private int bmpWidth;
    private int bmpCompression;
    private int bmpScanLineSize;
    private short bmpBitsPerPixel;
    private byte[][] lut = null;
    private byte[] lastImage;
    private int lastImageNo;

    public AVIReader() {
        super("Audio Video Interleave", "avi");
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readString(4).startsWith(AVI_MAGIC_STRING);
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.getSizeX()) {
            effectiveWidth = this.getSizeX();
        }
        long fileOff = this.offsets.get(no);
        this.in.seek(fileOff);
        if (this.bmpCompression != 0) {
            byte[] b = this.uncompress(no, buf);
            int rowLen = FormatTools.getPlaneSize(this, w, 1);
            int inputRowLen = FormatTools.getPlaneSize(this, this.getSizeX(), 1);
            for (int row = 0; row < h; ++row) {
                System.arraycopy(b, (row + y) * inputRowLen, buf, row * rowLen, rowLen);
            }
            b = null;
            return buf;
        }
        if (this.bmpBitsPerPixel < 8) {
            int rawSize = FormatTools.getPlaneSize(this, effectiveWidth, this.getSizeY());
            byte[] b = new byte[rawSize /= 8 / this.bmpBitsPerPixel];
            int len = rawSize / this.getSizeY();
            this.in.read(b);
            BitBuffer bb = new BitBuffer(b);
            bb.skipBits(this.bmpBitsPerPixel * len * (this.getSizeY() - h - y));
            for (int row = h; row >= y; --row) {
                bb.skipBits(this.bmpBitsPerPixel * x);
                for (int col = 0; col < len; ++col) {
                    buf[(row - y) * len + col] = (byte)bb.getBits(this.bmpBitsPerPixel);
                }
                bb.skipBits(this.bmpBitsPerPixel * (this.getSizeX() - w - x));
            }
            return buf;
        }
        int pad = this.bmpScanLineSize / this.getRGBChannelCount() - this.getSizeX() * bytes;
        int scanline = w * bytes * (this.isInterleaved() ? this.getRGBChannelCount() : 1);
        this.in.skipBytes((this.getSizeX() + pad) * bytes * (this.getSizeY() - h - y));
        if (this.getSizeX() == w && pad == 0) {
            for (int row = 0; row < this.getSizeY(); ++row) {
                this.in.read(buf, (this.getSizeY() - row - 1) * scanline, scanline);
            }
            if (this.bmpBitsPerPixel == 24) {
                for (int i = 0; i < buf.length / this.getRGBChannelCount(); ++i) {
                    byte r = buf[i * this.getRGBChannelCount() + 2];
                    buf[i * this.getRGBChannelCount() + 2] = buf[i * this.getRGBChannelCount()];
                    buf[i * this.getRGBChannelCount()] = r;
                }
            }
        } else {
            int skip = FormatTools.getPlaneSize(this, this.getSizeX() - w - x + pad, 1);
            for (int i = h - 1; i >= 0; --i) {
                this.in.skipBytes(x * (this.bmpBitsPerPixel / 8));
                this.in.read(buf, (i - y) * scanline, scanline);
                if (this.bmpBitsPerPixel == 24) {
                    for (int j = 0; j < this.getSizeX(); ++j) {
                        byte r = buf[i * scanline + j * 3 + 2];
                        buf[i * scanline + j * 3 + 2] = buf[i * scanline + j * 3];
                        buf[i * scanline + j * 3] = r;
                    }
                }
                this.in.skipBytes(skip);
            }
        }
        if (this.bmpBitsPerPixel == 16 && this.isRGB()) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 2, this.getRGBChannelCount());
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.lengths = null;
            this.type = null;
            this.fcc = null;
            this.size = -1;
            this.pos = 0L;
            this.bytesPerPlane = 0;
            this.bmpScanLineSize = 0;
            this.bmpCompression = 0;
            this.bmpWidth = 0;
            this.bmpColorsUsed = 0;
            this.bmpBitsPerPixel = 0;
            this.lut = null;
            this.lastImage = null;
            this.lastImageNo = -1;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        this.debug("AVIReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.status("Verifying AVI format");
        this.offsets = new Vector();
        this.lengths = new Vector();
        this.lastImageNo = -1;
        this.readChunkHeader();
        if (this.type.equals(AVI_MAGIC_STRING)) {
            if (!this.fcc.equals("AVI ")) {
                throw new FormatException("Sorry, AVI RIFF format not found.");
            }
        } else {
            throw new FormatException("Not an AVI file");
        }
        long spos = this.pos = this.in.getFilePointer();
        this.status("Searching for image data");
        while (this.in.length() - this.in.getFilePointer() > 4L) {
            String listString = this.in.readString(4);
            this.in.seek(this.pos);
            if (listString.equals(" JUN")) {
                this.in.skipBytes(1);
                ++this.pos;
            }
            if (listString.equals("JUNK")) {
                this.type = this.in.readString(4);
                this.size = this.in.readInt();
                if (this.type.equals("JUNK")) {
                    this.in.skipBytes(this.size);
                }
            } else if (listString.equals("LIST")) {
                spos = this.in.getFilePointer();
                this.readChunkHeader();
                this.in.seek(spos);
                if (this.fcc.equals("hdrl")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("hdrl")) {
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("avih")) {
                            spos = this.in.getFilePointer();
                            this.addGlobalMeta("Microseconds per frame", this.in.readInt());
                            this.addGlobalMeta("Max. bytes per second", this.in.readInt());
                            this.in.skipBytes(8);
                            this.addGlobalMeta("Total frames", this.in.readInt());
                            this.addGlobalMeta("Initial frames", this.in.readInt());
                            this.in.skipBytes(8);
                            this.core[0].sizeX = this.in.readInt();
                            this.addGlobalMeta("Frame height", this.in.readInt());
                            this.addGlobalMeta("Scale factor", this.in.readInt());
                            this.addGlobalMeta("Frame rate", this.in.readInt());
                            this.addGlobalMeta("Start time", this.in.readInt());
                            this.addGlobalMeta("Length", this.in.readInt());
                            this.addGlobalMeta("Frame width", this.getSizeX());
                            if (spos + (long)this.size <= this.in.length()) {
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                    }
                } else if (this.fcc.equals("strl")) {
                    long startPos = this.in.getFilePointer();
                    long streamSize = this.size;
                    this.readChunkHeader();
                    if (this.type.equals("LIST")) {
                        if (this.fcc.equals("strl")) {
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (this.type.equals("strh")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(40);
                                this.addGlobalMeta("Stream quality", this.in.readInt());
                                this.bytesPerPlane = this.in.readInt();
                                this.addGlobalMeta("Stream sample size", this.bytesPerPlane);
                                if (spos + (long)this.size <= this.in.length()) {
                                    this.in.seek(spos + (long)this.size);
                                }
                            }
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (this.type.equals("strf")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(4);
                                this.bmpWidth = this.in.readInt();
                                this.core[0].sizeY = this.in.readInt();
                                this.in.skipBytes(2);
                                this.bmpBitsPerPixel = this.in.readShort();
                                this.bmpCompression = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Horizontal resolution", this.in.readInt());
                                this.addGlobalMeta("Vertical resolution", this.in.readInt());
                                this.bmpColorsUsed = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addGlobalMeta("Bitmap compression value", this.bmpCompression);
                                this.addGlobalMeta("Number of colors used", this.bmpColorsUsed);
                                this.addGlobalMeta("Bits per pixel", this.bmpBitsPerPixel);
                                int npad = this.bmpWidth % 4;
                                if (npad > 0) {
                                    npad = 4 - npad;
                                }
                                this.bmpScanLineSize = (this.bmpWidth + npad) * (this.bmpBitsPerPixel / 8);
                                int bmpActualColorsUsed = 0;
                                if (this.bmpColorsUsed != 0) {
                                    bmpActualColorsUsed = this.bmpColorsUsed;
                                } else if (this.bmpBitsPerPixel < 16) {
                                    this.bmpColorsUsed = bmpActualColorsUsed = 1 << this.bmpBitsPerPixel;
                                }
                                if (this.bmpCompression != 1 && this.bmpCompression != 0 && this.bmpCompression != 1296126531) {
                                    throw new FormatException("Unsupported compression type " + this.bmpCompression);
                                }
                                if (this.bmpBitsPerPixel != 4 && this.bmpBitsPerPixel != 8 && this.bmpBitsPerPixel != 24 && this.bmpBitsPerPixel != 16 && this.bmpBitsPerPixel != 32) {
                                    throw new FormatException(this.bmpBitsPerPixel + " bits per pixel not supported");
                                }
                                if (bmpActualColorsUsed != 0) {
                                    this.lut = new byte[3][this.bmpColorsUsed];
                                    for (int i = 0; i < this.bmpColorsUsed; ++i) {
                                        this.lut[2][i] = this.in.readByte();
                                        this.lut[1][i] = this.in.readByte();
                                        this.lut[0][i] = this.in.readByte();
                                        this.in.skipBytes(1);
                                    }
                                }
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("strd")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("strn")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                    }
                    if (startPos + streamSize + 8L <= this.in.length()) {
                        this.in.seek(startPos + 8L + streamSize);
                    }
                } else if (this.fcc.equals("movi")) {
                    this.readChunkHeader();
                    if (this.type.equals("LIST") && this.fcc.equals("movi")) {
                        spos = this.in.getFilePointer();
                        if (spos >= this.in.length() - 12L) break;
                        this.readChunkHeader();
                        if (!this.type.equals("LIST") || !this.fcc.equals("rec ") && !this.fcc.equals("movi")) {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        if (this.type.startsWith("ix")) {
                            this.size = this.in.readInt();
                            this.in.skipBytes(this.size);
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                        } else {
                            this.size = this.in.readInt();
                        }
                        while (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc") || this.type.substring(2).equals("wb")) {
                            if (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc")) {
                                this.offsets.add(new Long(this.in.getFilePointer()));
                                this.lengths.add(new Long(this.size));
                                this.in.skipBytes(this.size);
                            }
                            spos = this.in.getFilePointer();
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (!this.type.equals("JUNK")) continue;
                            this.in.skipBytes(this.size);
                            spos = this.in.getFilePointer();
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                        }
                        this.in.seek(spos);
                    }
                } else if (this.size + 8 >= 0) {
                    this.in.skipBytes(8 + this.size);
                }
            } else {
                this.type = this.in.readString(4);
                if (this.in.getFilePointer() + (long)this.size + 4L <= this.in.length()) {
                    this.size = this.in.readInt();
                    this.in.skipBytes(this.size);
                }
            }
            this.pos = this.in.getFilePointer();
        }
        this.status("Populating metadata");
        this.core[0].imageCount = this.offsets.size();
        this.core[0].indexed = this.lut != null;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = this.getImageCount();
        this.core[0].littleEndian = true;
        boolean bl = this.core[0].interleaved = this.bmpBitsPerPixel != 16;
        if (this.bytesPerPlane == 0 || this.bmpBitsPerPixel == 24) {
            this.core[0].rgb = (this.bmpBitsPerPixel > 8 || this.bmpCompression != 0) && this.lut == null;
            this.core[0].sizeC = this.isRGB() ? 3 : 1;
        } else {
            this.core[0].sizeC = this.bytesPerPlane / (this.getSizeX() * this.getSizeY() * (this.bmpBitsPerPixel / 8));
            this.core[0].rgb = this.getSizeC() > 1;
        }
        this.core[0].dimensionOrder = this.getSizeC() == 3 ? "XYCTZ" : "XYTCZ";
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        if (this.bmpBitsPerPixel <= 8) {
            this.core[0].pixelType = 1;
        } else if (this.bmpBitsPerPixel == 16) {
            this.core[0].pixelType = 3;
        } else if (this.bmpBitsPerPixel == 32) {
            this.core[0].pixelType = 5;
        } else if (this.bmpBitsPerPixel == 24) {
            this.core[0].pixelType = 1;
        } else {
            throw new FormatException("Unknown matching for pixel bit width of: " + this.bmpBitsPerPixel);
        }
        if (this.bmpCompression != 0) {
            this.core[0].pixelType = 1;
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    private byte[] uncompress(int no, byte[] buf) throws FormatException, IOException {
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.previousImage = this.lastImageNo == no - 1 ? this.lastImage : null;
        options.bitsPerSample = this.bmpBitsPerPixel;
        if (this.bmpCompression == 1) {
            byte[] b = new byte[(int)this.lengths.get(no).longValue()];
            this.in.read(b);
            MSRLECodec codec = new MSRLECodec();
            buf = codec.decompress(b, options);
            this.lastImage = buf;
            this.lastImageNo = no;
        } else if (this.bmpCompression == 1296126531) {
            MSVideoCodec codec = new MSVideoCodec();
            buf = codec.decompress(this.in, options);
            this.lastImage = buf;
            this.lastImageNo = no;
        } else {
            throw new FormatException("Unsupported compression : " + this.bmpCompression);
        }
        return buf;
    }

    private void readChunkHeader() throws IOException {
        this.type = this.in.readString(4);
        this.size = this.in.readInt();
        this.fcc = this.in.readString(4);
    }
}

