/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Arrays;
import java.util.Hashtable;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.LogTools;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.common.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataTools {
    private MetadataTools() {
    }

    public static IMetadata createOMEXMLMetadata() {
        return MetadataTools.createOMEXMLMetadata(null);
    }

    public static IMetadata createOMEXMLMetadata(String xml) {
        return MetadataTools.createOMEXMLMetadata(xml, null);
    }

    public static IMetadata createOMEXMLMetadata(String xml, String version) {
        Object ome = null;
        IMetadata meta = null;
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            ome = MetadataTools.createOMEXMLRoot(xml);
            if (version == null) {
                if (ome == null) {
                    r.exec("import ome.xml.OMEXMLFactory");
                    version = (String)r.exec("OMEXMLFactory.LATEST_VERSION");
                } else {
                    r.setVar("ome", ome);
                    version = MetadataTools.getOMEXMLVersion(ome);
                }
            }
            String metaClass = "OMEXML" + version.replaceAll("[^\\w]", "") + "Metadata";
            r.exec("import loci.formats.ome." + metaClass);
            meta = (IMetadata)r.exec("new " + metaClass + "()");
            if (ome != null) {
                meta.setRoot(ome);
            }
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
        }
        return meta;
    }

    public static Object createOMEXMLRoot(String xml) {
        if (xml == null) {
            return null;
        }
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import ome.xml.OMEXMLFactory");
            r.setVar("xml", xml);
            return r.exec("OMEXMLFactory.newOMENodeFromSource(xml)");
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
            return null;
        }
    }

    public static boolean isOMEXMLMetadata(Object o) {
        return MetadataTools.isInstance(o, "loci.formats.ome", "OMEXMLMetadata");
    }

    public static boolean isOMEXMLRoot(Object o) {
        return MetadataTools.isInstance(o, "ome.xml", "OMEXMLNode");
    }

    public static String getOMEXMLVersion(Object o) {
        if (o == null) {
            return null;
        }
        String name = o.getClass().getName();
        if (MetadataTools.isOMEXMLMetadata(o)) {
            String numbers;
            String prefix = "loci.formats.ome.OMEXML";
            String suffix = "Metadata";
            if (name.startsWith("loci.formats.ome.OMEXML") && name.endsWith("Metadata") && (numbers = name.substring("loci.formats.ome.OMEXML".length(), name.length() - "Metadata".length())).length() == 6) {
                return numbers.substring(0, 4) + "-" + numbers.substring(4, 6).toUpperCase();
            }
        } else if (MetadataTools.isOMEXMLRoot(o)) {
            ReflectedUniverse r = new ReflectedUniverse();
            r.setVar("ome", o);
            try {
                return (String)r.exec("ome.getVersion()");
            }
            catch (ReflectException exc) {
                LogTools.traceDebug(exc);
            }
        }
        return null;
    }

    public static IMetadata getOMEMetadata(MetadataRetrieve src) {
        if (MetadataTools.isOMEXMLMetadata(src)) {
            return (IMetadata)src;
        }
        IMetadata omexmlMeta = MetadataTools.createOMEXMLMetadata();
        MetadataTools.convertMetadata(src, (MetadataStore)omexmlMeta);
        return omexmlMeta;
    }

    public static Hashtable<String, String> getOriginalMetadata(IMetadata src) {
        if (MetadataTools.isOMEXMLMetadata(src)) {
            ReflectedUniverse r = new ReflectedUniverse();
            r.setVar("omexml", src);
            try {
                return (Hashtable)r.exec("omexml.getOriginalMetadata()");
            }
            catch (ReflectException exc) {
                LogTools.traceDebug(exc);
            }
        }
        return null;
    }

    public static String getOMEXML(MetadataRetrieve src) {
        IMetadata omexmlMeta = MetadataTools.getOMEMetadata(src);
        ReflectedUniverse r = new ReflectedUniverse();
        r.setVar("omexmlMeta", omexmlMeta);
        try {
            return (String)r.exec("omexmlMeta.dumpXML()");
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
            return null;
        }
    }

    public static void validateOMEXML(String xml) {
        XMLTools.validateXML(xml, "OME-XML");
    }

    public static void populatePixels(MetadataStore store, IFormatReader r) {
        MetadataTools.populatePixels(store, r, false, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane) {
        MetadataTools.populatePixels(store, r, doPlane, true);
    }

    public static void populatePixels(MetadataStore store, IFormatReader r, boolean doPlane, boolean doImageName) {
        if (store == null || r == null) {
            return;
        }
        int oldSeries = r.getSeries();
        for (int i = 0; i < r.getSeriesCount(); ++i) {
            r.setSeries(i);
            if (doImageName) {
                store.setImageName(r.getCurrentFile(), i);
            }
            String pixelsID = MetadataTools.createLSID("Pixels", i, 0);
            store.setPixelsID(pixelsID, i, 0);
            store.setImageDefaultPixels(pixelsID, i);
            store.setPixelsSizeX(new Integer(r.getSizeX()), i, 0);
            store.setPixelsSizeY(new Integer(r.getSizeY()), i, 0);
            store.setPixelsSizeZ(new Integer(r.getSizeZ()), i, 0);
            store.setPixelsSizeC(new Integer(r.getSizeC()), i, 0);
            store.setPixelsSizeT(new Integer(r.getSizeT()), i, 0);
            store.setPixelsPixelType(FormatTools.getPixelTypeString(r.getPixelType()), i, 0);
            store.setPixelsBigEndian(new Boolean(!r.isLittleEndian()), i, 0);
            store.setPixelsDimensionOrder(r.getDimensionOrder(), i, 0);
            store.setDisplayOptionsDisplay(r.isRGB() ? "RGB" : "Grey", i);
            if (r.getSizeC() > 0) {
                Integer sampleCount = new Integer(r.getRGBChannelCount());
                for (int c = 0; c < r.getEffectiveSizeC(); ++c) {
                    store.setLogicalChannelSamplesPerPixel(sampleCount, i, c);
                    for (int rgb = 0; rgb < r.getRGBChannelCount(); ++rgb) {
                        store.setChannelComponentIndex(new Integer(c * r.getRGBChannelCount() + rgb), i, c, rgb);
                        store.setChannelComponentPixels(pixelsID, i, c, rgb);
                    }
                }
            }
            if (!doPlane) continue;
            for (int q = 0; q < r.getImageCount(); ++q) {
                int[] coords = r.getZCTCoords(q);
                store.setPlaneTheZ(new Integer(coords[0]), i, 0, q);
                store.setPlaneTheC(new Integer(coords[1]), i, 0, q);
                store.setPlaneTheT(new Integer(coords[2]), i, 0, q);
            }
        }
        r.setSeries(oldSeries);
    }

    public static String createLSID(String type, int ... indices) {
        StringBuffer lsid = new StringBuffer(type);
        for (int index : indices) {
            lsid.append(":");
            lsid.append(index);
        }
        return lsid.toString();
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src) throws FormatException {
        MetadataTools.verifyMinimumPopulated(src, 0);
    }

    public static void verifyMinimumPopulated(MetadataRetrieve src, int n) throws FormatException {
        if (src == null) {
            throw new FormatException("Metadata object is null; call IFormatWriter.setMetadataRetrieve() first");
        }
        MetadataStore store = MetadataTools.asStore(src);
        if (store != null && store.getRoot() == null) {
            throw new FormatException("Metadata object has null root; call IMetadata.createRoot() first");
        }
        if (src.getPixelsBigEndian(n, 0) == null) {
            throw new FormatException("BigEndian #" + n + " is null");
        }
        if (src.getPixelsDimensionOrder(n, 0) == null) {
            throw new FormatException("DimensionOrder #" + n + " is null");
        }
        if (src.getPixelsPixelType(n, 0) == null) {
            throw new FormatException("PixelType #" + n + " is null");
        }
        if (src.getPixelsSizeC(n, 0) == null) {
            throw new FormatException("SizeC #" + n + " is null");
        }
        if (src.getPixelsSizeT(n, 0) == null) {
            throw new FormatException("SizeT #" + n + " is null");
        }
        if (src.getPixelsSizeX(n, 0) == null) {
            throw new FormatException("SizeX #" + n + " is null");
        }
        if (src.getPixelsSizeY(n, 0) == null) {
            throw new FormatException("SizeY #" + n + " is null");
        }
        if (src.getPixelsSizeZ(n, 0) == null) {
            throw new FormatException("SizeZ #" + n + " is null");
        }
    }

    public static void setDefaultCreationDate(MetadataStore store, String id, int series) {
        Location file = new Location(id).getAbsoluteFile();
        long time = System.currentTimeMillis();
        if (file.exists()) {
            time = file.lastModified();
        }
        store.setImageCreationDate(DateTools.convertDate(time, 0), series);
    }

    public static void populateOriginalMetadata(Object omexmlMeta, String key, String value) {
        ReflectedUniverse r = new ReflectedUniverse();
        r.setVar("omexmlMeta", omexmlMeta);
        r.setVar("key", key);
        r.setVar("value", value);
        try {
            r.exec("omexmlMeta.setOriginalMetadata(key, value)");
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
        }
    }

    public static String getOriginalMetadata(Object omexmlMeta, String key) {
        ReflectedUniverse r = new ReflectedUniverse();
        r.setVar("omexmlMeta", omexmlMeta);
        r.setVar("key", key);
        try {
            return (String)r.exec("omexmlMeta.getOriginalMetadata(key)");
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
            return null;
        }
    }

    public static void convertMetadata(String xml, MetadataStore dest) {
        String storeVersion;
        Object ome = MetadataTools.createOMEXMLRoot(xml);
        String rootVersion = MetadataTools.getOMEXMLVersion(ome);
        if (rootVersion.equals(storeVersion = MetadataTools.getOMEXMLVersion(dest))) {
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.setVar("xml", xml);
                r.setVar("omexmlMeta", dest);
                r.exec("omexmlMeta.createRoot(xml)");
            }
            catch (ReflectException exc) {
                LogTools.traceDebug(exc);
            }
        } else {
            IMetadata src = MetadataTools.createOMEXMLMetadata(xml);
            MetadataTools.convertMetadata(src, dest);
        }
    }

    public static void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertMetadata(src, dest);
    }

    public static MetadataStore asStore(MetadataRetrieve meta) {
        return meta instanceof MetadataStore ? (MetadataStore)((Object)meta) : null;
    }

    public static MetadataRetrieve asRetrieve(MetadataStore meta) {
        return meta instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)meta) : null;
    }

    public static String[] keys(Hashtable meta) {
        Object[] keys = new String[meta.size()];
        meta.keySet().toArray(keys);
        Arrays.sort(keys);
        return keys;
    }

    private static boolean isInstance(Object o, String packageName, String className) {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import " + packageName + "." + className);
            Class c = (Class)r.getVar(className);
            return c.isInstance(o);
        }
        catch (ReflectException exc) {
            LogTools.traceDebug(exc);
            return false;
        }
    }
}

