/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import omero.model.Dataset;
import omero.model.Project;
import omerouploader.EditProjectDatasetUI;
import omerouploader.Main;
import omerouploader.NewProjectDatasetUI;
import omerouploader.QueueItemList;
import omerouploader.SessionDetails;
import omerouploader.TagPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDatasetPickerUI
extends JFrame {
    private Main parent;
    private omeroconnect.Main omeroserver;
    private SessionDetails sessiondetails;
    private QueueItemList processqueue;
    private NewProjectDatasetUI newprojdsui;
    private List<String> tags = new ArrayList<String>();
    private int inheritFromProject = 0;
    private int inheritFromDataset = 0;
    private JCheckBox ImagesInheritFromDatasetCheckBox;
    private JCheckBox ImagesInheritFromProjectCheckBox;
    private JButton addDatasetButton;
    private JButton addProjectButton;
    private JButton cancelButton;
    private JComboBox datasetComboBox;
    private JLabel datasetLabel;
    private JPanel datasetPanel;
    private JPanel dsLabelPanel;
    private JButton editDatasetButton;
    private JButton editProjectButton;
    private JLabel imageLabel;
    private JPanel imageLabelPanel;
    private JPanel jPanel1;
    private JButton okButton;
    private JComboBox projectComboBox;
    private JLabel projectLabel;
    private JPanel projectLabelPanel;
    private JPanel projectPanel;
    private JButton setImageTagsButton;
    private JButton setImageTagsButton1;

    public ProjectDatasetPickerUI(Main p, omeroconnect.Main os, QueueItemList pq, SessionDetails sd) {
        this.setTitle("OMEROUploader - Project/Dataset Selector");
        this.initComponents();
        this.parent = p;
        this.omeroserver = os;
        this.processqueue = pq;
        this.sessiondetails = sd;
        this.getProjectsDatasetsFromOMERO();
    }

    public void getProjectsFromOMERO(long selected_projectID) {
        long dsid = this.getSelectedDatasetId();
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            String item = this.projectComboBox.getItemAt(i).toString();
            long currid = this.getIdFromString(item);
            if (selected_projectID != currid) continue;
            String txt = this.getUpdatedProjectEntry(selected_projectID);
            this.projectComboBox.insertItemAt(txt, i);
            this.projectComboBox.removeItemAt(i + 1);
            this.projectComboBox.setSelectedIndex(i);
            this.setDatasetCombobox(item);
            this.setSelectedDataset(dsid);
            return;
        }
    }

    public String getUpdatedProjectEntry(long selected_projectID) {
        String entry = "";
        boolean ia = this.omeroserver.isAlive();
        if (ia) {
            System.out.println("Connection alive: TRUE");
        } else {
            System.out.println("Connection alive: FALSE");
        }
        int success = -1;
        success = !ia ? -1 : 1;
        if (!ia) {
            try {
                success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
            }
            catch (Exception ex) {
                System.out.println("ERROR: Connection Failed!");
            }
        }
        if (success == 1) {
            try {
                long id = this.omeroserver.getProject(selected_projectID).getId().getValue();
                String name = this.omeroserver.getProject(selected_projectID).getName().getValue();
                entry = "[" + id + "] " + name;
            }
            catch (Exception ex) {
                System.out.println("ERROR: Unable to retrieve Project ID and name!");
            }
        } else if (success == -1) {
            System.out.println("ERROR: Failed to reach the server.");
        } else if (success == -2) {
            System.out.println("ERROR: Incorrect Username/Password.");
        } else if (success == -3) {
            System.out.println("ERROR: Server Error.");
        }
        return entry;
    }

    public void getProjectsDatasetsFromOMERO() {
        try {
            try {
                this.projectComboBox.removeAllItems();
            }
            catch (Exception ex) {
                System.out.println("WARNING: Clearing ComboBox!");
            }
            List projects = new ArrayList();
            boolean ia = this.omeroserver.isAlive();
            if (ia) {
                System.out.println("Connection alive: TRUE");
            } else {
                System.out.println("Connection alive: FALSE");
            }
            int success = -1;
            success = !ia ? -1 : 1;
            if (!ia) {
                try {
                    success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Connection Failed!");
                }
            }
            if (success == 1) {
                System.out.println("Retrieving Projects...");
                projects = this.omeroserver.getAllProjectsList();
            } else if (success == -1) {
                System.out.println("ERROR: Failed to reach the server.");
            } else if (success == -2) {
                System.out.println("ERROR: Incorrect Username/Password.");
            } else if (success == -3) {
                System.out.println("ERROR: Server Error.");
            }
            for (int i = 0; i < projects.size() + 1; ++i) {
                if (i == 0) {
                    this.projectComboBox.insertItemAt("NONE", i);
                    continue;
                }
                this.projectComboBox.insertItemAt("[" + ((Project)projects.get(i - 1)).getId().getValue() + "] " + ((Project)projects.get(i - 1)).getName().getValue(), i);
            }
            this.projectComboBox.setSelectedIndex(0);
        }
        catch (Exception ex) {
            boolean ia = this.omeroserver.isAlive();
            if (ia) {
                System.out.println("Alive: TRUE");
            } else {
                System.out.println("Alive: FALSE");
            }
            System.out.println("ERROR: Creating PROJECT ComboBox!");
        }
    }

    public long getSelectedProjectId() {
        String projitem = (String)this.projectComboBox.getSelectedItem();
        return this.getIdFromString(projitem);
    }

    public long getSelectedDatasetId() {
        String dsitem = (String)this.datasetComboBox.getSelectedItem();
        return this.getIdFromString(dsitem);
    }

    public void setSelectedDataset(long id) {
        this.setSelectedProject(this.getSelectedProjectId());
        for (int i = 0; i < this.datasetComboBox.getItemCount(); ++i) {
            String item = this.datasetComboBox.getItemAt(i).toString();
            long currid = this.getIdFromString(item);
            if (id != currid) continue;
            this.datasetComboBox.setSelectedIndex(i);
            return;
        }
    }

    public void setSelectedProject(long id) {
        for (int i = 0; i < this.projectComboBox.getItemCount(); ++i) {
            String item = this.projectComboBox.getItemAt(i).toString();
            long currid = this.getIdFromString(item);
            if (id != currid) continue;
            this.projectComboBox.setSelectedIndex(i);
            this.setDatasetCombobox(item);
            return;
        }
    }

    public long getIdFromString(String str) {
        int index1 = str.indexOf("[");
        int index2 = str.indexOf("]");
        if (index1 != -1 && index2 != -1) {
            String indexstr = str.substring(index1 + 1, index2);
            long id = Long.parseLong(indexstr);
            return id;
        }
        return -1L;
    }

    public void setDatasetCombobox(String projectitem) {
        System.out.println("setDatasetCombobox");
        if (projectitem.equals("NONE")) {
            this.datasetComboBox.removeAllItems();
            this.datasetComboBox.insertItemAt("NONE", 0);
            this.datasetComboBox.setSelectedIndex(0);
        } else {
            boolean ia = this.omeroserver.isAlive();
            if (ia) {
                System.out.println("Connection alive: TRUE");
            } else {
                System.out.println("Connection alive: FALSE");
            }
            int success = -1;
            success = !ia ? -1 : 1;
            if (!ia) {
                try {
                    success = this.omeroserver.initConnectionDetails(this.sessiondetails.serveraddress, this.sessiondetails.username, this.sessiondetails.password);
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Connection Failed!");
                }
            }
            if (success == 1) {
                long projid = this.getIdFromString(projectitem);
                try {
                    System.out.println("Retrieving Datasets belonging to ProjectID: " + projid);
                    Project proj = this.omeroserver.getProject(projid);
                    List dsets = this.omeroserver.getDatasetsFromProject(proj);
                    this.datasetComboBox.removeAllItems();
                    for (int i = 0; i < dsets.size() + 1; ++i) {
                        if (i == 0) {
                            this.datasetComboBox.insertItemAt("NONE", i);
                            continue;
                        }
                        this.datasetComboBox.insertItemAt("[" + ((Dataset)dsets.get(i - 1)).getId().getValue() + "] " + ((Dataset)dsets.get(i - 1)).getName().getValue(), i);
                    }
                    this.datasetComboBox.setSelectedIndex(0);
                }
                catch (Exception exp) {
                    System.out.println("ERROR: Creating DATASET ComboBox!");
                }
            } else if (success == -1) {
                System.out.println("ERROR: Failed to reach the server.");
            } else if (success == -2) {
                System.out.println("ERROR: Incorrect Username/Password.");
            } else if (success == -3) {
                System.out.println("ERROR: Server Error.");
            }
        }
    }

    private void initComponents() {
        this.setImageTagsButton1 = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setImageTagsButton = new JButton();
        this.ImagesInheritFromDatasetCheckBox = new JCheckBox();
        this.ImagesInheritFromProjectCheckBox = new JCheckBox();
        this.projectPanel = new JPanel();
        this.projectComboBox = new JComboBox();
        this.addProjectButton = new JButton();
        this.editProjectButton = new JButton();
        this.datasetPanel = new JPanel();
        this.datasetComboBox = new JComboBox();
        this.addDatasetButton = new JButton();
        this.editDatasetButton = new JButton();
        this.projectLabelPanel = new JPanel();
        this.projectLabel = new JLabel();
        this.dsLabelPanel = new JPanel();
        this.datasetLabel = new JLabel();
        this.imageLabelPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.setImageTagsButton1.setText("Set TAGS");
        this.setImageTagsButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.setImageTagsButton1ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(3);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.setImageTagsButton.setText("Set TAGS");
        this.setImageTagsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.setImageTagsButtonActionPerformed(evt);
            }
        });
        this.ImagesInheritFromDatasetCheckBox.setText("Inherit from Dataset");
        this.ImagesInheritFromProjectCheckBox.setText("Inherit from Project");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.setImageTagsButton, -2, 102, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.ImagesInheritFromProjectCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.ImagesInheritFromDatasetCheckBox, -2, 151, -2)).addContainerGap(178, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.ImagesInheritFromProjectCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.ImagesInheritFromDatasetCheckBox)).addComponent(this.setImageTagsButton, GroupLayout.Alignment.LEADING, -2, 53, -2)).addContainerGap()));
        this.projectPanel.setBorder(BorderFactory.createEtchedBorder());
        this.projectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.projectComboBoxActionPerformed(evt);
            }
        });
        this.addProjectButton.setText("New");
        this.addProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.addProjectButtonActionPerformed(evt);
            }
        });
        this.editProjectButton.setText("Edit");
        this.editProjectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.editProjectButtonActionPerformed(evt);
            }
        });
        GroupLayout projectPanelLayout = new GroupLayout(this.projectPanel);
        this.projectPanel.setLayout(projectPanelLayout);
        projectPanelLayout.setHorizontalGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectComboBox, -2, 306, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addProjectButton, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editProjectButton).addContainerGap(-1, Short.MAX_VALUE)));
        projectPanelLayout.setVerticalGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectPanelLayout.createSequentialGroup().addContainerGap().addGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectComboBox, -2, -1, -2).addComponent(this.addProjectButton).addComponent(this.editProjectButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.datasetPanel.setBorder(BorderFactory.createEtchedBorder());
        this.addDatasetButton.setText("New");
        this.addDatasetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.addDatasetButtonActionPerformed(evt);
            }
        });
        this.editDatasetButton.setText("Edit");
        this.editDatasetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectDatasetPickerUI.this.editDatasetButtonActionPerformed(evt);
            }
        });
        GroupLayout datasetPanelLayout = new GroupLayout(this.datasetPanel);
        this.datasetPanel.setLayout(datasetPanelLayout);
        datasetPanelLayout.setHorizontalGroup(datasetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datasetPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.datasetComboBox, -2, 305, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addDatasetButton, -1, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editDatasetButton).addContainerGap()));
        datasetPanelLayout.setVerticalGroup(datasetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datasetPanelLayout.createSequentialGroup().addContainerGap().addGroup(datasetPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasetComboBox, -2, -1, -2).addComponent(this.addDatasetButton).addComponent(this.editDatasetButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.projectLabelPanel.setBorder(BorderFactory.createEtchedBorder());
        this.projectLabelPanel.setPreferredSize(new Dimension(104, 55));
        this.projectLabel.setFont(new Font("Tahoma", 1, 18));
        this.projectLabel.setHorizontalAlignment(0);
        this.projectLabel.setText("Project");
        GroupLayout projectLabelPanelLayout = new GroupLayout(this.projectLabelPanel);
        this.projectLabelPanel.setLayout(projectLabelPanelLayout);
        projectLabelPanelLayout.setHorizontalGroup(projectLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabel, GroupLayout.Alignment.TRAILING, -1, 100, Short.MAX_VALUE));
        projectLabelPanelLayout.setVerticalGroup(projectLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, projectLabelPanelLayout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).addComponent(this.projectLabel).addContainerGap()));
        this.dsLabelPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dsLabelPanel.setPreferredSize(new Dimension(104, 55));
        this.datasetLabel.setFont(new Font("Tahoma", 1, 18));
        this.datasetLabel.setHorizontalAlignment(0);
        this.datasetLabel.setText("Dataset");
        GroupLayout dsLabelPanelLayout = new GroupLayout(this.dsLabelPanel);
        this.dsLabelPanel.setLayout(dsLabelPanelLayout);
        dsLabelPanelLayout.setHorizontalGroup(dsLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetLabel, GroupLayout.Alignment.TRAILING, -1, 100, Short.MAX_VALUE));
        dsLabelPanelLayout.setVerticalGroup(dsLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dsLabelPanelLayout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).addComponent(this.datasetLabel).addContainerGap()));
        this.imageLabelPanel.setBorder(BorderFactory.createEtchedBorder());
        this.imageLabelPanel.setPreferredSize(new Dimension(104, 91));
        this.imageLabel.setFont(new Font("Tahoma", 1, 18));
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setText("Image");
        GroupLayout imageLabelPanelLayout = new GroupLayout(this.imageLabelPanel);
        this.imageLabelPanel.setLayout(imageLabelPanelLayout);
        imageLabelPanelLayout.setHorizontalGroup(imageLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageLabel, GroupLayout.Alignment.TRAILING, -1, 100, Short.MAX_VALUE));
        imageLabelPanelLayout.setVerticalGroup(imageLabelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imageLabelPanelLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.imageLabel).addContainerGap(29, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, 63, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectLabelPanel, -2, -1, -2).addComponent(this.dsLabelPanel, -2, -1, -2)).addComponent(this.imageLabelPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.datasetPanel, -1, -1, Short.MAX_VALUE).addComponent(this.projectPanel, -1, -1, Short.MAX_VALUE))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabelPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.projectPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetPanel, -2, -1, -2).addComponent(this.dsLabelPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.imageLabelPanel, -2, 83, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void setImageTagsButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedProjectId() == -1L) {
            JOptionPane.showMessageDialog(null, "Please specify a PROJECT first.", "ERROR", 0);
            return;
        }
        if (this.getSelectedDatasetId() == -1L) {
            JOptionPane.showMessageDialog(null, "Please specify a DATASET first.", "ERROR", 0);
            return;
        }
        long projIDtoEnherite = -1L;
        long dsIDtoEnherite = -1L;
        if (this.ImagesInheritFromProjectCheckBox.isSelected()) {
            projIDtoEnherite = this.getSelectedProjectId();
        }
        if (this.ImagesInheritFromDatasetCheckBox.isSelected()) {
            dsIDtoEnherite = this.getSelectedDatasetId();
        }
        TagPanelUI tagpanelUI = new TagPanelUI(this, this.omeroserver, 2, projIDtoEnherite, dsIDtoEnherite, this.sessiondetails);
        tagpanelUI.setTagButtons(this.tags);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.parent.addremoveUI_removefromQueue();
        this.setVisible(false);
        this.dispose();
    }

    private void projectComboBoxActionPerformed(ActionEvent evt) {
        String projitem = (String)this.projectComboBox.getSelectedItem();
        this.setDatasetCombobox(projitem);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        long projid = this.getSelectedProjectId();
        long dsid = this.getSelectedDatasetId();
        int tags_selected = !this.tags.isEmpty() ? 1 : -1;
        if (projid != -1L && dsid != -1L && tags_selected != -1) {
            System.out.println("projid " + projid + " dsid " + dsid);
            this.parent.projdspickerUI_okButton(projid, dsid);
        } else {
            String msg = "Please select ";
            if (projid == -1L) {
                msg = msg + " a Project,";
            }
            if (dsid == -1L) {
                msg = msg + " a Dataset, and";
            }
            if (tags_selected == -1) {
                msg = msg + " some TAGS.";
            }
            JOptionPane.showMessageDialog(null, msg, "ERROR", 0);
        }
    }

    private void addProjectButtonActionPerformed(ActionEvent evt) {
        this.newprojdsui = new NewProjectDatasetUI(this, this.omeroserver, "Project", this.sessiondetails);
        this.newprojdsui.setLocationRelativeTo(this);
        this.newprojdsui.setVisible(true);
    }

    private void addDatasetButtonActionPerformed(ActionEvent evt) {
        String projitem = (String)this.projectComboBox.getSelectedItem();
        if (this.getIdFromString(projitem) == -1L) {
            JOptionPane.showMessageDialog(null, "Please select or create a Project first.", "ERROR", 0);
            return;
        }
        this.newprojdsui = new NewProjectDatasetUI(this, this.omeroserver, "Dataset", this.sessiondetails);
        this.newprojdsui.setLocationRelativeTo(this);
        this.newprojdsui.setVisible(true);
    }

    private void setImageTagsButton1ActionPerformed(ActionEvent evt) {
    }

    private void editProjectButtonActionPerformed(ActionEvent evt) {
        String projitem = (String)this.projectComboBox.getSelectedItem();
        if (this.getIdFromString(projitem) == -1L) {
            JOptionPane.showMessageDialog(null, "Please select or create a Project first.", "ERROR", 0);
            return;
        }
        EditProjectDatasetUI editprojdsui = new EditProjectDatasetUI(this, this.omeroserver, "Project", this.sessiondetails);
        editprojdsui.setLocationRelativeTo(this);
        editprojdsui.setVisible(true);
    }

    private void editDatasetButtonActionPerformed(ActionEvent evt) {
        String dsitem = (String)this.datasetComboBox.getSelectedItem();
        if (this.getIdFromString(dsitem) == -1L) {
            JOptionPane.showMessageDialog(null, "Please select or create a Dataset first.", "ERROR", 0);
            return;
        }
        EditProjectDatasetUI editprojdsui = new EditProjectDatasetUI(this, this.omeroserver, "Dataset", this.sessiondetails);
        editprojdsui.setLocationRelativeTo(this);
        editprojdsui.setVisible(true);
    }

    public void setTags(List<String> tgs) {
        System.out.println("Setting " + tgs.size() + " tags.");
        this.tags = tgs;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public static void main(String[] args) {
    }
}

