/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;

class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private Logger logger;
    private Level level;
    private JTextArea logTextArea;

    public LoggingOutputStream(Logger logger, Level level, JTextArea lta) {
        this.logger = logger;
        this.level = level;
        this.logTextArea = lta;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        String record;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record.length() == 0 || record.equals(this.lineSeparator)) {
            return;
        }
        this.logTextArea.append(record + "\n");
        this.logger.logp(this.level, "", "", record);
    }
}

