/*
 * Decompiled with CFR 0.152.
 */
package omerouploader;

import java.util.List;
import javax.swing.SwingWorker;
import omero.model.Image;
import omeroconnect.Main;
import omerouploader.QueueItemList;

public class ImportThread {
    private Main omeroserver;
    private QueueItemList.QueueItem item;
    private SwingWorker parent;

    public ImportThread(QueueItemList.QueueItem itm) {
        this.item = itm;
        this.omeroserver = new Main();
        int success = -1;
        try {
            success = this.omeroserver.initConnectionDetails("cmpdartsvr1.cmp.uea.ac.uk", "avondoj", "avondo");
        }
        catch (Exception ex) {
            System.out.println("ERROR: Failed to login....");
            System.out.println(ex.getMessage());
        }
        if (success == 1) {
            if (itm.optdata) {
                System.out.println("OPTDATADIR_IMPORT!");
                this.doOPTImport();
            } else {
                System.out.println("IMAGE_IMPORT!");
                this.doImport();
            }
        }
        try {
            this.omeroserver.closeConnection();
        }
        catch (Exception ex) {
            System.out.println("ERROR: Failed to logout....");
            System.out.println(ex.getMessage());
        }
    }

    public void doOPTImport() {
        try {
            System.out.println("Importing Image... : " + this.item.fileobj.getPath());
            List imgs = this.omeroserver.uploadOPTDirectory(this.item.fileobj);
            for (int i = 0; i < imgs.size(); ++i) {
                long imgid = ((Image)imgs.get(i)).getId().getValue();
                try {
                    System.out.println("Setting to DatasetID:" + this.item.datasetid);
                    this.omeroserver.attachImageToDataset(this.omeroserver.getDataset(this.item.datasetid), this.omeroserver.getImage(imgid));
                }
                catch (Exception ex) {
                    System.out.println("ERROR: Setting Image to Database failed!");
                    System.out.println(ex.getMessage());
                }
                try {
                    System.out.println("Setting TAGS to the Image...");
                    for (int j = 0; j < this.item.tags.size(); ++j) {
                        this.omeroserver.addTag(this.omeroserver.getImage(imgid), this.item.tags.get(j));
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: Import failed for file: " + this.item.fileobj.getName());
            System.out.println(ex.getMessage());
        }
    }

    public void doImport() {
        try {
            System.out.println("Importing Image... : " + this.item.fileobj.getPath());
            long imgid = this.omeroserver.uploadImage(this.item.fileobj.getAbsoluteFile(), this.item.fileobj.getName(), "").getId().getValue();
            try {
                System.out.println("Setting to DatasetID:" + this.item.datasetid);
                this.omeroserver.attachImageToDataset(this.omeroserver.getDataset(this.item.datasetid), this.omeroserver.getImage(imgid));
            }
            catch (Exception ex) {
                System.out.println("ERROR: Setting Image to Database failed!");
                System.out.println(ex.getMessage());
            }
            try {
                System.out.println("Setting TAGS to the Image...");
                for (int i = 0; i < this.item.tags.size(); ++i) {
                    this.omeroserver.addTag(this.omeroserver.getImage(imgid), this.item.tags.get(i));
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: Import failed for file: " + this.item.fileobj.getName());
            System.out.println(ex.getMessage());
        }
    }
}

