/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import loci.common.CompressedRandomAccess;
import loci.common.HandleException;

public class ZipHandle
extends CompressedRandomAccess {
    private ZipFile zip;
    private ZipEntry entry;

    public ZipHandle(String file) throws IOException {
        this.file = file;
        if (!ZipHandle.isZipFile(file)) {
            throw new HandleException(file + " is not a Zip file.");
        }
        this.zip = new ZipFile(file);
        String innerFile = file.substring(0, file.length() - 4);
        int slash = innerFile.lastIndexOf(File.separator);
        if (slash < 0) {
            slash = innerFile.lastIndexOf("/");
        }
        if (slash >= 0) {
            innerFile = innerFile.substring(slash + 1);
        }
        this.entry = null;
        Enumeration<? extends ZipEntry> e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (ze.getName().startsWith(innerFile)) {
                this.entry = ze;
                break;
            }
            if (this.entry != null) continue;
            this.entry = ze;
        }
        if (this.entry == null) {
            throw new HandleException("Zip file '" + file + "' has no entries");
        }
        this.length = this.entry.getSize();
        this.stream = new DataInputStream(new BufferedInputStream(this.zip.getInputStream(this.entry), 0x100000));
    }

    public static boolean isZipFile(String file) {
        return file.toLowerCase().endsWith(".zip");
    }

    public String getEntryName() {
        return this.entry.getName();
    }

    public DataInputStream getInputStream() {
        return this.stream;
    }

    public void close() throws IOException {
        super.close();
        this.zip = null;
        this.entry = null;
    }

    public void seek(long pos) throws IOException {
        long oldFP = this.fp;
        this.fp = pos;
        if (this.fp > oldFP) {
            long diff = this.fp - oldFP;
            this.stream.skipBytes((int)diff);
        } else if (this.fp < oldFP) {
            this.stream.close();
            this.stream = new DataInputStream(new BufferedInputStream(this.zip.getInputStream(this.entry), 0x100000));
            this.stream.skipBytes((int)this.fp);
        }
    }
}

