/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeicaReader
extends FormatReader {
    public static final String[] LEI_SUFFIX = new String[]{"lei"};
    private static final int LEICA_MAGIC_TAG = 33923;
    private static final String DATE_FORMAT = "yyyy:MM:dd,HH:mm:ss:SSS";
    private static final Integer SERIES = new Integer(10);
    private static final Integer IMAGES = new Integer(15);
    private static final Integer DIMDESCR = new Integer(20);
    private static final Integer FILTERSET = new Integer(30);
    private static final Integer TIMEINFO = new Integer(40);
    private static final Integer SCANNERSET = new Integer(50);
    private static final Integer EXPERIMENT = new Integer(60);
    private static final Integer LUTDESC = new Integer(70);
    private static final Integer CHANDESC = new Integer(80);
    private static final Integer SEQUENTIALSET = new Integer(90);
    private static final Integer SEQ_SCANNERSET = new Integer(200);
    private static final Integer SEQ_FILTERSET = new Integer(700);
    private static final int SEQ_SCANNERSET_END = 300;
    private static final int SEQ_FILTERSET_END = 800;
    private static final Hashtable<String, Integer> CHANNEL_PRIORITIES = LeicaReader.createChannelPriorities();
    private static Hashtable<Integer, String> dimensionNames = LeicaReader.makeDimensionTable();
    protected IFDList ifds;
    protected IFDList headerIFDs;
    protected MinimalTiffReader tiff;
    protected Vector[] files;
    private int numSeries;
    private String leiFilename;
    private Vector<String> seriesNames;
    private Vector<String> seriesDescriptions;
    private int lastPlane = 0;
    private double[][] physicalSizes;
    private double[] pinhole;
    private double[] exposureTime;
    private int nextDetector = 0;
    private int nextChannel = 0;
    private Vector<Integer> activeChannelIndices = new Vector();
    private boolean sequential = false;
    private Vector[] channelNames;
    private Vector[] emWaves;
    private Vector[] exWaves;
    private boolean[][] cutInPopulated;
    private boolean[][] cutOutPopulated;

    private static Hashtable<String, Integer> createChannelPriorities() {
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        h.put("red", new Integer(0));
        h.put("green", new Integer(1));
        h.put("blue", new Integer(2));
        h.put("cyan", new Integer(3));
        h.put("magenta", new Integer(4));
        h.put("yellow", new Integer(5));
        h.put("black", new Integer(6));
        h.put("gray", new Integer(7));
        h.put("", new Integer(8));
        return h;
    }

    public LeicaReader() {
        super("Leica", new String[]{"lei", "tif", "tiff"});
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (LeicaReader.checkSuffix(name, LEI_SUFFIX)) {
            return true;
        }
        if (!LeicaReader.checkSuffix(name, TiffReader.TIFF_SUFFIXES)) {
            return false;
        }
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        return lei.exists();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(new Integer(33923));
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            this.tiff.setId((String)this.files[this.series].get(this.lastPlane));
            return this.tiff.get8BitLookupTable();
        }
        catch (IOException e) {
            this.traceDebug(e);
            return null;
        }
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            this.tiff.setId((String)this.files[this.series].get(this.lastPlane));
            return this.tiff.get16BitLookupTable();
        }
        catch (IOException e) {
            this.traceDebug(e);
            return null;
        }
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        String filename;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        if (no < this.files[this.series].size() && new Location(filename = (String)this.files[this.series].get(no)).exists()) {
            this.tiff.setId(filename);
            return this.tiff.openBytes(0, buf, x, y, w, h);
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        if (this.leiFilename != null) {
            v.add(this.leiFilename);
        }
        if (!noPixels) {
            v.addAll(this.files[this.getSeries()]);
        }
        return v.toArray(new String[v.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.leiFilename = null;
            this.files = null;
            this.headerIFDs = null;
            this.ifds = null;
            this.tiff = null;
            this.seriesNames = null;
            this.numSeries = 0;
            this.lastPlane = 0;
            this.physicalSizes = null;
            this.seriesDescriptions = null;
            this.exposureTime = null;
            this.pinhole = null;
            this.nextDetector = 0;
            this.nextChannel = 0;
            this.sequential = false;
            this.activeChannelIndices.clear();
            this.channelNames = null;
            this.emWaves = null;
            this.exWaves = null;
            this.cutInPopulated = null;
            this.cutOutPopulated = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int i2;
        this.debug("LeicaReader.initFile(" + id + ")");
        this.close();
        if (LeicaReader.checkSuffix(id, TiffReader.TIFF_SUFFIXES) && this.isGroupFiles()) {
            if (this.ifds == null) {
                super.initFile(id);
            }
            this.in = new RandomAccessInputStream(id);
            TiffParser tp = new TiffParser(this.in);
            this.in.order(tp.checkHeader());
            this.in.seek(0L);
            this.status("Finding companion file name");
            this.ifds = tp.getIFDs();
            if (this.ifds == null) {
                throw new FormatException("No IFDs found");
            }
            String descr = ((IFD)this.ifds.get(0)).getComment();
            descr = descr.replaceAll("\\[.*.\\]\n", "");
            String lei = id.substring(0, id.lastIndexOf(File.separator) + 1);
            StringTokenizer lines = new StringTokenizer(descr, "\n");
            String line = null;
            String key = null;
            String value = null;
            while (lines.hasMoreTokens()) {
                line = lines.nextToken();
                if (line.indexOf("=") == -1) continue;
                key = line.substring(0, line.indexOf("=")).trim();
                value = line.substring(line.indexOf("=") + 1).trim();
                this.addGlobalMeta(key, value);
                if (!key.startsWith("Series Name")) continue;
                lei = lei + value;
            }
            Location l = new Location(lei).getAbsoluteFile();
            if (l.exists()) {
                this.initFile(lei);
                return;
            }
            l = l.getParentFile();
            String[] list = l.list();
            for (int i3 = 0; i3 < list.length; ++i3) {
                if (!LeicaReader.checkSuffix(list[i3], LEI_SUFFIX)) continue;
                this.initFile(new Location(l.getAbsolutePath(), list[i3]).getAbsolutePath());
                return;
            }
            throw new FormatException("LEI file not found.");
        }
        if (LeicaReader.checkSuffix(id, TiffReader.TIFF_SUFFIXES) && !this.isGroupFiles()) {
            super.initFile(id);
            TiffReader r = new TiffReader();
            r.setMetadataStore(this.getMetadataStore());
            r.setId(id);
            this.core = r.getCoreMetadata();
            this.metadata = r.getMetadata();
            this.metadataStore = r.getMetadataStore();
            r.close();
            this.files = new Vector[]{new Vector()};
            this.files[0].add(id);
            this.tiff = new MinimalTiffReader();
            return;
        }
        super.initFile(id);
        this.leiFilename = new File(id).exists() ? new Location(id).getAbsolutePath() : id;
        this.in = new RandomAccessInputStream(id);
        this.seriesNames = new Vector();
        byte[] fourBytes = new byte[4];
        this.in.read(fourBytes);
        this.core[0].littleEndian = fourBytes[0] == 73 && fourBytes[1] == 73 && fourBytes[2] == 73 && fourBytes[3] == 73;
        this.in.order(this.isLittleEndian());
        this.status("Reading metadata blocks");
        this.in.skipBytes(8);
        int addr = this.in.readInt();
        this.headerIFDs = new IFDList();
        while (addr != 0) {
            IFD ifd = new IFD();
            this.headerIFDs.add(ifd);
            this.in.seek(addr + 4);
            int tag = this.in.readInt();
            while (tag != 0) {
                int offset = this.in.readInt();
                long pos = this.in.getFilePointer();
                this.in.seek(offset + 12);
                int size = this.in.readInt();
                byte[] data = new byte[size];
                this.in.read(data);
                ifd.putIFDValue(tag, data);
                this.in.seek(pos);
                tag = this.in.readInt();
            }
            addr = this.in.readInt();
        }
        this.numSeries = this.headerIFDs.size();
        this.core = new CoreMetadata[this.numSeries];
        for (i2 = 0; i2 < this.numSeries; ++i2) {
            this.core[i2] = new CoreMetadata();
        }
        this.files = new Vector[this.numSeries];
        this.channelNames = new Vector[this.getSeriesCount()];
        this.emWaves = new Vector[this.getSeriesCount()];
        this.exWaves = new Vector[this.getSeriesCount()];
        this.cutInPopulated = new boolean[this.getSeriesCount()][];
        this.cutOutPopulated = new boolean[this.getSeriesCount()][];
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            this.channelNames[i2] = new Vector();
            this.emWaves[i2] = new Vector();
            this.exWaves[i2] = new Vector();
        }
        int nameLength = 0;
        int maxPlanes = 0;
        this.status("Parsing metadata blocks");
        this.core[0].littleEndian = !this.isLittleEndian();
        boolean seriesIndex = false;
        boolean[] valid = new boolean[this.numSeries];
        for (int i4 = 0; i4 < this.headerIFDs.size(); ++i4) {
            IFD ifd = (IFD)this.headerIFDs.get(i4);
            valid[i4] = true;
            if (ifd.get(SERIES) != null) {
                byte[] temp = (byte[])ifd.get(SERIES);
                nameLength = DataTools.bytesToInt(temp, 8, this.isLittleEndian()) * 2;
            }
            Vector<String> f = new Vector<String>();
            byte[] tempData = (byte[])ifd.get(IMAGES);
            RandomAccessInputStream data = new RandomAccessInputStream(tempData);
            data.order(this.isLittleEndian());
            int tempImages = data.readInt();
            if ((long)tempImages * (long)nameLength > data.length()) {
                data.order(!this.isLittleEndian());
                tempImages = data.readInt();
                data.order(this.isLittleEndian());
            }
            this.core[i4].sizeX = data.readInt();
            this.core[i4].sizeY = data.readInt();
            data.skipBytes(4);
            int samplesPerPixel = data.readInt();
            this.core[i4].rgb = samplesPerPixel > 1;
            this.core[i4].sizeC = samplesPerPixel;
            File dirFile = new File(id).getAbsoluteFile();
            String[] listing = null;
            String dirPrefix = "";
            if (dirFile.exists()) {
                listing = dirFile.getParentFile().list();
                dirPrefix = dirFile.getParent();
                if (!dirPrefix.endsWith(File.separator)) {
                    dirPrefix = dirPrefix + File.separator;
                }
            } else {
                listing = Location.getIdMap().keySet().toArray(new String[0]);
            }
            Vector<String> list = new Vector<String>();
            for (int k = 0; k < listing.length; ++k) {
                if (!LeicaReader.checkSuffix(listing[k], TiffReader.TIFF_SUFFIXES)) continue;
                list.add(listing[k]);
            }
            boolean tiffsExist = false;
            String prefix = "";
            for (int j = 0; j < tempImages; ++j) {
                prefix = this.getString(data, nameLength);
                f.add(dirPrefix + prefix);
                Location test = new Location((String)f.get(f.size() - 1));
                if (test.exists()) {
                    list.remove(prefix);
                }
                if (tiffsExist) continue;
                tiffsExist = test.exists();
            }
            data.close();
            tempData = null;
            if (!tiffsExist) {
                this.status("Handling renamed TIFF files");
                listing = list.toArray(new String[list.size()]);
                Vector<String> filePatterns = new Vector<String>();
                for (String q : listing) {
                    Location l = new Location(dirPrefix, q).getAbsoluteFile();
                    FilePattern pattern = new FilePattern(l);
                    AxisGuesser guess = new AxisGuesser(pattern, "XYZCT", 1, 1, 1, false);
                    String fp = pattern.getPattern();
                    if (guess.getAxisCountS() >= 1) {
                        String pre = pattern.getPrefix(guess.getAxisCountS());
                        Vector<String> fileList = new Vector<String>();
                        for (int n = 0; n < listing.length; ++n) {
                            Location p = new Location(dirPrefix, listing[n]);
                            if (!p.getAbsolutePath().startsWith(pre)) continue;
                            fileList.add(listing[n]);
                        }
                        fp = FilePattern.findPattern(l.getAbsolutePath(), dirPrefix, fileList.toArray(new String[fileList.size()]));
                    }
                    if (fp == null || filePatterns.contains(fp)) continue;
                    filePatterns.add(fp);
                }
                for (String q : filePatterns) {
                    String[] pattern = new FilePattern(q).getFiles();
                    if (pattern.length != tempImages) continue;
                    boolean validPattern = true;
                    for (int n = 0; n < i4; ++n) {
                        if (this.files[n] == null || !this.files[n].contains(pattern[0])) continue;
                        validPattern = false;
                        break;
                    }
                    if (!validPattern) continue;
                    this.files[i4] = new Vector();
                    this.files[i4].addAll(Arrays.asList(pattern));
                }
            } else {
                this.files[i4] = f;
            }
            if (this.files[i4] == null) {
                valid[i4] = false;
                continue;
            }
            this.core[i4].imageCount = this.files[i4].size();
            if (this.core[i4].imageCount <= maxPlanes) continue;
            maxPlanes = this.core[i4].imageCount;
        }
        int invalidCount = 0;
        for (int i5 = 0; i5 < valid.length; ++i5) {
            if (valid[i5]) continue;
            ++invalidCount;
        }
        this.numSeries -= invalidCount;
        int[] count = new int[this.getSeriesCount()];
        for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
            count[i6] = this.core[i6].imageCount;
        }
        Vector[] tempFiles = this.files;
        IFDList tempIFDs = this.headerIFDs;
        this.core = new CoreMetadata[this.numSeries];
        this.files = new Vector[this.numSeries];
        this.headerIFDs = new IFDList();
        int index = 0;
        for (int i7 = 0; i7 < this.numSeries; ++i7) {
            this.core[i7] = new CoreMetadata();
            while (!valid[index]) {
                ++index;
            }
            this.core[i7].imageCount = count[index];
            this.files[i7] = tempFiles[index];
            Object[] sorted = this.files[i7].toArray();
            Arrays.sort(sorted);
            this.files[i7].clear();
            this.files[i7].addAll(Arrays.asList(sorted));
            this.headerIFDs.add(tempIFDs.get(index));
            ++index;
        }
        this.tiff = new MinimalTiffReader();
        this.status("Populating metadata");
        if (this.headerIFDs == null) {
            this.headerIFDs = this.ifds;
        }
        int fileLength = 0;
        int resolution = -1;
        String[][] timestamps = new String[this.headerIFDs.size()][];
        this.seriesDescriptions = new Vector();
        this.physicalSizes = new double[this.headerIFDs.size()][5];
        this.pinhole = new double[this.headerIFDs.size()];
        this.exposureTime = new double[this.headerIFDs.size()];
        for (i = 0; i < this.headerIFDs.size(); ++i) {
            IFD ifd = (IFD)this.headerIFDs.get(i);
            this.core[i].littleEndian = this.isLittleEndian();
            this.setSeries(i);
            Object[] keys = ifd.keySet().toArray();
            Arrays.sort(keys);
            for (int q = 0; q < keys.length; ++q) {
                byte[] tmp = (byte[])ifd.get(keys[q]);
                if (tmp == null) continue;
                RandomAccessInputStream stream = new RandomAccessInputStream(tmp);
                stream.order(this.isLittleEndian());
                if (keys[q].equals(SERIES)) {
                    this.addSeriesMeta("Version", stream.readInt());
                    this.addSeriesMeta("Number of Series", stream.readInt());
                    fileLength = stream.readInt();
                    this.addSeriesMeta("Length of filename", fileLength);
                    int extLen = stream.readInt();
                    if (extLen > fileLength) {
                        stream.seek(8L);
                        this.core[0].littleEndian = !this.isLittleEndian();
                        stream.order(this.isLittleEndian());
                        fileLength = stream.readInt();
                        extLen = stream.readInt();
                    }
                    this.addSeriesMeta("Length of file extension", extLen);
                    this.addSeriesMeta("Image file extension", this.getString(stream, extLen));
                } else if (keys[q].equals(IMAGES)) {
                    this.core[i].imageCount = stream.readInt();
                    this.core[i].sizeX = stream.readInt();
                    this.core[i].sizeY = stream.readInt();
                    this.addSeriesMeta("Number of images", this.getImageCount());
                    this.addSeriesMeta("Image width", this.getSizeX());
                    this.addSeriesMeta("Image height", this.getSizeY());
                    this.addSeriesMeta("Bits per Sample", stream.readInt());
                    this.addSeriesMeta("Samples per pixel", stream.readInt());
                    String name = this.getString(stream, fileLength * 2);
                    if (name.indexOf(".") != -1) {
                        name = name.substring(0, name.lastIndexOf("."));
                    }
                    String[] tokens = name.split("_");
                    StringBuffer buf = new StringBuffer();
                    for (int p = 1; p < tokens.length; ++p) {
                        String lcase = tokens[p].toLowerCase();
                        if (lcase.startsWith("ch0") || lcase.startsWith("c0") || lcase.startsWith("z0") || lcase.startsWith("t0")) continue;
                        if (buf.length() > 0) {
                            buf.append("_");
                        }
                        buf.append(tokens[p]);
                    }
                    this.seriesNames.add(buf.toString());
                } else if (keys[q].equals(DIMDESCR)) {
                    this.addSeriesMeta("Voxel Version", stream.readInt());
                    this.core[i].rgb = stream.readInt() == 20;
                    this.addSeriesMeta("VoxelType", this.isRGB() ? "RGB" : "gray");
                    int bpp = stream.readInt();
                    this.addSeriesMeta("Bytes per pixel", bpp);
                    switch (bpp) {
                        case 1: {
                            this.core[i].pixelType = 1;
                            break;
                        }
                        case 3: {
                            this.core[i].pixelType = 1;
                            this.core[i].sizeC = 3;
                            this.core[i].rgb = true;
                            break;
                        }
                        case 2: {
                            this.core[i].pixelType = 3;
                            break;
                        }
                        case 6: {
                            this.core[i].pixelType = 3;
                            this.core[i].sizeC = 3;
                            this.core[i].rgb = true;
                            break;
                        }
                        case 4: {
                            this.core[i].pixelType = 5;
                            break;
                        }
                        default: {
                            throw new FormatException("Unsupported bytes per pixel (" + bpp + ")");
                        }
                    }
                    this.core[i].dimensionOrder = "XY";
                    this.core[i].bitsPerPixel = resolution = stream.readInt();
                    this.addSeriesMeta("Real world resolution", resolution);
                    this.addSeriesMeta("Maximum voxel intensity", this.getString(stream, true));
                    this.addSeriesMeta("Minimum voxel intensity", this.getString(stream, true));
                    int len = stream.readInt();
                    stream.skipBytes(len * 2 + 4);
                    len = stream.readInt();
                    for (int j = 0; j < len; ++j) {
                        int dimId = stream.readInt();
                        String dimType = dimensionNames.get(new Integer(dimId));
                        if (dimType == null) {
                            dimType = "";
                        }
                        int size = stream.readInt();
                        int distance = stream.readInt();
                        int strlen = stream.readInt() * 2;
                        String[] sizeData = this.getString(stream, strlen).split(" ");
                        String physicalSize = sizeData[0];
                        String unit = "";
                        if (sizeData.length > 1) {
                            unit = sizeData[1];
                        }
                        double physical = Double.parseDouble(physicalSize) / (double)size;
                        if (unit.equals("m")) {
                            physical *= 1000000.0;
                        }
                        if (dimType.equals("x")) {
                            this.core[i].sizeX = size;
                            this.physicalSizes[i][0] = physical;
                        } else if (dimType.equals("y")) {
                            this.core[i].sizeY = size;
                            this.physicalSizes[i][1] = physical;
                        } else if (dimType.equals("channel")) {
                            if (this.getSizeC() == 0) {
                                this.core[i].sizeC = 1;
                            }
                            this.core[i].sizeC *= size;
                            if (this.getDimensionOrder().indexOf("C") == -1) {
                                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
                            }
                            this.physicalSizes[i][3] = physical;
                        } else if (dimType.equals("z")) {
                            this.core[i].sizeZ = size;
                        } else {
                            this.core[i].sizeT = size;
                            if (this.getDimensionOrder().indexOf("T") == -1) {
                                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
                            }
                            this.physicalSizes[i][4] = physical;
                        }
                        String dimPrefix = "Dim" + j;
                        this.addSeriesMeta(dimPrefix + " type", dimType);
                        this.addSeriesMeta(dimPrefix + " size", size);
                        this.addSeriesMeta(dimPrefix + " distance between sub-dimensions", distance);
                        this.addSeriesMeta(dimPrefix + " physical length", physicalSize + " " + unit);
                        this.addSeriesMeta(dimPrefix + " physical origin", this.getString(stream, true));
                    }
                    this.addSeriesMeta("Series name", this.getString(stream, false));
                    String description = this.getString(stream, false);
                    this.seriesDescriptions.add(description);
                    this.addSeriesMeta("Series description", description);
                } else if (keys[q].equals(TIMEINFO)) {
                    int nDims = stream.readInt();
                    this.addSeriesMeta("Number of time-stamped dimensions", nDims);
                    this.addSeriesMeta("Time-stamped dimension", stream.readInt());
                    for (int j = 0; j < nDims; ++j) {
                        String dimPrefix = "Dimension " + j;
                        this.addSeriesMeta(dimPrefix + " ID", stream.readInt());
                        this.addSeriesMeta(dimPrefix + " size", stream.readInt());
                        this.addSeriesMeta(dimPrefix + " distance", stream.readInt());
                    }
                    int numStamps = stream.readInt();
                    this.addSeriesMeta("Number of time-stamps", numStamps);
                    timestamps[i] = new String[numStamps];
                    for (int j = 0; j < numStamps; ++j) {
                        timestamps[i][j] = this.getString(stream, 64);
                        this.addSeriesMeta("Timestamp " + j, timestamps[i][j]);
                    }
                    if (stream.getFilePointer() < stream.length()) {
                        int numTMs = stream.readInt();
                        this.addSeriesMeta("Number of time-markers", numTMs);
                        for (int j = 0; j < numTMs; ++j) {
                            int numDims = stream.readInt();
                            String time = "Time-marker " + j + " Dimension ";
                            for (int k = 0; k < numDims; ++k) {
                                this.addSeriesMeta(time + k + " coordinate", stream.readInt());
                            }
                            this.addSeriesMeta("Time-marker " + j, this.getString(stream, 64));
                        }
                    }
                } else if (keys[q].equals(EXPERIMENT)) {
                    stream.skipBytes(8);
                    String description = this.getString(stream, true);
                    this.addSeriesMeta("Image Description", description);
                    this.addSeriesMeta("Main file extension", this.getString(stream, true));
                    this.addSeriesMeta("Image format identifier", this.getString(stream, true));
                    this.addSeriesMeta("Single image extension", this.getString(stream, true));
                } else if (keys[q].equals(LUTDESC)) {
                    int nChannels = stream.readInt();
                    if (nChannels > 0) {
                        this.core[i].indexed = true;
                    }
                    this.addSeriesMeta("Number of LUT channels", nChannels);
                    this.addSeriesMeta("ID of colored dimension", stream.readInt());
                    for (int j = 0; j < nChannels; ++j) {
                        String p = "LUT Channel " + j;
                        this.addSeriesMeta(p + " version", stream.readInt());
                        this.addSeriesMeta(p + " inverted?", stream.read() == 1);
                        this.addSeriesMeta(p + " description", this.getString(stream, false));
                        this.addSeriesMeta(p + " filename", this.getString(stream, false));
                        String lut = this.getString(stream, false);
                        this.addSeriesMeta(p + " name", lut);
                        stream.skipBytes(8);
                    }
                } else if (keys[q].equals(CHANDESC)) {
                    int nBands = stream.readInt();
                    for (int band = 0; band < nBands; ++band) {
                        String p = "Band #" + (band + 1) + " ";
                        this.addSeriesMeta(p + "Lower wavelength", stream.readDouble());
                        stream.skipBytes(4);
                        this.addSeriesMeta(p + "Higher wavelength", stream.readDouble());
                        stream.skipBytes(4);
                        this.addSeriesMeta(p + "Gain", stream.readDouble());
                        this.addSeriesMeta(p + "Offset", stream.readDouble());
                    }
                }
                stream.close();
            }
            this.core[i].orderCertain = true;
            this.core[i].littleEndian = this.isLittleEndian();
            this.core[i].falseColor = true;
            this.core[i].metadataComplete = true;
            this.core[i].interleaved = false;
        }
        for (i = 0; i < this.numSeries; ++i) {
            this.setSeries(i);
            if (this.getSizeZ() == 0) {
                this.core[i].sizeZ = 1;
            }
            if (this.getSizeT() == 0) {
                this.core[i].sizeT = 1;
            }
            if (this.getSizeC() == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.getImageCount() == 0) {
                this.core[i].imageCount = 1;
            }
            if (this.getImageCount() == 1 && this.getSizeZ() * this.getSizeT() > 1) {
                this.core[i].sizeZ = 1;
                this.core[i].sizeT = 1;
            }
            if (this.getSizeY() == 1) {
                if (this.getSizeZ() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeT()) {
                    this.core[i].sizeY = this.getSizeZ();
                    this.core[i].sizeZ = 1;
                } else if (this.getSizeT() > 1 && this.getImageCount() == this.getSizeC() * this.getSizeZ()) {
                    this.core[i].sizeY = this.getSizeT();
                    this.core[i].sizeT = 1;
                }
            }
            if (this.isRGB()) {
                this.core[i].indexed = false;
            }
            if (this.getDimensionOrder().indexOf("C") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "C";
            }
            if (this.getDimensionOrder().indexOf("Z") == -1) {
                this.core[i].dimensionOrder = this.core[i].dimensionOrder + "Z";
            }
            if (this.getDimensionOrder().indexOf("T") != -1) continue;
            this.core[i].dimensionOrder = this.core[i].dimensionOrder + "T";
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        for (int i8 = 0; i8 < this.numSeries; ++i8) {
            IFD ifd = (IFD)this.headerIFDs.get(i8);
            long firstPlane = 0L;
            if (i8 < timestamps.length && timestamps[i8] != null && timestamps[i8].length > 0) {
                firstPlane = DateTools.getTime(timestamps[i8][0], DATE_FORMAT);
                store.setImageCreationDate(DateTools.formatDate(timestamps[i8][0], DATE_FORMAT), i8);
            } else {
                MetadataTools.setDefaultCreationDate(store, id, i8);
            }
            store.setImageName(this.seriesNames.get(i8), i8);
            store.setImageDescription(this.seriesDescriptions.get(i8), i8);
            String instrumentID = MetadataTools.createLSID("Instrument", i8);
            store.setInstrumentID(instrumentID, i8);
            this.nextDetector = 0;
            this.nextChannel = 0;
            this.cutInPopulated[i8] = new boolean[this.core[i8].sizeC];
            this.cutOutPopulated[i8] = new boolean[this.core[i8].sizeC];
            Object[] keys = ifd.keySet().toArray();
            Arrays.sort(keys);
            int nextInstrumentBlock = 1;
            this.sequential = DataTools.indexOf(keys, SEQ_SCANNERSET) != -1;
            for (int q = 0; q < keys.length; ++q) {
                byte[] tmp;
                if (!keys[q].equals(FILTERSET) && !keys[q].equals(SCANNERSET) && !keys[q].equals(SEQ_SCANNERSET) && !keys[q].equals(SEQ_FILTERSET) && ((Integer)keys[q] <= SEQ_SCANNERSET || (Integer)keys[q] >= 300) && ((Integer)keys[q] <= SEQ_FILTERSET || (Integer)keys[q] >= 800) || this.sequential && (keys[q].equals(FILTERSET) || keys[q].equals(SCANNERSET)) || (tmp = (byte[])ifd.get(keys[q])) == null) continue;
                RandomAccessInputStream stream = new RandomAccessInputStream(tmp);
                stream.order(this.isLittleEndian());
                this.parseInstrumentData(stream, store, i8, nextInstrumentBlock++);
                stream.close();
            }
            this.activeChannelIndices.clear();
            store.setImageInstrumentRef(instrumentID, i8);
            store.setDimensionsPhysicalSizeX(new Double(this.physicalSizes[i8][0]), i8, 0);
            store.setDimensionsPhysicalSizeY(new Double(this.physicalSizes[i8][1]), i8, 0);
            store.setDimensionsPhysicalSizeZ(new Double(this.physicalSizes[i8][2]), i8, 0);
            if ((int)this.physicalSizes[i8][3] > 0) {
                store.setDimensionsWaveIncrement(new Integer((int)this.physicalSizes[i8][3]), i8, 0);
            }
            if ((int)this.physicalSizes[i8][4] > 0) {
                store.setDimensionsTimeIncrement(new Double(this.physicalSizes[i8][4]), i8, 0);
            }
            for (int j = 0; j < this.core[i8].imageCount; ++j) {
                if (timestamps[i8] == null || j >= timestamps[i8].length) continue;
                long time = DateTools.getTime(timestamps[i8][j], DATE_FORMAT);
                double elapsedTime = (double)(time - firstPlane) / 1000.0;
                store.setPlaneTimingDeltaT(new Double(elapsedTime), i8, 0, j);
                store.setPlaneTimingExposureTime(new Double(this.exposureTime[i8]), i8, 0, j);
            }
        }
        this.setSeries(0);
    }

    private void parseInstrumentData(RandomAccessInputStream stream, MetadataStore store, int series, int blockNum) throws IOException {
        this.setSeries(series);
        stream.skipBytes(4);
        int cbElements = stream.readInt();
        stream.skipBytes(8);
        int nElements = stream.readInt();
        stream.skipBytes(4);
        for (int j = 0; j < nElements; ++j) {
            String data;
            String contentID;
            block75: {
                stream.seek(24 + j * cbElements);
                contentID = this.getString(stream, 128);
                String description = this.getString(stream, 64);
                data = this.getString(stream, 64);
                short dataType = stream.readShort();
                stream.skipBytes(6);
                switch (dataType) {
                    case 2: {
                        data = String.valueOf(stream.readShort());
                        break;
                    }
                    case 3: {
                        data = String.valueOf(stream.readInt());
                        break;
                    }
                    case 4: {
                        data = String.valueOf(stream.readFloat());
                        break;
                    }
                    case 5: {
                        data = String.valueOf(stream.readDouble());
                        break;
                    }
                    case 7: 
                    case 11: {
                        data = stream.read() == 0 ? "false" : "true";
                        break;
                    }
                    case 17: {
                        data = stream.readString(1);
                    }
                }
                String[] tokens = contentID.split("\\|");
                if (tokens[0].startsWith("CDetectionUnit")) {
                    if (tokens[1].startsWith("PMT")) {
                        try {
                            if (tokens[2].equals("VideoOffset")) {
                                store.setDetectorOffset(new Double(data), series, this.nextDetector);
                                break block75;
                            }
                            if (tokens[2].equals("HighVoltage")) {
                                store.setDetectorVoltage(new Double(data), series, this.nextDetector);
                                ++this.nextDetector;
                                break block75;
                            }
                            if (!tokens[2].equals("State")) break block75;
                            store.setDetectorType("PMT", series, this.nextDetector);
                            if (!data.equals("Active")) break block75;
                            String index = tokens[1].substring(tokens[1].indexOf(" ") + 1);
                            int channelIndex = -1;
                            try {
                                channelIndex = Integer.parseInt(index) - 1;
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (channelIndex >= 0) {
                                this.activeChannelIndices.add(new Integer(channelIndex));
                            }
                            String detectorID = MetadataTools.createLSID("Detector", series, this.nextDetector);
                            store.setDetectorID(detectorID, series, this.nextDetector);
                            if (this.nextDetector == 0) {
                                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                                    store.setDetectorSettingsDetector(detectorID, series, c);
                                }
                            }
                            if (this.nextChannel < this.getEffectiveSizeC()) {
                                store.setDetectorSettingsDetector(detectorID, series, this.nextChannel++);
                            }
                        }
                        catch (NumberFormatException e) {
                            this.traceDebug(e);
                        }
                    }
                } else if (tokens[0].startsWith("CTurret")) {
                    int objective = Integer.parseInt(tokens[3]);
                    if (tokens[2].equals("NumericalAperture")) {
                        store.setObjectiveLensNA(new Double(data), series, objective);
                    } else if (tokens[2].equals("Objective")) {
                        String[] objectiveData = data.split(" ");
                        StringBuffer model = new StringBuffer();
                        String mag = null;
                        String na = null;
                        String immersion = null;
                        String correction = null;
                        for (int i = 0; i < objectiveData.length; ++i) {
                            if (objectiveData[i].indexOf("x") != -1 && mag == null && na == null) {
                                int xIndex = objectiveData[i].indexOf("x");
                                mag = objectiveData[i].substring(0, xIndex).trim();
                                na = objectiveData[i].substring(xIndex + 1).trim();
                                continue;
                            }
                            if (mag == null && na == null) {
                                model.append(objectiveData[i]);
                                model.append(" ");
                                continue;
                            }
                            if (correction == null) {
                                correction = objectiveData[i];
                                continue;
                            }
                            if (immersion != null) continue;
                            immersion = objectiveData[i];
                        }
                        if (immersion == null || immersion.trim().equals("")) {
                            immersion = "Unknown";
                        }
                        if (correction == null) {
                            correction = "Unknown";
                        }
                        store.setObjectiveImmersion(immersion, series, objective);
                        store.setObjectiveCorrection(correction.trim(), series, objective);
                        store.setObjectiveModel(model.toString().trim(), series, objective);
                        store.setObjectiveLensNA(new Double(na), series, objective);
                        store.setObjectiveNominalMagnification(new Integer((int)Double.parseDouble(mag)), series, objective);
                    } else if (tokens[2].equals("OrderNumber")) {
                        store.setObjectiveSerialNumber(data, series, objective);
                    } else if (tokens[2].equals("RefractionIndex")) {
                        store.setObjectiveSettingsRefractiveIndex(new Double(data), series);
                    }
                    String objectiveID = MetadataTools.createLSID("Objective", series, objective);
                    store.setObjectiveID(objectiveID, series, objective);
                    if (objective == 0) {
                        store.setObjectiveSettingsObjective(objectiveID, series);
                    }
                } else if (tokens[0].startsWith("CSpectrophotometerUnit")) {
                    int ndx = tokens[1].lastIndexOf(" ");
                    int channel = Integer.parseInt(tokens[1].substring(ndx + 1)) - 1;
                    if (tokens[2].equals("Wavelength")) {
                        Integer wavelength = new Integer((int)Double.parseDouble(data));
                        store.setFilterModel(tokens[1], series, channel);
                        String filterID = MetadataTools.createLSID("Filter", series, channel);
                        store.setFilterID(filterID, series, channel);
                        int index = this.activeChannelIndices.indexOf(new Integer(channel));
                        if (index >= 0 && index < this.core[series].sizeC) {
                            store.setLogicalChannelSecondaryEmissionFilter(filterID, series, index);
                            if (tokens[3].equals("0") && !this.cutInPopulated[series][index]) {
                                store.setTransmittanceRangeCutIn(wavelength, series, channel);
                                this.cutInPopulated[series][index] = true;
                            } else if (tokens[3].equals("1") && !this.cutOutPopulated[series][index]) {
                                store.setTransmittanceRangeCutOut(wavelength, series, channel);
                                this.cutOutPopulated[series][index] = true;
                            }
                        }
                    } else if (tokens[2].equals("Stain") && this.activeChannelIndices.contains(new Integer(channel))) {
                        String prevValue;
                        int nNames = this.channelNames[series].size();
                        String string = prevValue = nNames == 0 ? "" : (String)this.channelNames[series].get(nNames - 1);
                        if (!prevValue.equals(data)) {
                            this.channelNames[series].add(data);
                        }
                    }
                } else if (tokens[0].startsWith("CXYZStage")) {
                    if (tokens[2].equals("XPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setStagePositionPositionX(new Double(data), series, 0, q);
                        }
                    } else if (tokens[2].equals("YPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setStagePositionPositionY(new Double(data), series, 0, q);
                        }
                    } else if (tokens[2].equals("ZPos")) {
                        for (int q = 0; q < this.core[series].imageCount; ++q) {
                            store.setStagePositionPositionZ(new Double(data), series, 0, q);
                        }
                    }
                } else if (tokens[0].equals("CScanActuator") && tokens[1].equals("Z Scan Actuator") && tokens[2].equals("Position")) {
                    double pos = Double.parseDouble(data) * 1000000.0;
                    for (int q = 0; q < this.core[series].imageCount; ++q) {
                        store.setStagePositionPositionZ(new Double(pos), series, 0, q);
                    }
                }
            }
            if (contentID.equals("dblVoxelX")) {
                this.physicalSizes[series][0] = Double.parseDouble(data);
            } else if (contentID.equals("dblVoxelY")) {
                this.physicalSizes[series][1] = Double.parseDouble(data);
            } else if (contentID.equals("dblStepSize")) {
                this.physicalSizes[series][2] = Double.parseDouble(data);
            } else if (contentID.equals("dblPinhole")) {
                this.pinhole[series] = Double.parseDouble(data) * 1000000.0;
            } else if (contentID.startsWith("nDelayTime")) {
                this.exposureTime[series] = Double.parseDouble(data);
                if (contentID.endsWith("_ms")) {
                    int n = series;
                    this.exposureTime[n] = this.exposureTime[n] / 1000.0;
                }
            }
            this.addSeriesMeta("Block " + blockNum + " " + contentID, data);
        }
        stream.close();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            for (int channel = 0; channel < this.getEffectiveSizeC(); ++channel) {
                String name;
                if (channel < this.channelNames[i].size() && (name = (String)this.channelNames[i].get(channel)) != null && !name.trim().equals("") && !name.equals("None")) {
                    store.setLogicalChannelName(name, i, channel);
                }
                if (channel < this.emWaves[i].size()) {
                    store.setLogicalChannelEmWave((Integer)this.emWaves[i].get(channel), i, channel);
                }
                if (channel < this.exWaves[i].size()) {
                    store.setLogicalChannelExWave((Integer)this.exWaves[i].get(channel), i, channel);
                }
                if (i >= this.pinhole.length) continue;
                store.setLogicalChannelPinholeSize(new Double(this.pinhole[i]), i, channel);
            }
        }
        this.setSeries(0);
    }

    private boolean usedFile(String s) {
        if (this.files == null) {
            return false;
        }
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i] == null) continue;
            for (int j = 0; j < this.files[i].size(); ++j) {
                if (!((String)this.files[i].get(j)).endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    private String getString(RandomAccessInputStream stream, int len) throws IOException {
        return DataTools.stripString(stream.readString(len));
    }

    private String getString(RandomAccessInputStream stream, boolean doubleLength) throws IOException {
        int len = stream.readInt();
        if (doubleLength) {
            len *= 2;
        }
        return this.getString(stream, len);
    }

    private static Hashtable<Integer, String> makeDimensionTable() {
        Hashtable<Integer, String> table = new Hashtable<Integer, String>();
        table.put(new Integer(0), "undefined");
        table.put(new Integer(120), "x");
        table.put(new Integer(121), "y");
        table.put(new Integer(122), "z");
        table.put(new Integer(116), "t");
        table.put(new Integer(6815843), "channel");
        table.put(new Integer(6357100), "wave length");
        table.put(new Integer(7602290), "rotation");
        table.put(new Integer(0x770078), "x-wide for the motorized xy-stage");
        table.put(new Integer(0x770079), "y-wide for the motorized xy-stage");
        table.put(new Integer(0x77007A), "z-wide for the z-stage-drive");
        table.put(new Integer(4259957), "user1 - unspecified");
        table.put(new Integer(4325493), "user2 - unspecified");
        table.put(new Integer(4391029), "user3 - unspecified");
        table.put(new Integer(6357095), "graylevel");
        table.put(new Integer(6422631), "graylevel1");
        table.put(new Integer(6488167), "graylevel2");
        table.put(new Integer(6553703), "graylevel3");
        table.put(new Integer(7864398), "logical x");
        table.put(new Integer(7929934), "logical y");
        table.put(new Integer(7995470), "logical z");
        table.put(new Integer(7602254), "logical t");
        table.put(new Integer(7077966), "logical lambda");
        table.put(new Integer(7471182), "logical rotation");
        table.put(new Integer(5767246), "logical x-wide");
        table.put(new Integer(5832782), "logical y-wide");
        table.put(new Integer(5898318), "logical z-wide");
        return table;
    }
}

