/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class IPLabReader
extends FormatReader {
    private int bps;
    private int dataSize;
    private Double pixelSize;
    private Double timeIncrement;

    public IPLabReader() {
        super("IPLab", "ipl");
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 12;
        if (!FormatTools.validStream(stream, 12, false)) {
            return false;
        }
        String s = stream.readString(4);
        boolean little = s.equals("iiii");
        boolean big = s.equals("mmmm");
        if (!big && !little) {
            return false;
        }
        stream.order(little);
        int size = stream.readInt();
        if (size != 4) {
            return false;
        }
        int version = stream.readInt();
        return version >= 4110;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int numPixels = FormatTools.getPlaneSize(this);
        this.in.seek(numPixels * no + 44);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataSize = 0;
            this.bps = 0;
            this.timeIncrement = null;
            this.pixelSize = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String ptype;
        this.debug("IPLabReader.initFile(" + id + ")");
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.status("Populating metadata");
        this.core[0].littleEndian = this.in.readString(4).equals("iiii");
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(12);
        this.dataSize = this.in.readInt() - 28;
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeC = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        this.core[0].sizeT = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.addGlobalMeta("Width", this.getSizeX());
        this.addGlobalMeta("Height", this.getSizeY());
        this.addGlobalMeta("Channels", this.getSizeC());
        this.addGlobalMeta("ZDepth", this.getSizeZ());
        this.addGlobalMeta("TDepth", this.getSizeT());
        switch (filePixelType) {
            case 0: {
                ptype = "8 bit unsigned";
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                ptype = "16 bit signed short";
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                ptype = "16 bit unsigned short";
                this.core[0].pixelType = 3;
                break;
            }
            case 3: {
                ptype = "32 bit signed long";
                this.core[0].pixelType = 4;
                break;
            }
            case 4: {
                ptype = "32 bit single-precision float";
                this.core[0].pixelType = 6;
                break;
            }
            case 5: {
                ptype = "Color24";
                this.core[0].pixelType = 5;
                break;
            }
            case 6: {
                ptype = "Color48";
                this.core[0].pixelType = 3;
                break;
            }
            case 10: {
                ptype = "64 bit double-precision float";
                this.core[0].pixelType = 7;
                break;
            }
            default: {
                ptype = "reserved";
            }
        }
        this.bps = FormatTools.getBytesPerPixel(this.getPixelType());
        this.addGlobalMeta("PixelType", ptype);
        this.in.skipBytes(this.dataSize);
        this.core[0].dimensionOrder = "XY";
        this.core[0].dimensionOrder = this.getSizeC() > 1 ? this.core[0].dimensionOrder + "CZT" : this.core[0].dimensionOrder + "ZTC";
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        this.status("Reading tags");
        byte[] tagBytes = new byte[4];
        this.in.read(tagBytes);
        String tag = new String(tagBytes);
        while (!tag.equals("fini") && this.in.getFilePointer() < this.in.length() - 4L) {
            int size = this.in.readInt();
            if (tag.equals("clut")) {
                if (size == 8) {
                    this.in.skipBytes(4);
                    int type = this.in.readInt();
                    String[] types = new String[]{"monochrome", "reverse monochrome", "BGR", "classify", "rainbow", "red", "green", "blue", "cyan", "magenta", "yellow", "saturated pixels"};
                    String clutType = type >= 0 && type < types.length ? types[type] : "unknown";
                    this.addGlobalMeta("LUT type", clutType);
                } else {
                    this.in.skipBytes(772);
                }
            } else if (tag.equals("norm")) {
                if (size != 44 * this.getSizeC()) {
                    throw new FormatException("Bad normalization settings");
                }
                String[] types = new String[]{"user", "plane", "sequence", "saturated plane", "saturated sequence", "ROI"};
                for (int i = 0; i < this.getSizeC(); ++i) {
                    int source = this.in.readInt();
                    String sourceType = source >= 0 && source < types.length ? types[source] : "user";
                    this.addGlobalMeta("NormalizationSource" + i, sourceType);
                    double min = this.in.readDouble();
                    double max = this.in.readDouble();
                    double gamma = this.in.readDouble();
                    double black = this.in.readDouble();
                    double white = this.in.readDouble();
                    this.addGlobalMeta("NormalizationMin" + i, min);
                    this.addGlobalMeta("NormalizationMax" + i, max);
                    this.addGlobalMeta("NormalizationGamma" + i, gamma);
                    this.addGlobalMeta("NormalizationBlack" + i, black);
                    this.addGlobalMeta("NormalizationWhite" + i, white);
                }
            } else if (tag.equals("head")) {
                for (int i = 0; i < size / 22; ++i) {
                    short num = this.in.readShort();
                    this.addGlobalMeta("Header" + num, this.in.readString(20));
                }
            } else if (tag.equals("mmrc")) {
                this.in.skipBytes(size);
            } else if (tag.equals("roi ")) {
                this.in.skipBytes(4);
                int roiLeft = this.in.readInt();
                int roiTop = this.in.readInt();
                int roiRight = this.in.readInt();
                int roiBottom = this.in.readInt();
                int numRoiPts = this.in.readInt();
                Integer x0 = new Integer(roiLeft);
                Integer x1 = new Integer(roiRight);
                Integer y0 = new Integer(roiBottom);
                Integer y1 = new Integer(roiTop);
                this.in.skipBytes(8 * numRoiPts);
            } else if (tag.equals("mask")) {
                this.in.skipBytes(size);
            } else if (tag.equals("unit")) {
                for (int i = 0; i < 4; ++i) {
                    int xResStyle = this.in.readInt();
                    float unitsPerPixel = this.in.readFloat();
                    int xUnitName = this.in.readInt();
                    this.addGlobalMeta("ResolutionStyle" + i, xResStyle);
                    this.addGlobalMeta("UnitsPerPixel" + i, unitsPerPixel);
                    switch (xUnitName) {
                        case 2: {
                            unitsPerPixel *= 1000.0f;
                            break;
                        }
                        case 3: {
                            unitsPerPixel *= 10000.0f;
                            break;
                        }
                        case 4: {
                            unitsPerPixel *= 1000000.0f;
                            break;
                        }
                        case 5: {
                            unitsPerPixel *= 3937.0f;
                            break;
                        }
                        case 6: {
                            unitsPerPixel *= 47244.0f;
                        }
                    }
                    if (i == 0) {
                        this.pixelSize = new Double(unitsPerPixel);
                    }
                    this.addGlobalMeta("UnitName" + i, xUnitName);
                }
            } else if (tag.equals("view")) {
                this.in.skipBytes(size);
            } else if (tag.equals("plot")) {
                this.in.skipBytes(size);
            } else if (tag.equals("note")) {
                String descriptor = this.in.readString(64);
                String notes = this.in.readString(512);
                this.addGlobalMeta("Descriptor", descriptor);
                this.addGlobalMeta("Notes", notes);
                store.setImageDescription(notes, 0);
                MetadataTools.setDefaultCreationDate(store, id, 0);
            } else if (tagBytes[0] == 26 && tagBytes[1] == -39 && tagBytes[2] == -117 && tagBytes[3] == -17) {
                int units = this.in.readInt();
                for (int i = 0; i < this.getSizeT(); ++i) {
                    float timepoint = this.in.readFloat();
                    switch (units) {
                        case 0: {
                            timepoint /= 1000.0f;
                            break;
                        }
                        case 2: {
                            timepoint *= 60.0f;
                            break;
                        }
                        case 3: {
                            timepoint *= 3600.0f;
                        }
                    }
                    this.addGlobalMeta("Timestamp " + i, timepoint);
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        for (int z = 0; z < this.getSizeZ(); ++z) {
                            int plane = this.getIndex(z, c, i);
                            store.setPlaneTimingDeltaT(new Double(timepoint), 0, 0, plane);
                        }
                    }
                    if (i != 1) continue;
                    this.timeIncrement = new Double(timepoint);
                }
            } else {
                this.in.skipBytes(size);
            }
            if (this.in.getFilePointer() + 4L <= this.in.length()) {
                this.in.read(tagBytes);
                tag = new String(tagBytes);
            } else {
                tag = "fini";
            }
            if (this.in.getFilePointer() < this.in.length() || tag.equals("fini")) continue;
            tag = "fini";
        }
        if (this.pixelSize != null) {
            store.setDimensionsPhysicalSizeX(this.pixelSize, 0, 0);
            store.setDimensionsPhysicalSizeY(this.pixelSize, 0, 0);
        }
        if (this.timeIncrement != null) {
            store.setDimensionsTimeIncrement(this.timeIncrement, 0, 0);
        }
    }
}

