/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.FilterMetadata;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;

public class FluoviewReader
extends BaseTiffReader {
    private static final String FLUOVIEW_MAGIC_STRING = "FLUOVIEW";
    private static final int MMHEADER = 34361;
    private static final int MMSTAMP = 34362;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss.SSS";
    private double voxelX = 1.0;
    private double voxelY = 1.0;
    private double voxelZ = 1.0;
    private double voxelC = 1.0;
    private double voxelT = 1.0;
    private String dimensionOrder;
    private String date = null;
    private int timeIndex = -1;
    private long[][] stamps = null;
    private String[] gains;
    private String[] voltages;
    private String[] offsets;
    private String[] channelNames;
    private String[] lensNA;
    private String mag;
    private String detManu;
    private String objManu;
    private String comment;
    private Double gamma;

    public FluoviewReader() {
        super("Olympus Fluoview/ABD TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String com = ifd.getComment();
        if (com == null) {
            com = "";
        }
        return com.indexOf(FLUOVIEW_MAGIC_STRING) != -1 && ifd.containsKey(new Integer(34361)) || ifd.containsKey(new Integer(34362));
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int[] lengths = new int[4];
        int[] pos = this.getZCTCoords(no);
        int[] realPos = new int[4];
        for (int i = 2; i < this.dimensionOrder.length(); ++i) {
            char axis = this.dimensionOrder.charAt(i);
            if (axis == 'Z') {
                lengths[i - 2] = this.getSizeZ();
                realPos[i - 2] = pos[0];
                continue;
            }
            if (axis == 'C') {
                lengths[i - 2] = this.getEffectiveSizeC();
                realPos[i - 2] = pos[1];
                continue;
            }
            if (axis == 'T') {
                lengths[i - 2] = this.getSizeT();
                realPos[i - 2] = pos[2];
                continue;
            }
            if (axis != 'S') continue;
            lengths[i - 2] = this.getSeriesCount();
            realPos[i - 2] = this.getSeries();
        }
        int image = FormatTools.positionToRaster(lengths, realPos);
        if ((long)this.getSizeY() == ((IFD)this.ifds.get(0)).getImageLength()) {
            this.tiffParser.getSamples((IFD)this.ifds.get(image), buf, x, y, w, h);
        } else {
            FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
            this.tiffParser.getSamples((IFD)this.ifds.get(0), buf, x, image, w, 1L);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.voxelT = 1.0;
            this.voxelC = 1.0;
            this.voxelZ = 1.0;
            this.voxelY = 1.0;
            this.voxelX = 1.0;
            this.dimensionOrder = null;
            this.lensNA = null;
            this.channelNames = null;
            this.offsets = null;
            this.voltages = null;
            this.gains = null;
            this.comment = null;
            this.objManu = null;
            this.detManu = null;
            this.mag = null;
            this.gamma = null;
            this.date = null;
            this.timeIndex = -1;
            this.stamps = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        short[] s = ((IFD)this.ifds.get(0)).getIFDShortArray(34361, true);
        byte[] mmheader = new byte[s.length];
        for (int i2 = 0; i2 < mmheader.length; ++i2) {
            mmheader[i2] = (byte)s[i2];
            if (mmheader[i2] >= 0) continue;
            int n = i2;
            mmheader[n] = (byte)(mmheader[n] + 1);
        }
        RandomAccessInputStream ras = new RandomAccessInputStream(mmheader);
        ras.order(this.isLittleEndian());
        this.put("Header Flag", ras.readShort());
        this.put("Image Type", ras.readChar());
        this.put("Image name", ras.readString(257));
        ras.skipBytes(4);
        this.put("Number of colors", ras.readInt());
        ras.skipBytes(4);
        ras.skipBytes(4);
        this.put("Comment size", ras.readInt());
        ras.skipBytes(4);
        String[] names = new String[10];
        int[] sizes = new int[10];
        double[] resolutions = new double[10];
        for (i = 0; i < 10; ++i) {
            names[i] = ras.readString(16);
            sizes[i] = ras.readInt();
            double origin = ras.readDouble();
            resolutions[i] = ras.readDouble();
            this.put("Dimension " + (i + 1) + " Name", names[i]);
            this.put("Dimension " + (i + 1) + " Size", sizes[i]);
            this.put("Dimension " + (i + 1) + " Origin", origin);
            this.put("Dimension " + (i + 1) + " Resolution", resolutions[i]);
            this.put("Dimension " + (i + 1) + " Units", ras.readString(64));
        }
        ras.skipBytes(4);
        this.put("Map type", ras.readShort());
        this.put("Map min", ras.readDouble());
        this.put("Map max", ras.readDouble());
        this.put("Min value", ras.readDouble());
        this.put("Max value", ras.readDouble());
        ras.skipBytes(4);
        this.put("Gamma", ras.readDouble());
        this.put("Offset", ras.readDouble());
        this.put("Gray Channel Name", ras.readString(16));
        this.put("Gray Channel Size", ras.readInt());
        this.put("Gray Channel Origin", ras.readDouble());
        this.put("Gray Channel Resolution", ras.readDouble());
        this.put("Gray Channel Units", ras.readString(64));
        ras.skipBytes(4);
        this.put("Voice field", ras.readInt());
        ras.skipBytes(4);
        this.stamps = new long[8][this.ifds.size()];
        for (i = 0; i < this.ifds.size(); ++i) {
            int j;
            s = ((IFD)this.ifds.get(i)).getIFDShortArray(34362, true);
            byte[] stamp = new byte[s.length];
            for (j = 0; j < s.length; ++j) {
                stamp[j] = (byte)s[j];
                if (stamp[j] >= 0) continue;
                int n = j;
                stamp[n] = (byte)(stamp[n] + 1);
            }
            ras = new RandomAccessInputStream(stamp);
            for (j = 0; j < 8; ++j) {
                this.stamps[j][i] = ras.readLong() / 10000L;
            }
        }
        this.dimensionOrder = "XY";
        int seriesCount = 1;
        this.core[0].sizeT = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeZ = 1;
        for (int i3 = 0; i3 < 10; ++i3) {
            String name = names[i3];
            int size = sizes[i3];
            double voxel = resolutions[i3];
            if (name == null || size == 0 || (name = name.toLowerCase().trim()).length() == 0) continue;
            if (name.equals("x")) {
                this.voxelX = voxel;
                continue;
            }
            if (name.equals("y")) {
                this.voxelY = voxel;
                continue;
            }
            if (name.equals("z") || name.equals("event")) {
                this.core[0].sizeZ *= size;
                if (this.dimensionOrder.indexOf("Z") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "Z";
                }
                this.voxelZ = voxel;
                continue;
            }
            if (name.equals("ch") || name.equals("wavelength")) {
                this.core[0].sizeC *= size;
                if (this.dimensionOrder.indexOf("C") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "C";
                }
                this.voxelC = voxel;
                continue;
            }
            if (name.equals("time") || name.equals("t") || name.equals("animation")) {
                this.core[0].sizeT *= size;
                if (this.dimensionOrder.indexOf("T") == -1) {
                    this.dimensionOrder = this.dimensionOrder + "T";
                }
                this.voxelT = voxel;
                this.timeIndex = i3 - 2;
                continue;
            }
            if (this.dimensionOrder.indexOf("S") == -1) {
                this.dimensionOrder = this.dimensionOrder + "S";
            }
            seriesCount *= size;
        }
        if (this.dimensionOrder.indexOf("Z") == -1) {
            this.dimensionOrder = this.dimensionOrder + "Z";
        }
        if (this.dimensionOrder.indexOf("T") == -1) {
            this.dimensionOrder = this.dimensionOrder + "T";
        }
        if (this.dimensionOrder.indexOf("C") == -1) {
            this.dimensionOrder = this.dimensionOrder + "C";
        }
        if (this.dimensionOrder.indexOf("S") == -1) {
            this.dimensionOrder = this.dimensionOrder + "S";
        }
        this.core[0].imageCount = this.ifds.size() / seriesCount;
        if (this.getSizeZ() > this.getImageCount()) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.getSizeT() > this.getImageCount()) {
            this.core[0].sizeT = this.getImageCount();
        }
        if (!(this.getImageCount() != 1 || this.getSizeT() != this.getSizeY() && this.getSizeZ() != this.getSizeY() || this.getSizeT() <= this.getImageCount() && this.getSizeZ() <= this.getImageCount())) {
            this.core[0].sizeY = 1;
            this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        this.core[0].dimensionOrder = this.dimensionOrder.replaceAll("S", "");
        if (seriesCount > 1) {
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[seriesCount];
            for (int i4 = 0; i4 < seriesCount; ++i4) {
                this.core[i4] = oldCore;
            }
        }
        this.comment = ((IFD)this.ifds.get(0)).getComment();
        this.gains = new String[this.getSizeC()];
        this.offsets = new String[this.getSizeC()];
        this.voltages = new String[this.getSizeC()];
        this.channelNames = new String[this.getSizeC()];
        this.lensNA = new String[this.getSizeC()];
        if (this.comment != null) {
            StringTokenizer st = new StringTokenizer(this.comment, "\n");
            block7: while (st.hasMoreTokens()) {
                int i5;
                String token = st.nextToken();
                int eq = token.indexOf("=");
                if (eq == -1) continue;
                String key = token.substring(0, eq);
                String value = token.substring(eq + 1);
                this.addGlobalMeta(key, value);
                if (key.startsWith("Gain Ch")) {
                    for (i5 = 0; i5 < this.gains.length; ++i5) {
                        if (this.gains[i5] != null) continue;
                        this.gains[i5] = value;
                        continue block7;
                    }
                    continue;
                }
                if (key.startsWith("PMT Voltage Ch")) {
                    for (i5 = 0; i5 < this.voltages.length; ++i5) {
                        if (this.voltages[i5] != null) continue;
                        this.voltages[i5] = value;
                        continue block7;
                    }
                    continue;
                }
                if (key.startsWith("Offset Ch")) {
                    for (i5 = 0; i5 < this.offsets.length; ++i5) {
                        if (this.offsets[i5] != null) continue;
                        this.offsets[i5] = value;
                        continue block7;
                    }
                    continue;
                }
                if (key.equals("Magnification")) {
                    this.mag = value;
                    continue;
                }
                if (key.equals("System Configuration")) {
                    this.detManu = value;
                    continue;
                }
                if (key.equals("Objective Lens")) {
                    this.objManu = value;
                    continue;
                }
                if (key.equals("Gamma")) {
                    this.gamma = new Double(value);
                    continue;
                }
                if (key.startsWith("Channel ") && key.endsWith("Dye")) {
                    for (i5 = 0; i5 < this.channelNames.length; ++i5) {
                        if (this.channelNames[i5] != null) continue;
                        this.channelNames[i5] = value;
                        continue block7;
                    }
                    continue;
                }
                if (key.startsWith("Confocal Aperture-Ch")) {
                    for (i5 = 0; i5 < this.lensNA.length; ++i5) {
                        if (this.lensNA[i5] != null) continue;
                        this.lensNA[i5] = value.substring(0, value.length() - 2);
                        continue block7;
                    }
                    continue;
                }
                if (key.equals("Date")) {
                    this.date = value;
                    continue;
                }
                if (!key.equals("Time")) continue;
                this.date = this.date + " " + value;
            }
            if (this.date != null) {
                this.date = DateTools.formatDate(this.date.trim(), new String[]{"MM/dd/yyyy hh:mm:ss a", "MM-dd-yyyy hh:mm:ss"}, true);
                if (this.timeIndex >= 0 && this.date != null) {
                    long ms = DateTools.getTime(this.date, "yyyy-MM-dd'T'HH:mm:ss");
                    int nChars = String.valueOf(this.getImageCount()).length();
                    for (int i6 = 0; i6 < this.getImageCount(); ++i6) {
                        int[] zct = this.getZCTCoords(i6);
                        String key = String.format("Timestamp for Z=%2s, C=%2s, T=%2s", zct[0], zct[1], zct[2]);
                        long stamp = ms + this.stamps[this.timeIndex][i6];
                        this.addGlobalMeta(key, DateTools.convertDate(stamp, 0, DATE_FORMAT));
                    }
                }
            }
            int start = this.comment.indexOf("[Version Info]");
            int end = this.comment.indexOf("[Version Info End]");
            if (start != -1 && end != -1 && end > start) {
                this.comment = this.comment.substring(start + 14, end).trim();
                start = this.comment.indexOf("=") + 1;
                end = this.comment.indexOf("\n");
                this.comment = end > start ? this.comment.substring(start, end).trim() : this.comment.substring(start).trim();
            } else {
                this.comment = "";
            }
        }
        this.addGlobalMeta("Comment", this.comment);
    }

    protected void initMetadataStore() throws FormatException {
        int i;
        super.initMetadataStore();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setImageDescription(this.comment, 0);
        if (this.date != null) {
            store.setImageCreationDate(this.date, 0);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setImageInstrumentRef(instrumentID, 0);
        if (this.timeIndex >= 0) {
            for (i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneTimingDeltaT(new Double((double)this.stamps[this.timeIndex][i] / 1000.0), 0, 0, i);
            }
        }
        store.setDimensionsPhysicalSizeX(new Double(this.voxelX), 0, 0);
        store.setDimensionsPhysicalSizeY(new Double(this.voxelY), 0, 0);
        store.setDimensionsPhysicalSizeZ(new Double(this.voxelZ), 0, 0);
        store.setDimensionsTimeIncrement(new Double(this.voxelT), 0, 0);
        if ((int)this.voxelC > 0) {
            store.setDimensionsWaveIncrement(new Integer((int)this.voxelC), 0, 0);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.channelNames[i] == null) continue;
            store.setLogicalChannelName(this.channelNames[i].trim(), 0, i);
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            if (this.voltages[i] != null) {
                if (this.detManu != null) {
                    store.setDetectorManufacturer(this.detManu, 0, 0);
                }
                store.setDetectorSettingsVoltage(new Double(this.voltages[i]), 0, 0);
            }
            if (this.gains[i] != null) {
                store.setDetectorSettingsGain(new Double(this.gains[i]), 0, i);
            }
            if (this.offsets[i] != null) {
                store.setDetectorSettingsOffset(new Double(this.offsets[i]), 0, i);
            }
            store.setDetectorType("Unknown", 0, i);
            String detectorID = MetadataTools.createLSID("Detector", 0, i);
            store.setDetectorID(detectorID, 0, i);
            store.setDetectorSettingsDetector(detectorID, 0, i);
        }
        if (this.mag != null && this.mag.toLowerCase().endsWith("x")) {
            this.mag = this.mag.substring(0, this.mag.length() - 1);
        } else if (this.mag == null) {
            this.mag = "1";
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveImmersion("Unknown", 0, 0);
        if (this.objManu != null) {
            String[] objectiveData = this.objManu.split(" ");
            store.setObjectiveModel(objectiveData[0], 0, 0);
            if (objectiveData.length > 2) {
                store.setObjectiveImmersion(objectiveData[2], 0, 0);
            }
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Double(this.mag), 0, 0);
        }
        for (int i2 = 0; i2 < this.getSizeC(); ++i2) {
            if (this.lensNA[i2] == null) continue;
            store.setObjectiveLensNA(new Double(this.lensNA[i2]), 0, i2);
        }
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsObjective(objectiveID, 0);
    }
}

