/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.WriterWrapper;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;

public class BufferedImageWriter
extends WriterWrapper {
    public static BufferedImageWriter makeBufferedImageWriter(IFormatWriter w) {
        if (w instanceof BufferedImageWriter) {
            return (BufferedImageWriter)w;
        }
        return new BufferedImageWriter(w);
    }

    public BufferedImageWriter() {
    }

    public BufferedImageWriter(IFormatWriter r) {
        super(r);
    }

    public void saveImage(BufferedImage image, boolean last) throws FormatException, IOException {
        this.saveImage(image, 0, last, last);
    }

    public void saveImage(BufferedImage image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        Class dataType = this.getNativeDataType();
        if (BufferedImage.class.isAssignableFrom(dataType)) {
            this.savePlane(image, series, lastInSeries, last);
        } else {
            Boolean bigEndian;
            boolean littleEndian = false;
            int bpp = FormatTools.getBytesPerPixel(AWTImageTools.getPixelType(image));
            MetadataRetrieve r = this.getMetadataRetrieve();
            if (r != null && (bigEndian = r.getPixelsBigEndian(series, 0)) != null) {
                littleEndian = bigEndian == false;
            }
            byte[][] pixelBytes = AWTImageTools.getPixelBytes(image, littleEndian);
            byte[] buf = new byte[pixelBytes.length * pixelBytes[0].length];
            if (this.isInterleaved()) {
                for (int i = 0; i < pixelBytes[0].length; i += bpp) {
                    for (int j = 0; j < pixelBytes.length; ++j) {
                        System.arraycopy(pixelBytes[j], i, buf, i * pixelBytes.length + j * bpp, bpp);
                    }
                }
            } else {
                for (int i = 0; i < pixelBytes.length; ++i) {
                    System.arraycopy(pixelBytes[i], 0, buf, i * pixelBytes[0].length, pixelBytes[i].length);
                }
            }
            pixelBytes = null;
            this.saveBytes(buf, series, lastInSeries, last);
        }
    }
}

