/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.ExperimentType;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentTypeEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = ExperimentTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*FP\\s*", "FP");
        p.put("^\\s*FRET\\s*", "FRET");
        p.put("^\\s*TimeLapse\\s*", "TimeLapse");
        p.put("^\\s*FourDPlus\\s*", "FourDPlus");
        p.put("^\\s*Screen\\s*", "Screen");
        p.put("^\\s*Immunocytochemistry\\s*", "Immunocytochemistry");
        p.put("^\\s*Immunofluorescence\\s*", "Immunofluorescence");
        p.put("^\\s*FISH\\s*", "FISH");
        p.put("^\\s*Electrophysiology\\s*", "Electrophysiology");
        p.put("^\\s*IonImaging\\s*", "IonImaging");
        p.put("^\\s*Colocalization\\s*", "Colocalization");
        p.put("^\\s*PGIDocumentation\\s*", "PGIDocumentation");
        p.put("^\\s*FluorescenceLifetime\\s*", "FluorescenceLifetime");
        p.put("^\\s*SpectralImaging\\s*", "SpectralImaging");
        p.put("^\\s*Photobleaching\\s*", "Photobleaching");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return ExperimentType.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return ExperimentType.class;
    }
}

