/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.DimensionOrder;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionOrderEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = DimensionOrderEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*XYZCT\\s*", "XYZCT");
        p.put("^\\s*XYZTC\\s*", "XYZTC");
        p.put("^\\s*XYCTZ\\s*", "XYCTZ");
        p.put("^\\s*XYCZT\\s*", "XYCZT");
        p.put("^\\s*XYTCZ\\s*", "XYTCZ");
        p.put("^\\s*XYTZC\\s*", "XYTZC");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return DimensionOrder.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return DimensionOrder.class;
    }
}

