/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.Correction;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrectionEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = CorrectionEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*UV\\s*", "UV");
        p.put("^\\s*PlanApo\\s*", "PlanApo");
        p.put("^\\s*PlanFluor\\s*", "PlanFluor");
        p.put("^\\s*SuperFluor\\s*", "SuperFluor");
        p.put("^\\s*VioletCorrected\\s*", "VioletCorrected");
        p.put("^\\s*Achro\\s*", "Achro");
        p.put("^\\s*Achromat\\s*", "Achromat");
        p.put("^\\s*Fluor\\s*", "Fluor");
        p.put("^\\s*Fl\\s*", "Fl");
        p.put("^\\s*Fluar\\s*", "Fluar");
        p.put("^\\s*Neofluar\\s*", "Neofluar");
        p.put("^\\s*Fluotar\\s*", "Fluotar");
        p.put("^\\s*Apo\\s*", "Apo");
        p.put("^\\s*PlanNeofluar\\s*", "PlanNeofluar");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return Correction.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return Correction.class;
    }
}

