/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums.handler;

import java.util.Hashtable;
import loci.formats.enums.AcquisitionMode;
import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;
import loci.formats.enums.handler.IEnumerationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquisitionModeEnumHandler
implements IEnumerationHandler {
    private static final Hashtable<String, String> patterns = AcquisitionModeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*WideField\\s*", "WideField");
        p.put("^\\s*LaserScanningMicroscopy\\s*", "LaserScanningMicroscopy");
        p.put("^\\s*LaserScanningConfocal\\s*", "LaserScanningConfocal");
        p.put("^\\s*SpinningDiskConfocal\\s*", "SpinningDiskConfocal");
        p.put("^\\s*SlitScanConfocal\\s*", "SlitScanConfocal");
        p.put("^\\s*MultiPhotonMicroscopy\\s*", "MultiPhotonMicroscopy");
        p.put("^\\s*StructuredIllumination\\s*", "StructuredIllumination");
        p.put("^\\s*SingleMoleculeImaging\\s*", "SingleMoleculeImaging");
        p.put("^\\s*TotalInternalReflection\\s*", "TotalInternalReflection");
        p.put("^\\s*FluorescenceLifetime\\s*", "FluorescenceLifetime");
        p.put("^\\s*SpectralImaging\\s*", "SpectralImaging");
        p.put("^\\s*FluorescenceCorrelationSpectroscopy\\s*", "FluorescenceCorrelationSpectroscopy");
        p.put("^\\s*NearFieldScanningOpticalMicroscopy\\s*", "NearFieldScanningOpticalMicroscopy");
        p.put("^\\s*SecondHarmonicGenerationImaging\\s*", "SecondHarmonicGenerationImaging");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        for (String pattern : patterns.keySet()) {
            if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
            String v = patterns.get(pattern);
            return AcquisitionMode.fromString(v);
        }
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return AcquisitionMode.class;
    }
}

