/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.enums;

import loci.formats.enums.Enumeration;
import loci.formats.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FontFamily implements Enumeration
{
    ARIAL("Arial"),
    COURIER("Courier"),
    HELVETICA("Helvetica"),
    TIMESNEWROMAN("TimesNewRoman");

    private final String value;

    private FontFamily(String value) {
        this.value = value;
    }

    public static FontFamily fromString(String value) throws EnumerationException {
        if ("Arial".equals(value)) {
            return ARIAL;
        }
        if ("Courier".equals(value)) {
            return COURIER;
        }
        if ("Helvetica".equals(value)) {
            return HELVETICA;
        }
        if ("TimesNewRoman".equals(value)) {
            return TIMESNEWROMAN;
        }
        String s = String.format("%s not a supported value of %s", value, FontFamily.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

